/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.j2c.CMConfigData;
import com.ibm.ejs.j2c.ConnectorPoolProperties;
import com.ibm.ejs.j2c.ConnectorProperties;
import com.ibm.ejs.j2c.ConnectorProperty;
import com.ibm.ejs.j2c.J2CGlobalConfigProperties;
import com.ibm.ejs.j2c.J2CXAResourceFactory;
import com.ibm.ejs.j2c.J2CXAResourceInfo;
import com.ibm.ejs.j2c.MBeanProps;
import com.ibm.ejs.j2c.MCFEntry;
import com.ibm.ejs.j2c.MCFExtendedProperties;
import com.ibm.ejs.j2c.ManagedConnectionFactoryProps;
import com.ibm.ejs.j2c.PmiProps;
import com.ibm.ejs.j2c.RALifeCycleManagerImpl;
import com.ibm.ejs.j2c.ResourceAdapterDD;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.j2c.SecurityHelper;
import com.ibm.ws.j2c.SelfXARecoverable;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactory;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.cred.AuthDataCredential;
import com.ibm.ws.security.cred.Credential;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.PasswordUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.login.LoginException;

public final class J2CUtilityClass {
    public static final String _defaultThrowableDelimiter = ":";
    private static final TraceComponent tc = Tr.register(J2CUtilityClass.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");
    public static Hashtable pmiNameToCompAlias = new Hashtable();

    static final void dynamicMethodSetter(Class clazz, Object object, String string, String string2, String string3, String string4) {
        String string5 = clazz.getName();
        if (string3 != null && string3.trim() != "") {
            String string6 = string.substring(0, 1).toUpperCase() + string.substring(1, string.length());
            String string7 = "set" + string6;
            try {
                Object[] objectArray;
                Class[] classArray = new Class[1];
                Object[] objectArray2 = null;
                if (string2.equals("java.lang.String")) {
                    classArray[0] = String.class;
                    objectArray2 = new Object[]{string3};
                } else if (string2.equals("java.lang.Character")) {
                    classArray[0] = Character.class;
                    objectArray2 = new Object[]{new Character(string3.charAt(0))};
                } else if (string2.equals("char")) {
                    classArray[0] = Character.TYPE;
                    objectArray2 = new Object[]{new Character(string3.charAt(0))};
                } else if (string2.equals("java.lang.Boolean")) {
                    classArray[0] = Boolean.class;
                    objectArray2 = new Object[]{Boolean.valueOf(string3)};
                } else if (string2.equals("boolean")) {
                    classArray[0] = Boolean.TYPE;
                    objectArray2 = new Object[]{Boolean.valueOf(string3)};
                } else if (string2.equals("java.lang.Byte")) {
                    classArray[0] = Byte.class;
                    objectArray2 = new Object[]{new Byte(string3)};
                } else if (string2.equals("byte")) {
                    classArray[0] = Byte.TYPE;
                    objectArray2 = new Object[]{new Byte(string3)};
                } else if (string2.equals("java.lang.Integer")) {
                    classArray[0] = Integer.class;
                    objectArray2 = new Object[]{new Integer(string3)};
                } else if (string2.equals("int")) {
                    classArray[0] = Integer.TYPE;
                    objectArray2 = new Object[]{new Integer(string3)};
                } else if (string2.equals("java.lang.Long")) {
                    classArray[0] = Long.class;
                    objectArray2 = new Object[]{new Long(string3)};
                } else if (string2.equals("long")) {
                    classArray[0] = Long.TYPE;
                    objectArray2 = new Object[]{new Long(string3)};
                } else if (string2.equals("java.lang.Float")) {
                    classArray[0] = Float.class;
                    objectArray2 = new Object[]{new Float(string3)};
                } else if (string2.equals("float")) {
                    classArray[0] = Float.TYPE;
                    objectArray2 = new Object[]{new Float(string3)};
                } else if (string2.equals("java.lang.Double")) {
                    classArray[0] = Double.class;
                    objectArray2 = new Object[]{new Double(string3)};
                } else if (string2.equals("double")) {
                    classArray[0] = Double.TYPE;
                    objectArray2 = new Object[]{new Double(string3)};
                } else {
                    objectArray = new Object[]{string, string4, string2};
                    Tr.error(tc, "INVALID_PROPERTY_TYPE_J2CA0047", objectArray);
                }
                objectArray = clazz.getMethod(string7, classArray);
                try {
                    objectArray.invoke(object, objectArray2);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    Object[] objectArray3 = new Object[]{string6, string5, throwable, string4};
                    Tr.warning(tc, "SET_METHOD_EXCP_J2CA0007", objectArray3);
                    throw invocationTargetException;
                }
                catch (Exception exception) {
                    Object[] objectArray4 = new Object[]{string6, string5, exception, string4};
                    Tr.warning(tc, "SET_METHOD_EXCP_J2CA0007", objectArray4);
                    throw exception;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Object[] objectArray = new Object[]{string5, string6, string4};
                Tr.warning(tc, "NO_SET_METHOD_J2CA0008", objectArray);
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{"dynamicMethodSetter", exception};
                Tr.warning(tc, "METHOD_FAILED_J2CA0132", objectArray);
            }
        } else {
            Object[] objectArray = new Object[]{string, string5, string4};
            Tr.warning(tc, "NULL_PROPERTY_VALUE_J2CA0050", objectArray);
        }
    }

    protected static MCFEntry createMCFEntry(J2CXAResourceInfo j2CXAResourceInfo) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMCFEntry J2CXAResourceInfo");
        }
        return J2CUtilityClass.createMCFEntry(j2CXAResourceInfo.getCfName(), j2CXAResourceInfo.getConfigProps(), j2CXAResourceInfo.getDd(), j2CXAResourceInfo.getDsProps(), j2CXAResourceInfo.getMbeanProps(), j2CXAResourceInfo.getCmConfig(), true);
    }

    protected static MCFEntry createMCFEntry(String string, ConnectorProperties connectorProperties, ResourceAdapterDD resourceAdapterDD, Properties properties, MBeanProps mBeanProps, CMConfigData cMConfigData, ConnectorPoolProperties connectorPoolProperties, boolean bl) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object[] objectArray;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        String string2;
        boolean bl2;
        String string3;
        String string4;
        MCFEntry mCFEntry;
        MCFExtendedProperties mCFExtendedProperties;
        ManagedConnectionFactory managedConnectionFactory;
        String string5;
        block51: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createMCFEntry");
            }
            string5 = string;
            string5 = cMConfigData != null ? cMConfigData.getPmiName() : (mBeanProps != null ? mBeanProps.getJndiName() : string);
            managedConnectionFactory = null;
            mCFExtendedProperties = null;
            mCFEntry = null;
            string4 = resourceAdapterDD.getManagedConnectionFactoryClass().trim();
            string3 = null;
            bl2 = false;
            Class clazz = null;
            try {
                clazz = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        return classLoader.loadClass(string4);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (ClassNotFoundException)privilegedActionException.getException();
            }
            managedConnectionFactory = (ManagedConnectionFactory)clazz.newInstance();
            if (managedConnectionFactory instanceof WSManagedConnectionFactoryImpl) {
                int n = 0;
                if (connectorPoolProperties != null) {
                    n = connectorPoolProperties.getMaxConnections();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting RRA EndToEndMonitoringFeature initial values for " + managedConnectionFactory + " setting pmiName " + string5 + " MaxConnections " + n);
                    }
                    ((WSManagedConnectionFactoryImpl)managedConnectionFactory).setJ2CInitialConfigProperties(string5, n);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting RRA EndToEndMonitoringFeature initial values for " + managedConnectionFactory + " setting pmiName " + string5 + " default MaxConnections " + n);
                    }
                    ((WSManagedConnectionFactoryImpl)managedConnectionFactory).setJ2CInitialConfigProperties(string5, n);
                }
            }
            if (properties != null) {
                properties.remove("defaultResSharingScope");
                properties.remove("defaultResIsolationLevel");
                properties.remove("defaultResAuth");
                string2 = "DataSourceProperties";
                try {
                    String string6;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "dsProps.getClass = " + properties.getClass().toString());
                    }
                    Class[] classArray = new Class[]{properties.getClass()};
                    object8 = managedConnectionFactory.getClass().getMethod("setDataSourceProperties", classArray);
                    object7 = properties.keys();
                    while (object7.hasMoreElements()) {
                        object6 = object7.nextElement().toString();
                        if (object6.toLowerCase().indexOf("password") == -1) continue;
                        properties.setProperty((String)object6, PasswordUtil.passwordDecode(properties.getProperty((String)object6)));
                    }
                    object6 = new Object[]{properties};
                    try {
                        ((Method)object8).invoke((Object)managedConnectionFactory, object6);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        FFDCFilter.processException(invocationTargetException, "com.ibm.ejs.j2c.J2CUtilityClass.createMCFEntry", "320");
                        string6 = string5;
                        if (bl) {
                            string5 = " for XA Recovery";
                            string6 = " for XA Recovery";
                        }
                        object5 = invocationTargetException.getTargetException();
                        objectArray = new Object[]{string2, string4, object5, string6};
                        Tr.error(tc, "SET_METHOD_EXCP_J2CA0036", objectArray);
                        if (!bl) {
                            throw invocationTargetException;
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, "com.ibm.ejs.j2c.J2CUtilityClass.createMCFEntry", "330");
                        string6 = string5;
                        if (bl) {
                            string5 = " for XA Recovery";
                            string6 = " for XA Recovery";
                        }
                        object5 = new Object[]{string2, string4, exception, string6};
                        Tr.error(tc, "SET_METHOD_EXCP_J2CA0036", object5);
                        if (!bl) {
                            throw exception;
                        }
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    FFDCFilter.processException(noSuchMethodException, "com.ibm.ejs.j2c.J2CUtilityClass.createMCFEntry", "338");
                    object8 = string5;
                    if (bl) {
                        object8 = string5 + " for XA recovery";
                    }
                    object7 = new Object[]{string4, string2, object8};
                    Tr.error(tc, "NO_SET_METHOD_EXCP_J2CA0035", object7);
                    if (bl) break block51;
                    throw noSuchMethodException;
                }
            }
        }
        String string7 = null;
        object8 = null;
        object7 = null;
        object6 = null;
        Object object9 = null;
        boolean bl3 = true;
        object5 = null;
        mCFExtendedProperties = new MCFExtendedProperties();
        if (bl) {
            object5 = connectorProperties.findConnectorPropertyString("XA_RECOVERY_AUTH_ALIAS", null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "xaRecoveryAuthAlias = <" + (String)object5 + ">");
            }
        }
        objectArray = connectorProperties.elements();
        while (objectArray.hasMoreElements()) {
            ConnectorProperty connectorProperty = (ConnectorProperty)objectArray.nextElement();
            string2 = connectorProperty.getName();
            String string8 = connectorProperty.getType();
            Object object10 = connectorProperty.getValue();
            if (string2.equals("OptionC_authDataAlias")) {
                object4 = null;
                object3 = object10;
                try {
                    object4 = (AuthDataCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws LoginException {
                            return WSDefaultPrincipalMapping.getAuthData((String)object3);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
                if (object4 != null) {
                    int n = ((AuthDataCredential)object4).getStatus();
                    if (n == 0) {
                        object6 = ((Credential)object4).getUserName();
                        object9 = ((Credential)object4).getPassword();
                    } else {
                        object2 = "Component-managed authentication alias " + object3 + " for connection factory or datasource " + string5 + " is invalid.  It may be necessary to re-start the server for " + " previous configuration changes to take effect.";
                        Tr.info(tc, "ENGLISH_ONLY_MESSAGE_J2CA0090", object2);
                    }
                }
                if (string5 == null) continue;
                pmiNameToCompAlias.put(string5, object3);
                continue;
            }
            if (string2.equals("UserName")) {
                string7 = (String)object10;
                continue;
            }
            if (string2.equals("Password")) {
                object8 = (String)object10;
                object8 = PasswordUtil.passwordDecode((String)object8);
                continue;
            }
            if (string2.equals("KeyRingPassword")) {
                object7 = (String)object10;
                object7 = PasswordUtil.passwordDecode((String)object7);
                continue;
            }
            if (string2.toLowerCase().indexOf("password") != -1) {
                object4 = object10.toString();
                object10 = PasswordUtil.passwordDecode((String)object4);
            }
            if (string2.equals("TransactionResourceRegistration")) {
                string3 = J2CUtilityClass.callSetTransactionResourceRegistration(managedConnectionFactory, string4, object10, string5);
                mCFExtendedProperties.setTransactionResourceRegistration(string3);
                continue;
            }
            if (string2.equals("InactiveConnectionSupport")) {
                bl2 = J2CUtilityClass.callSetInactiveConnectionSupport(managedConnectionFactory, string4, object10, string5);
                mCFExtendedProperties.setSmartHandlesSupported(bl2);
                continue;
            }
            if (string2.equals("defaultResSharingScope") || string2.equals("defaultResIsolationLevel") || string2.equals("defaultResAuth")) continue;
            if (string2.equals("XA_RECOVERY_AUTH_ALIAS")) {
                object5 = (String)object10;
                if (object5 == null || !(managedConnectionFactory instanceof SelfXARecoverable)) continue;
                ((SelfXARecoverable)managedConnectionFactory).setXARecoveryAlias((String)object5);
                continue;
            }
            if (object10 != null) {
                if (object10.getClass().getName().equals("java.lang.String")) {
                    object10 = RALifeCycleManagerImpl.expandVarDefault(object10.toString());
                }
                J2CUtilityClass.dynamicMethodSetter(managedConnectionFactory.getClass(), managedConnectionFactory, string2, string8, object10.toString(), "");
                continue;
            }
            object4 = new Object[]{string2, string5};
            Tr.warning(tc, "NULL_PROPERTY_VALUE_J2CA0085", object4);
        }
        object4 = object6;
        object3 = object9;
        if (bl && object5 != null && !object5.equals("")) {
            int n;
            AuthDataCredential authDataCredential = null;
            object2 = object5;
            try {
                authDataCredential = (AuthDataCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws LoginException {
                        return WSDefaultPrincipalMapping.getAuthData((String)object2);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
            if (authDataCredential != null && (n = authDataCredential.getStatus()) == 0) {
                object4 = authDataCredential.getUserName();
                object3 = authDataCredential.getPassword();
            }
        }
        if (object4 == null || ((String)object4).equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "component-managed alias UserName blank or null.  Using Custom Property UserName, Password.");
            }
            object4 = string7;
            object3 = object8;
        }
        J2CUtilityClass.callMCFSetter(managedConnectionFactory, string4, "UserName", object4, string5);
        J2CUtilityClass.callMCFSetter(managedConnectionFactory, string4, "Password", object3, string5);
        J2CUtilityClass.callMCFSetter(managedConnectionFactory, string4, "KeyRingPassword", object7, string5);
        mCFExtendedProperties.setUserName((String)object4);
        if (tc.isDebugEnabled()) {
            bl3 = false;
            if (object4 == null || ((String)object4).equals("")) {
                bl3 = true;
            }
            Object object11 = bl3 ? "blank or null" : object4;
            Tr.debug(tc, "component-managed UserName from alias or custom props is " + (String)object11);
        }
        try {
            object = new TraceWriter(managedConnectionFactory.getClass().getName());
            if (((TraceWriter)object).isTraceEnabled()) {
                managedConnectionFactory.setLogWriter(new PrintWriter((Writer)object));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ejs.j2c.J2CUtilityClass.createMCFEntry", "609");
            Tr.error(tc, "ERROR_SETTING_TRACEWRITER_J2CA0118", new Object[]{managedConnectionFactory, exception});
        }
        object = J2CUtilityClass.getRRSTransactional(managedConnectionFactory, string4, string5);
        mCFExtendedProperties.setRRSTransactional((Boolean)object);
        object2 = J2CUtilityClass.getThreadSecurity(managedConnectionFactory, string4, string5);
        mCFExtendedProperties.setThreadSecurity((Boolean)object2);
        String string9 = J2CUtilityClass.getThreadIdentitySupport(managedConnectionFactory, string4, string5);
        mCFExtendedProperties.setThreadIdentitySupport(string9);
        SecurityHelper securityHelper = J2CUtilityClass.createSecurityHelper(managedConnectionFactory, mCFExtendedProperties);
        mCFEntry = new MCFEntry(managedConnectionFactory, mCFExtendedProperties, securityHelper, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMCFEntry");
        }
        return mCFEntry;
    }

    private static Boolean callSetInactiveConnectionSupport(ManagedConnectionFactory managedConnectionFactory, String string, Object object, String string2) throws Exception {
        Boolean bl = Boolean.FALSE;
        Boolean bl2 = (Boolean)object;
        Boolean bl3 = null;
        try {
            Class[] classArray = new Class[]{object.getClass()};
            Method method2 = managedConnectionFactory.getClass().getMethod("setInactiveConnectionSupport", classArray);
            Object[] objectArray = new Object[]{object};
            method2.invoke((Object)managedConnectionFactory, objectArray);
            bl3 = bl2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            FFDCFilter.processException(noSuchMethodException, "com.ibm.ejs.j2c.J2CUtilityClass.callSetInactiveConnectionSupport", "1175");
            bl3 = bl;
            Object[] objectArray = new Object[]{string, "InactiveConnectionSupport", string2};
            Tr.warning(tc, "NO_SET_METHOD_J2CA0008", objectArray);
            if (!bl3.equals(bl2)) {
                objectArray = new Object[]{bl3, bl2, string2};
                Tr.warning(tc, "INACTIVE_SUPPORT_USED_J2CA0082", objectArray);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ejs.j2c.J2CUtilityClass.callSetInactiveConnectionSupport", "1190");
            try {
                Method method3 = managedConnectionFactory.getClass().getMethod("getInactiveConnectionSupport", null);
                bl3 = (Boolean)method3.invoke((Object)managedConnectionFactory, null);
                if (!bl3.equals(bl2)) {
                    Object[] objectArray = new Object[]{bl3, bl2, string2};
                    Tr.warning(tc, "INACTIVE_SUPPORT_USED_J2CA0082", objectArray);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                FFDCFilter.processException(invocationTargetException, "com.ibm.ejs.j2c.J2CUtilityClass.callSetInactiveConnectionSupport", "785");
                Throwable throwable = invocationTargetException.getTargetException();
                Object[] objectArray = new Object[]{"getInactiveConnectionSupport", managedConnectionFactory.getClass(), bl2, throwable, string2};
                Tr.error(tc, "GET_CONFIGPROPERTY_FAILED_J2CA0066", objectArray);
                throw invocationTargetException;
            }
            catch (Exception exception2) {
                FFDCFilter.processException(exception2, "com.ibm.ejs.j2c.J2CUtilityClass.callSetInactiveConnectionSupport", "1214");
                Object[] objectArray = new Object[]{"getInactiveConnectionSupport", managedConnectionFactory.getClass(), bl2, exception2, string2};
                Tr.error(tc, "GET_CONFIGPROPERTY_FAILED_J2CA0066", objectArray);
                throw exception2;
            }
        }
        return bl3;
    }

    private static String callSetTransactionResourceRegistration(ManagedConnectionFactory managedConnectionFactory, String string, Object object, String string2) throws Exception {
        String string3 = "static";
        String string4 = (String)object;
        String string5 = null;
        try {
            Class[] classArray = new Class[]{object.getClass()};
            Method method2 = managedConnectionFactory.getClass().getMethod("setTransactionResourceRegistration", classArray);
            Object[] objectArray = new Object[]{object};
            method2.invoke((Object)managedConnectionFactory, objectArray);
            string5 = string4;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            FFDCFilter.processException(noSuchMethodException, "com.ibm.ejs.j2c.J2CUtilityClass.callSetTransactionResourceRegistration", "1080");
            string5 = string3;
            Object[] objectArray = new Object[]{string, "TransactionResourceRegistration", string2};
            Tr.warning(tc, "NO_SET_METHOD_J2CA0008", objectArray);
            if (!string5.equals(string4)) {
                objectArray = new Object[]{string5, string4, string2};
                Tr.warning(tc, "ENLIST_OPTION_USED_J2CA0053", objectArray);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ejs.j2c.J2CUtilityClass.callSetTransactionResourceRegistration", "1095");
            try {
                Method method3 = managedConnectionFactory.getClass().getMethod("getTransactionResourceRegistration", null);
                string5 = (String)method3.invoke((Object)managedConnectionFactory, null);
                if (!string5.equals(string4)) {
                    Object[] objectArray = new Object[]{string5, string4, string2};
                    Tr.warning(tc, "ENLIST_OPTION_USED_J2CA0053", objectArray);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                FFDCFilter.processException(invocationTargetException, "com.ibm.ejs.j2c.J2CUtilityClass.callSetTransactionResourceRegistration", "886");
                Throwable throwable = invocationTargetException.getTargetException();
                Object[] objectArray = new Object[]{"getTransactionResourceRegistration", managedConnectionFactory.getClass(), string4, throwable, string2};
                Tr.error(tc, "GET_CONFIGPROPERTY_FAILED_J2CA0066", objectArray);
                throw invocationTargetException;
            }
            catch (Exception exception2) {
                FFDCFilter.processException(exception2, "com.ibm.ejs.j2c.J2CUtilityClass.callSetTransactionResourceRegistration", "1119");
                Object[] objectArray = new Object[]{"getTransactionResourceRegistration", managedConnectionFactory.getClass(), string4, exception2, string2};
                Tr.error(tc, "GET_CONFIGPROPERTY_FAILED_J2CA0066", objectArray);
                throw exception2;
            }
        }
        return string5;
    }

    private static void callMCFSetter(ManagedConnectionFactory managedConnectionFactory, String string, String string2, Object object, String string3) throws Exception {
        if (object != null) {
            String string4 = string2.substring(0, 1).toUpperCase() + string2.substring(1, string2.length());
            String string5 = "set" + string4;
            try {
                Class[] classArray = new Class[]{object.getClass()};
                Method method2 = managedConnectionFactory.getClass().getMethod(string5, classArray);
                Object[] objectArray = new Object[]{object};
                try {
                    method2.invoke((Object)managedConnectionFactory, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    FFDCFilter.processException(invocationTargetException, "com.ibm.ejs.j2c.J2CUtilityClass.callMCFSetter", "942");
                    Throwable throwable = invocationTargetException.getTargetException();
                    Object[] objectArray2 = new Object[]{string4, string, throwable, string3};
                    Tr.warning(tc, "SET_METHOD_EXCP_J2CA0007", objectArray2);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ejs.j2c.J2CUtilityClass.callMCFSetter", "408");
                    Object[] objectArray3 = new Object[]{string4, string, exception, string3};
                    Tr.warning(tc, "SET_METHOD_EXCP_J2CA0007", objectArray3);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                FFDCFilter.processException(noSuchMethodException, "com.ibm.ejs.j2c.J2CUtilityClass.callMCFSetter", "415");
                Object[] objectArray = new Object[]{string, string4, string3};
                Tr.warning(tc, "NO_SET_METHOD_J2CA0008", objectArray);
            }
        }
    }

    private static Boolean getRRSTransactional(ManagedConnectionFactory managedConnectionFactory, String string, String string2) throws Exception {
        Object[] objectArray;
        Boolean bl;
        Boolean bl2;
        block10: {
            bl2 = Boolean.FALSE;
            bl = null;
            String string3 = System.getProperty("os.name");
            if (!string3.equalsIgnoreCase("OS/390") && !string3.equalsIgnoreCase("Z/OS")) {
                return bl2;
            }
            try {
                objectArray = managedConnectionFactory.getClass().getMethod("getRRSTransactional", null);
                try {
                    bl = (Boolean)objectArray.invoke((Object)managedConnectionFactory, null);
                }
                catch (InvocationTargetException invocationTargetException) {
                    FFDCFilter.processException(invocationTargetException, "com.ibm.ejs.j2c.J2CUtilityClass.getRRSTransactional", "1013");
                    Throwable throwable = invocationTargetException.getTargetException();
                    Object[] objectArray2 = new Object[]{"getRRSTransactional", managedConnectionFactory.getClass(), null, throwable, string2};
                    Tr.error(tc, "GET_CONFIGPROPERTY_FAILED_J2CA0066", objectArray2);
                    throw invocationTargetException;
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ejs.j2c.J2CUtilityClass.getRRSTransactional", "1215");
                    Object[] objectArray3 = new Object[]{"getRRSTransactional", managedConnectionFactory.getClass(), null, exception, string2};
                    Tr.error(tc, "GET_CONFIGPROPERTY_FAILED_J2CA0066", objectArray3);
                    throw exception;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                bl = bl2;
                if (!tc.isDebugEnabled()) break block10;
                Object[] objectArray4 = new Object[]{string, string2, managedConnectionFactory};
                Tr.debug(tc, "getRRSTransactional method not supported: ", objectArray4);
            }
        }
        if (bl == null) {
            bl = bl2;
        }
        if (tc.isDebugEnabled()) {
            objectArray = new Object[]{string, string2, managedConnectionFactory};
            if (bl.booleanValue()) {
                Tr.debug(tc, "Configured ManagedConnectionFactory is RRSTransactional: ", objectArray);
            } else {
                Tr.debug(tc, "Configured ManagedConnectionFactory is not RRSTransactional: ", objectArray);
            }
        }
        return bl;
    }

    private static String getThreadIdentitySupport(ManagedConnectionFactory managedConnectionFactory, String string, String string2) throws Exception {
        Object[] objectArray;
        String string3;
        String string4;
        block7: {
            string4 = "NOTALLOWED";
            string3 = null;
            try {
                objectArray = managedConnectionFactory.getClass().getMethod("getThreadIdentitySupport", null);
                try {
                    string3 = (String)objectArray.invoke((Object)managedConnectionFactory, null);
                }
                catch (InvocationTargetException invocationTargetException) {
                    FFDCFilter.processException(invocationTargetException, "com.ibm.ejs.j2c.J2CUtilityClass.getThreadIdentitySupport", "1088");
                    Throwable throwable = invocationTargetException.getTargetException();
                    Object[] objectArray2 = new Object[]{"getThreadIdentitySupport", managedConnectionFactory.getClass(), null, throwable, string2};
                    Tr.error(tc, "GET_CONFIGPROPERTY_FAILED_J2CA0066", objectArray2);
                    throw invocationTargetException;
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ejs.j2c.J2CUtilityClass.getThreadIdentitySupport", "1217");
                    Object[] objectArray3 = new Object[]{"getThreadIdentitySupport", managedConnectionFactory.getClass(), null, exception, string2};
                    Tr.error(tc, "GET_CONFIGPROPERTY_FAILED_J2CA0066", objectArray3);
                    throw exception;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                string3 = string4;
                if (!tc.isDebugEnabled()) break block7;
                Object[] objectArray4 = new Object[]{string, string2, managedConnectionFactory};
                Tr.debug(tc, "getThreadIdentitySupport method not supported: ", objectArray4);
            }
        }
        if (string3 == null) {
            string3 = string4;
        }
        if (tc.isDebugEnabled()) {
            objectArray = new Object[]{string, string2, managedConnectionFactory};
            Tr.debug(tc, "Configured ManagedConnectionFactory ThreadIdentitySupport: " + string3, objectArray);
        }
        return string3;
    }

    private static Boolean getThreadSecurity(ManagedConnectionFactory managedConnectionFactory, String string, String string2) throws Exception {
        Object[] objectArray;
        Boolean bl;
        Boolean bl2;
        block9: {
            bl2 = Boolean.FALSE;
            bl = null;
            try {
                objectArray = managedConnectionFactory.getClass().getMethod("getThreadSecurity", null);
                try {
                    bl = (Boolean)objectArray.invoke((Object)managedConnectionFactory, null);
                }
                catch (InvocationTargetException invocationTargetException) {
                    FFDCFilter.processException(invocationTargetException, "com.ibm.ejs.j2c.J2CUtilityClass.getThreadSecurity", "1158");
                    Throwable throwable = invocationTargetException.getTargetException();
                    Object[] objectArray2 = new Object[]{"getThreadSecurity", managedConnectionFactory.getClass(), null, throwable, string2};
                    Tr.error(tc, "GET_CONFIGPROPERTY_FAILED_J2CA0066", objectArray2);
                    throw invocationTargetException;
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ejs.j2c.J2CUtilityClass.getThreadSecurity", "1216");
                    Object[] objectArray3 = new Object[]{"getThreadSecurity", managedConnectionFactory.getClass(), null, exception, string2};
                    Tr.error(tc, "GET_CONFIGPROPERTY_FAILED_J2CA0066", objectArray3);
                    throw exception;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                bl = bl2;
                if (!tc.isDebugEnabled()) break block9;
                Object[] objectArray4 = new Object[]{string, string2, managedConnectionFactory};
                Tr.debug(tc, "getThreadSecurity method not supported: ", objectArray4);
            }
        }
        if (bl == null) {
            bl = bl2;
        }
        if (tc.isDebugEnabled()) {
            objectArray = new Object[]{string, string2, managedConnectionFactory};
            if (bl.booleanValue()) {
                Tr.debug(tc, "Configured ManagedConnectionFactory requires OS ThreadSecurity when ThreadIdentity is used for getConnection processing: ", objectArray);
            } else {
                Tr.debug(tc, "Configured ManagedConnectionFactory does not require OS ThreadSecurity when ThreadIdentity is used for getConnection processing: ", objectArray);
            }
        }
        return bl;
    }

    private static SecurityHelper createSecurityHelper(ManagedConnectionFactory managedConnectionFactory, MCFExtendedProperties mCFExtendedProperties) throws ResourceException, Exception {
        ClassLoader classLoader;
        try {
            classLoader = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ClassNotFoundException)privilegedActionException.getException();
        }
        final String string = mCFExtendedProperties.getThreadIdentitySupport();
        final ManagedConnectionFactory managedConnectionFactory2 = managedConnectionFactory;
        final MCFExtendedProperties mCFExtendedProperties2 = mCFExtendedProperties;
        SecurityHelper securityHelper = null;
        try {
            if (System.getSecurityManager() != null) {
                securityHelper = (SecurityHelper)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        String string2 = string.equals("NOTALLOWED") ? "com.ibm.ejs.j2c.DefaultSecurityHelper" : "com.ibm.ejs.j2c.ThreadIdentitySecurityHelper";
                        Class<?> clazz = classLoader.loadClass("com.ibm.ejs.j2c.MCFExtendedProperties");
                        Class<?> clazz2 = classLoader.loadClass("javax.resource.spi.ManagedConnectionFactory");
                        Class<?> clazz3 = classLoader.loadClass(string2);
                        Constructor<?> constructor = clazz3.getConstructor(clazz2, clazz);
                        SecurityHelper securityHelper = (SecurityHelper)constructor.newInstance(managedConnectionFactory2, mCFExtendedProperties2);
                        return securityHelper;
                    }
                });
            } else {
                String string2 = string.equals("NOTALLOWED") ? "com.ibm.ejs.j2c.DefaultSecurityHelper" : "com.ibm.ejs.j2c.ThreadIdentitySecurityHelper";
                Class<?> clazz = classLoader.loadClass("com.ibm.ejs.j2c.MCFExtendedProperties");
                Class<?> clazz2 = classLoader.loadClass("javax.resource.spi.ManagedConnectionFactory");
                Class<?> clazz3 = classLoader.loadClass(string2);
                Constructor<?> constructor = clazz3.getConstructor(clazz2, clazz);
                securityHelper = (SecurityHelper)constructor.newInstance(managedConnectionFactory2, mCFExtendedProperties2);
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            Tr.debug(tc, "Failed to create Security Helper due to PrivilegedActionException occurred. Actual exception encountered was: ", exception);
            ResourceException resourceException = new ResourceException("ThreadIdentitySecurityHelper.beforeGettingConnection() failed attempting to push the current user identity to the OS Thread");
            resourceException.initCause((Throwable)exception);
            throw resourceException;
        }
        catch (Exception exception) {
            Tr.debug(tc, "Failed to create Security Helper. The following exception occurred:", exception);
            throw exception;
        }
        return securityHelper;
    }

    protected static final void setMcfProps(ManagedConnectionFactory managedConnectionFactory, ManagedConnectionFactoryProps managedConnectionFactoryProps, String string, boolean bl) throws NoSuchMethodException, Exception {
        block10: {
            String string2 = "ConnectionFactoryType";
            try {
                Class[] classArray = new Class[]{managedConnectionFactoryProps.getConnectionFactoryType().getClass()};
                Method method2 = managedConnectionFactory.getClass().getMethod("setConnectionFactoryType", classArray);
                Object[] objectArray = new Object[]{managedConnectionFactoryProps.getConnectionFactoryType()};
                try {
                    method2.invoke((Object)managedConnectionFactory, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    FFDCFilter.processException(invocationTargetException, "com.ibm.ejs.j2c.J2CUtilityClass.setMcfProps", "1338");
                    String string3 = managedConnectionFactory.getClass().getName();
                    String string4 = string;
                    if (bl) {
                        string4 = string + " for XA recovery";
                    }
                    Throwable throwable = invocationTargetException.getTargetException();
                    Object[] objectArray2 = new Object[]{string2, string3, throwable, string4};
                    Tr.error(tc, "SET_METHOD_EXCP_J2CA0036", objectArray2);
                    if (!bl) {
                        throw invocationTargetException;
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ejs.j2c.J2CUtilityClass.setMcfProps", "861");
                    String string5 = managedConnectionFactory.getClass().getName();
                    String string6 = string;
                    if (bl) {
                        string6 = string + " for XA recovery";
                    }
                    Object[] objectArray3 = new Object[]{string2, string5, exception, string6};
                    Tr.error(tc, "SET_METHOD_EXCP_J2CA0036", objectArray3);
                    if (!bl) {
                        throw exception;
                    }
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                FFDCFilter.processException(noSuchMethodException, "com.ibm.ejs.j2c.J2CUtilityClass.setMcfProps", "871");
                String string7 = managedConnectionFactory.toString().trim();
                String string8 = string;
                if (bl) {
                    string8 = string + " for XA recovery";
                }
                Object[] objectArray = new Object[]{string7, string2, string8};
                Tr.error(tc, "NO_SET_METHOD_EXCP_J2CA0035", objectArray);
                if (bl) break block10;
                throw noSuchMethodException;
            }
        }
    }

    public static final boolean nullSafeEquals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object == object2) {
            return true;
        }
        return object.equals(object2);
    }

    public static J2CGlobalConfigProperties createGlobalConfigProps(String string, ResourceAdapterDD resourceAdapterDD, ConnectorPoolProperties connectorPoolProperties, ManagedConnectionFactoryProps managedConnectionFactoryProps, ConnectorProperties connectorProperties, Properties properties, CMConfigData cMConfigData, PmiProps pmiProps, MCFEntry mCFEntry, Properties properties2) throws Exception {
        Object object;
        String string2;
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createGlobalConfigProps");
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = connectorPoolProperties.isTestConnection();
        int n = connectorPoolProperties.getTestConnectionInterval();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = connectorPoolProperties.getSurgeCreationInterval();
        int n6 = connectorPoolProperties.getSurgeThreshold();
        int n7 = connectorPoolProperties.getStuckTimerTime();
        int n8 = connectorPoolProperties.getStuckTime();
        int n9 = connectorPoolProperties.getStuckThreshold();
        int n10 = connectorPoolProperties.getHoldTimeLimit();
        boolean bl7 = false;
        int n11 = connectorPoolProperties.getMaxConnections();
        int n12 = connectorPoolProperties.getMinConnections();
        boolean bl8 = false;
        int n13 = connectorPoolProperties.getConnectionTimeout();
        String string4 = connectorPoolProperties.getPurgePolicy();
        int n14 = connectorPoolProperties.getReapTime();
        int n15 = connectorPoolProperties.getUnusedTimeout();
        int n16 = connectorPoolProperties.getAgedTimeout();
        MCFExtendedProperties mCFExtendedProperties = null;
        mCFExtendedProperties = mCFEntry.getMCFExtendedProperties();
        String string5 = properties2.getProperty("manageCachedHandles", "false");
        if (string5.equalsIgnoreCase("true")) {
            bl4 = true;
        }
        if ((string3 = properties2.getProperty("logMissingTransactionContext", "true")).equalsIgnoreCase("false")) {
            bl5 = false;
        }
        if ((string2 = properties2.getProperty("diagnoseConnectionUsage", "false")).equalsIgnoreCase("true")) {
            bl8 = true;
        }
        if (resourceAdapterDD != null) {
            bl = resourceAdapterDD.getReauthenticationSupport();
        }
        if (properties != null && managedConnectionFactoryProps != null) {
            bl2 = true;
            bl = true;
            object = mCFEntry.getManagedConnectionFactory();
            if (object instanceof WSManagedConnectionFactory && ((WSManagedConnectionFactory)object).isReauthenticationEnabled()) {
                bl3 = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Reauthentication is supported for Connection Pool " + pmiProps.getPmiName());
                }
            }
        } else if (bl && tc.isDebugEnabled()) {
            Tr.debug(tc, "Reauthentication is supported for Connection Pool " + pmiProps.getPmiName());
        }
        if (n11 > 0) {
            if (n11 > 10) {
                if (n2 == 0) {
                    n2 = 1;
                }
                if (n4 == 0) {
                    n4 = n11 / 2;
                }
                if (n3 == 0 && (n3 = n11 * 2) < 200) {
                    n3 = 200;
                }
            } else {
                if (n2 == 0) {
                    n2 = 1;
                }
                if (n3 == 0) {
                    n3 = 200;
                }
                if (n4 == 0) {
                    n4 = 5;
                }
            }
        } else {
            if (n2 == 0) {
                n2 = 1;
            }
            if (n3 == 0) {
                n3 = 200;
            }
            if (n4 == 0) {
                n4 = 100;
            }
        }
        bl7 = connectorProperties.findConnectorPropertyBoolean("InactiveConnectionSupport", false);
        object = null;
        if (cMConfigData != null) {
            object = cMConfigData.getCFDetailsKey();
        }
        J2CGlobalConfigProperties j2CGlobalConfigProperties = new J2CGlobalConfigProperties(pmiProps.getPmiName(), (String)object, mCFExtendedProperties.getTransactionResourceRegistration(), bl4, mCFExtendedProperties.getRRSTransactional(), mCFExtendedProperties.getThreadSecurity(), mCFExtendedProperties.getThreadIdentitySupport(), bl5, mCFExtendedProperties.getUserName(), resourceAdapterDD, bl6, n, bl7, bl, bl2, n2, n3, n4, bl3, mCFEntry.getManagedConnectionFactory(), bl8, n13, n11, n12, string4, n14, n15, n16, n5, n6, n7, n8, n9, n10);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createGlobalConfigProps", j2CGlobalConfigProperties);
        }
        return j2CGlobalConfigProperties;
    }

    public static Properties packageRAMetaData(ConnectionFactory connectionFactory, Properties properties) {
        Properties properties2 = null;
        properties2 = properties == null ? new Properties() : properties;
        ResourceAdapterMetaData resourceAdapterMetaData = null;
        if (connectionFactory != null) {
            block7: {
                try {
                    resourceAdapterMetaData = connectionFactory.getMetaData();
                }
                catch (ResourceException resourceException) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "raMetaData.getMetaData() threw the following exception: ", (Object)resourceException);
                }
            }
            if (resourceAdapterMetaData != null) {
                properties2.put("AdapterName", resourceAdapterMetaData.getAdapterName());
                properties2.put("AdapterShortDescription", resourceAdapterMetaData.getAdapterShortDescription());
                properties2.put("AdapterVendorName", resourceAdapterMetaData.getAdapterVendorName());
                properties2.put("AdapterVersion", resourceAdapterMetaData.getAdapterVersion());
                properties2.put("InteractionSpecsSupported", resourceAdapterMetaData.getInteractionSpecsSupported());
                properties2.put("SpecVersion", resourceAdapterMetaData.getSpecVersion());
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "packageRAMetaData() - ConnectionFactory parm was null");
        }
        if (connectionFactory == null || resourceAdapterMetaData == null) {
            properties2.put("AdapterName", "Not Available");
            properties2.put("AdapterShortDescription", "Not Available");
            properties2.put("AdapterVendorName", "Not Available");
            properties2.put("AdapterVersion", "Not Available");
            properties2.put("InteractionSpecsSupported", new String[]{"Not Available"});
            properties2.put("SpecVersion", "Not Available");
        }
        return properties2;
    }

    public static Properties packageConnectionMetaData(Connection connection, Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        ConnectionMetaData connectionMetaData = null;
        if (connection != null) {
            block12: {
                try {
                    connectionMetaData = connection.getMetaData();
                }
                catch (ResourceException resourceException) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "Connection.getMetaData() threw the following exception: ", (Object)resourceException);
                }
            }
            if (connectionMetaData != null) {
                String string = "Not Available";
                try {
                    string = connectionMetaData.getEISProductName();
                }
                catch (ResourceException resourceException) {
                    // empty catch block
                }
                properties.put("EISProductName", string);
                string = "Not Available";
                try {
                    string = connectionMetaData.getEISProductVersion();
                }
                catch (ResourceException resourceException) {
                    // empty catch block
                }
                properties.put("EISProductVersion", string);
                string = "Not Available";
                try {
                    string = connectionMetaData.getUserName();
                }
                catch (ResourceException resourceException) {
                    // empty catch block
                }
                properties.put("UserName", string);
            } else {
                properties.put("EISProductName", "Not Available");
                properties.put("EISProductVersion", "Not Available");
                properties.put("UserName", "Not Available");
            }
        }
        return properties;
    }

    public static Properties packageDataSourceMetaData(J2CGlobalConfigProperties j2CGlobalConfigProperties, java.sql.Connection connection) {
        Properties properties = null;
        String string = null;
        DatabaseMetaData databaseMetaData = null;
        if (connection != null) {
            block27: {
                try {
                    databaseMetaData = connection.getMetaData();
                }
                catch (SQLException sQLException) {
                    if (!tc.isDebugEnabled()) break block27;
                    Tr.debug(tc, "dataSource.getMetaData() threw the following exception: ", sQLException);
                }
            }
            if (databaseMetaData != null) {
                if (j2CGlobalConfigProperties.dsMetaDataProps == null) {
                    properties = new Properties();
                    string = "Not Available";
                    string = String.valueOf(databaseMetaData.getDriverMajorVersion());
                    properties.put("DriverMajorVersion", string);
                    string = "Not Available";
                    string = String.valueOf(databaseMetaData.getDriverMinorVersion());
                    properties.put("DriverMinorVersion", string);
                    string = "Not Available";
                    try {
                        string = String.valueOf(databaseMetaData.getDriverName());
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    properties.put("DriverName", string);
                    string = "Not Available";
                    try {
                        string = String.valueOf(databaseMetaData.getDriverVersion());
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    properties.put("DriverVersion", string);
                    string = "Not Available";
                    try {
                        string = String.valueOf(databaseMetaData.getJDBCMajorVersion());
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    properties.put("JDBCMajorVersion", string);
                    string = "Not Available";
                    try {
                        string = String.valueOf(databaseMetaData.getJDBCMinorVersion());
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    properties.put("JDBCMinorVersion", string);
                    j2CGlobalConfigProperties.dsMetaDataProps = properties;
                } else {
                    properties = (Properties)j2CGlobalConfigProperties.dsMetaDataProps.clone();
                }
                string = "Not Available";
                try {
                    string = databaseMetaData.getUserName();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                properties.put("UserName", string);
                string = "Not Available";
                try {
                    string = databaseMetaData.getURL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                properties.put("URL", string);
                string = "Not Available";
                try {
                    string = String.valueOf(databaseMetaData.getDatabaseMajorVersion());
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                properties.put("DatabaseMajorVersion", string);
                string = "Not Available";
                try {
                    string = String.valueOf(databaseMetaData.getDatabaseMinorVersion());
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                properties.put("DatabaseMinorVersion", string);
                string = "Not Available";
                try {
                    string = databaseMetaData.getDatabaseProductName();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                properties.put("DatabaseProductName", string);
                string = "Not Available";
                try {
                    string = databaseMetaData.getDatabaseProductVersion();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                properties.put("DatabaseProductVersion", string);
            } else {
                string = "Not Available";
                properties.put("DriverMajorVersion", string);
                properties.put("DriverMinorVersion", string);
                properties.put("DriverName", string);
                properties.put("DriverVersion", string);
                properties.put("JDBCMajorVersion", string);
                properties.put("JDBCMinorVersion", string);
                properties.put("UserName", string);
                properties.put("URL", string);
                properties.put("DatabaseMajorVersion", string);
                properties.put("DatabaseMinorVersion", string);
                properties.put("DatabaseProductName", string);
                properties.put("DatabaseProductVersion", string);
            }
        }
        return properties;
    }

    public static HashMap stateDumpDeepClone(HashMap hashMap) {
        if (hashMap == null) {
            return null;
        }
        HashMap hashMap2 = (HashMap)hashMap.clone();
        Set set = hashMap2.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = hashMap2.get(k);
            if (!(v instanceof HashMap)) continue;
            hashMap2.put(k, J2CUtilityClass.stateDumpDeepClone((HashMap)v));
        }
        return hashMap2;
    }

    public static Object deserObjByte(byte[] byArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deserObjByte");
        }
        Object object = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ejs.j2c.J2CUtilityClass.deserObjByte", "1411");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to deserialize an object from the byte stream", exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deserObjByte");
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deserObjByte", object);
        }
        return object;
    }

    public static byte[] serObjByte(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serObjByte");
        }
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ejs.j2c.J2CUtilityClass.serObjByte", "1435");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to serialize an object to the byte stream", iOException);
            }
            byArray = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serObjByte");
        }
        return byArray;
    }

    public static String deserializeString(byte[] byArray, ClassLoader classLoader) {
        String string;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deserializeString", classLoader);
            }
            string = null;
            try {
                if (classLoader != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Deserializing using custom classloader: ", classLoader);
                    }
                    final String string2 = new J2CUtilityClass().getClass().getName();
                    final ClassLoader classLoader2 = classLoader;
                    final byte[] byArray2 = byArray;
                    try {
                        string = (String)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                Class<?> clazz = Class.forName(string2, true, classLoader2);
                                return clazz.getMethod("deserObjByte", byArray2.getClass()).invoke(null, new Object[]{byArray2});
                            }
                        });
                        break block10;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException(privilegedActionException, "com.ibm.ejs.j2c.J2CUtilityClass.deserializeString", "1223");
                        Exception exception = privilegedActionException.getException();
                        throw exception;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No classloader supplied. Deserializing using this objects current classloader: ", J2CXAResourceFactory.class.getClass().getClassLoader());
                }
                string = (String)J2CUtilityClass.deserObjByte(byArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException(classNotFoundException, "com.ibm.ejs.j2c.J2CUtilityClass.deserializeString", "1237");
                String string3 = classNotFoundException.getMessage();
                int n = string3.indexOf(_defaultThrowableDelimiter);
                string3 = string3.substring(n + 1);
                Tr.error(tc, "UNABLE_TO_FIND_CLASS_J2CA0200", string3);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ejs.j2c.J2CUtilityClass.deserializeString", "1245");
                Tr.error(tc, "OBJECT_DESERIALIZE_FAILED_J2CA0201", throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deserializeString", string);
        }
        return string;
    }

    public static String generateExceptionString(Throwable throwable) {
        return J2CUtilityClass.generateExceptionString(throwable, _defaultThrowableDelimiter);
    }

    public static String generateExceptionString(Throwable throwable, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (throwable != null) {
            stringBuffer.append(throwable.toString());
            Throwable throwable2 = J2CUtilityClass.getNextThrowable(throwable);
            if (throwable2 != null) {
                stringBuffer.append(string);
                stringBuffer.append(J2CUtilityClass.generateExceptionString(J2CUtilityClass.getNextThrowable(throwable), string));
            }
        }
        return stringBuffer.toString();
    }

    public static Throwable getNextThrowable(Throwable throwable) {
        Throwable throwable2 = null;
        if (throwable != null && (throwable2 = throwable.getCause()) == null) {
            if (throwable instanceof SQLException) {
                throwable2 = ((SQLException)throwable).getNextException();
            } else if (throwable instanceof ResourceException) {
                throwable2 = ((ResourceException)throwable).getCause();
            }
        }
        return throwable2;
    }

    public static int getResolutionControl() {
        int n = 0;
        boolean bl = false;
        UOWCurrent uOWCurrent = TransactionManagerFactory.getUOWCurrent();
        UOWCoordinator uOWCoordinator = uOWCurrent.getUOWCoord();
        if (uOWCoordinator != null) {
            bl = ((LocalTransactionCoordinator)((Object)uOWCoordinator)).isContainerResolved();
        }
        n = bl ? 1 : 0;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getResolutionControl returning " + n);
        }
        return n;
    }

    public static MCFEntry createMCFEntry(String string, ConnectorProperties connectorProperties, ResourceAdapterDD resourceAdapterDD, Properties properties, MBeanProps mBeanProps, CMConfigData cMConfigData, boolean bl) throws Exception {
        return J2CUtilityClass.createMCFEntry(string, connectorProperties, resourceAdapterDD, properties, mBeanProps, cMConfigData, null, false);
    }
}

