/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.J2CGlobalConfigProperties;
import com.ibm.ejs.j2c.MCWrapper;
import com.ibm.ejs.j2c.PoolManager;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.J2CPerf;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import java.util.ArrayList;
import javax.resource.spi.ManagedConnection;

public final class MCWrapperPool {
    private static final TraceComponent tc = Tr.register(MCWrapperPool.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");
    private PoolManager pm;
    private final int initialSize;
    private final J2CPerf pmiData;
    private final ArrayList pool;
    private final J2CGlobalConfigProperties gConfigProps;

    public MCWrapperPool(int n, PoolManager poolManager, J2CPerf j2CPerf, J2CGlobalConfigProperties j2CGlobalConfigProperties) {
        this.initialSize = n;
        this.pm = poolManager;
        this.pmiData = j2CPerf;
        this.gConfigProps = j2CGlobalConfigProperties;
        this.pool = this.initialSize > 0 ? new ArrayList(this.initialSize) : new ArrayList(50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized com.ibm.ws.j2c.MCWrapper getInstance(ManagedConnection managedConnection) {
        int n;
        if (this.pm == null) {
            throw new IllegalStateException("MCWrapper pool is not intialized");
        }
        com.ibm.ws.j2c.MCWrapper mCWrapper = null;
        ArrayList arrayList = this.pool;
        synchronized (arrayList) {
            n = this.pool.size();
            if (n > 0) {
                mCWrapper = (com.ibm.ws.j2c.MCWrapper)this.pool.remove(n - 1);
            }
        }
        if (mCWrapper == null) {
            if (this.initialSize == 0 || n < this.initialSize) {
                mCWrapper = new MCWrapper(this.pm, this.pmiData, this.gConfigProps);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "MCWrapper pool was asked to grow beyond its capacity");
                }
                throw new IllegalStateException("MCWrapperPool asked to grow beyond its capacity");
            }
        }
        if (managedConnection != null) {
            try {
                mCWrapper.setManagedConnection(managedConnection);
            }
            catch (NullPointerException nullPointerException) {
                FFDCFilter.processException((Throwable)nullPointerException, "com.ibm.ejs.j2c.MCWrapperPool.getInstance", "207", this);
                Tr.error(tc, "MCWRAPPER_GETINSTANCE_ERROR_J2CA0096", nullPointerException);
                throw new IllegalStateException("Cannot setManagedConnection on null wrapper");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Managed connection is not created or null");
        }
        return mCWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseInstance(com.ibm.ws.j2c.MCWrapper mCWrapper) throws IllegalStateException {
        int n;
        Serializable serializable;
        if (this.pm == null) {
            throw new IllegalStateException("MCWrapper pool is not intialized");
        }
        String string = mCWrapper.getStateString();
        if (string.equals("STATE_ACTIVE_FREE") || string.equals("STATE_INACTIVE")) {
            if (((MCWrapper)mCWrapper).do_not_reuse_mcw) {
                if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Releasing mcw and not reusing " + mCWrapper + " from pool manager" + this.pm.hashCode());
                }
                serializable = this.pool;
                synchronized (serializable) {
                    n = this.pool.size();
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding mcw to reuse pool " + mCWrapper + " in mcw pool from pool manager" + this.pm.hashCode());
                }
                if (string.equals("STATE_ACTIVE_FREE")) {
                    mCWrapper.setStateInActive();
                }
                serializable = this.pool;
                synchronized (serializable) {
                    this.pool.add(mCWrapper);
                    n = this.pool.size();
                }
            }
        } else {
            IllegalStateException illegalStateException = new IllegalStateException("releaseInstance: illegal state exception. State = " + string);
            Object[] objectArray = new Object[]{"releaseInstance", illegalStateException};
            Tr.error(tc, "ILLEGAL_STATE_EXCEPTION_J2CA0079", objectArray);
            throw illegalStateException;
        }
        if (this.initialSize != 0 && n > this.initialSize && tc.isDebugEnabled()) {
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append("This pool was created with ");
            ((StringBuffer)serializable).append(this.initialSize);
            ((StringBuffer)serializable).append("but size now is ");
            ((StringBuffer)serializable).append(n);
            Tr.debug(tc, ((StringBuffer)serializable).toString());
        }
    }

    public void clearMCWrapperPool() {
        for (int i = this.pool.size(); i > 0; --i) {
            com.ibm.ws.j2c.MCWrapper mCWrapper = (com.ibm.ws.j2c.MCWrapper)this.pool.remove(i - 1);
            mCWrapper.clearMCWrapper();
        }
        this.pm = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.pm);
        stringBuffer.append(", ");
        stringBuffer.append(this.pmiData == null ? "null" : this.pmiData.toString());
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }
}

