/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

final class NamesQueryer
implements PrivilegedExceptionAction {
    private static final TraceComponent tc = Tr.register(NamesQueryer.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");
    protected String id;
    protected boolean mbeanErrorOccurred = false;
    private AdminService adminService = AdminServiceFactory.getAdminService();
    private ObjectName objectName;

    NamesQueryer() {
    }

    public Object run() {
        block5: {
            try {
                if (this.id != null && !this.id.equals("")) {
                    this.objectName = new ObjectName("WebSphere:mbeanIdentifier=" + this.id + ",*");
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "input id is null or empty");
                    }
                    this.mbeanErrorOccurred = true;
                }
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Problems creating MBean ObjectName <" + this.objectName + ">.  Exception: " + malformedObjectNameException);
            }
        }
        return this.adminService.queryNames(this.objectName, null);
    }

    public ObjectName queryNames(String string) {
        ObjectName objectName = null;
        Set set = null;
        try {
            this.id = string;
            set = (Set)AccessController.doPrivileged((PrivilegedExceptionAction)this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        if (!set.isEmpty()) {
            objectName = (ObjectName)set.iterator().next();
            if (objectName == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "name for " + string + " is null");
                }
                this.mbeanErrorOccurred = true;
            }
            if (set.size() > 1 && tc.isDebugEnabled()) {
                Tr.debug(tc, "Returned name set for " + string + " has more than one element.  Contact SM.");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The MBean for " + string + " could not be found");
            }
            this.mbeanErrorOccurred = true;
        }
        return objectName;
    }
}

