/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.ConnectionFactoryRefBuilder;
import com.ibm.ejs.j2c.MCFExtendedProperties;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import java.io.IOException;
import java.io.Serializable;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.login.LoginException;

class PrivExAction
implements PrivilegedExceptionAction,
Serializable {
    private static final long serialVersionUID = 1786534903510827206L;
    private static final TraceComponent tc = Tr.register(PrivExAction.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");
    private static HashMap warningIssued = new HashMap();
    protected ManagedConnectionFactory mcf;
    protected MCFExtendedProperties mcfXProps;
    protected String cfName;
    protected String mappingConfig;
    protected String uidpsw;
    protected String loginConfigurationName;
    protected HashMap loginConfigProperties;
    protected String xaRecoveryAuthAlias;

    PrivExAction() {
    }

    public Object run() throws ResourceException {
        try {
            if (this.xaRecoveryAuthAlias != null && !this.xaRecoveryAuthAlias.equals("")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "calling deprecated WSDPM.getSubject(" + this.mcf + ", " + WSDefaultPrincipalMapping.DEFAULT_PRINCIPAL_MAPPING + ", " + this.xaRecoveryAuthAlias + ") for XA recovery");
                }
                return WSDefaultPrincipalMapping.getSubject(this.mcf, WSDefaultPrincipalMapping.DEFAULT_PRINCIPAL_MAPPING, this.xaRecoveryAuthAlias);
            }
            if (this.loginConfigurationName != null && !this.loginConfigurationName.equals("")) {
                if (this.loginConfigurationName.equals(ConnectionFactoryRefBuilder.DEFAULT_MAPPING_MODULE_mappingConfigAlias) && (this.loginConfigProperties == null || this.loginConfigProperties.equals("")) && tc.isDebugEnabled()) {
                    Tr.debug(tc, "loginConfiguration is " + this.loginConfigurationName + " but no login config properties were specified.  " + "(with loginConfigurationName=DefaultPrincipalMapping, " + "we expect com.ibm.mapping.authDataAlias=<some alias>).");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "calling WSDPM.getMappedSubject(" + this.mcf + ", " + this.loginConfigurationName + ", " + this.loginConfigProperties + ")");
                }
                return WSDefaultPrincipalMapping.getMappedSubject(this.mcf, this.loginConfigurationName, this.loginConfigProperties);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loginConfigurationName is null.  Using deprecated container-managed auth data");
            }
            if (this.mappingConfig == null || this.mappingConfig.equals("")) {
                this.mappingConfig = "DefaultPrincipalMapping";
                Tr.warning(tc, "NO_MAPPING_CONFIG_ALIAS_J2CA0144", this.cfName);
            }
            if ((this.uidpsw == null || this.uidpsw.equals("")) && this.mappingConfig.equals("DefaultPrincipalMapping") && warningIssued.get(this.cfName) == null) {
                String string = this.mcfXProps.getThreadIdentitySupport();
                if (string.equals("NOTALLOWED")) {
                    Tr.warning(tc, "NO_ALIAS_J2CA0114", this.cfName);
                }
                warningIssued.put(this.cfName, true);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "calling deprecated WSDPM.getSubject(" + this.mcf + ", " + this.mappingConfig + ", " + this.uidpsw + ")");
            }
            return WSDefaultPrincipalMapping.getSubject(this.mcf, this.mappingConfig, this.uidpsw);
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{iOException.getMessage()};
            FFDCFilter.processException(iOException, "com.ibm.ejs.j2c.PrivExAction.run", "805", this, objectArray);
            Object[] objectArray2 = new Object[]{this.cfName, iOException};
            Tr.error(tc, "FAILED_GETTING_SUBJECT_J2CA0044", objectArray2);
            throw new ResourceException("IOException getting Subject", (Throwable)iOException);
        }
        catch (LoginException loginException) {
            Object[] objectArray = new Object[]{loginException.getMessage()};
            FFDCFilter.processException(loginException, "com.ibm.ejs.j2c.PrivExAction.run", "810", this, objectArray);
            Object[] objectArray3 = new Object[]{this.cfName, loginException};
            Tr.error(tc, "FAILED_GETTING_SUBJECT_J2CA0044", objectArray3);
            throw new ResourceException("LoginException getting Subject", (Throwable)loginException);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{exception.getMessage()};
            FFDCFilter.processException(exception, "com.ibm.ejs.j2c.PrivExAction.run", "815", this, objectArray);
            Object[] objectArray4 = new Object[]{this.cfName, exception};
            Tr.error(tc, "FAILED_GETTING_SUBJECT_J2CA0044", objectArray4);
            throw new ResourceException("Exception getting Subject", (Throwable)exception);
        }
    }

    protected final void setMcf(ManagedConnectionFactory managedConnectionFactory) {
        this.mcf = managedConnectionFactory;
    }

    protected final void setMcfXProps(MCFExtendedProperties mCFExtendedProperties) {
        this.mcfXProps = mCFExtendedProperties;
    }

    protected final void setCfName(String string) {
        this.cfName = string;
    }

    protected final void setMappingConfig(String string) {
        this.mappingConfig = string;
    }

    protected final void setUidpsw(String string) {
        this.uidpsw = string;
    }

    protected final void setLoginConfigurationName(String string) {
        this.loginConfigurationName = string;
    }

    protected final void setLoginConfigProperties(HashMap hashMap) {
        this.loginConfigProperties = hashMap;
    }

    protected final void setXaRecoveryAuthAlias(String string) {
        this.xaRecoveryAuthAlias = string;
    }
}

