/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.ConnectorRuntime;
import com.ibm.ejs.j2c.ResourceAdapterDD;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.rasdiag.DiagnosticTypedValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import org.eclipse.jst.j2ee.jca.TransactionSupportKind;

public final class ResourceAdapterDDImpl
implements ResourceAdapterDD,
Serializable {
    private static final long serialVersionUID = -4347094359843983146L;
    public static final String NO_MCF_CLASSNAME_SPECIFIED = "NO_MCF_CLASSNAME_SPECIFIED";
    public static final String NO_CF_INTERFACE_SPECIFIED = "NO_CF_INTERFACE_SPECIFIED";
    public static final int NO_TRANSACTION = 0;
    public static final int LOCAL_TRANSACTION = 1;
    public static final int XA_TRANSACTION = 2;
    public static final int INVALID_TX_TYPE = 3;
    public static final String String_NO_TRANSACTION = TransactionSupportKind.NO_TRANSACTION_LITERAL.getName();
    public static final String String_LOCAL_TRANSACTION = TransactionSupportKind.LOCAL_TRANSACTION_LITERAL.getName();
    public static final String String_XA_TRANSACTION = TransactionSupportKind.XA_TRANSACTION_LITERAL.getName();
    private static final TraceComponent tc = Tr.register(ResourceAdapterDDImpl.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");
    private String mcfClass;
    private String cfInterface;
    private int transactionSupport;
    private boolean reauthenticationSupport = false;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("mcfClass", String.class), new ObjectStreamField("cfInterface", String.class), new ObjectStreamField("transactionSupport", Integer.TYPE), new ObjectStreamField("reauthenticationSupport", Boolean.TYPE)};

    public String getConnectionFactoryInterface() {
        return this.cfInterface;
    }

    public String getManagedConnectionFactoryClass() {
        return this.mcfClass;
    }

    public int getTransactionSupport() {
        return this.transactionSupport;
    }

    public boolean isReauthenticationSupported() {
        return this.reauthenticationSupport;
    }

    public void setConnectionFactoryInterface(String string) {
        this.cfInterface = string;
    }

    public void setManagedConnectionFactoryClass(String string) {
        this.mcfClass = string;
    }

    public void setReauthenticationSupport(boolean bl) {
        this.reauthenticationSupport = bl;
    }

    public boolean getReauthenticationSupport() {
        return this.reauthenticationSupport;
    }

    public void setTransactionSupport(int n) {
        if (n >= 0 && n < 3) {
            this.transactionSupport = n;
        } else {
            Object[] objectArray = new Object[]{"transaction", new Integer(n), "0=NO_TRANSACTION"};
            Tr.warning(tc, "INVALID_OR_UNEXPECTED_SETTING_J2CA0067", objectArray);
            this.transactionSupport = 0;
        }
    }

    public boolean supportsLocalTransaction() {
        return this.transactionSupport == 1;
    }

    public boolean supportsXATransaction() {
        return this.transactionSupport == 2;
    }

    public boolean supportsNoTransaction() {
        return this.transactionSupport == 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(60);
        String string = ConnectorRuntime.nl;
        stringBuffer.append("[Resource Adapter DD]" + string);
        stringBuffer.append("\tManagedConnectionFactory Class Name: " + this.mcfClass + string);
        stringBuffer.append("\tConnection Factory Interface Name:   " + this.cfInterface + string);
        stringBuffer.append("\tTransaction Support:                 " + this.transactionSupport + string);
        stringBuffer.append("\tReauthentication Support:            " + this.reauthenticationSupport + string);
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeObject");
        }
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("mcfClass", this.mcfClass);
        putField.put("cfInterface", this.cfInterface);
        putField.put("transactionSupport", this.transactionSupport);
        putField.put("reauthenticationSupport", this.reauthenticationSupport);
        objectOutputStream.writeFields();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeObject");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readObject", objectInputStream);
        }
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        if (tc.isDebugEnabled()) {
            for (int i = 0; i < serialPersistentFields.length; ++i) {
                String string = serialPersistentFields[i].getName();
                if (!getField.defaulted(string)) continue;
                Tr.warning(tc, "DESERIALIZATION_FIELD_NOT_FOUND_J2CA0278", new Object[]{string, "com.ibm.ejs.j2c.ResourceAdapterDDImpl"});
            }
        }
        this.mcfClass = (String)getField.get("mcfClass", null);
        this.cfInterface = (String)getField.get("cfInterface", null);
        this.transactionSupport = getField.get("transactionSupport", 3);
        this.reauthenticationSupport = getField.get("reauthenticationSupport", false);
        if (tc.isEntryEnabled()) {
            Object[] objectArray = new Object[]{this.mcfClass, this.cfInterface, new Integer(this.transactionSupport), this.reauthenticationSupport};
            Tr.exit(tc, "readObject", objectArray);
        }
    }

    public LinkedHashMap getConfigDump(String string, boolean bl) {
        LinkedHashMap<String, DiagnosticTypedValue> linkedHashMap = new LinkedHashMap<String, DiagnosticTypedValue>();
        Pattern pattern = Pattern.compile(string);
        if (pattern.matcher("current-resourceAdapterDD-mcfClass").matches()) {
            linkedHashMap.put("mcfClass", new DiagnosticTypedValue(this.mcfClass, null));
        }
        if (pattern.matcher("current-resourceAdapterDD-cfInterface").matches()) {
            linkedHashMap.put("cfInterface", new DiagnosticTypedValue(this.cfInterface, null));
        }
        if (pattern.matcher("current-resourceAdapterDD-transactionSupport").matches()) {
            linkedHashMap.put("transactionSupport", new DiagnosticTypedValue(this.transactionSupport, null));
        }
        if (pattern.matcher("current-resourceAdapterDD-reauthenticationSupport").matches()) {
            linkedHashMap.put("reauthenticationSupport", new DiagnosticTypedValue(this.reauthenticationSupport, null));
        }
        return linkedHashMap;
    }
}

