/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.MCWrapper;
import com.ibm.ejs.j2c.PoolManager;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;

public final class StuckTaskTimer
extends Thread {
    private long m_interval;
    private boolean m_exiled = false;
    private PoolManager _pm;
    private int collectorStuckCount = 0;
    private Object stuckLockObject = new Object();
    private static final TraceComponent tc = Tr.register(StuckTaskTimer.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");

    protected StuckTaskTimer(long l, PoolManager poolManager) {
        this.m_interval = l * 1000L;
        this._pm = poolManager;
        final StuckTaskTimer stuckTaskTimer = this;
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                stuckTaskTimer.setDaemon(true);
                return null;
            }
        });
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeStuckTask() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeStuckTask");
        }
        ++this.collectorStuckCount;
        if (this.collectorStuckCount > 1) {
            --this.collectorStuckCount;
            return;
        }
        Object object = this._pm.mcToMCWMapLock;
        synchronized (object) {
            Iterator iterator = this._pm.mcToMCWMap.values().iterator();
            long l = System.currentTimeMillis();
            int n = 0;
            while (iterator.hasNext()) {
                long l2;
                MCWrapper mCWrapper = (MCWrapper)iterator.next();
                long l3 = mCWrapper.getStuckTimeStart();
                if (l3 <= 0L || (l2 = l - l3) <= (long)(this._pm.gConfigProps.getStuckTime() * 1000)) continue;
                ++n;
                if (!tc.isDebugEnabled()) continue;
                mCWrapper.amountOfStuckTime = (int)l2 / 1000;
                Tr.debug(tc, "This managed connection " + mCWrapper + " is stuck for " + mCWrapper.amountOfStuckTime + " seconds");
            }
            this._pm.stuckConnections = this._pm.gConfigProps.getStuckThreshold() <= n;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stuck mode is " + this._pm.stuckConnections + " with " + n + " connection stuck");
            }
        }
        --this.collectorStuckCount;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeStuckTask");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getInterval() {
        Object object = this.stuckLockObject;
        synchronized (object) {
            return this.m_interval / 1000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (!this.m_exiled) {
                Object object = this.stuckLockObject;
                synchronized (object) {
                    this.stuckLockObject.wait(this.m_interval);
                    if (!this.m_exiled) {
                        this.executeStuckTask();
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ejs.j2c.poolmanager.StuckTaskTimer.run", "112", this);
            Tr.error(tc, "INTERUPTED_EXCEPTION_J2CA0091");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TaskTimer exiting run()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInterval(long l) {
        Object object = this.stuckLockObject;
        synchronized (object) {
            this.m_interval = l * 1000L;
        }
    }

    protected void exile() {
        this.m_exiled = true;
    }

    public final synchronized boolean isM_exiled() {
        return this.m_exiled;
    }
}

