/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.MCWrapperPool;
import com.ibm.ejs.j2c.PoolManager;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rasdiag.AlertAgent;
import com.ibm.ws.rasdiag.AlertConfig;
import com.ibm.ws.rasdiag.AlertController;
import com.ibm.ws.rasdiag.AlertFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.rasdiag.DiagnosticEvent;
import com.ibm.wsspi.rasdiag.DiagnosticTypedValue;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.LinkedHashMap;
import javax.resource.spi.ConnectionRequestInfo;
import javax.security.auth.Subject;

public final class TestConnectionTaskTimer
extends Thread
implements AlertAgent {
    private long _interval;
    private boolean _exiled = false;
    private PoolManager _pm;
    private MCWrapperPool _mcWrapperPool = null;
    private Subject _subject;
    private int _hashMapBucket;
    private ConnectionRequestInfo _cri;
    private int _testConnectionTimes = 0;
    private boolean pretestRunning = false;
    private static final TraceComponent tc = Tr.register(TestConnectionTaskTimer.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");
    private static final String thisClassName = TestConnectionTaskTimer.class.getName();

    protected TestConnectionTaskTimer(Subject subject, ConnectionRequestInfo connectionRequestInfo, int n, MCWrapperPool mCWrapperPool, long l, int n2, PoolManager poolManager) {
        this._subject = subject;
        this._cri = connectionRequestInfo;
        this._hashMapBucket = n;
        this._mcWrapperPool = mCWrapperPool;
        this._interval = l;
        this._testConnectionTimes = n2;
        this._pm = poolManager;
        final TestConnectionTaskTimer testConnectionTaskTimer = this;
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                testConnectionTaskTimer.setDaemon(true);
                return null;
            }
        });
        this.start();
    }

    protected void setMCWrapperPool(MCWrapperPool mCWrapperPool) {
        this._mcWrapperPool = mCWrapperPool;
    }

    protected void setTestConnectionTimes(int n) {
        this._testConnectionTimes = n;
    }

    protected void setInterval(long l) {
        this._interval = l;
    }

    protected void exile() {
        this._exiled = true;
    }

    public void run() {
        int n = 1;
        this.pretestRunning = true;
        AlertController.checkPoint(PoolManager.alertLogger, this, this._pm.gConfigProps.pretestBlockModeAlertConfig);
        try {
            while (!this._exiled) {
                this._pm.executeTestConnectionTask(this._subject, this._cri, this._hashMapBucket, this._mcWrapperPool);
                TestConnectionTaskTimer.sleep(this._interval);
                if (this._testConnectionTimes <= 0) continue;
                if (this._testConnectionTimes < n) {
                    this._pm.allowConnectionRequests = true;
                    this._exiled = true;
                    continue;
                }
                ++n;
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ejs.j2c.poolmanager.TestConnectionTaskTimer.run", "112", this);
            Tr.error(tc, "INTERUPTED_EXCEPTION_J2CA0091");
        }
        this.pretestRunning = false;
        AlertController.checkPoint(PoolManager.alertLogger, this, this._pm.gConfigProps.pretestBlockModeAlertConfig);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Ending TestConnectionTaskTimer thread");
        }
    }

    public DiagnosticEvent evaluateTriggerConditions(AlertConfig alertConfig) {
        DiagnosticEvent diagnosticEvent = null;
        String string = alertConfig.getAlertKey();
        if (string.equals("pretestBlockModeAlert")) {
            LinkedHashMap<String, DiagnosticTypedValue> linkedHashMap = new LinkedHashMap<String, DiagnosticTypedValue>();
            linkedHashMap.put("ConnectionFactory/DataSource", new DiagnosticTypedValue(this._pm.gConfigProps.pmiName, null));
            Date date = new Date();
            linkedHashMap.put("timeStamp", new DiagnosticTypedValue(date, null));
            diagnosticEvent = this.pretestRunning ? AlertFactory.createAlert(this._pm.diagProviderName, 30, thisClassName, "evaluateTriggerConditions", "com.ibm.ws.j2c.resources.J2CAMessages", "ALERT_PRETEST_BLOCK_J2CA0505", linkedHashMap) : AlertFactory.createAlert(this._pm.diagProviderName, 30, thisClassName, "evaluateTriggerConditions", "com.ibm.ws.j2c.resources.J2CAMessages", "ALERT_PRETEST_BLOCK_J2CA0515", linkedHashMap);
        }
        return diagnosticEvent;
    }
}

