/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.ConnectorRuntime;
import com.ibm.ejs.j2c.MCFExtendedProperties;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.j2c.SecurityHelper;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactory;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtension;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtensionFactory;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.GenericCredential;
import javax.security.auth.Subject;

public class ThreadIdentitySecurityHelper
implements SecurityHelper {
    private static final long serialVersionUID = 8149240599418799687L;
    private ManagedConnectionFactory mcf = null;
    private MCFExtendedProperties mcfXProps = null;
    private WSLoginLocalOSExtension securityLoginExtension;
    private ContextManager ctx;
    private boolean m_SyncToThreadEnabled;
    private boolean m_AppSyncToThreadEnabled;
    private boolean m_ThreadSecurity;
    private String m_ThreadIdentitySupport = null;
    private boolean m_GlobalSecurityEnabled = false;
    final String nl = ConnectorRuntime.nl;
    private static TraceComponent tc = Tr.register(ThreadIdentitySecurityHelper.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");
    private PrivilegedExceptionAction getLocalOSInvocationSubject = new PrivilegedExceptionAction(){

        public Object run() throws Exception {
            return ThreadIdentitySecurityHelper.this.securityLoginExtension.getLocalOSInvocationSubject();
        }
    };

    public ThreadIdentitySecurityHelper(ManagedConnectionFactory managedConnectionFactory, MCFExtendedProperties mCFExtendedProperties) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ThreadIdentitySecurityHelper<init>:", new Object[]{this, managedConnectionFactory, mCFExtendedProperties});
        }
        this.mcf = managedConnectionFactory;
        this.mcfXProps = mCFExtendedProperties;
        this.m_ThreadIdentitySupport = mCFExtendedProperties.getThreadIdentitySupport();
        this.m_ThreadSecurity = mCFExtendedProperties.getThreadSecurity();
        try {
            if (System.getSecurityManager() != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ThreadIdentitySecurityHelper<init>: java2 security is enabled");
                }
                class SecurityData {
                    boolean syncToThreadEnabled;
                    boolean appSyncToThreadEnabled;
                    boolean globalSecurityEnabled;
                    ContextManager ctxMgr;
                    WSLoginLocalOSExtension secLoginExtension;

                    SecurityData() {
                    }

                    public ContextManager getContextManager() {
                        return this.ctxMgr;
                    }

                    public boolean getGlobalSecurityEnabled() {
                        return this.globalSecurityEnabled;
                    }

                    public WSLoginLocalOSExtension getSecurityLoginExtension() {
                        return this.secLoginExtension;
                    }

                    public boolean getSyncToThreadEnabled() {
                        return this.syncToThreadEnabled;
                    }

                    public boolean getAppSyncToThreadEnabled() {
                        return this.appSyncToThreadEnabled;
                    }

                    public void setContextManager(ContextManager contextManager) {
                        this.ctxMgr = contextManager;
                    }

                    public void setGlobalSecurityEnabled(boolean bl) {
                        this.globalSecurityEnabled = bl;
                    }

                    public void setSecurityLoginExtension(WSLoginLocalOSExtension wSLoginLocalOSExtension) {
                        this.secLoginExtension = wSLoginLocalOSExtension;
                    }

                    public void setSyncToThreadEnabled(boolean bl) {
                        this.syncToThreadEnabled = bl;
                    }

                    public void setAppSyncToThreadEnabled(boolean bl) {
                        this.appSyncToThreadEnabled = bl;
                    }
                }
                SecurityData securityData = (SecurityData)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        SecurityData securityData = new SecurityData();
                        ContextManager contextManager = ContextManagerFactory.getInstance();
                        WSLoginLocalOSExtension wSLoginLocalOSExtension = WSLoginLocalOSExtensionFactory.getInstance();
                        securityData.setContextManager(contextManager);
                        securityData.setSecurityLoginExtension(wSLoginLocalOSExtension);
                        securityData.setGlobalSecurityEnabled(contextManager.isServerSecurityEnabled());
                        securityData.setSyncToThreadEnabled(wSLoginLocalOSExtension.isSyncToThreadEnabled());
                        securityData.setAppSyncToThreadEnabled(wSLoginLocalOSExtension.isApplicationSyncToOSThreadEnabled());
                        return securityData;
                    }
                });
                this.m_AppSyncToThreadEnabled = securityData.getAppSyncToThreadEnabled();
                this.m_SyncToThreadEnabled = securityData.getSyncToThreadEnabled();
                this.m_GlobalSecurityEnabled = securityData.getGlobalSecurityEnabled();
                this.securityLoginExtension = securityData.getSecurityLoginExtension();
                this.ctx = securityData.getContextManager();
            } else {
                this.securityLoginExtension = WSLoginLocalOSExtensionFactory.getInstance();
                this.m_SyncToThreadEnabled = this.securityLoginExtension.isSyncToThreadEnabled();
                this.m_AppSyncToThreadEnabled = this.securityLoginExtension.isApplicationSyncToOSThreadEnabled();
                this.ctx = ContextManagerFactory.getInstance();
                this.m_GlobalSecurityEnabled = this.ctx.isServerSecurityEnabled();
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ejs.j2c.ThreadIdentitySecurityHelper.ThreadIdentitySecurityHelper", "826", this);
            Tr.error(tc, "FAILED_DOPRIVILEGED_J2CA0060", privilegedActionException);
            Exception exception = privilegedActionException.getException();
            ResourceException resourceException = new ResourceException("ThreadIdentitySecurityHelper.constructor faile attempting to get the WSLoginLocalOSExtension from security.");
            resourceException.initCause((Throwable)exception);
            throw resourceException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ThreadIdentitySecurityHelper<init>");
        }
    }

    public Subject finalizeSubject(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "finalizeSubject", new Object[]{this, this.getSubjectString(subject), connectionRequestInfo});
        }
        Subject subject2 = subject;
        Subject subject3 = subject;
        if (subject3 != null) {
            if (this.m_ThreadIdentitySupport.equals("ALLOWED")) {
                Set<Object> set = subject3.getPrivateCredentials();
                Iterator<Object> iterator = set.iterator();
                if (!iterator.hasNext()) {
                    try {
                        subject2 = System.getSecurityManager() != null ? (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)this.getLocalOSInvocationSubject) : this.securityLoginExtension.getLocalOSInvocationSubject();
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ejs.j2c.ThreadIdentitySecurityHelper.finalizeSubject", "826", this);
                        Tr.error(tc, "FAILED_DOPRIVILEGED_J2CA0060", privilegedActionException);
                        Exception exception = privilegedActionException.getException();
                        ResourceException resourceException = new ResourceException("ThreadIdentitySecurityHelper.finalizeSubject() failed attempting to get local OS invocation subject");
                        resourceException.initCause((Throwable)exception);
                        throw resourceException;
                    }
                    catch (IllegalStateException illegalStateException) {
                        FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ejs.j2c.ThreadIdentitySecurityHelper.finalizeSubject", "826", this);
                        Object[] objectArray = new Object[]{"ThreadIdentitySecurityHelper.finalizeSubject()", illegalStateException};
                        Tr.error(tc, "ILLEGAL_STATE_EXCEPTION_J2CA0079", objectArray);
                        ResourceException resourceException = new ResourceException("ThreadIdentitySecurityHelper.finalizeSubject() failed attempting to get local OS invocation subject");
                        resourceException.initCause((Throwable)illegalStateException);
                        throw resourceException;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "finalizeSubject(): No user identity was specifed. User identity has been defaulted to current thread identity");
                    }
                }
            } else if (this.m_ThreadIdentitySupport.equals("REQUIRED")) {
                try {
                    subject2 = System.getSecurityManager() != null ? (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)this.getLocalOSInvocationSubject) : this.securityLoginExtension.getLocalOSInvocationSubject();
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ejs.j2c.ThreadIdentitySecurityHelper.finalizeSubject", "826", this);
                    Tr.error(tc, "FAILED_DOPRIVILEGED_J2CA0060", privilegedActionException);
                    Exception exception = privilegedActionException.getException();
                    ResourceException resourceException = new ResourceException("ThreadIdentitySecurityHelper.finalizeSubject() failed attempting to get local OS invocation subject");
                    resourceException.initCause((Throwable)exception);
                    throw resourceException;
                }
                catch (IllegalStateException illegalStateException) {
                    FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ejs.j2c.ThreadIdentitySecurityHelper.finalizeSubject", "826", this);
                    Object[] objectArray = new Object[]{"ThreadIdentitySecurityHelper.finalizeSubject()", illegalStateException};
                    Tr.error(tc, "ILLEGAL_STATE_EXCEPTION_J2CA0079", objectArray);
                    ResourceException resourceException = new ResourceException("ThreadIdentitySecurityHelper.finalizeSubject() failed attempting to get local OS invocation subject");
                    resourceException.initCause((Throwable)illegalStateException);
                    throw resourceException;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "finalizeSubject(): Connector REQUIRED specified user identity to be overridden by the current thread identity");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "finalizeSubject", new Object[]{this.getSubjectString(subject2)});
        }
        return subject2;
    }

    public void finalizeCriForRRA(Subject subject, ConnectionRequestInfo connectionRequestInfo, ManagedConnectionFactory managedConnectionFactory) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finalizeCriForRRA");
        }
        if (subject != null) {
            ((WSManagedConnectionFactory)managedConnectionFactory).finalizeCriForRRA(subject, connectionRequestInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "finalizeCriForRRA");
        }
    }

    public Object beforeGettingConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeGettingConnection", new Object[]{this, this.getSubjectString(subject), connectionRequestInfo});
        }
        Object object = null;
        final Subject subject2 = subject;
        if (this.m_GlobalSecurityEnabled) {
            if (this.m_ThreadIdentitySupport.equals("ALLOWED") || this.m_ThreadIdentitySupport.equals("REQUIRED")) {
                if (subject2 != null) {
                    Object object2;
                    Set set = null;
                    if (System.getSecurityManager() != null) {
                        object2 = new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return subject2.getPrivateCredentials(class$javax$resource$spi$security$GenericCredential == null ? (class$javax$resource$spi$security$GenericCredential = ThreadIdentitySecurityHelper.class$("javax.resource.spi.security.GenericCredential")) : class$javax$resource$spi$security$GenericCredential);
                            }
                        };
                        try {
                            set = (Set)AccessController.doPrivileged((PrivilegedExceptionAction)object2);
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ejs.j2c.ThreadIdentitySecurityHelper.beforeGettingConnection", "826", this);
                            Tr.error(tc, "FAILED_DOPRIVILEGED_J2CA0060", privilegedActionException);
                            Exception exception = privilegedActionException.getException();
                            ResourceException resourceException = new ResourceException("ThreadIdentitySecurityHelper failed attempting to access Subject's credentials");
                            resourceException.initCause((Throwable)exception);
                            throw resourceException;
                        }
                    } else {
                        set = subject2.getPrivateCredentials(GenericCredential.class);
                    }
                    object2 = set.iterator();
                    PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction((Iterator)object2){
                        private final /* synthetic */ Iterator val$iter;
                        {
                            this.val$iter = iterator;
                        }

                        public Object run() throws Exception {
                            return this.val$iter.next();
                        }
                    };
                    boolean bl = false;
                    GenericCredential genericCredential = null;
                    while (object2.hasNext()) {
                        if (System.getSecurityManager() != null) {
                            try {
                                genericCredential = (GenericCredential)AccessController.doPrivileged((PrivilegedExceptionAction)privilegedExceptionAction);
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ejs.j2c.ThreadIdentitySecurityHelper.beforeGettingConnection", "826", this);
                                Tr.error(tc, "FAILED_DOPRIVILEGED_J2CA0060", privilegedActionException);
                                Exception exception = privilegedActionException.getException();
                                ResourceException resourceException = new ResourceException("ThreadIdentitySecurityHelper.beforeGettingConnection() failed attempting to access Subject's credentials");
                                resourceException.initCause((Throwable)exception);
                                throw resourceException;
                            }
                        } else {
                            genericCredential = (GenericCredential)object2.next();
                        }
                        if (!genericCredential.getMechType().equals("oid:1.3.18.0.2.30.1")) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        if (this.m_ThreadSecurity) {
                            if (this.m_SyncToThreadEnabled) {
                                try {
                                    object = System.getSecurityManager() != null ? AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                                        public Object run() throws Exception {
                                            return ThreadIdentitySecurityHelper.this.securityLoginExtension.setLocalOSThreadID(subject2);
                                        }
                                    }) : this.securityLoginExtension.setLocalOSThreadID(subject2);
                                }
                                catch (PrivilegedActionException privilegedActionException) {
                                    FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ejs.j2c.ThreadIdentitySecurityHelper.beforeGettingConnection", "826", this);
                                    Tr.error(tc, "FAILED_DOPRIVILEGED_J2CA0060", privilegedActionException);
                                    Exception exception = privilegedActionException.getException();
                                    ResourceException resourceException = new ResourceException("ThreadIdentitySecurityHelper.beforeGettingConnection() failed attempting to push the current user identity to the OS Thread");
                                    resourceException.initCause((Throwable)exception);
                                    throw resourceException;
                                }
                                catch (IllegalStateException illegalStateException) {
                                    FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ejs.j2c.ThreadIdentitySecurityHelper.beforeGettingConnection", "826", this);
                                    Object[] objectArray = new Object[]{"ThreadIdentitySecurityHelper.beforeGettingConnection()", illegalStateException};
                                    Tr.error(tc, "ILLEGAL_STATE_EXCEPTION_J2CA0079", objectArray);
                                    ResourceException resourceException = new ResourceException("ThreadIdentitySecurityHelper.beforeGettingConnection() failed attempting to push the current user identity to the OS Thread");
                                    resourceException.initCause((Throwable)illegalStateException);
                                    throw resourceException;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "beforeGettingConnection() pushed the user identity associated with the thread to the OS Thread:  ", new Object[]{this.getSubjectString(subject2)});
                                }
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "beforeGettingConnection() could not push user identity associated with the thread to the OS Thread  because server was not enabled for SyncToThread.");
                                }
                                if (this.m_AppSyncToThreadEnabled) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "beforeGettingConnection() pushing server identity to the OS Thread because Application SyncToThread is enabled.");
                                    }
                                    object = this.synchServerSubjectToThread();
                                }
                            }
                        }
                    } else {
                        if (this.m_ThreadIdentitySupport.equals("REQUIRED")) {
                            try {
                                IllegalStateException illegalStateException = new IllegalStateException("ThreadIdentitySecurityHelper.beforeGettingConnection() detected Subject not setup for using thread identity, but the connector requires thread identity be used.");
                                Object[] objectArray = new Object[]{"ThreadIdentitySecurityHelper.beforeGettingConnection()", illegalStateException};
                                Tr.error(tc, "ILLEGAL_STATE_EXCEPTION_J2CA0079", objectArray);
                                throw illegalStateException;
                            }
                            catch (IllegalStateException illegalStateException) {
                                ResourceException resourceException = new ResourceException("ThreadIdentitySecurityHelper.beforeGettingConnection() detected Subject with illegal state");
                                resourceException.initCause((Throwable)illegalStateException);
                                throw resourceException;
                            }
                        }
                        Set<Object> set2 = subject2.getPrivateCredentials();
                        Iterator<Object> iterator = set2.iterator();
                        if (!iterator.hasNext()) {
                            try {
                                IllegalStateException illegalStateException = new IllegalStateException("ThreadIdentitySecurityHelper.beforeGettingConnection() detected Subject with no credentials.");
                                Object[] objectArray = new Object[]{"ThreadIdentitySecurityHelper.beforeGettingConnection()", illegalStateException};
                                Tr.error(tc, "ILLEGAL_STATE_EXCEPTION_J2CA0079", objectArray);
                                throw illegalStateException;
                            }
                            catch (IllegalStateException illegalStateException) {
                                ResourceException resourceException = new ResourceException("ThreadIdentitySecurityHelper.beforeGettingConnection() detected Subject with illegal state");
                                resourceException.initCause((Throwable)illegalStateException);
                                throw resourceException;
                            }
                        }
                    }
                } else if (this.m_ThreadSecurity && (this.m_SyncToThreadEnabled || this.m_AppSyncToThreadEnabled)) {
                    object = this.synchServerSubjectToThread();
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "beforeGettingConnection() processing skipped. Security not enabled.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeGettingConnection", new Object[]{object});
        }
        return object;
    }

    public void afterGettingConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo, Object object) throws ResourceException {
        final Object object2 = object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterGettingConnection", new Object[]{this, this.getSubjectString(subject), connectionRequestInfo, object});
        }
        if (object2 != null) {
            try {
                if (System.getSecurityManager() != null) {
                    AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            ThreadIdentitySecurityHelper.this.securityLoginExtension.restoreLocalOSThreadID(object2);
                            return null;
                        }
                    });
                } else {
                    this.securityLoginExtension.restoreLocalOSThreadID(object2);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "afterGettingConnection() restored OS thread identity");
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ejs.j2c.ThreadIdentitySecurityHelper.afterGettingConnection", "826", this);
                Tr.error(tc, "FAILED_DOPRIVILEGED_J2CA0060", privilegedActionException);
                Exception exception = privilegedActionException.getException();
                ResourceException resourceException = new ResourceException("ThreadIdentitySecurityHelper.afterGettingConnection() failed attempting to restore user identity to the OS Thread");
                resourceException.initCause((Throwable)exception);
                throw resourceException;
            }
            catch (IllegalStateException illegalStateException) {
                FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ejs.j2c.ThreadIdentitySecurityHelper.afterGettingConnection", "826", this);
                Object[] objectArray = new Object[]{"ThreadIdentitySecurityHelper.afterGettingConnection()", illegalStateException};
                Tr.error(tc, "ILLEGAL_STATE_EXCEPTION_J2CA0079", objectArray);
                ResourceException resourceException = new ResourceException("ThreadIdentitySecurityHelper.afterGettingConnection() failed attempting to restore user identity to the OS Thread");
                resourceException.initCause((Throwable)illegalStateException);
                throw resourceException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterGettingConnection");
        }
    }

    private Object synchServerSubjectToThread() throws ResourceException {
        Object object = null;
        try {
            if (System.getSecurityManager() != null) {
                object = AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Subject subject = ThreadIdentitySecurityHelper.this.securityLoginExtension.getLocalOSOwnSubject();
                        Object object = ThreadIdentitySecurityHelper.this.securityLoginExtension.setLocalOSThreadID(subject);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "beforeGettingConnection() pushed Server Identity to the OS Thread:  ", new Object[]{ThreadIdentitySecurityHelper.this.getSubjectString(subject)});
                        }
                        return object;
                    }
                });
            } else {
                Subject subject = this.securityLoginExtension.getLocalOSOwnSubject();
                object = this.securityLoginExtension.setLocalOSThreadID(subject);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "beforeGettingConnection() pushed Server Identity to the OS Thread:  ", new Object[]{this.getSubjectString(subject)});
                }
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ejs.j2c.ThreadIdentitySecurityHelper.synchServerSubjectToThread", "826", this);
            Tr.error(tc, "FAILED_DOPRIVILEGED_J2CA0060", privilegedActionException);
            Exception exception = privilegedActionException.getException();
            ResourceException resourceException = new ResourceException("ThreadIdentitySecurityHelper.beforeGettingConnection() failed attempting to push the server identity to the OS Thread");
            resourceException.initCause((Throwable)exception);
            throw resourceException;
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ejs.j2c.ThreadIdentitySecurityHelper.synchServerSubjectToThread", "826", this);
            Object[] objectArray = new Object[]{"ThreadIdentitySecurityHelper.beforeGettingConnection()", illegalStateException};
            Tr.error(tc, "ILLEGAL_STATE_EXCEPTION_J2CA0079", objectArray);
            ResourceException resourceException = new ResourceException("ThreadIdentitySecurityHelper.beforeGettingConnection() failed attempting to push the server identity to the OS Thread");
            resourceException.initCause((Throwable)illegalStateException);
            throw resourceException;
        }
        return object;
    }

    private String getSubjectString(Subject subject) {
        String string = null;
        if (subject != null) {
            if (System.getSecurityManager() != null) {
                final Subject subject2 = subject;
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return subject2.toString();
                    }
                };
                try {
                    string = (String)AccessController.doPrivileged((PrivilegedExceptionAction)privilegedExceptionAction);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception received in getSubjectString:", privilegedActionException);
                    }
                    string = "Subject cannot be traced due to a PrivilegedActionException";
                }
            } else {
                string = subject.toString();
            }
        }
        return string;
    }
}

