/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.ConnectorRuntime;
import com.ibm.ejs.j2c.MCWrapper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.reqmetrics.PmiReqMetrics;
import com.ibm.ws.Transaction.SynchronizationProvider;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.j2c.TranWrapper;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.transaction.Synchronization;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XATransactionWrapper
implements XAResource,
Synchronization,
TranWrapper {
    private String XAWrapperObject_hexString = null;
    private MCWrapper mcWrapper;
    private XAResource xaResource;
    private boolean enlisted = false;
    final String nl = ConnectorRuntime.nl;
    private boolean hasRollbackOccured = false;
    private static final TraceComponent tc = Tr.register(XATransactionWrapper.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");

    protected XATransactionWrapper(MCWrapper mCWrapper) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.mcWrapper = mCWrapper;
        this.XAWrapperObject_hexString = Integer.toHexString(this.hashCode());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init> Id " + this.XAWrapperObject_hexString);
        }
    }

    protected void initialize() throws ResourceException {
        if (this.xaResource == null) {
            try {
                this.xaResource = this.mcWrapper.getManagedConnection().getXAResource();
            }
            catch (ResourceException resourceException) {
                FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.j2c.XATransactionWrapper.initialize", "149", this);
                String string = null;
                if (this.mcWrapper != null) {
                    string = this.mcWrapper.gConfigProps.pmiName;
                }
                Tr.error(tc, "FAILED_TO_OBTAIN_XAResource_J2CA0078", new Object[]{resourceException, string});
                throw resourceException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.XATransactionWrapper.initialize", "154", this);
                String string = null;
                if (this.mcWrapper != null) {
                    string = this.mcWrapper.gConfigProps.pmiName;
                }
                Tr.error(tc, "FAILED_TO_OBTAIN_XAResource_J2CA0078", new Object[]{exception, string});
                ResourceException resourceException = new ResourceException("initialize: caught Exception");
                resourceException.initCause((Throwable)exception);
                throw resourceException;
            }
        }
    }

    public void cleanup() {
        this.enlisted = false;
    }

    public void releaseResources() {
        this.xaResource = null;
    }

    public boolean addSync() throws ResourceException {
        UOWCoordinator uOWCoordinator;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSync");
        }
        if ((uOWCoordinator = this.mcWrapper.getUOWCoordinator()) == null) {
            IllegalStateException illegalStateException = new IllegalStateException("addSync: illegal state exception. uowCoord is null");
            Object[] objectArray = new Object[]{"addSync", illegalStateException};
            Tr.error(tc, "ILLEGAL_STATE_EXCEPTION_J2CA0079", objectArray);
            throw illegalStateException;
        }
        try {
            if (this.mcWrapper.isConnectionSynchronizationProvider()) {
                Synchronization synchronization = ((SynchronizationProvider)this.mcWrapper.getManagedConnection()).getSynchronization();
                TransactionManagerFactory.getTransactionManager().registerSynchronization(uOWCoordinator, synchronization, 2);
            }
            if (this.mcWrapper.isEnlistmentDisabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Managed connection isEnlistmentDisabled is true.");
                    Tr.debug(tc, "Returning without registering.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addSync: false");
                }
                boolean bl = false;
                return bl;
            }
            TransactionManagerFactory.getTransactionManager().registerSynchronization(uOWCoordinator, this);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.XATransactionWrapper.addSync", "237", this);
            Object[] objectArray = new Object[]{"addSync", exception, "ResourceException"};
            Tr.error(tc, "REGISTER_WITH_SYNCHRONIZATION_EXCP_J2CA0026", objectArray);
            ResourceException resourceException = new ResourceException("addSync: caught Exception");
            resourceException.initCause((Throwable)exception);
            throw resourceException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addSync");
            }
        }
        return true;
    }

    public void afterCompletion(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterCompletion");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using transaction wrapper@" + Integer.toHexString(this.hashCode()));
        }
        if (tc.isDebugEnabled() && this.mcWrapper.getHandleCount() != 0) {
            String string = null;
            if (this.mcWrapper != null) {
                string = this.mcWrapper.gConfigProps.pmiName;
            }
            Tr.debug(tc, "Information:  handle not closed at end of UOW for resource " + string);
        }
        this.hasRollbackOccured = false;
        this.mcWrapper.transactionComplete();
        boolean bl = this.mcWrapper.getConnectionManager().shareable();
        if (bl || !bl && this.mcWrapper.getHandleCount() == 0 || this.mcWrapper.isStale()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Releasing the connection to the pool. shareable = " + bl + "  handleCount = " + this.mcWrapper.getHandleCount() + "  isStale = " + this.mcWrapper.isStale());
            }
            try {
                this.mcWrapper.releaseToPoolManager();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.XATransactionWrapper.afterCompletion", "291", this);
                if (tc.isDebugEnabled()) {
                    String string = null;
                    if (this.mcWrapper != null) {
                        string = this.mcWrapper.gConfigProps.pmiName;
                    }
                    Tr.debug(tc, "afterCompletionCode for resource " + string + ":  caught Exception", exception);
                }
            }
        } else {
            this.enlisted = false;
            this.mcWrapper.setUOWCoordinator(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterCompletion");
        }
    }

    public void beforeCompletion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeCompletion");
            Tr.exit(tc, "beforeCompletion");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit(Xid xid, boolean bl) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit");
        }
        Object object = null;
        if (PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID)) {
            object = PmiReqMetrics.reqStart(this.mcWrapper.gConfigProps.reqMetricID, 2, new String[]{"javax.resource.spi.XAResource", "commit(Xid, boolean)"});
        }
        if (this.mcWrapper.pm.efficiencyGroupEnabled) {
            this.mcWrapper.useTimeStart();
        }
        int n = 2;
        try {
            try {
                this.xaResource.commit(xid, bl);
                n = 0;
            }
            catch (XAException xAException) {
                this.processXAException(xAException);
                FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.j2c.XATransactionWrapper.commit", "378", this);
                if (this.mcWrapper.isStale()) throw xAException;
                String string = null;
                if (this.mcWrapper != null) {
                    string = this.mcWrapper.gConfigProps.pmiName;
                }
                Object[] objectArray = new Object[]{"commit", xid, xAException, string};
                Tr.error(tc, "XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", objectArray);
                throw xAException;
            }
            catch (Exception exception) {
                Object object2;
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.XATransactionWrapper.commit", "384", this);
                if (!this.mcWrapper.shouldBeDestroyed()) {
                    this.mcWrapper.markTransactionError();
                    object2 = null;
                    if (this.mcWrapper != null) {
                        object2 = this.mcWrapper.gConfigProps.pmiName;
                    }
                    Object[] objectArray = new Object[]{"commit", xid, exception, object2};
                    Tr.error(tc, "XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", objectArray);
                }
                object2 = new XAException(-7);
                ((Throwable)object2).initCause(exception);
                throw object2;
            }
            Object var9_5 = null;
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            if (PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID)) {
                Properties properties = null;
                int n2 = PmiReqMetrics.getTranDetailLevel(object, this.mcWrapper.gConfigProps.reqMetricID);
                if (n2 == 3) {
                    properties = (Properties)this.mcWrapper.gConfigProps.raMetaDataProps.clone();
                }
                if (properties == null) {
                    PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n);
                } else {
                    PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n, properties);
                }
            }
            if (this.mcWrapper.pm.efficiencyGroupEnabled) {
                this.mcWrapper.useTimeStop();
            }
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "commit");
            throw throwable;
        }
        if (PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID)) {
            Properties properties = null;
            int n3 = PmiReqMetrics.getTranDetailLevel(object, this.mcWrapper.gConfigProps.reqMetricID);
            if (n3 == 3) {
                properties = (Properties)this.mcWrapper.gConfigProps.raMetaDataProps.clone();
            }
            if (properties == null) {
                PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n);
            } else {
                PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n, properties);
            }
        }
        if (this.mcWrapper.pm.efficiencyGroupEnabled) {
            this.mcWrapper.useTimeStop();
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "commit");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void end(Xid xid, int n) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "end");
        }
        Object object = null;
        if (PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID)) {
            object = PmiReqMetrics.reqStart(this.mcWrapper.gConfigProps.reqMetricID, 2, new String[]{"javax.resource.spi.XAResource", "end(Xid, int)"});
        }
        if (this.mcWrapper.pm.efficiencyGroupEnabled) {
            this.mcWrapper.useTimeStart();
        }
        int n2 = 2;
        try {
            try {
                this.xaResource.end(xid, n);
                n2 = 0;
            }
            catch (XAException xAException) {
                block27: {
                    block28: {
                        block26: {
                            this.processXAException(xAException);
                            if (n != 0x20000000 || xAException.errorCode < 100 || xAException.errorCode > 107) break block26;
                            Object var9_6 = null;
                            if (!PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID)) break block27;
                            break block28;
                        }
                        FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.j2c.XATransactionWrapper.end", "417", this);
                        if (this.mcWrapper.isStale()) throw xAException;
                        String string = null;
                        if (this.mcWrapper != null) {
                            string = this.mcWrapper.gConfigProps.pmiName;
                        }
                        Object[] objectArray = new Object[]{"end", xid, xAException, string};
                        Tr.error(tc, "XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", objectArray);
                        throw xAException;
                    }
                    Properties properties = null;
                    int n5 = PmiReqMetrics.getTranDetailLevel(object, this.mcWrapper.gConfigProps.reqMetricID);
                    if (n5 == 3) {
                        properties = (Properties)this.mcWrapper.gConfigProps.raMetaDataProps.clone();
                    }
                    if (properties == null) {
                        PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n2);
                    } else {
                        PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n2, properties);
                    }
                }
                if (this.mcWrapper.pm.efficiencyGroupEnabled) {
                    this.mcWrapper.useTimeStop();
                }
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "end");
                return;
            }
            catch (Exception exception) {
                Object object2;
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.XATransactionWrapper.end", "423", this);
                if (!this.mcWrapper.shouldBeDestroyed()) {
                    this.mcWrapper.markTransactionError();
                    object2 = null;
                    if (this.mcWrapper != null) {
                        object2 = this.mcWrapper.gConfigProps.pmiName;
                    }
                    Object[] objectArray = new Object[]{"end", xid, exception, object2};
                    Tr.error(tc, "XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", objectArray);
                }
                object2 = new XAException(-7);
                ((Throwable)object2).initCause(exception);
                throw object2;
            }
            Object var9_5 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            if (PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID)) {
                Properties properties = null;
                int n3 = PmiReqMetrics.getTranDetailLevel(object, this.mcWrapper.gConfigProps.reqMetricID);
                if (n3 == 3) {
                    properties = (Properties)this.mcWrapper.gConfigProps.raMetaDataProps.clone();
                }
                if (properties == null) {
                    PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n2);
                } else {
                    PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n2, properties);
                }
            }
            if (this.mcWrapper.pm.efficiencyGroupEnabled) {
                this.mcWrapper.useTimeStop();
            }
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "end");
            throw throwable;
        }
        if (PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID)) {
            Properties properties = null;
            int n4 = PmiReqMetrics.getTranDetailLevel(object, this.mcWrapper.gConfigProps.reqMetricID);
            if (n4 == 3) {
                properties = (Properties)this.mcWrapper.gConfigProps.raMetaDataProps.clone();
            }
            if (properties == null) {
                PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n2);
            } else {
                PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n2, properties);
            }
        }
        if (this.mcWrapper.pm.efficiencyGroupEnabled) {
            this.mcWrapper.useTimeStop();
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "end");
    }

    public void enlist() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "enlist");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "enlisting XATranWrapper :" + Integer.toHexString(this.hashCode()) + " with coordinator :" + this.mcWrapper.getUOWCoordinator());
        }
        if (this.hasRollbackOccured) {
            Tr.error(tc, "enlist(): It is NOT valid to continue working under a transaction that has already rolledback");
            throw new ResourceException("Attempt to continue working after transaction rolledback !");
        }
        if (this.enlisted) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "enlist(): called when already enlisted for XATransactionWrapper@" + Integer.toHexString(this.hashCode()));
            }
            return;
        }
        try {
            int n = this.mcWrapper.getRecoveryToken();
            if (!TransactionManagerFactory.getTransactionManager().enlist(this.mcWrapper.getUOWCoordinator(), this, n)) {
                String string = null;
                if (this.mcWrapper != null) {
                    string = this.mcWrapper.gConfigProps.pmiName;
                }
                Tr.error(tc, "BAD_RETURN_VALUE_FROM_ENLIST_J2CA0087", new Object[]{this, string});
                throw new ResourceException("Error on enlist");
            }
        }
        catch (ResourceException resourceException) {
            block21: {
                FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.j2c.XATransactionWrapper.enlist", "535", this);
                String string = null;
                if (this.mcWrapper != null) {
                    string = this.mcWrapper.gConfigProps.pmiName;
                }
                Object[] objectArray = new Object[]{"enlist", resourceException, "ResourceException", string};
                Tr.error(tc, "ENLIST_RESOURCE_EXCP_J2CA0030", objectArray);
                this.mcWrapper.markTransactionError();
                try {
                    TransactionManagerFactory.getTransactionManager().getTransaction().setRollbackOnly();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.XATransactionWrapper.enlist", "630", this);
                    if (!tc.isEventEnabled()) break block21;
                    Tr.event(tc, "Caught Exception while trying to mark transaction RollbackOnly - Exception:" + exception);
                }
            }
            throw resourceException;
        }
        catch (Exception exception) {
            block22: {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.XATransactionWrapper.enlist", "546", this);
                String string = null;
                if (this.mcWrapper != null) {
                    string = this.mcWrapper.gConfigProps.pmiName;
                }
                Object[] objectArray = new Object[]{"enlist", exception, "ResourceException", string};
                Tr.error(tc, "ENLIST_RESOURCE_EXCP_J2CA0030", objectArray);
                this.mcWrapper.markTransactionError();
                try {
                    TransactionManagerFactory.getTransactionManager().getTransaction().setRollbackOnly();
                }
                catch (Exception exception2) {
                    FFDCFilter.processException((Throwable)exception2, "com.ibm.ejs.j2c.XATransactionWrapper.enlist", "663", this);
                    if (!tc.isEventEnabled()) break block22;
                    Tr.event(tc, "Caught Exception while trying to mark transaction RollbackOnly - Exception:" + exception2);
                }
            }
            ResourceException resourceException = new ResourceException("enlist: caught Exception");
            resourceException.initCause((Throwable)exception);
            throw resourceException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "enlist");
            }
        }
        this.enlisted = true;
    }

    public void delist() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "delist");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "delisting XATranWrapper :" + Integer.toHexString(this.hashCode()) + " with coordinator :" + this.mcWrapper.getUOWCoordinator());
        }
        this.enlisted = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "delist");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void forget(Xid xid) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "forget");
        }
        Object object = null;
        if (PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID)) {
            object = PmiReqMetrics.reqStart(this.mcWrapper.gConfigProps.reqMetricID, 2, new String[]{"javax.resource.spi.XAResource", "forget(Xid)"});
        }
        if (this.mcWrapper.pm.efficiencyGroupEnabled) {
            this.mcWrapper.useTimeStart();
        }
        int n = 2;
        try {
            try {
                this.xaResource.forget(xid);
                n = 0;
            }
            catch (XAException xAException) {
                this.processXAException(xAException);
                FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.j2c.XATransactionWrapper.forget", "561", this);
                if (this.mcWrapper.isStale()) throw xAException;
                String string = null;
                if (this.mcWrapper != null) {
                    string = this.mcWrapper.gConfigProps.pmiName;
                }
                Object[] objectArray = new Object[]{"forget", xid, xAException, string};
                Tr.error(tc, "XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", objectArray);
                throw xAException;
            }
            catch (Exception exception) {
                Object object2;
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.XATransactionWrapper.forget", "567", this);
                if (!this.mcWrapper.shouldBeDestroyed()) {
                    this.mcWrapper.markTransactionError();
                    object2 = null;
                    if (this.mcWrapper != null) {
                        object2 = this.mcWrapper.gConfigProps.pmiName;
                    }
                    Object[] objectArray = new Object[]{"forget", xid, exception, object2};
                    Tr.error(tc, "XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", objectArray);
                }
                object2 = new XAException(-7);
                ((Throwable)object2).initCause(exception);
                throw object2;
            }
            Object var8_4 = null;
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            if (PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID)) {
                Properties properties = null;
                int n2 = PmiReqMetrics.getTranDetailLevel(object, this.mcWrapper.gConfigProps.reqMetricID);
                if (n2 == 3) {
                    properties = (Properties)this.mcWrapper.gConfigProps.raMetaDataProps.clone();
                }
                if (properties == null) {
                    PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n);
                } else {
                    PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n, properties);
                }
            }
            if (this.mcWrapper.pm.efficiencyGroupEnabled) {
                this.mcWrapper.useTimeStop();
            }
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "forget");
            throw throwable;
        }
        if (PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID)) {
            Properties properties = null;
            int n3 = PmiReqMetrics.getTranDetailLevel(object, this.mcWrapper.gConfigProps.reqMetricID);
            if (n3 == 3) {
                properties = (Properties)this.mcWrapper.gConfigProps.raMetaDataProps.clone();
            }
            if (properties == null) {
                PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n);
            } else {
                PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n, properties);
            }
        }
        if (this.mcWrapper.pm.efficiencyGroupEnabled) {
            this.mcWrapper.useTimeStop();
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "forget");
    }

    public int getTransactionTimeout() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransactionTimeout");
        }
        int n = -1;
        try {
            n = this.xaResource.getTransactionTimeout();
        }
        catch (XAException xAException) {
            this.processXAException(xAException);
            FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.j2c.XATransactionWrapper.getTransactionTimeout", "611", this);
            if (!this.mcWrapper.isStale()) {
                String string = null;
                if (this.mcWrapper != null) {
                    string = this.mcWrapper.gConfigProps.pmiName;
                }
                Object[] objectArray = new Object[]{"getTransactionTimeout", xAException, string};
                Tr.error(tc, "XA_RESOURCE_ADAPTER_OPERATION_EXCP_J2CA0028", objectArray);
            }
            throw xAException;
        }
        catch (Exception exception) {
            Object object;
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.XATransactionWrapper.getTransactionTimeout", "618", this);
            if (!this.mcWrapper.shouldBeDestroyed()) {
                this.mcWrapper.markTransactionError();
                object = null;
                if (this.mcWrapper != null) {
                    object = this.mcWrapper.gConfigProps.pmiName;
                }
                Object[] objectArray = new Object[]{"getTransactionTimeout", exception, object};
                Tr.error(tc, "XA_RESOURCE_ADAPTER_OPERATION_EXCP_J2CA0028", objectArray);
            }
            object = new XAException(-7);
            ((Throwable)object).initCause(exception);
            throw object;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTransactionTimeout");
            }
        }
        return n;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSameRM");
        }
        boolean bl = false;
        try {
            bl = this.xaResource.isSameRM(xAResource);
        }
        catch (XAException xAException) {
            this.processXAException(xAException);
            FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.j2c.XATransactionWrapper.isSameRM", "648", this);
            if (!this.mcWrapper.isStale()) {
                String string = null;
                if (this.mcWrapper != null) {
                    string = this.mcWrapper.gConfigProps.pmiName;
                }
                Object[] objectArray = new Object[]{"isSameRM", xAException, string};
                Tr.error(tc, "XA_RESOURCE_ADAPTER_OPERATION_EXCP_J2CA0028", objectArray);
            }
            throw xAException;
        }
        catch (Exception exception) {
            Object object;
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.XATransactionWrapper.isSameRM", "655", this);
            if (!this.mcWrapper.shouldBeDestroyed()) {
                this.mcWrapper.markTransactionError();
                object = null;
                if (this.mcWrapper != null) {
                    object = this.mcWrapper.gConfigProps.pmiName;
                }
                Object[] objectArray = new Object[]{"isSameRM", exception, object};
                Tr.error(tc, "XA_RESOURCE_ADAPTER_OPERATION_EXCP_J2CA0028", objectArray);
            }
            object = new XAException(-7);
            ((Throwable)object).initCause(exception);
            throw object;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isSameRM");
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int prepare(Xid xid) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepare");
        }
        int n = -1;
        Object object = null;
        if (PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID)) {
            object = PmiReqMetrics.reqStart(this.mcWrapper.gConfigProps.reqMetricID, 2, new String[]{"javax.resource.spi.XAResource", "prepare(Xid)"});
        }
        if (this.mcWrapper.pm.efficiencyGroupEnabled) {
            this.mcWrapper.useTimeStart();
        }
        int n2 = 2;
        try {
            try {
                n = this.xaResource.prepare(xid);
                n2 = 0;
            }
            catch (XAException xAException) {
                this.processXAException(xAException);
                FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.j2c.XATransactionWrapper.prepare", "686", this);
                if (this.mcWrapper.isStale()) throw xAException;
                String string = null;
                if (this.mcWrapper != null) {
                    string = this.mcWrapper.gConfigProps.pmiName;
                }
                Object[] objectArray = new Object[]{"prepare", xid, xAException, string};
                Tr.error(tc, "XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", objectArray);
                throw xAException;
            }
            catch (Exception exception) {
                Object object2;
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.XATransactionWrapper.prepare", "692", this);
                if (!this.mcWrapper.shouldBeDestroyed()) {
                    this.mcWrapper.markTransactionError();
                    object2 = null;
                    if (this.mcWrapper != null) {
                        object2 = this.mcWrapper.gConfigProps.pmiName;
                    }
                    Object[] objectArray = new Object[]{"prepare", xid, exception, object2};
                    Tr.error(tc, "XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", objectArray);
                }
                object2 = new XAException(-7);
                ((Throwable)object2).initCause(exception);
                throw object2;
            }
            Object var9_5 = null;
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            if (PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID)) {
                Properties properties = null;
                int n3 = PmiReqMetrics.getTranDetailLevel(object, this.mcWrapper.gConfigProps.reqMetricID);
                if (n3 == 3) {
                    properties = (Properties)this.mcWrapper.gConfigProps.raMetaDataProps.clone();
                }
                if (properties == null) {
                    PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n2);
                } else {
                    PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n2, properties);
                }
            }
            if (this.mcWrapper.pm.efficiencyGroupEnabled) {
                this.mcWrapper.useTimeStop();
            }
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "prepare");
            throw throwable;
        }
        if (PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID)) {
            Properties properties = null;
            int n4 = PmiReqMetrics.getTranDetailLevel(object, this.mcWrapper.gConfigProps.reqMetricID);
            if (n4 == 3) {
                properties = (Properties)this.mcWrapper.gConfigProps.raMetaDataProps.clone();
            }
            if (properties == null) {
                PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n2);
            } else {
                PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n2, properties);
            }
        }
        if (this.mcWrapper.pm.efficiencyGroupEnabled) {
            this.mcWrapper.useTimeStop();
        }
        if (!tc.isEntryEnabled()) return n;
        Tr.exit(tc, "prepare");
        return n;
    }

    public Xid[] recover(int n) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recover");
        }
        Xid[] xidArray = new Xid[]{null};
        try {
            xidArray = this.xaResource.recover(n);
        }
        catch (XAException xAException) {
            this.processXAException(xAException);
            FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.j2c.XATransactionWrapper.recover", "722", this);
            if (!this.mcWrapper.isStale()) {
                String string = null;
                if (this.mcWrapper != null) {
                    string = this.mcWrapper.gConfigProps.pmiName;
                }
                Object[] objectArray = new Object[]{"recover", xAException, string};
                Tr.error(tc, "XA_RESOURCE_ADAPTER_OPERATION_EXCP_J2CA0028", objectArray);
            }
            throw xAException;
        }
        catch (Exception exception) {
            Object object;
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.XATransactionWrapper.recover", "728", this);
            if (!this.mcWrapper.shouldBeDestroyed()) {
                this.mcWrapper.markTransactionError();
                object = null;
                if (this.mcWrapper != null) {
                    object = this.mcWrapper.gConfigProps.pmiName;
                }
                Object[] objectArray = new Object[]{"recover", exception, object};
                Tr.error(tc, "XA_RESOURCE_ADAPTER_OPERATION_EXCP_J2CA0028", objectArray);
            }
            object = new XAException(-7);
            ((Throwable)object).initCause(exception);
            throw object;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recover");
            }
        }
        return xidArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback(Xid xid) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback");
        }
        this.hasRollbackOccured = true;
        Object object = null;
        if (PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID)) {
            object = PmiReqMetrics.reqStart(this.mcWrapper.gConfigProps.reqMetricID, 2, new String[]{"javax.resource.spi.XAResource", "rollback(Xid)"});
        }
        if (this.mcWrapper.pm.efficiencyGroupEnabled) {
            this.mcWrapper.useTimeStart();
        }
        int n = 2;
        try {
            try {
                this.xaResource.rollback(xid);
                n = 0;
            }
            catch (XAException xAException) {
                this.processXAException(xAException);
                FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.j2c.XATransactionWrapper.rollback", "755", this);
                if (this.mcWrapper.isStale()) throw xAException;
                String string = null;
                if (this.mcWrapper != null) {
                    string = this.mcWrapper.gConfigProps.pmiName;
                }
                Object[] objectArray = new Object[]{"rollback", xid, xAException, string};
                Tr.error(tc, "XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", objectArray);
                throw xAException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.XATransactionWrapper.rollback", "761", this);
                if (this.mcWrapper.shouldBeDestroyed()) throw new XAException("Exception:" + exception.toString());
                this.mcWrapper.markTransactionError();
                String string = null;
                if (this.mcWrapper != null) {
                    string = this.mcWrapper.gConfigProps.pmiName;
                }
                Object[] objectArray = new Object[]{"rollback", xid, exception, string};
                Tr.error(tc, "XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", objectArray);
                throw new XAException("Exception:" + exception.toString());
            }
            Object var8_4 = null;
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            if (PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID)) {
                Properties properties = null;
                int n2 = PmiReqMetrics.getTranDetailLevel(object, this.mcWrapper.gConfigProps.reqMetricID);
                if (n2 == 3) {
                    properties = (Properties)this.mcWrapper.gConfigProps.raMetaDataProps.clone();
                }
                if (properties == null) {
                    PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n);
                } else {
                    PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n, properties);
                }
            }
            if (this.mcWrapper.pm.efficiencyGroupEnabled) {
                this.mcWrapper.useTimeStop();
            }
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "rollback");
            throw throwable;
        }
        if (PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID)) {
            Properties properties = null;
            int n3 = PmiReqMetrics.getTranDetailLevel(object, this.mcWrapper.gConfigProps.reqMetricID);
            if (n3 == 3) {
                properties = (Properties)this.mcWrapper.gConfigProps.raMetaDataProps.clone();
            }
            if (properties == null) {
                PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n);
            } else {
                PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n, properties);
            }
        }
        if (this.mcWrapper.pm.efficiencyGroupEnabled) {
            this.mcWrapper.useTimeStop();
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "rollback");
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTransactionTimeout");
        }
        boolean bl = false;
        try {
            bl = this.xaResource.setTransactionTimeout(n);
        }
        catch (XAException xAException) {
            this.processXAException(xAException);
            FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.j2c.XATransactionWrapper.setTransactionTimeout", "790", this);
            if (!this.mcWrapper.isStale()) {
                String string = null;
                if (this.mcWrapper != null) {
                    string = this.mcWrapper.gConfigProps.pmiName;
                }
                Object[] objectArray = new Object[]{"setTransactionTimeout", xAException, string};
                Tr.error(tc, "XA_RESOURCE_ADAPTER_OPERATION_EXCP_J2CA0028", objectArray);
            }
            throw xAException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.XATransactionWrapper.setTransactionTimeout", "796", this);
            if (!this.mcWrapper.shouldBeDestroyed()) {
                this.mcWrapper.markTransactionError();
                String string = null;
                if (this.mcWrapper != null) {
                    string = this.mcWrapper.gConfigProps.pmiName;
                }
                Object[] objectArray = new Object[]{"setTransactionTimeout", exception, string};
                Tr.error(tc, "XA_RESOURCE_ADAPTER_OPERATION_EXCP_J2CA0028", objectArray);
            }
            throw new XAException("Exception:" + exception.toString());
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setTransactionTimeout");
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(Xid xid, int n) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        Object object = null;
        if (PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID)) {
            object = PmiReqMetrics.reqStart(this.mcWrapper.gConfigProps.reqMetricID, 2, new String[]{"javax.resource.spi.XAResource", "start(Xid, int)"});
        }
        if (this.mcWrapper.pm.efficiencyGroupEnabled) {
            this.mcWrapper.useTimeStart();
        }
        int n2 = 2;
        try {
            try {
                this.xaResource.start(xid, n);
                n2 = 0;
            }
            catch (XAException xAException) {
                this.processXAException(xAException);
                FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.j2c.XATransactionWrapper.start", "824", this);
                if (this.mcWrapper.isStale()) throw xAException;
                String string = null;
                if (this.mcWrapper != null) {
                    string = this.mcWrapper.gConfigProps.pmiName;
                }
                Object[] objectArray = new Object[]{"start", xid, xAException, string};
                Tr.error(tc, "XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", objectArray);
                throw xAException;
            }
            catch (Exception exception) {
                Object object2;
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.XATransactionWrapper.start", "830", this);
                if (!this.mcWrapper.shouldBeDestroyed()) {
                    this.mcWrapper.markTransactionError();
                    object2 = null;
                    if (this.mcWrapper != null) {
                        object2 = this.mcWrapper.gConfigProps.pmiName;
                    }
                    Object[] objectArray = new Object[]{"start", xid, exception, object2};
                    Tr.error(tc, "XA_RESOURCE_ADAPTER_OPERATION_ID_EXCP_J2CA0027", objectArray);
                }
                object2 = new XAException(-7);
                ((Throwable)object2).initCause(exception);
                throw object2;
            }
            Object var9_5 = null;
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            if (PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID)) {
                Properties properties = null;
                int n3 = PmiReqMetrics.getTranDetailLevel(object, this.mcWrapper.gConfigProps.reqMetricID);
                if (n3 == 3) {
                    properties = (Properties)this.mcWrapper.gConfigProps.raMetaDataProps.clone();
                }
                if (properties == null) {
                    PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n2);
                } else {
                    PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n2, properties);
                }
            }
            if (this.mcWrapper.pm.efficiencyGroupEnabled) {
                this.mcWrapper.useTimeStop();
            }
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "start");
            throw throwable;
        }
        if (PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID)) {
            Properties properties = null;
            int n4 = PmiReqMetrics.getTranDetailLevel(object, this.mcWrapper.gConfigProps.reqMetricID);
            if (n4 == 3) {
                properties = (Properties)this.mcWrapper.gConfigProps.raMetaDataProps.clone();
            }
            if (properties == null) {
                PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n2);
            } else {
                PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n2, properties);
            }
        }
        if (this.mcWrapper.pm.efficiencyGroupEnabled) {
            this.mcWrapper.useTimeStop();
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "start");
    }

    public void processXAException(XAException xAException) {
        if (xAException.errorCode == -3 || xAException.errorCode == -7) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processXAException: detecting bad XAException error code. Marking MCWrapper stale. ");
            }
            this.mcWrapper.markTransactionError();
        }
        if (xAException.errorCode != 0 && tc.isDebugEnabled()) {
            Tr.debug(tc, "processXAException: Non-zero return code from XAResource. Return code is:  ", XATransactionWrapper.getXAExceptionCodeString(xAException.errorCode));
        }
    }

    public static String getXAExceptionCodeString(int n) {
        switch (n) {
            case 107: {
                return "XA_RBTRANSIENT";
            }
            case 100: {
                return "XA_RBROLLBACK";
            }
            case 7: {
                return "XA_HEURCOM";
            }
            case 8: {
                return "XA_HEURHAZ";
            }
            case 5: {
                return "XA_HEURMIX";
            }
            case 6: {
                return "XA_HEURRB";
            }
            case 9: {
                return "XA_NOMIGRATE";
            }
            case 101: {
                return "XA_RBCOMMFAIL";
            }
            case 102: {
                return "XA_RBDEADLOCK";
            }
            case 103: {
                return "XA_RBINTEGRITY";
            }
            case 104: {
                return "XA_RBOTHER";
            }
            case 105: {
                return "XA_RBPROTO";
            }
            case 106: {
                return "XA_RBTIMEOUT";
            }
            case 3: {
                return "XA_RDONLY";
            }
            case 4: {
                return "XA_RETRY";
            }
            case -2: {
                return "XAER_ASYNC";
            }
            case -8: {
                return "XAER_DUPID";
            }
            case -5: {
                return "XAER_INVAL";
            }
            case -4: {
                return "XAER_NOTA";
            }
            case -9: {
                return "XAER_OUTSIDE";
            }
            case -6: {
                return "XAER_PROTO";
            }
            case -3: {
                return "XAER_RMERR";
            }
            case -7: {
                return "XAER_RMFAIL";
            }
        }
        return "UNKNOWN XA EXCEPTION CODE: " + n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("XATransactionWrapper@ ");
        stringBuffer.append(this.XAWrapperObject_hexString);
        stringBuffer.append("  XAResource: ");
        stringBuffer.append(this.xaResource);
        stringBuffer.append("  enlisted: ");
        stringBuffer.append(this.enlisted);
        stringBuffer.append("  mcWrapper.hashCode()");
        stringBuffer.append(this.mcWrapper.hashCode());
        return stringBuffer.toString();
    }

    public MCWrapper getMcWrapper() {
        return this.mcWrapper;
    }
}

