/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c.mbeans;

import com.ibm.ejs.j2c.ConnectionFactoryDetailsImpl;
import com.ibm.ejs.j2c.DataSourceMBean;
import com.ibm.ejs.j2c.MCFEntry;
import com.ibm.ejs.j2c.mbeans.ConnectionFactoryMbeanImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.resource.ResourceException;

public class DataSourceMbeanImpl
extends ConnectionFactoryMbeanImpl {
    private static final TraceComponent tc = Tr.register(DataSourceMbeanImpl.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");
    private DataSourceMBean _dsMbean = null;
    private String jdbcDriver = null;

    public Class getConnectionFactoryClass() {
        Class clazz = null;
        this.getDsMBean();
        if (this._dsMbean != null) {
            clazz = this._dsMbean.getConnectionFactoryClass();
        }
        return clazz;
    }

    public String getDataSourceName() {
        String string = null;
        this.getDsMBean();
        if (this._dsMbean != null) {
            string = this._dsMbean.getDataSourceName();
        }
        return string;
    }

    public Class getDataStoreHelperClass() {
        Class clazz = null;
        this.getDsMBean();
        if (this._dsMbean != null) {
            clazz = this._dsMbean.getDataStoreHelperClass();
        }
        return clazz;
    }

    public String getDescription() {
        String string = null;
        this.getDsMBean();
        if (this._dsMbean != null && ((string = this._dsMbean.getDescription()) == null || string.equals(""))) {
            string = super.getDescription();
        }
        return string;
    }

    public int getLoginTimeout() {
        int n;
        block3: {
            n = -1;
            this.getDsMBean();
            if (this._dsMbean != null) {
                try {
                    n = this._dsMbean.getLoginTimeout();
                }
                catch (ResourceException resourceException) {
                    n = 0;
                    FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.j2c.mbeans.DataSourceMbeanImpl.getLoginTimeout", "166", this);
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Caught Resource Exception trying to get loginTimeout from RRA" + (Object)((Object)resourceException) + " using default value of 0");
                }
            }
        }
        return n;
    }

    public int getStatementCacheSize() {
        int n = -1;
        this.getDsMBean();
        if (this._dsMbean != null) {
            n = this._dsMbean.getStatementCacheSize();
        }
        return n;
    }

    public boolean isJTAEnabled() {
        if (this._dsMbean == null) {
            this.getDsMBean();
            if (this._dsMbean == null) {
                IllegalStateException illegalStateException = new IllegalStateException("Connection pool is not available.  The connection pool is created at first JNDI lookup of a data source or connection factory.");
                throw illegalStateException;
            }
            return this._dsMbean.isJTAEnabled();
        }
        return this._dsMbean.isJTAEnabled();
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public void setJdbcDriver(String string) {
        this.jdbcDriver = string;
    }

    public String getProperty(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperty");
        }
        if (string == null || string.length() == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getProperty: The property name " + string + " is malformed.");
            }
            throw new IllegalArgumentException("The property name " + string + " is malformed.");
        }
        String string2 = null;
        this.getDsMBean();
        string2 = this._dsMbean != null ? this._dsMbean.getProperty(string) : this.getPropertyValueFromConfiguration(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperty");
        }
        return string2;
    }

    public void setDsMBean(Object object) {
        if (object != null && object instanceof DataSourceMBean) {
            try {
                this._dsMbean = (DataSourceMBean)object;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.mbeans.DataSourceMbeanImpl.setDsMBean", "280", this);
                Tr.warning(tc, "ERROR_READING_DS_MBEAN_PROPS_J2CA0119", exception);
                this._dsMbean = null;
            }
        } else {
            this._dsMbean = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDsMBean() {
        if (this._dsMbean == null) {
            MCFEntry mCFEntry = null;
            Object object = ConnectionFactoryDetailsImpl.LOCKOBJECT;
            synchronized (object) {
                mCFEntry = (MCFEntry)ConnectionFactoryDetailsImpl.cfKeyToMcf.get(this._cfKey);
            }
            if (mCFEntry != null) {
                this._dsMbean = (DataSourceMBean)mCFEntry.getManagedConnectionFactory();
                if (this._dsMbean == null) {
                    Tr.debug(tc, "Connection pool is not available.  The connection pool is created at first JNDI lookup of a data source or connection factory.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Connection pool is not available.  The connection pool is created at first JNDI lookup of a data source or connection factory.");
            }
        }
    }
}

