/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c.work;

import com.ibm.ejs.j2c.RALifeCycleManagerImpl;
import com.ibm.ejs.j2c.work.AsyncWorkProxy;
import com.ibm.ejs.j2c.work.WorkManagerServiceImpl;
import com.ibm.ejs.j2c.work.WorkProxy;
import com.ibm.ejs.j2c.work.WorkScheduler;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.asynchbeans.ExecutionContext;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.j2c.RALifeCycleManagerFactory;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.ThreadPool;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import javax.resource.spi.work.WorkRejectedException;

public final class WorkManagerImpl
implements WorkManager {
    private ThreadPool threadPool = null;
    private String providerId = null;
    private WorkScheduler theScheduler = null;
    private static final TraceComponent TC = Tr.register(WorkManagerImpl.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");
    private boolean _propogateThreadContext = false;

    public WorkManagerImpl(boolean bl) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "WorkManagerImpl", bl);
        }
        this._propogateThreadContext = bl;
        WorkManagerServiceImpl.setAllowRegisterOff();
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "WorkManagerImpl");
        }
    }

    public void doWork(Work work) throws WorkException {
        this.doWork(work, Long.MAX_VALUE, null, null);
    }

    public void doWork(Work work, long l, javax.resource.spi.work.ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "doWork");
        }
        this.beforeRunCheck(work, workListener, l);
        try {
            new WorkProxy(work, l, executionContext, workListener, this.providerId).run();
        }
        catch (Exception exception) {
            WorkException workException = this.afterRunCheck(exception, work, workListener);
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "doWork - error");
            }
            throw workException;
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "doWork");
        }
    }

    public long startWork(Work work) throws WorkException {
        return this.startWork(work, Long.MAX_VALUE, null, null);
    }

    public long startWork(Work work, long l, javax.resource.spi.work.ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        RuntimeException runtimeException;
        long l2;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "startWork");
        }
        this.beforeRunCheck(work, workListener, l);
        WorkProxy workProxy = null;
        try {
            workProxy = null;
            if (this._propogateThreadContext) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "Starting an AsynchWorkProxy.");
                }
                workProxy = this.getABWorkProxy(work, l, executionContext, workListener);
            } else {
                workProxy = new WorkProxy(work, l, executionContext, workListener, this.providerId);
            }
            this.threadPool.execute((Runnable)((Object)workProxy));
            l2 = workProxy.getStartupDuration();
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "Total time to start work " + workProxy.getInstanceID() + "=" + l2);
            }
        }
        catch (Exception exception) {
            WorkException workException = this.afterRunCheck(exception, work, workListener);
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "startWork " + (workProxy == null ? "" : workProxy.getInstanceID()) + " - error=", workException);
            }
            throw workException;
        }
        if (workProxy != null && (runtimeException = workProxy.getWorkException()) != null) {
            WorkException workException = this.afterRunCheck(runtimeException, work, workListener);
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "startWork " + workProxy.getInstanceID() + " - error=", workException);
            }
            throw workException;
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "startWork  - saveStartupDuration=" + l2);
        }
        return l2;
    }

    public void scheduleWork(Work work) throws WorkException {
        this.scheduleWork(work, Long.MAX_VALUE, null, null);
    }

    public void scheduleWork(Work work, long l, javax.resource.spi.work.ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "scheduleWork");
        }
        this.beforeRunCheck(work, workListener, l);
        try {
            long l2 = System.currentTimeMillis();
            if (this._propogateThreadContext) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "Scheduling an AsynchWorkProxy.");
                }
                this.theScheduler.addWork(this.getABWorkProxy(work, l, executionContext, workListener));
            } else {
                this.theScheduler.addWork(new WorkProxy(work, l, executionContext, workListener, this.providerId));
            }
            long l3 = System.currentTimeMillis();
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "Time to add work to scheduler queue: " + (l3 - l2));
            }
        }
        catch (Exception exception) {
            WorkException workException = this.afterRunCheck(exception, work, workListener);
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "scheduleWork - error");
            }
            throw workException;
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "scheduleWork");
        }
    }

    private void beforeRunCheck(Work work, WorkListener workListener, long l) throws WorkException {
        if (this.threadPool == null) {
            WorkRejectedException workRejectedException = new WorkRejectedException("The WorkManager is unusable until the problem with obtaining the thread pool is resolved.", "0");
            if (workListener != null) {
                if (work == null) {
                    workListener.workRejected(null);
                } else {
                    WorkEvent workEvent = new WorkEvent((Object)work, 2, work, (WorkException)workRejectedException);
                    workListener.workRejected(workEvent);
                }
            }
            throw workRejectedException;
        }
        if (work == null) {
            WorkRejectedException workRejectedException = new WorkRejectedException("Work cannot be null", "0");
            if (workListener != null) {
                workListener.workRejected(null);
            }
            throw workRejectedException;
        }
        if (l < 0L) {
            WorkRejectedException workRejectedException = new WorkRejectedException("Start timeout value cannot be set to a negative value", "1");
            if (workListener != null) {
                WorkEvent workEvent = new WorkEvent((Object)work, 2, work, (WorkException)workRejectedException);
                workListener.workRejected(workEvent);
            }
            throw workRejectedException;
        }
    }

    private WorkException afterRunCheck(Exception exception, Work work, WorkListener workListener) {
        if (exception.getCause() != null && exception.getCause() instanceof WorkException) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "Casting Exception to WorkException: " + exception);
            }
            return (WorkException)exception.getCause();
        }
        if (exception instanceof RuntimeException) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "Created WorkException that contains RuntimeException: " + exception);
            }
            WorkException workException = new WorkException("RuntimeException thrown by work", (Throwable)exception);
            workException.setErrorCode("-1");
            return workException;
        }
        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.work.WorkManagerImpl.afterRunCheck", "427", this);
        Tr.error(TC, "METHOD_FAILED_J2CA0132", new Object[]{"doWork", exception});
        WorkException workException = new WorkException("Unknown exception thrown by work", (Throwable)exception);
        workException.setErrorCode("-1");
        if (workListener != null) {
            WorkRejectedException workRejectedException = new WorkRejectedException("Serious failure in WorkManager", (Throwable)exception);
            workRejectedException.setErrorCode("-1");
            WorkEvent workEvent = new WorkEvent((Object)work, 2, work, (WorkException)workRejectedException);
            workListener.workRejected(workEvent);
        }
        return workException;
    }

    public void setThreadPoolName(String string) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "setThreadPoolName: " + string);
        }
        ThreadPoolMgr threadPoolMgr = WorkManagerServiceImpl.getThreadPoolMgr();
        this.threadPool = this.getRaThreadPool(threadPoolMgr, string);
        if (this.threadPool == null) {
            Tr.warning(TC, "MISSING_THREAD_POOL_J2CA0289", string);
            if (string == "Default") {
                throw new IllegalArgumentException("Thread pool Default has not been defined in the server configuration or is not configured correctly");
            }
            this.threadPool = this.getRaThreadPool(threadPoolMgr, "Default");
            if (this.threadPool == null) {
                throw new IllegalArgumentException("Thread pool Default has not been defined in the server configuration or is not configured correctly");
            }
            Tr.warning(TC, "USING_DEFAULT_THREAD_POOL_J2CA0290", "Default");
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "ThreadPool:                   " + this.threadPool);
            Tr.debug(TC, "Threadpool name:              " + this.threadPool.getName());
            Tr.debug(TC, "Threadpool keep alive time:   " + this.threadPool.getKeepAliveTime());
            Tr.debug(TC, "Threadpool maximum pool size: " + this.threadPool.getMaximumPoolSize());
            Tr.debug(TC, "Threadpool minimum pool size: " + this.threadPool.getMinimumPoolSize());
            Tr.debug(TC, "Threadpool current pool size: " + this.threadPool.getPoolSize());
            Tr.debug(TC, "Threadpool thread priority:   " + this.threadPool.getThreadPriority());
            Tr.debug(TC, "Threadpool grow as needed:    " + this.threadPool.isGrowAsNeeded());
        }
        this.theScheduler = new WorkScheduler(this.threadPool);
        this.threadPool.executeOnDaemon(this.theScheduler);
    }

    private ThreadPool getRaThreadPool(ThreadPoolMgr threadPoolMgr, String string) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "getRaThreadPool: " + threadPoolMgr + ", " + string);
        }
        try {
            final ThreadPoolMgr threadPoolMgr2 = threadPoolMgr;
            final String string2 = string;
            return (ThreadPool)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() {
                    return threadPoolMgr2.getThreadPool(string2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (RuntimeException)privilegedActionException.getException();
        }
    }

    public void setProviderId(String string) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "providerId: " + string);
        }
        this.providerId = string;
    }

    public void stop() {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "stop");
        }
        this.theScheduler.stop();
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "stop");
        }
    }

    private AsyncWorkProxy getABWorkProxy(Work work, long l, javax.resource.spi.work.ExecutionContext executionContext, WorkListener workListener) {
        RALifeCycleManagerImpl rALifeCycleManagerImpl = (RALifeCycleManagerImpl)RALifeCycleManagerFactory.getInstance();
        ExecutionContext executionContext2 = rALifeCycleManagerImpl.getAsynchExecutionContext();
        return new AsyncWorkProxy(work, l, executionContext, workListener, this.providerId, rALifeCycleManagerImpl.getEventSource(), rALifeCycleManagerImpl.getAsynchContextDescriptor(), executionContext2);
    }
}

