/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c.work;

import com.ibm.ejs.j2c.work.WorkProxy;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Queue;
import com.ibm.ejs.util.QueueElement;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ThreadPool;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkRejectedException;

public final class WorkScheduler
implements Runnable {
    private boolean runScheduler = true;
    private Queue workQueue;
    private ThreadPool threadPool;
    private static final TraceComponent TC = Tr.register(WorkScheduler.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");

    public WorkScheduler(ThreadPool threadPool) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "WorkScheduler " + threadPool);
        }
        this.workQueue = new Queue();
        this.threadPool = threadPool;
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "WorkScheduler");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "run");
        }
        while (this.runScheduler) {
            WorkScheduler workScheduler = this;
            synchronized (workScheduler) {
                try {
                    if (TC.isDebugEnabled()) {
                        Tr.debug(TC, "Number of items in work queue is: " + this.workQueue.size());
                    }
                    if (this.workQueue.size() == 0) {
                        if (TC.isDebugEnabled()) {
                            Tr.debug(TC, "Waiting for work to be scheduled");
                        }
                        this.wait();
                    }
                    if (TC.isDebugEnabled()) {
                        Tr.debug(TC, "Wake up and process items in queue: " + this.workQueue.size());
                    }
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ejs.j2c.work.WorkScheduler.run", "114", this);
                    Tr.error(TC, "METHOD_FAILED_J2CA0132", new Object[]{"run", interruptedException});
                }
            }
            boolean bl = true;
            QueueElement queueElement = new QueueElement();
            while (bl) {
                WorkScheduler workScheduler2 = this;
                synchronized (workScheduler2) {
                    queueElement = this.workQueue.removeHead();
                }
                if (queueElement != null) {
                    if (TC.isDebugEnabled()) {
                        Tr.debug(TC, "Scheduled work: " + queueElement);
                    }
                    try {
                        this.threadPool.execute((Runnable)((Object)((WorkProxy)queueElement)));
                    }
                    catch (Exception exception) {
                        if (((WorkProxy)queueElement).lsnr != null) {
                            WorkRejectedException workRejectedException = new WorkRejectedException("Serious failure in work scheduler", (Throwable)exception);
                            workRejectedException.setErrorCode("-1");
                            WorkEvent workEvent = new WorkEvent((Object)((WorkProxy)queueElement).work, 2, ((WorkProxy)queueElement).work, (WorkException)workRejectedException);
                            ((WorkProxy)queueElement).lsnr.workRejected(workEvent);
                        }
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.work.WorkScheduler.run", "165", this);
                        Tr.error(TC, "METHOD_FAILED_J2CA0132", new Object[]{"run", exception});
                    }
                    continue;
                }
                bl = false;
                if (!TC.isDebugEnabled()) continue;
                Tr.debug(TC, "Done processing queue");
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "run");
        }
    }

    public synchronized void addWork(WorkProxy workProxy) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "addWork " + workProxy);
        }
        this.workQueue.addToTail(workProxy);
        this.notify();
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "addWork");
        }
    }

    public synchronized void stop() {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "stop");
        }
        this.runScheduler = false;
        this.notify();
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "stop");
        }
    }
}

