/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSMessageConsumerHandle;
import com.ibm.ejs.jms.JMSSessionHandle;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;

public class AccessorForNonASFMessageListener {
    private static final TraceComponent tc = Tr.register(AccessorForNonASFMessageListener.class, "Messaging", JMSCMUtils.MSG_BUNDLE);

    public static Message receiveWithoutEnlist(MessageConsumer messageConsumer, long l) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "receiveWithoutEnlist", new Object[]{messageConsumer, new Long(l)});
        }
        Message message = messageConsumer instanceof JMSMessageConsumerHandle ? ((JMSMessageConsumerHandle)messageConsumer).receiveWithoutEnlist(l) : messageConsumer.receive(l);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "receiveWithoutEnlist", message);
        }
        return message;
    }

    public static void commitInAnyContext(Session session) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "commitInAnyContext", session);
        }
        if (session instanceof JMSSessionHandle) {
            ((JMSSessionHandle)session).commitInAnyContext();
        } else {
            session.commit();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "commitInAnyContext");
        }
    }

    public static void rollbackInAnyContext(Session session) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "rollbackInAnyContext", session);
        }
        if (session instanceof JMSSessionHandle) {
            ((JMSSessionHandle)session).rollbackInAnyContext();
        } else {
            session.rollback();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "rollbackInAnyContext");
        }
    }
}

