/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.DurableSubscription;
import com.ibm.ejs.jms.DurableSubscriptionLog;
import com.ibm.ejs.jms.DurableSubscriptionManager;
import com.ibm.ejs.jms.JMSListenerSessionRequestInfo;
import com.ibm.ejs.jms.JMSManagedSession;
import com.ibm.ejs.jms.JMSManagedSessionFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.runtime.ServerName;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.resource.ResourceException;

public class DurableSubscriptionManagerImpl
implements DurableSubscriptionManager,
DeployedObjectListener {
    protected static TraceComponent tc = Tr.register(DurableSubscriptionManagerImpl.class, "Messaging", "com.ibm.ejs.jms.messaging");
    private static final int MAX_RETRIES = 5;
    List installedApps = null;
    String durableSubDataFile = null;
    Hashtable moduleSubscriptions = new Hashtable();

    public DurableSubscriptionManagerImpl() {
        Tr.entry(tc, "DurableSubscriptionManagerImpl");
        Tr.exit(tc, "DurableSubscriptionManagerImpl");
    }

    public void initialize(List list, String string) {
        Tr.entry(tc, "initialize");
        this.installedApps = list;
        this.durableSubDataFile = string == null || string.length() == 0 ? ServerName.getDisplayName() + "-durableSubscriptions.ser" : string + File.separator + ServerName.getDisplayName() + "-durableSubscriptions.ser";
        Tr.event(tc, "Durable subscription log file name: ", this.durableSubDataFile);
        Tr.exit(tc, "initialize");
    }

    public synchronized void checkDurableSubscriptions() {
        Tr.entry(tc, "checkDurableSubscriptions");
        try {
            List list = this.readDurableSubscriptionFile();
            boolean bl = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DurableSubscriptionLog durableSubscriptionLog = (DurableSubscriptionLog)iterator.next();
                if (this.installedApps.contains(durableSubscriptionLog.getApplicationName())) continue;
                Tr.event(tc, "unsubscribing durable subscription log entry for deleted application", durableSubscriptionLog);
                if (!this.cleanUpDurableSubscription(durableSubscriptionLog) && durableSubscriptionLog.getUnsubscribeCount() < 5) {
                    durableSubscriptionLog.incrementUnsubscribeCount();
                } else {
                    iterator.remove();
                }
                bl = true;
            }
            if (bl) {
                this.writeDurableSubscriptionFile(list);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.DurableSubscriptionManagerImpl.checkDurableSubscriptions", "109", this);
            Tr.warning(tc, "CheckDurableSubscriptionException", exception);
        }
        Tr.exit(tc, "checkDurableSubscriptions");
    }

    private synchronized void validateSubscriptionsForApp(String string) {
        Tr.entry(tc, "validateSubscriptionsForApp", string);
        try {
            List list = this.readDurableSubscriptionFile();
            Hashtable hashtable = (Hashtable)this.moduleSubscriptions.get(string);
            int n = DurableSubscriptionManager.subscriptionTypes.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2;
                int n2 = DurableSubscriptionManager.subscriptionTypes[i];
                if (tc.isEntryEnabled()) {
                    Tr.event(tc, "Validating durable subscriptions of type: ", new Integer(n2));
                }
                Hashtable<String, DurableSubscription> hashtable2 = new Hashtable<String, DurableSubscription>();
                if (hashtable != null && (object2 = (List)hashtable.get(new Integer(n2))) != null) {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        DurableSubscription durableSubscription = (DurableSubscription)object.next();
                        hashtable2.put(durableSubscription.getName(), durableSubscription);
                    }
                }
                object2 = list.iterator();
                while (object2.hasNext()) {
                    object = (DurableSubscriptionLog)object2.next();
                    if (!((DurableSubscriptionLog)object).getApplicationName().equals(string) || ((DurableSubscriptionLog)object).getType() != n2 || hashtable2.containsKey(((DurableSubscriptionLog)object).getName())) continue;
                    Tr.event(tc, "unsubscribing durable subscription log entry for redundent subscription", object);
                    if (!this.cleanUpDurableSubscription((DurableSubscriptionLog)object) && ((DurableSubscriptionLog)object).getUnsubscribeCount() < 5) {
                        ((DurableSubscriptionLog)object).incrementUnsubscribeCount();
                        continue;
                    }
                    object2.remove();
                }
            }
            this.writeDurableSubscriptionFile(list);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.DurableSubscriptionManagerImpl.setCurrentSubscriptionsForApp", "178", this);
            Tr.warning(tc, "SetCurrentSubscriptionsForAppException", exception);
        }
        Tr.exit(tc, "validateSubscriptionsForApp");
    }

    public synchronized void setCurrentSubscriptionsForModule(String string, int n, List list) {
        Vector<DurableSubscription> vector;
        Hashtable hashtable;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCurrentSubscriptionsForModule", new Object[]{string, new Integer(n), list});
        }
        if ((hashtable = (Hashtable)this.moduleSubscriptions.get(string)) == null) {
            hashtable = new Hashtable();
            this.moduleSubscriptions.put(string, hashtable);
        }
        if ((vector = (Vector<DurableSubscription>)hashtable.get(new Integer(n))) == null) {
            vector = new Vector<DurableSubscription>();
            hashtable.put(new Integer(n), vector);
        }
        try {
            List list2 = this.readDurableSubscriptionFile();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DurableSubscription durableSubscription = (DurableSubscription)iterator.next();
                vector.add(durableSubscription);
                JMSManagedSessionFactory jMSManagedSessionFactory = (JMSManagedSessionFactory)durableSubscription.getJMSManagedSessionFactory();
                DurableSubscriptionLog durableSubscriptionLog = new DurableSubscriptionLog(durableSubscription.getName(), string, n, jMSManagedSessionFactory);
                int n2 = list2.indexOf(durableSubscriptionLog);
                if (n2 > -1) {
                    ((DurableSubscriptionLog)list2.get(n2)).setManagedSessionFactory(jMSManagedSessionFactory);
                    Tr.event(tc, "updated MSF for existing durable subscription log entry", durableSubscriptionLog);
                    continue;
                }
                list2.add(durableSubscriptionLog);
                Tr.event(tc, "added new durable subscription log entry", durableSubscriptionLog);
            }
            this.writeDurableSubscriptionFile(list2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.DurableSubscriptionManagerImpl.setCurrentSubscriptionsForModule", "296", this);
            Tr.warning(tc, "SetCurrentSubscriptionsForAppException", exception);
        }
        Tr.exit(tc, "setCurrentSubscriptionsForModule");
    }

    private boolean cleanUpDurableSubscription(DurableSubscriptionLog durableSubscriptionLog) {
        boolean bl;
        block12: {
            Tr.entry(tc, "cleanUpDurableSubscription", durableSubscriptionLog);
            bl = false;
            Session session = null;
            try {
                JMSListenerSessionRequestInfo jMSListenerSessionRequestInfo = new JMSListenerSessionRequestInfo(1, false, false);
                JMSManagedSessionFactory jMSManagedSessionFactory = durableSubscriptionLog.getManagedSessionFactory();
                if (jMSManagedSessionFactory != null) {
                    JMSManagedSession jMSManagedSession = (JMSManagedSession)jMSManagedSessionFactory.createManagedConnection(null, jMSListenerSessionRequestInfo);
                    session = (Session)jMSManagedSession.getConnection(null, jMSListenerSessionRequestInfo);
                    session.unsubscribe(durableSubscriptionLog.getName());
                    session.close();
                } else {
                    Tr.event(tc, "JMSManagedSessionFactory is null");
                }
                bl = true;
                Tr.audit(tc, "CleanedUpDurableSubscription", durableSubscriptionLog.getName());
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ejs.jms.DurableSubscriptionManagerImpl.cleanUpDurableSubscription", "207", this);
                if (durableSubscriptionLog.getUnsubscribeCount() == 5) {
                    Exception exception;
                    String string = throwable.toString();
                    if (throwable instanceof ResourceException) {
                        Exception exception2 = ((ResourceException)throwable).getLinkedException();
                        if (exception2 != null) {
                            string = exception2.toString();
                        }
                    } else if (throwable instanceof JMSException && (exception = ((ResourceException)throwable).getLinkedException()) != null) {
                        string = exception.toString();
                    }
                    if (string != null) {
                        Tr.warning(tc, "CleanupDurableSubscriptionException", new Object[]{durableSubscriptionLog.getName(), string});
                    }
                }
                Tr.debug(tc, "Exception:", throwable);
                if (session == null) break block12;
                try {
                    session.close();
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException(throwable2, "com.ibm.ejs.jms.DurableSubscriptionManagerImpl.cleanUpDurableSubscription", "210", this);
                }
            }
        }
        Tr.exit(tc, "cleanUpDurableSubscription", new Boolean(bl));
        return bl;
    }

    private List readDurableSubscriptionFile() throws Exception {
        Tr.entry(tc, "readDurableSubscriptionFile");
        List list = null;
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.durableSubDataFile);
            objectInputStream = new ObjectInputStream(fileInputStream);
            list = (List)objectInputStream.readObject();
            objectInputStream.close();
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Tr.event(tc, "Durable subscription data file does not exist", this.durableSubDataFile);
            list = new Vector();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.DurableSubscriptionManagerImpl.readDurableSubscriptionFile", "242", this);
            Tr.event(tc, "Exception reading durable subscription data file", new Object[]{this.durableSubDataFile, exception});
            if (objectInputStream != null) {
                objectInputStream.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            list = new Vector();
        }
        Tr.exit(tc, "readDurableSubscriptionFile", list);
        return list;
    }

    private void writeDurableSubscriptionFile(List list) throws Exception {
        Tr.entry(tc, "writeDurableSubscriptionFile", list);
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.durableSubDataFile);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(list);
            objectOutputStream.flush();
            objectOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.DurableSubscriptionManagerImpl.writeDurableSubscriptionFile", "272", this);
            Tr.event(tc, "Exception writing durable subscription data file", new Object[]{this.durableSubDataFile, exception});
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            Tr.exit(tc, "writeDurableSubscriptionFile");
            throw exception;
        }
        Tr.exit(tc, "writeDurableSubscriptionFile");
    }

    public void stateChanged(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        DeployedObject deployedObject;
        Tr.entry(tc, "stateChanged", deployedObjectEvent);
        if (deployedObjectEvent.getNewValue() == "STARTING") {
            DeployedObject deployedObject2 = (DeployedObject)deployedObjectEvent.getSource();
            if (deployedObject2.getModuleFile().isEARFile()) {
                this.applicationStarting(deployedObject2.getName());
            }
        } else if (deployedObjectEvent.getNewValue() == "STARTED" && (deployedObject = (DeployedObject)deployedObjectEvent.getSource()).getModuleFile().isEARFile()) {
            this.applicationStarted(deployedObject.getName());
        }
        Tr.exit(tc, "stateChanged");
    }

    private synchronized void applicationStarting(String string) {
        Tr.entry(tc, "applicationStarting", string);
        this.moduleSubscriptions.remove(string);
        Tr.exit(tc, "applicationStarting");
    }

    private synchronized void applicationStarted(String string) {
        Tr.entry(tc, "applicationStarted", string);
        this.moduleSubscriptions.remove(string);
        Tr.exit(tc, "applicationStarted");
    }
}

