/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSManagedConnectionFactory;
import com.ibm.ejs.jms.JMSResourceRefBuilderFactory;
import com.ibm.ejs.jms.mq.JMSWrapXAQueueConnectionFactory;
import com.ibm.ejs.jms.mq.JMSWrapXATopicConnectionFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.rmi.PortableRemoteObject;

public class GenericJMSManagedConnectionFactory
extends JMSManagedConnectionFactory {
    private static final TraceComponent tc = Tr.register(GenericJMSManagedConnectionFactory.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private String providerURL = null;
    private String contextFactoryClassname = null;
    private String jndiPath = null;
    private Properties customProperties = null;
    private static final long serialVersionUID = -538947506115951420L;
    private static ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("providerURL", String.class), new ObjectStreamField("contextFactoryClassname", String.class), new ObjectStreamField("jndiPath", String.class), new ObjectStreamField("customProperties", Properties.class)};

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeObject");
        }
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("providerURL", this.providerURL);
        putField.put("contextFactoryClassname", this.contextFactoryClassname);
        putField.put("jndiPath", this.jndiPath);
        putField.put("customProperties", this.customProperties);
        objectOutputStream.writeFields();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeObject");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readObject", objectInputStream);
        }
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.providerURL = (String)getField.get("providerURL", null);
        this.contextFactoryClassname = (String)getField.get("contextFactoryClassname", null);
        this.jndiPath = (String)getField.get("jndiPath", null);
        this.customProperties = (Properties)getField.get("customProperties", null);
        if (tc.isEntryEnabled()) {
            Object[] objectArray = new Object[]{this.providerURL, this.contextFactoryClassname, this.jndiPath, JMSResourceRefBuilderFactory.maskPasswords(this.customProperties)};
            Tr.exit(tc, "readObject", objectArray);
        }
    }

    public final void setContextFactoryClassname(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ContextFactoryClassname set", string);
        }
        this.contextFactoryClassname = string;
    }

    public final void setJNDIPath(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "JNDIPath set", string);
        }
        this.jndiPath = string;
    }

    public final void setProviderURL(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ProviderURL set", string);
        }
        this.providerURL = string;
    }

    public void setDataSourceProperties(Properties properties) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "DataSourceProperties set", JMSResourceRefBuilderFactory.maskPasswords(properties));
        }
        this.customProperties = properties;
    }

    public Properties getDataSourceProperties() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "DataSourceProperties get", JMSResourceRefBuilderFactory.maskPasswords(this.customProperties));
        }
        return this.customProperties;
    }

    public final String getContextFactoryClassname() {
        return this.contextFactoryClassname;
    }

    public final String getJNDIPath() {
        return this.jndiPath;
    }

    public final String getProviderURL() {
        return this.providerURL;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        GenericJMSManagedConnectionFactory genericJMSManagedConnectionFactory = (GenericJMSManagedConnectionFactory)object;
        if (!JMSCMUtils.objectsEqual(this.providerURL, genericJMSManagedConnectionFactory.providerURL)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.contextFactoryClassname, genericJMSManagedConnectionFactory.contextFactoryClassname)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.jndiPath, genericJMSManagedConnectionFactory.jndiPath)) {
            return false;
        }
        return JMSCMUtils.objectsEqual(this.customProperties, genericJMSManagedConnectionFactory.customProperties);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = JMSCMUtils.HASH_CODE_PRIME * n + JMSCMUtils.objectHashCode(this.providerURL);
        n = JMSCMUtils.HASH_CODE_PRIME * n + JMSCMUtils.objectHashCode(this.contextFactoryClassname);
        n = JMSCMUtils.HASH_CODE_PRIME * n + JMSCMUtils.objectHashCode(this.jndiPath);
        n = JMSCMUtils.HASH_CODE_PRIME * n + JMSCMUtils.objectHashCode(this.customProperties);
        return n;
    }

    protected void setupForRecovery() {
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(string + "provider URL = " + this.providerURL);
        stringBuffer.append(string + "context factory classname = " + this.contextFactoryClassname);
        stringBuffer.append(string + "JNDI path = " + this.jndiPath);
        stringBuffer.append(string + "custom properties = " + JMSResourceRefBuilderFactory.maskPasswords(this.customProperties));
        return stringBuffer.toString();
    }

    protected synchronized ConnectionFactory getConnectionFactory() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionFactory");
        }
        try {
            if (this.connectionFactory == null) {
                Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
                if (this.providerURL != null) {
                    hashtable.put("java.naming.provider.url", this.providerURL);
                }
                if (this.contextFactoryClassname != null) {
                    hashtable.put("java.naming.factory.initial", this.contextFactoryClassname);
                }
                if (this.customProperties != null) {
                    hashtable.putAll(JMSResourceRefBuilderFactory.getNamingProperties(this.customProperties));
                }
                InitialContext initialContext = new InitialContext(hashtable);
                Object object = initialContext.lookup(this.jndiPath);
                this.connectionFactory = (ConnectionFactory)PortableRemoteObject.narrow((Object)object, (Class)ConnectionFactory.class);
                if (this.connectionFactory instanceof JMSWrapXAQueueConnectionFactory) {
                    JMSWrapXAQueueConnectionFactory jMSWrapXAQueueConnectionFactory = (JMSWrapXAQueueConnectionFactory)this.connectionFactory;
                    this.connectionFactory = jMSWrapXAQueueConnectionFactory.getWrappedFactory();
                } else if (this.connectionFactory instanceof JMSWrapXATopicConnectionFactory) {
                    JMSWrapXATopicConnectionFactory jMSWrapXATopicConnectionFactory = (JMSWrapXATopicConnectionFactory)this.connectionFactory;
                    this.connectionFactory = jMSWrapXATopicConnectionFactory.getWrappedFactory();
                }
            }
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, "com.ibm.ejs.jms.GenericJMSManagedConnectionFactory.getConnectionFactory", "258", this);
            throw JMSCMUtils.mapToResourceException(classCastException, tc, "Expected to find JMS ConnectionFactory in JNDI");
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ejs.jms.GenericJMSManagedConnectionFactory.getConnectionFactory", "263", this);
            throw JMSCMUtils.mapToResourceException(namingException, tc, "ConnectionFactory not found in JNDI");
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConnectionFactory", this.connectionFactory);
            }
        }
        return this.connectionFactory;
    }

    protected ConnectionFactory getConnectionFactory(boolean bl) throws ResourceException {
        return this.getConnectionFactory();
    }
}

