/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedAction;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;

public final class JMSCMUtils {
    static int HASH_CODE_PRIME = 1000003;
    public static String MSG_BUNDLE = "com.ibm.ejs.jms.messaging";

    private JMSCMUtils() {
    }

    static boolean inGlobalTransaction() {
        return TransactionManagerFactory.getUOWCurrent().getUOWType() == 2;
    }

    static JMSException mapToJMSException(ResourceException resourceException, TraceComponent traceComponent, String string) {
        Throwable throwable;
        if (traceComponent.isEventEnabled()) {
            Tr.event(traceComponent, "Caught exception:", (Object)resourceException);
        }
        JMSException jMSException = null;
        Throwable throwable2 = resourceException.getCause();
        if (throwable2 == null) {
            throwable2 = resourceException.getLinkedException();
        }
        while (throwable2 != null) {
            if (throwable2 instanceof JMSException) {
                jMSException = (JMSException)throwable2;
                break;
            }
            if (!(throwable2 instanceof ResourceException)) break;
            throwable = throwable2.getCause();
            if (throwable == null) {
                throwable2 = ((ResourceException)throwable2).getLinkedException();
                continue;
            }
            throwable2 = throwable;
        }
        if (jMSException == null) {
            jMSException = new JMSException(string);
            jMSException.setLinkedException((Exception)((Object)resourceException));
        }
        if (traceComponent.isEventEnabled()) {
            Tr.event(traceComponent, "Mapping to JMSException:", (Object)resourceException);
            throwable = resourceException.getLinkedException();
            if (throwable != null) {
                Tr.event(traceComponent, "Linked exception", throwable);
            }
        }
        return jMSException;
    }

    static ResourceException mapToResourceException(Exception exception, TraceComponent traceComponent, String string) {
        if (traceComponent.isEventEnabled()) {
            Tr.event(traceComponent, "Caught exception:", exception);
        }
        ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException(string, (Throwable)exception);
        resourceAdapterInternalException.setLinkedException(exception);
        if (traceComponent.isEventEnabled()) {
            Tr.event(traceComponent, "Mapping to ResourceException:", exception);
        }
        return resourceAdapterInternalException;
    }

    static int objectHashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    static String objectToString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
    }

    static boolean objectsEqual(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    static IllegalStateException methodNotPermittedException(TraceComponent traceComponent, String string) {
        IllegalStateException illegalStateException = new IllegalStateException("Method " + string + " not permitted");
        if (traceComponent.isEventEnabled()) {
            Tr.event(traceComponent, "Method " + string + " not permitted", illegalStateException);
        }
        return illegalStateException;
    }

    static void trace(TraceComponent traceComponent, String string, JMSException jMSException) {
        if (traceComponent.isEventEnabled()) {
            Tr.event(traceComponent, "Caught JMSException in " + string, jMSException);
            Exception exception = jMSException.getLinkedException();
            if (exception != null) {
                Tr.event(traceComponent, "Linked exception", exception);
            }
        }
    }

    static String subjectToString(Subject subject) {
        String string = null;
        if (subject != null) {
            final Subject subject2 = subject;
            string = System.getSecurityManager() != null ? (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return subject2.toString();
                }
            }) : subject2.toString();
        }
        return string;
    }
}

