/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.jms.ConnectionFactory;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;

public final class JMSConnectionFactoryFactory
implements ObjectFactory {
    private static final TraceComponent _tc = Tr.register(JMSConnectionFactoryFactory.class, "Messaging", null);
    static String ADDR_TYPE_JCA = "JCA";
    static String ADDR_TYPE_JMS = "JMS";
    static String ADDR_TYPE_SSL = "SSL";
    static String ADDR_TYPE_SESSION_SHARING_SCOPE = "SESSION_SHARING_SCOPE";

    /*
     * Enabled aggressive block sorting
     */
    public Object getObjectInstance(Object object, Name name2, Context context, Hashtable hashtable) throws Exception {
        ConnectionFactory connectionFactory;
        block15: {
            block13: {
                String string;
                block14: {
                    Object object2;
                    if (_tc.isEntryEnabled()) {
                        Tr.entry(_tc, "getObjectInstance", new Object[]{object, name2, context, hashtable, this});
                    }
                    if (!(object instanceof Reference)) break block13;
                    string = this.onServer() ? ADDR_TYPE_JCA : ADDR_TYPE_JMS;
                    RefAddr refAddr = ((Reference)object).get(string);
                    if (refAddr == null) break block14;
                    byte[] byArray = (byte[])refAddr.getContent();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    Object object3 = objectInputStream.readObject();
                    if (object3 instanceof ConnectionFactory) {
                        connectionFactory = (ConnectionFactory)object3;
                    } else {
                        if (!(object3 instanceof Reference)) {
                            throw new Exception("Address " + string + " of Reference contained " + object3 + " not javax.jms.ConnectionFactory");
                        }
                        object2 = NamingManager.getObjectInstance((Reference)object3, name2, context, hashtable);
                        if (object2 instanceof ConnectionFactory) {
                            connectionFactory = (ConnectionFactory)object2;
                        } else {
                            if (object2 instanceof Reference) {
                                throw new Exception("De-reference of JMS provider's Reference failed - check provider is on classpath");
                            }
                            throw new Exception("De-reference of JMS provider's Reference returned " + object2 + " not javax.jms.ConnectionFactory");
                        }
                    }
                    if (string.equals(ADDR_TYPE_JCA)) {
                        String string2;
                        object2 = ((Reference)object).get(ADDR_TYPE_SSL);
                        if (object2 != null) {
                            string2 = (String)((RefAddr)object2).getContent();
                            this.setSSLConfig(connectionFactory, string2);
                        }
                        if ((object2 = ((Reference)object).get(ADDR_TYPE_SESSION_SHARING_SCOPE)) != null) {
                            string2 = (String)((RefAddr)object2).getContent();
                            this.setSessionSharingScope(connectionFactory, string2);
                        }
                    }
                    break block15;
                }
                Exception exception = new Exception("Reference did not contain " + string + " address");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getObjectInstance", exception);
                }
                throw exception;
            }
            Exception exception = new Exception("Expected javax.naming.Reference not " + object);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getObjectInstance", exception);
            }
            throw exception;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getObjectInstance", connectionFactory);
        }
        return connectionFactory;
    }

    private void setSSLConfig(ConnectionFactory connectionFactory, String string) {
        block6: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "setSSLConfig", new Object[]{connectionFactory, string, this});
            }
            try {
                Method method2 = connectionFactory.getClass().getMethod("getManagedConnectionFactory", new Class[0]);
                Object object = method2.invoke((Object)connectionFactory, new Object[0]);
                Method method3 = object.getClass().getMethod("setSSLRepertoire", String.class);
                method3.invoke(object, string);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                FFDCFilter.processException((Throwable)noSuchMethodException, "com.ibm.ejs.jms.JMSConnectionFactoryFactory.setSSLConfig", "168", this);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Unable to find the appropriate method", noSuchMethodException);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.JMSConnectionFactoryFactory.setSSLConfig", "174", this);
                if (!_tc.isEventEnabled()) break block6;
                Tr.event(_tc, "Unable to call the appropriate method", exception);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setSSLConfig");
        }
    }

    private void setSessionSharingScope(ConnectionFactory connectionFactory, String string) {
        block6: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "setSessionSharingScope", new Object[]{connectionFactory, string, this});
            }
            try {
                Method method2 = connectionFactory.getClass().getMethod("getManagedConnectionFactory", new Class[0]);
                Object object = method2.invoke((Object)connectionFactory, new Object[0]);
                Method method3 = object.getClass().getMethod("setSessionSharingScope", String.class);
                method3.invoke(object, string);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                FFDCFilter.processException((Throwable)noSuchMethodException, "com.ibm.ejs.jms.JMSConnectionFactoryFactory.setSessionSharingScope", "203", this);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Unable to find the appropriate method", noSuchMethodException);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.JMSConnectionFactoryFactory.setSessionSharingScope", "209", this);
                if (!_tc.isEventEnabled()) break block6;
                Tr.event(_tc, "Unable to call the appropriate method", exception);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setSessionSharingScope");
        }
    }

    private boolean onServer() {
        boolean bl = false;
        try {
            Class<?> clazz = Class.forName("com.ibm.ejs.ras.RasHelper");
            bl = (Boolean)clazz.getMethod("isServer", null).invoke(null, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }
}

