/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSConnectionHandle;
import com.ibm.ejs.jms.JMSConnectionRequestInfo;
import com.ibm.ejs.jms.JMSManagedConnectionFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public class JMSConnectionFactoryHandle
implements ConnectionFactory,
Serializable {
    private static final long serialVersionUID = 5936309103310526617L;
    private static final TraceComponent tc = Tr.register(JMSConnectionFactoryHandle.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    protected final ConnectionManager cxManager;
    protected final ManagedConnectionFactory factory;
    protected boolean restrictedMethodsEnabled = false;
    private boolean unified = true;

    JMSConnectionFactoryHandle(ManagedConnectionFactory managedConnectionFactory, ConnectionManager connectionManager) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSConnectionFactoryHandle", new Object[]{managedConnectionFactory, connectionManager});
        }
        this.factory = managedConnectionFactory;
        this.cxManager = connectionManager;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JMSConnectionFactoryHandle");
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JMSConnectionFactoryHandle jMSConnectionFactoryHandle = (JMSConnectionFactoryHandle)object;
        return JMSCMUtils.objectsEqual(this.factory, jMSConnectionFactoryHandle.factory);
    }

    public int hashCode() {
        return JMSCMUtils.objectHashCode(this.factory);
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(JMSCMUtils.objectToString(this));
        stringBuffer.append(string + "managed connection factory = " + JMSCMUtils.objectToString(this.factory));
        stringBuffer.append(string + "connection manager = " + JMSCMUtils.objectToString(this.cxManager));
        stringBuffer.append(string + "restricted methods enabled = " + this.restrictedMethodsEnabled);
        return stringBuffer.toString();
    }

    public final void enableRestrictedMethods() {
        this.restrictedMethodsEnabled = true;
    }

    final boolean getRestrictedMethodsEnabled() {
        return this.restrictedMethodsEnabled;
    }

    public final int getSessionPoolMaxConnections() {
        int n;
        try {
            n = Integer.parseInt(((JMSManagedConnectionFactory)this.factory).getSessionPoolMaxConnections());
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ejs.jms.JMSConnectionFactoryHandle.getSessionPoolMaxConnections", "174", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid SessionPool maxConnections string", numberFormatException);
            }
            n = 0;
        }
        return n;
    }

    public final String getMappingConfigAlias() {
        return ((JMSManagedConnectionFactory)this.factory).getMappingConfigAlias();
    }

    public final String getAuthDataAlias() {
        return ((JMSManagedConnectionFactory)this.factory).getAuthDataAlias();
    }

    public final ManagedConnectionFactory getManagedConnectionFactory() {
        return this.factory;
    }

    public Connection createConnection() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConnection");
        }
        JMSConnectionHandle jMSConnectionHandle = null;
        try {
            boolean bl = !this.restrictedMethodsEnabled;
            JMSConnectionRequestInfo jMSConnectionRequestInfo = new JMSConnectionRequestInfo(bl, this.unified);
            jMSConnectionHandle = (JMSConnectionHandle)this.cxManager.allocateConnection(this.factory, (ConnectionRequestInfo)jMSConnectionRequestInfo);
            jMSConnectionHandle.setConnectionFactoryHandle(this);
        }
        catch (ResourceException resourceException) {
            try {
                FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSConnectionFactoryHandle.createConnection", "242", this);
                throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create connection");
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createConnection", jMSConnectionHandle);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConnection", jMSConnectionHandle);
        }
        return jMSConnectionHandle;
    }

    public Connection createConnection(String string, String string2) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConnection", new Object[]{string, "password not traced"});
        }
        JMSConnectionHandle jMSConnectionHandle = null;
        try {
            boolean bl = !this.restrictedMethodsEnabled;
            JMSConnectionRequestInfo jMSConnectionRequestInfo = new JMSConnectionRequestInfo(string, string2, bl, this.unified);
            jMSConnectionHandle = (JMSConnectionHandle)this.cxManager.allocateConnection(this.factory, (ConnectionRequestInfo)jMSConnectionRequestInfo);
            jMSConnectionHandle.setConnectionFactoryHandle(this);
        }
        catch (ResourceException resourceException) {
            try {
                FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSConnectionFactoryHandle.createConnection", "284", this);
                throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create connection");
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createConnection", jMSConnectionHandle);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConnection", jMSConnectionHandle);
        }
        return jMSConnectionHandle;
    }
}

