/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.j2c.ConnectionFactoryRefBuilder;
import com.ibm.ejs.j2c.ConnectionFactoryRefBuilderFactory;
import com.ibm.ejs.j2c.ConnectorProperties;
import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSConnectionFactoryFactory;
import com.ibm.ejs.jms.JMSResourceRefBuilderFactory;
import com.ibm.ejs.jms.WSJMSManagedConnectionFactory;
import com.ibm.ejs.jms.WSJMSManagedQueueConnectionFactory;
import com.ibm.ejs.jms.WSJMSManagedTopicConnectionFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.util.IndirectJndiLookup;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.resource.ResourceException;

public final class JMSConnectionFactoryReferenceable
implements Referenceable {
    private Referenceable connectorReferenceable;
    private Object connectionFactory;
    private String className = "javax.jms.ConnectionFactory";
    private String sslRepertoire;
    private String sessionSharingScope;
    private static final String QCF = "javax.jms.QueueConnectionFactory";
    private static final String TCF = "javax.jms.TopicConnectionFactory";
    private static final String CF = "javax.jms.ConnectionFactory";
    private static final TraceComponent tc = Tr.register(JMSConnectionFactoryReferenceable.class, "Messaging", JMSCMUtils.MSG_BUNDLE);

    public JMSConnectionFactoryReferenceable(Properties properties, ConnectorProperties connectorProperties, Properties properties2, int n) throws ResourceBindingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSConnectionFactoryReferenceable", new Object[]{properties, connectorProperties, properties2, new Integer(n)});
        }
        try {
            WSJMSManagedConnectionFactory wSJMSManagedConnectionFactory;
            this.sslRepertoire = (String)properties2.remove("ssl.repertoire");
            this.sessionSharingScope = (String)properties2.remove("session.sharing.scope");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ssl repertoire is: " + this.sslRepertoire);
                Tr.debug(tc, "session sharing scope is: " + this.sessionSharingScope);
                Tr.debug(tc, "jms properties are: " + properties2);
            }
            ConnectionFactoryRefBuilder connectionFactoryRefBuilder = ConnectionFactoryRefBuilderFactory.create();
            this.connectorReferenceable = connectionFactoryRefBuilder.createConnectorReferenceableObject(properties, connectorProperties, properties2);
            String string = properties.getProperty("managedConnectionFactoryClass");
            if (string.equals("com.ibm.ejs.jms.WSJMSManagedQueueConnectionFactory")) {
                wSJMSManagedConnectionFactory = new WSJMSManagedQueueConnectionFactory();
                this.className = QCF;
            } else if (string.equals("com.ibm.ejs.jms.WSJMSManagedTopicConnectionFactory")) {
                wSJMSManagedConnectionFactory = new WSJMSManagedTopicConnectionFactory();
                this.className = TCF;
            } else {
                wSJMSManagedConnectionFactory = new WSJMSManagedConnectionFactory();
                this.className = CF;
            }
            wSJMSManagedConnectionFactory.setObjectType(new Integer(n));
            wSJMSManagedConnectionFactory.setDataSourceProperties(properties2);
            this.connectionFactory = wSJMSManagedConnectionFactory.getConnectionFactory();
        }
        catch (ResourceException resourceException) {
            this.traceResourceException(resourceException);
            throw new ResourceBindingException("Failed to create connection factory: " + resourceException.getMessage() + " : " + resourceException.getErrorCode());
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "JMSConnectionFactoryReferenceable");
            }
        }
    }

    public JMSConnectionFactoryReferenceable(Properties properties, ConnectorProperties connectorProperties, String string, String string2, String string3, Properties properties2) throws ResourceBindingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSConnectionFactoryReferenceable", new Object[]{properties, connectorProperties, string, string2, string3, properties2});
        }
        ConnectionFactoryRefBuilder connectionFactoryRefBuilder = ConnectionFactoryRefBuilderFactory.create();
        this.connectorReferenceable = connectionFactoryRefBuilder.createConnectorReferenceableObject(properties, connectorProperties, properties2);
        this.className = properties.getProperty("managedConnectionFactoryClass").equals("com.ibm.ejs.jms.GenericJMSManagedQueueConnectionFactory") ? QCF : (properties.getProperty("managedConnectionFactoryClass").equals("com.ibm.ejs.jms.GenericJMSManagedTopicConnectionFactory") ? TCF : CF);
        Properties properties3 = JMSResourceRefBuilderFactory.getNamingProperties(properties2);
        this.connectionFactory = new IndirectJndiLookup(string, string3, string2, false, this.className, properties3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JMSConnectionFactoryReferenceable");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Reference getReference() throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReference");
        }
        Reference reference = null;
        try {
            reference = new Reference(this.className, JMSConnectionFactoryFactory.class.getName(), null);
            reference.add(this.createBinaryRefAddr(this.connectorReferenceable.getReference(), JMSConnectionFactoryFactory.ADDR_TYPE_JCA));
            if (this.sslRepertoire != null) {
                reference.add(new StringRefAddr(JMSConnectionFactoryFactory.ADDR_TYPE_SSL, this.sslRepertoire));
            }
            if (this.sessionSharingScope != null) {
                reference.add(new StringRefAddr(JMSConnectionFactoryFactory.ADDR_TYPE_SESSION_SHARING_SCOPE, this.sessionSharingScope));
            }
            Serializable serializable = this.connectionFactory instanceof Referenceable ? ((Referenceable)this.connectionFactory).getReference() : (Serializable)this.connectionFactory;
            reference.add(this.createBinaryRefAddr(serializable, JMSConnectionFactoryFactory.ADDR_TYPE_JMS));
        }
        catch (NamingException namingException) {
            try {
                if (!tc.isEventEnabled()) throw namingException;
                Tr.event(tc, "Caught NamingException", namingException);
                throw namingException;
                catch (Exception exception) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Caught Exception", exception);
                    }
                    NamingException namingException2 = new NamingException("Exception in getReference");
                    namingException2.setRootCause(exception);
                    throw namingException2;
                }
            }
            catch (Throwable throwable) {
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "getReference", reference);
                throw throwable;
            }
        }
        if (!tc.isEntryEnabled()) return reference;
        Tr.exit(tc, "getReference", reference);
        return reference;
    }

    private BinaryRefAddr createBinaryRefAddr(Serializable serializable, String string) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.flush();
        return new BinaryRefAddr(string, byteArrayOutputStream.toByteArray());
    }

    private void traceResourceException(ResourceException resourceException) {
        if (tc.isEventEnabled()) {
            Throwable throwable;
            Throwable throwable2;
            Tr.event(tc, "Caught ResourceException when creating connection factory", (Object)resourceException);
            Exception exception = resourceException.getLinkedException();
            if (exception != null) {
                Tr.event(tc, "Linked exception ", exception);
                if (exception instanceof JMSException) {
                    throwable2 = ((JMSException)exception).getLinkedException();
                    if (throwable2 != null) {
                        Tr.event(tc, "JMS linked exception", throwable2);
                    }
                    if ((throwable = ((JMSException)exception).getCause()) != null) {
                        Tr.event(tc, "JMS cause exception", throwable);
                    }
                }
            }
            if ((throwable2 = resourceException.getCause()) != null) {
                Tr.event(tc, "Caused by ", throwable2);
                if (throwable2 instanceof JMSException) {
                    Throwable throwable3;
                    throwable = ((JMSException)throwable2).getLinkedException();
                    if (throwable != null) {
                        Tr.event(tc, "JMS linked exception", throwable);
                    }
                    if ((throwable3 = ((JMSException)throwable2).getCause()) != null) {
                        Tr.event(tc, "JMS cause exception", throwable3);
                    }
                }
            }
        }
    }
}

