/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSConnectionFactoryHandle;
import com.ibm.ejs.jms.JMSListenerSessionRequestInfo;
import com.ibm.ejs.jms.JMSManagedConnection;
import com.ibm.ejs.jms.JMSManagedSessionFactory;
import com.ibm.ejs.jms.JMSSessionHandle;
import com.ibm.ejs.jms.JMSSessionRequestInfo;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public class JMSConnectionHandle
implements Connection,
Serializable {
    private static final long serialVersionUID = 1170899765083230213L;
    private static final TraceComponent tc = Tr.register(JMSConnectionHandle.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private boolean closed = false;
    private boolean invalid = false;
    private List openSessionHandles = Collections.synchronizedList(new ArrayList());
    private boolean restrictedMethodsEnabled = false;
    protected Connection connection;
    private JMSManagedConnection managedConnection;
    protected final ConnectionManager sessionManager;
    protected final JMSManagedSessionFactory factory;
    private List temporaryQueues = new ArrayList();
    private List temporaryTopics = new ArrayList();
    protected transient Vector methodSyncList;
    private transient String lockStop = new String("stop");
    private transient String lockStart = new String("start");
    private transient String lockClose = new String("close");
    private transient String lockSetExceptionListener = new String("setExceptionListener");
    private transient String lockGetExceptionListener = new String("getExceptionListener");
    private transient String lockGetMetaData = new String("getMetaData");
    private transient String lockGetClientID = new String("getClientID");
    private transient String lockSetClientID = new String("setClientID");
    private transient String lockMarkStale = new String("markManagedConnectionAsStale");
    private transient String lockCreateListenerSession = new String("createListenerSession");
    private transient String lockCreateSession = new String("createSession");
    private transient String lockCreateConnectionConsumer = new String("createConnectionConsumer");
    private transient String lockCreateDurableConnectionConsumer = new String("createDurableConnectionConsumer");
    private transient String lockCallConnectionErrorOccurredOnce = new String("callConnectionErrorOccurredOnce");
    private final transient int INIT_METHOD_LOCK_VECTOR_IDX = -1;
    private transient int iterationIdx = -1;
    private transient boolean canInvalidateNow = false;
    private boolean isMarkManagedConnectionAsStaleAlreadyCalled = false;

    JMSConnectionHandle(JMSManagedSessionFactory jMSManagedSessionFactory, ConnectionManager connectionManager) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSConnectionHandle", new Object[]{jMSManagedSessionFactory, connectionManager});
        }
        this.sessionManager = connectionManager;
        this.factory = jMSManagedSessionFactory;
        this.methodSyncList = new Vector();
        this.methodSyncList.add(this.lockStop);
        this.methodSyncList.add(this.lockStart);
        this.methodSyncList.add(this.lockClose);
        this.methodSyncList.add(this.lockSetExceptionListener);
        this.methodSyncList.add(this.lockGetExceptionListener);
        this.methodSyncList.add(this.lockGetMetaData);
        this.methodSyncList.add(this.lockGetClientID);
        this.methodSyncList.add(this.lockSetClientID);
        this.methodSyncList.add(this.lockMarkStale);
        this.methodSyncList.add(this.lockCreateListenerSession);
        this.methodSyncList.add(this.lockCreateSession);
        this.methodSyncList.add(this.lockCreateConnectionConsumer);
        this.methodSyncList.add(this.lockCreateDurableConnectionConsumer);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JMSConnectionHandle");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setClientID(String string) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setClientID", string);
        }
        JMSException jMSException = null;
        try {
            String string2 = this.lockSetClientID;
            synchronized (string2) {
                this.checkRestrictedMethod("setClientID");
                this.checkOpen();
                this.checkValid();
                try {
                    this.connection.setClientID(string);
                }
                catch (InvalidClientIDException invalidClientIDException) {
                    throw invalidClientIDException;
                }
                catch (IllegalStateException illegalStateException) {
                    throw illegalStateException;
                }
                catch (JMSException jMSException2) {
                    jMSException = jMSException2;
                    throw jMSException2;
                }
            }
        }
        catch (JMSException jMSException3) {
            FFDCFilter.processException((Throwable)jMSException3, "com.ibm.ejs.jms.JMSConnectionHandle.setClientID", "159", this);
            JMSCMUtils.trace(tc, "setClientID", jMSException3);
            if (jMSException != null) {
                this.markManagedConnectionAsStale(jMSException);
            }
            throw jMSException3;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "setClientID");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setExceptionListener", exceptionListener);
        }
        String string = this.lockSetExceptionListener;
        synchronized (string) {
            try {
                this.checkRestrictedMethod("setExceptionListener");
                this.checkOpen();
                this.checkValid();
                this.managedConnection.setExceptionListener(exceptionListener);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSConnectionHandle.setExceptionListener", "185", this);
                JMSCMUtils.trace(tc, "setExceptionListener", jMSException);
                throw jMSException;
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setExceptionListener");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getClientID() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientID");
        }
        String string = null;
        try {
            String string2 = this.lockGetClientID;
            synchronized (string2) {
                this.checkOpen();
                this.checkValid();
                string = this.connection.getClientID();
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSConnectionHandle.getClientID", "218", this);
            JMSCMUtils.trace(tc, "getClientID", jMSException);
            this.markManagedConnectionAsStale(jMSException);
            throw jMSException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientID", string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ExceptionListener getExceptionListener() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExceptionListener");
        }
        ExceptionListener exceptionListener = null;
        String string = this.lockGetExceptionListener;
        synchronized (string) {
            try {
                this.checkOpen();
                this.checkValid();
                exceptionListener = this.managedConnection.getExceptionListener();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSConnectionHandle.getExceptionListener", "250", this);
                JMSCMUtils.trace(tc, "getExceptionListener", jMSException);
                throw jMSException;
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getExceptionListener", exceptionListener);
                }
            }
        }
        return exceptionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ConnectionMetaData getMetaData() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getMetaData");
        }
        ConnectionMetaData connectionMetaData = null;
        JMSException jMSException = null;
        try {
            String string = this.lockGetMetaData;
            synchronized (string) {
                this.checkOpen();
                this.checkValid();
                try {
                    connectionMetaData = this.connection.getMetaData();
                }
                catch (JMSException jMSException2) {
                    jMSException = jMSException2;
                    throw jMSException2;
                }
            }
        }
        catch (JMSException jMSException3) {
            try {
                FFDCFilter.processException((Throwable)jMSException3, "com.ibm.ejs.jms.JMSConnectionHandle.getMetaData", "291", this);
                JMSCMUtils.trace(tc, "getMetaData", jMSException3);
                if (jMSException != null) {
                    this.markManagedConnectionAsStale(jMSException);
                }
                throw jMSException3;
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMetaData", connectionMetaData);
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getMetaData", connectionMetaData);
        }
        return connectionMetaData;
    }

    public final List getTemporaryQueues() {
        return this.temporaryQueues;
    }

    public final List getTemporaryTopics() {
        return this.temporaryTopics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "close");
        }
        JMSException jMSException = null;
        try {
            String string = this.lockClose;
            synchronized (string) {
                if (!this.invalid) {
                    if (!this.openSessionHandles.isEmpty()) {
                        ArrayList arrayList = new ArrayList(this.openSessionHandles);
                        Iterator iterator = arrayList.iterator();
                        while (iterator.hasNext()) {
                            Session session = (Session)iterator.next();
                            try {
                                session.close();
                            }
                            catch (JMSException jMSException2) {
                                jMSException = jMSException2;
                                throw jMSException2;
                            }
                        }
                    }
                    try {
                        this.deleteTemporaryDestinations();
                    }
                    catch (JMSException jMSException3) {
                        jMSException = jMSException3;
                        throw jMSException3;
                    }
                    if (!this.closed) {
                        this.closed = true;
                        if (this.managedConnection != null) {
                            this.managedConnection.handleClosed(this);
                            this.managedConnection = null;
                            this.connection = null;
                        }
                    }
                }
            }
        }
        catch (JMSException jMSException4) {
            FFDCFilter.processException((Throwable)jMSException4, "com.ibm.ejs.jms.JMSConnectionHandle.close", "345", this);
            JMSCMUtils.trace(tc, "close", jMSException4);
            if (jMSException != null) {
                this.markManagedConnectionAsStale(jMSException);
            }
            throw jMSException4;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "close");
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JMSConnectionHandle jMSConnectionHandle = (JMSConnectionHandle)object;
        if (this.closed != jMSConnectionHandle.closed) {
            return false;
        }
        if (this.invalid != jMSConnectionHandle.invalid) {
            return false;
        }
        if (this.restrictedMethodsEnabled != jMSConnectionHandle.restrictedMethodsEnabled) {
            return false;
        }
        return JMSCMUtils.objectsEqual(this.managedConnection, jMSConnectionHandle.managedConnection);
    }

    public int hashCode() {
        return JMSCMUtils.objectHashCode(this.managedConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        JMSException jMSException = null;
        try {
            String string = this.lockStart;
            synchronized (string) {
                this.checkOpen();
                this.checkValid();
                try {
                    this.connection.start();
                }
                catch (JMSException jMSException2) {
                    jMSException = jMSException2;
                    throw jMSException2;
                }
            }
        }
        catch (JMSException jMSException3) {
            FFDCFilter.processException((Throwable)jMSException3, "com.ibm.ejs.jms.JMSConnectionHandle.start", "438", this);
            JMSCMUtils.trace(tc, "start", jMSException3);
            if (jMSException != null) {
                this.markManagedConnectionAsStale(jMSException);
            }
            throw jMSException3;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "start");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        JMSException jMSException = null;
        try {
            String string = this.lockStop;
            synchronized (string) {
                this.checkRestrictedMethod("stop");
                this.checkOpen();
                this.checkValid();
                try {
                    this.connection.stop();
                }
                catch (JMSException jMSException2) {
                    jMSException = jMSException2;
                    throw jMSException2;
                }
            }
        }
        catch (JMSException jMSException3) {
            FFDCFilter.processException((Throwable)jMSException3, "com.ibm.ejs.jms.JMSConnectionHandle.stop", "477", this);
            JMSCMUtils.trace(tc, "stop", jMSException3);
            if (jMSException != null) {
                this.markManagedConnectionAsStale(jMSException);
            }
            throw jMSException3;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "stop");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(JMSCMUtils.objectToString(this));
        stringBuffer.append(string + "managed connection = " + JMSCMUtils.objectToString(this.managedConnection));
        stringBuffer.append(string + "physical connection = " + this.connection);
        stringBuffer.append(string + "closed = " + this.closed);
        stringBuffer.append(string + "invalid = " + this.invalid);
        stringBuffer.append(string + "restricted methods enabled = " + this.restrictedMethodsEnabled);
        stringBuffer.append(string + "open session handles = [");
        List list = this.openSessionHandles;
        synchronized (list) {
            Iterator iterator = this.openSessionHandles.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(JMSCMUtils.objectToString(iterator.next()));
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected final void checkOpen() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("Connection closed");
        }
    }

    protected final void checkRestrictedMethod(String string) throws JMSException {
        if (!this.restrictedMethodsEnabled) {
            throw JMSCMUtils.methodNotPermittedException(tc, string);
        }
    }

    protected final void checkValid() throws IllegalStateException {
        if (this.invalid) {
            throw new IllegalStateException("Connection invalidated");
        }
    }

    final void setManagedConnection(JMSManagedConnection jMSManagedConnection) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setManagedConnection", jMSManagedConnection);
        }
        this.managedConnection = jMSManagedConnection;
        this.connection = jMSManagedConnection.getPhysicalConnection();
        this.factory.setManagedConnection(jMSManagedConnection);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setManagedConnection");
        }
    }

    final JMSManagedConnection getManagedConnection() {
        return this.managedConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void markManagedConnectionAsStale(JMSException jMSException) {
        boolean bl = false;
        String string = this.lockCallConnectionErrorOccurredOnce;
        synchronized (string) {
            if (!this.isMarkManagedConnectionAsStaleAlreadyCalled) {
                bl = true;
                this.isMarkManagedConnectionAsStaleAlreadyCalled = true;
            }
        }
        if (bl) {
            string = this.lockMarkStale;
            synchronized (string) {
                if (this.managedConnection != null) {
                    this.managedConnection.connectionErrorOccurred((Exception)((Object)jMSException));
                }
            }
        }
    }

    final boolean getRestrictedMethodsEnabled() {
        return this.restrictedMethodsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void invalidate() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invalidate");
        }
        if (!this.invalid) {
            if (++this.iterationIdx < this.methodSyncList.size()) {
                Object e2 = this.methodSyncList.get(this.iterationIdx);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempt to obtain lock for method " + e2.toString());
                }
                Object e3 = e2;
                synchronized (e3) {
                    this.invalidate();
                }
            }
            if (!this.invalid) {
                this.canInvalidateNow = true;
            }
            if (this.canInvalidateNow) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "All locks acquired, invalidating ConnectionHandle");
                }
                this.invalid = true;
                this.managedConnection = null;
                this.connection = null;
                this.canInvalidateNow = false;
                this.iterationIdx = -1;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invalidate");
        }
    }

    final void addSessionHandle(JMSSessionHandle jMSSessionHandle) {
        this.openSessionHandles.add(jMSSessionHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeSessionHandle(JMSSessionHandle jMSSessionHandle) {
        List list = this.openSessionHandles;
        synchronized (list) {
            for (int i = 0; i < this.openSessionHandles.size(); ++i) {
                JMSSessionHandle jMSSessionHandle2 = (JMSSessionHandle)this.openSessionHandles.get(i);
                if (jMSSessionHandle != jMSSessionHandle2) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found sessionhandle to remove, compared: " + jMSSessionHandle + " with this: " + jMSSessionHandle2);
                }
                this.openSessionHandles.remove(i);
                break;
            }
        }
    }

    final void setConnectionFactoryHandle(JMSConnectionFactoryHandle jMSConnectionFactoryHandle) {
        this.restrictedMethodsEnabled = jMSConnectionFactoryHandle.getRestrictedMethodsEnabled();
    }

    final JMSManagedSessionFactory getManagedSessionFactory() {
        return this.factory;
    }

    final ConnectionManager getSessionManager() {
        return this.sessionManager;
    }

    final void addTemporaryQueue(TemporaryQueue temporaryQueue) {
        this.temporaryQueues.add(temporaryQueue);
    }

    final void addTemporaryTopic(TemporaryTopic temporaryTopic) {
        this.temporaryTopics.add(temporaryTopic);
    }

    void deleteTemporaryDestinations() throws JMSException {
        this.deleteTemporaryQueues();
        this.deleteTemporaryTopics();
    }

    private void deleteTemporaryQueues() throws JMSException {
        Iterator iterator = this.temporaryQueues.iterator();
        while (iterator.hasNext()) {
            TemporaryQueue temporaryQueue = (TemporaryQueue)iterator.next();
            try {
                temporaryQueue.delete();
            }
            catch (JMSException jMSException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "JMSException deleting temporary queue", (Object)jMSException);
                }
                if (jMSException.getMessage().indexOf("MQJMS3001:") == -1) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSConnectionHandle.deleteTemporaryQueues", "843", this);
                    throw jMSException;
                }
                if (!tc.isEventEnabled()) continue;
                Tr.event(tc, "Trying to delete a temporary queue that does not exist - ignoring exception");
            }
        }
        this.temporaryQueues.clear();
    }

    private void deleteTemporaryTopics() throws JMSException {
        Iterator iterator = this.temporaryTopics.iterator();
        while (iterator.hasNext()) {
            TemporaryTopic temporaryTopic = (TemporaryTopic)iterator.next();
            try {
                temporaryTopic.delete();
            }
            catch (JMSException jMSException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "JMSException deleting temporary topic", (Object)jMSException);
                }
                if (jMSException.getMessage().indexOf("MQJMS3001:") == -1) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSConnectionHandle.deleteTemporaryTopics", "866", this);
                    throw jMSException;
                }
                if (!tc.isEventEnabled()) continue;
                Tr.event(tc, "Trying to delete a temporary topic that does not exist - ignoring exception");
            }
        }
        this.temporaryTopics.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionConsumer createConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createConnectionConsumer", new Object[]{destination, string, serverSessionPool, new Integer(n)});
        }
        ConnectionConsumer connectionConsumer = null;
        JMSException jMSException = null;
        try {
            String string2 = this.lockCreateConnectionConsumer;
            synchronized (string2) {
                this.checkRestrictedMethod("createConnectionConsumer");
                this.checkOpen();
                this.checkValid();
                Connection connection = this.connection;
                try {
                    connectionConsumer = connection.createConnectionConsumer(destination, string, serverSessionPool, n);
                }
                catch (InvalidDestinationException invalidDestinationException) {
                    throw invalidDestinationException;
                }
                catch (InvalidSelectorException invalidSelectorException) {
                    throw invalidSelectorException;
                }
                catch (JMSException jMSException2) {
                    jMSException = jMSException2;
                    throw jMSException2;
                }
            }
        }
        catch (JMSException jMSException3) {
            try {
                FFDCFilter.processException((Throwable)jMSException3, "com.ibm.ejs.jms.JMSConnectionHandle.createConnectionConsumer", "929", this);
                JMSCMUtils.trace(tc, "createConnectionConsumer", jMSException3);
                if (jMSException != null) {
                    this.markManagedConnectionAsStale(jMSException);
                }
                throw jMSException3;
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "createConnectionConsumer", connectionConsumer);
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createConnectionConsumer", connectionConsumer);
        }
        return connectionConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createDurableConnectionConsumer", new Object[]{topic, string, string2, serverSessionPool, new Integer(n)});
        }
        ConnectionConsumer connectionConsumer = null;
        JMSException jMSException = null;
        try {
            String string3 = this.lockCreateDurableConnectionConsumer;
            synchronized (string3) {
                this.checkRestrictedMethod("createDurableConnectionConsumer");
                this.checkOpen();
                this.checkValid();
                try {
                    connectionConsumer = this.connection.createDurableConnectionConsumer(topic, string, string2, serverSessionPool, n);
                }
                catch (InvalidDestinationException invalidDestinationException) {
                    throw invalidDestinationException;
                }
                catch (InvalidSelectorException invalidSelectorException) {
                    throw invalidSelectorException;
                }
                catch (JMSException jMSException2) {
                    jMSException = jMSException2;
                    throw jMSException2;
                }
            }
        }
        catch (JMSException jMSException3) {
            try {
                FFDCFilter.processException((Throwable)jMSException3, "com.ibm.ejs.jms.JMSConnectionHandle.createDurableConnectionConsumer", "1000", this);
                JMSCMUtils.trace(tc, "createDurableConnectionConsumer", jMSException3);
                if (jMSException != null) {
                    this.markManagedConnectionAsStale(jMSException);
                }
                throw jMSException3;
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "createDurableConnectionConsumer", connectionConsumer);
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createDurableConnectionConsumer", connectionConsumer);
        }
        return connectionConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Session createSession(boolean bl, int n) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createSession", new Object[]{bl, new Integer(n)});
        }
        JMSSessionHandle jMSSessionHandle = null;
        try {
            String string = this.lockCreateSession;
            synchronized (string) {
                this.checkOpen();
                this.checkValid();
                JMSSessionRequestInfo jMSSessionRequestInfo = new JMSSessionRequestInfo(bl, n);
                jMSSessionHandle = (JMSSessionHandle)this.sessionManager.allocateConnection((ManagedConnectionFactory)this.factory, (ConnectionRequestInfo)jMSSessionRequestInfo);
                jMSSessionHandle.setConnectionHandle(this);
            }
        }
        catch (JMSException jMSException) {
            try {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSConnectionHandle.createSession", "1044", this);
                JMSCMUtils.trace(tc, "createSession", jMSException);
                throw jMSException;
                catch (ResourceException resourceException) {
                    FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSConnectionHandle.createSession", "1051", this);
                    if (!(resourceException.getCause() instanceof JMSException)) throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create session");
                    this.markManagedConnectionAsStale((JMSException)resourceException.getCause());
                    throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create session");
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "createSession", jMSSessionHandle);
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return jMSSessionHandle;
        if (!tc.isEntryEnabled()) return jMSSessionHandle;
        Tr.exit(tc, "createSession", jMSSessionHandle);
        return jMSSessionHandle;
    }

    public Session createListenerSession(int n, boolean bl) throws JMSException {
        return this.createListenerSession(n, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Session createListenerSession(int n, boolean bl, boolean bl2) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createListenerSession", new Object[]{new Integer(n), bl, bl2});
        }
        JMSSessionHandle jMSSessionHandle = null;
        try {
            String string = this.lockCreateListenerSession;
            synchronized (string) {
                this.checkOpen();
                this.checkValid();
                JMSListenerSessionRequestInfo jMSListenerSessionRequestInfo = new JMSListenerSessionRequestInfo(n, bl, bl2);
                jMSSessionHandle = (JMSSessionHandle)this.sessionManager.allocateConnection((ManagedConnectionFactory)this.factory, (ConnectionRequestInfo)jMSListenerSessionRequestInfo);
                jMSSessionHandle.setConnectionHandle(this);
            }
        }
        catch (JMSException jMSException) {
            try {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSConnectionHandle.createListenerQueueSession", "1052", this);
                JMSCMUtils.trace(tc, "createListenerSession", jMSException);
                throw jMSException;
                catch (ResourceException resourceException) {
                    FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSQueueConnectionHandle.createListenerQueueSession", "1053", this);
                    if (!(resourceException.getCause() instanceof JMSException)) throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create queue session");
                    this.markManagedConnectionAsStale((JMSException)resourceException.getCause());
                    throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create queue session");
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "createListenerQueueSession", jMSSessionHandle);
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return jMSSessionHandle;
        if (!tc.isEntryEnabled()) return jMSSessionHandle;
        Tr.exit(tc, "createListenerQueueSession", jMSSessionHandle);
        return jMSSessionHandle;
    }
}

