/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.security.PasswordCredential;

public final class JMSConnectionRequestInfo
implements ConnectionRequestInfo,
FFDCSelfIntrospectable {
    private static final TraceComponent tc = Tr.register(JMSConnectionRequestInfo.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private PasswordCredential credential = null;
    private boolean sessionSharing;
    private Boolean unified = Boolean.FALSE;
    private boolean allowsNonTransactedSessionsInTran;

    public JMSConnectionRequestInfo(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSConnectionRequestInfo", new Boolean(bl));
        }
        this.sessionSharing = bl;
        this.allowsNonTransactedSessionsInTran = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JMSConnectionRequestInfo");
        }
    }

    public JMSConnectionRequestInfo(boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSConnectionRequestInfo", new Object[]{new Boolean(bl), new Boolean(bl2)});
        }
        this.sessionSharing = bl;
        this.allowsNonTransactedSessionsInTran = false;
        this.unified = new Boolean(bl2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JMSConnectionRequestInfo");
        }
    }

    public JMSConnectionRequestInfo(String string, String string2, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSConnectionRequestInfo", new Object[]{string, "password not traced", new Boolean(bl)});
        }
        char[] cArray = string2 == null ? null : string2.toCharArray();
        this.credential = new PasswordCredential(string, cArray);
        this.sessionSharing = bl;
        this.allowsNonTransactedSessionsInTran = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JMSConnectionRequestInfo");
        }
    }

    public JMSConnectionRequestInfo(String string, String string2, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSConnectionRequestInfo", new Object[]{string, "password not traced", new Boolean(bl), new Boolean(bl2)});
        }
        char[] cArray = string2 == null ? null : string2.toCharArray();
        this.credential = new PasswordCredential(string, cArray);
        this.sessionSharing = bl;
        this.unified = new Boolean(bl2);
        this.allowsNonTransactedSessionsInTran = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JMSConnectionRequestInfo");
        }
    }

    public String[] introspectSelf() {
        String[] stringArray = new String[4];
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer();
        stringArray[0] = JMSCMUtils.objectToString(this);
        stringArray[1] = string + "tc = " + tc;
        if (this.credential == null) {
            stringArray[2] = string + "credential = null";
        } else {
            stringBuffer.append(string + "credential = ");
            stringBuffer.append(string + string + "UserName = " + this.credential.getUserName());
            stringBuffer.append(string + string + "Password not dumped");
            stringArray[2] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        stringArray[3] = string + "sessionSharing = " + this.sessionSharing;
        return stringArray;
    }

    public final PasswordCredential getPasswordCredential() {
        return this.credential;
    }

    public final boolean getSessionSharing() {
        return this.sessionSharing;
    }

    public final Boolean getUnified() {
        return this.unified;
    }

    public boolean getAllowsNonTransactedSessionsInTran() {
        return this.allowsNonTransactedSessionsInTran;
    }

    public void setAllowsNonTransactedSessionsInTran(boolean bl) {
        this.allowsNonTransactedSessionsInTran = bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JMSConnectionRequestInfo jMSConnectionRequestInfo = (JMSConnectionRequestInfo)object;
        if (!JMSCMUtils.objectsEqual(this.credential, jMSConnectionRequestInfo.credential)) {
            return false;
        }
        if (this.sessionSharing != jMSConnectionRequestInfo.sessionSharing) {
            return false;
        }
        return this.unified == jMSConnectionRequestInfo.unified;
    }

    public int hashCode() {
        int n = this.sessionSharing ? -1 : 1;
        n += this.unified != false ? -10 : 10;
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.credential);
        return n;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(JMSCMUtils.objectToString(this));
        stringBuffer.append(string + "credential = " + this.credential);
        stringBuffer.append(string + "session sharing = " + this.sessionSharing);
        stringBuffer.append(string + "nonTransactedInTran = " + this.allowsNonTransactedSessionsInTran);
        stringBuffer.append(string + "unified = " + this.unified);
        return stringBuffer.toString();
    }
}

