/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;

public final class JMSDefaultConnectionManager
implements ConnectionManager {
    private static final long serialVersionUID = 6051450020216644130L;
    private static final TraceComponent tc = Tr.register(JMSDefaultConnectionManager.class, "Messaging", JMSCMUtils.MSG_BUNDLE);

    public Object allocateConnection(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "allocateConnection", new Object[]{managedConnectionFactory, connectionRequestInfo});
        }
        Object object = null;
        try {
            ManagedConnection managedConnection = managedConnectionFactory.createManagedConnection(null, connectionRequestInfo);
            new ConnectionEventHandler(managedConnection);
            object = managedConnection.getConnection(null, connectionRequestInfo);
        }
        catch (ResourceException resourceException) {
            try {
                FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSDefaultConnectionManager.allocateConnection", "73", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Caught ResourceException when attempting to create managed connection:", (Object)resourceException);
                }
                throw resourceException;
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "allocateConnection", object);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "allocateConnection", object);
        }
        return object;
    }

    private class ConnectionEventHandler
    implements ConnectionEventListener {
        private ManagedConnection managedConnection;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConnectionEventHandler(ManagedConnection managedConnection) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ConnectionEventHandler", managedConnection);
            }
            try {
                this.managedConnection = managedConnection;
                this.managedConnection.addConnectionEventListener((ConnectionEventListener)this);
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "ConnectionEventHandler");
                }
            }
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "connectionClosed", connectionEvent);
            }
            this.destroyManagedConnection();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "connectionClosed");
            }
        }

        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "connectionErrorOccurred", connectionEvent);
            }
            this.destroyManagedConnection();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "connectionErrorOccurred");
            }
        }

        public void localTransactionCommitted(ConnectionEvent connectionEvent) {
        }

        public void localTransactionRolledback(ConnectionEvent connectionEvent) {
        }

        public void localTransactionStarted(ConnectionEvent connectionEvent) {
        }

        protected void destroyManagedConnection() {
            block2: {
                this.managedConnection.removeConnectionEventListener((ConnectionEventListener)this);
                try {
                    this.managedConnection.destroy();
                    this.managedConnection = null;
                }
                catch (ResourceException resourceException) {
                    FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSDefaultConnectionManager.destroyManagedConnection", "214", this);
                    if (!tc.isEventEnabled()) break block2;
                    Tr.event(tc, "Caught ResourceException when attempting to destroy managed connection:", (Object)resourceException);
                }
            }
        }
    }
}

