/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.DiagnosticModule;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.ffdc.IncidentStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.jms.JMSException;

public final class JMSDiagnosticModule
extends DiagnosticModule {
    private static final TraceComponent tc = Tr.register(JMSDiagnosticModule.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    public static JMSDiagnosticModule instance;

    public static void register() {
        if (instance == null) {
            instance = new JMSDiagnosticModule();
            int n = FFDC.registerDiagnosticModule(instance, "com.ibm.ejs.jms");
            if (tc.isEventEnabled()) {
                if (n != 0) {
                    Tr.event(tc, "Register of JMS diagnostic module failed with return code " + n);
                } else {
                    Tr.event(tc, "Registered JMS diagnostic module");
                }
            }
        }
    }

    private JMSDiagnosticModule() {
    }

    public void ffdcDumpDefaultDefault(Throwable throwable, IncidentStream incidentStream, Object object, Object[] objectArray, String string) {
        JMSException jMSException;
        Exception exception;
        incidentStream.introspectAndWriteLine("Dump of callerThis", object, 2);
        if (throwable instanceof JMSException && (exception = (jMSException = (JMSException)throwable).getLinkedException()) != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(byteArrayOutputStream);
                exception.printStackTrace(printStream);
                incidentStream.writeLine("Linked exception", byteArrayOutputStream.toString());
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }
}

