/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSSessionRequestInfo;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;

final class JMSListenerSessionRequestInfo
extends JMSSessionRequestInfo {
    private static TraceComponent tc = Tr.register(JMSListenerSessionRequestInfo.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private final boolean transactional;
    private final boolean localTransRequired;

    JMSListenerSessionRequestInfo(int n, boolean bl, boolean bl2) {
        super(false, n);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSListenerSessionRequestInfo", new Object[]{new Integer(n), bl, bl2});
        }
        this.transactional = bl || bl2;
        this.localTransRequired = bl2;
        if (bl2 && bl) {
            bl2 = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Both localTransRequired and globalTransRequired were specified. Ignoring localTransRequired.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JMSListenerSessionRequestInfo");
        }
    }

    final boolean getTransactional() {
        return this.transactional;
    }

    final boolean getLocalTransactionRequired() {
        return this.localTransRequired;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        JMSListenerSessionRequestInfo jMSListenerSessionRequestInfo = (JMSListenerSessionRequestInfo)object;
        return this.transactional == jMSListenerSessionRequestInfo.transactional;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = n * JMSCMUtils.HASH_CODE_PRIME + (this.transactional ? -1 : 1);
        return n;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(string + "transactional = " + this.transactional);
        stringBuffer.append(string + "localTransRequired = " + this.localTransRequired);
        return stringBuffer.toString();
    }
}

