/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.j2c.ConnectionFactoryBuilder;
import com.ibm.ejs.j2c.ConnectionFactoryBuilderFactory;
import com.ibm.ejs.j2c.ConnectorProperties;
import com.ibm.ejs.j2c.ConnectorProperty;
import com.ibm.ejs.jms.GenericJMSManagedConnectionFactory;
import com.ibm.ejs.jms.GenericJMSManagedQueueConnectionFactory;
import com.ibm.ejs.jms.GenericJMSManagedTopicConnectionFactory;
import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSConnectionHandle;
import com.ibm.ejs.jms.JMSConnectionRequestInfo;
import com.ibm.ejs.jms.JMSManagedConnectionFactory;
import com.ibm.ejs.jms.JMSManagedSessionFactory;
import com.ibm.ejs.jms.JMSResourceRefBuilderFactory;
import com.ibm.ejs.jms.WSJMSManagedConnectionFactory;
import com.ibm.ejs.jms.WSJMSManagedQueueConnectionFactory;
import com.ibm.ejs.jms.WSJMSManagedTopicConnectionFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.security.util.PasswordUtil;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.XAConnectionFactory;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.eclipse.jst.j2ee.jca.TransactionSupportKind;

class JMSManagedConnection
implements ManagedConnection,
ExceptionListener,
FFDCSelfIntrospectable {
    private static final TraceComponent tc = Tr.register(JMSManagedConnection.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    static final String RRS_TRANSACTIONAL = "RRSTransactional";
    private HashSet connEventListenerSet = new HashSet();
    private final Set connectionEventListeners = Collections.synchronizedSet(this.connEventListenerSet);
    private Set copyOfConnectionEventListeners = new HashSet();
    private ExceptionListener exceptionListener = null;
    private ExceptionListener connectionExceptionListener = null;
    private JMSException jmsException = null;
    private HashSet connHandlesSet = new HashSet();
    private final Set openConnectionHandles = Collections.synchronizedSet(this.connHandlesSet);
    private final Connection connection;
    private PrintWriter logWriter;
    protected boolean xaCapable;
    private final PasswordCredential credential;
    private final ConnectionFactory connectionFactory;
    private final JMSManagedConnectionFactory managedConnectionFactory;
    private Subject subject;
    private final Set sessionSharingScopes = new HashSet();
    private boolean allowsNonTransactedSessionsInTran = false;
    private static final String MANAGED_SESSION_FACTORY_CLASS_NAME = JMSManagedSessionFactory.class.getName();
    private Properties _properties = null;
    private Properties _dsProperties = null;
    private ConnectorProperties _connectorProperties = null;
    private final Object onExceptionSem = new Object();
    private boolean alreadyProcessedException = false;
    private Boolean unifiedConnection;
    private int _hashCode = 0;
    private final String _connectorName;
    private static long _connectorNameUID = 0L;
    private static final Object _connectorNameUIDLock = new ConnectorNameLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JMSManagedConnection(JMSManagedConnectionFactory jMSManagedConnectionFactory, PasswordCredential passwordCredential, boolean bl, Boolean bl2) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSManagedConnection", new Object[]{jMSManagedConnectionFactory, passwordCredential, new Boolean(bl), bl2});
        }
        try {
            this.credential = passwordCredential;
            this.logWriter = jMSManagedConnectionFactory.getLogWriter();
            this.connectionFactory = jMSManagedConnectionFactory.getConnectionFactory(bl);
            this.managedConnectionFactory = jMSManagedConnectionFactory;
            this.allowsNonTransactedSessionsInTran = bl;
            this.unifiedConnection = bl2;
            if (passwordCredential == null || this.managedConnectionFactory.getServerRecoveryNoCredentials()) {
                this.connection = this.createConnection(this.connectionFactory);
            } else {
                String string = passwordCredential.getUserName();
                String string2 = new String(passwordCredential.getPassword());
                this.connection = this.createConnection(this.connectionFactory, string, string2);
            }
            this.connection.setExceptionListener((ExceptionListener)this);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedConnection.JMSManagedConnection", "168", this);
            throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), tc, "Failed to create connection");
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSManagedConnection.JMSManagedConnection", "173", this);
            Tr.event(tc, "Caught ResourceException when attempting to create physical connection factory:", (Object)resourceException);
            throw resourceException;
        }
        finally {
            this._hashCode = this._hashCode();
            Object object = _connectorNameUIDLock;
            synchronized (object) {
                this._connectorName = this.managedConnectionFactory.getConnectorName() + "$JMSManagedConnection@" + System.identityHashCode(this) + "@" + _connectorNameUID++;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "JMSManagedConnection");
            }
        }
    }

    public String[] introspectSelf() {
        String[] stringArray = new String[11];
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer();
        stringArray[0] = JMSCMUtils.objectToString(this);
        stringArray[1] = string + "tc = " + tc;
        stringArray[2] = string + "exceptionListener = " + this.exceptionListener;
        stringArray[3] = string + "connection = " + this.connection;
        stringArray[4] = string + "logWriter = " + this.logWriter;
        stringArray[5] = string + "xaCapable = " + this.xaCapable;
        if (this.credential == null) {
            stringArray[6] = string + "credential = null";
        } else {
            stringBuffer.append(string + "credential = ");
            stringBuffer.append(string + string + "UserName = " + this.credential.getUserName());
            stringBuffer.append(string + string + "Password not dumped");
            stringArray[6] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        stringArray[7] = string + "connectionFactory = " + this.connectionFactory;
        if (this.managedConnectionFactory == null) {
            stringArray[8] = string + "managedConnectionFactory = null";
        } else {
            String[] stringArray2 = this.managedConnectionFactory.introspectSelf();
            stringBuffer.append(string + "managedConnectionFactory = ");
            for (int i = 0; i < stringArray2.length; ++i) {
                stringBuffer.append(string + stringArray2[i]);
            }
            stringArray[8] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        stringArray[9] = string + "sessionSharingScopes = " + this.sessionSharingScopes;
        stringArray[10] = string + "connectorName = " + this._connectorName;
        return stringArray;
    }

    public final void setLogWriter(PrintWriter printWriter) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Log writer set", printWriter);
        }
        this.logWriter = printWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnection", new Object[]{JMSCMUtils.subjectToString(subject), connectionRequestInfo});
        }
        JMSConnectionHandle jMSConnectionHandle = null;
        try {
            Object object;
            Object object2;
            if (this._properties == null) {
                String string;
                this._connectorProperties = new ConnectorProperties();
                object2 = new ConnectorProperty("TransactionResourceRegistration", String.class.getName(), "dynamic");
                this._connectorProperties.add(object2);
                ConnectorProperty connectorProperty = new ConnectorProperty("InactiveConnectionSupport", Boolean.class.getName(), Boolean.TRUE.toString());
                this._connectorProperties.add(connectorProperty);
                Properties properties = this.getMCFProperties(this._connectorProperties);
                this._dsProperties = (Properties)properties.clone();
                if (this.managedConnectionFactory instanceof WSJMSManagedConnectionFactory && ((WSJMSManagedConnectionFactory)this.managedConnectionFactory).getRRSEnabledSessions() == Boolean.TRUE) {
                    string = this.allowsNonTransactedSessionsInTran ? "false" : "true";
                    this._dsProperties.setProperty(RRS_TRANSACTIONAL, string);
                }
                if (this.managedConnectionFactory.getNondeferredreaper()) {
                    this._dsProperties.setProperty("nondeferredreaper", "true");
                }
                this._properties = new Properties();
                string = this.xaCapable ? TransactionSupportKind.XA_TRANSACTION_LITERAL.getName() : TransactionSupportKind.LOCAL_TRANSACTION_LITERAL.getName();
                this._properties.setProperty("transactionSupport", string);
                this._properties.setProperty("name", this._connectorName);
                object = this.getManagedSessionFactoryClassName();
                this._properties.setProperty("managedConnectionFactoryClass", (String)object);
                this._properties.putAll((Map<?, ?>)this.managedConnectionFactory.getSessionPoolProperties());
            }
            object2 = (JMSConnectionRequestInfo)connectionRequestInfo;
            int n = 1;
            if (((JMSConnectionRequestInfo)object2).getSessionSharing()) {
                n = this.managedConnectionFactory.getSessionSharingScope();
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Assuming MDBs are being used - sharingScope defaulting to ResRef.UNSHAREABLE");
            }
            object = ConnectionFactoryBuilderFactory.create();
            jMSConnectionHandle = (JMSConnectionHandle)object.getConnectionFactory(this._properties, this._dsProperties, this._connectorProperties, n, 0, 1);
            this.sessionSharingScopes.add(new Integer(n));
            jMSConnectionHandle.setManagedConnection(this);
            Set set = this.openConnectionHandles;
            synchronized (set) {
                this.openConnectionHandles.add(jMSConnectionHandle);
            }
        }
        catch (Exception exception) {
            try {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.JMSManagedConnection.getConnection", "274", this);
                ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("Failed to create JMSManagedSessionFactory");
                resourceAdapterInternalException.setLinkedException(exception);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to create JMSManagedSessionFactory", exception);
                }
                throw resourceAdapterInternalException;
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getConnection", jMSConnectionHandle);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnection", jMSConnectionHandle);
        }
        return jMSConnectionHandle;
    }

    public final Properties getMCFProperties(ConnectorProperties connectorProperties) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMCFProperties", connectorProperties);
        }
        boolean bl = true;
        Properties properties = null;
        if (this.managedConnectionFactory instanceof WSJMSManagedQueueConnectionFactory) {
            connectorProperties.add(new ConnectorProperty("mcfClassname", String.class.getName(), "com.ibm.ejs.jms.WSJMSManagedQueueConnectionFactory"));
            properties = ((WSJMSManagedQueueConnectionFactory)this.managedConnectionFactory).getDataSourceProperties();
            bl = true;
        }
        if (this.managedConnectionFactory instanceof WSJMSManagedTopicConnectionFactory) {
            connectorProperties.add(new ConnectorProperty("mcfClassname", String.class.getName(), "com.ibm.ejs.jms.WSJMSManagedTopicConnectionFactory"));
            properties = ((WSJMSManagedTopicConnectionFactory)this.managedConnectionFactory).getDataSourceProperties();
            bl = true;
        }
        if (this.managedConnectionFactory instanceof WSJMSManagedConnectionFactory) {
            connectorProperties.add(new ConnectorProperty("mcfClassname", String.class.getName(), "com.ibm.ejs.jms.WSJMSManagedConnectionFactory"));
            properties = ((WSJMSManagedConnectionFactory)this.managedConnectionFactory).getDataSourceProperties();
            bl = true;
        }
        if (this.managedConnectionFactory instanceof GenericJMSManagedQueueConnectionFactory) {
            connectorProperties.add(new ConnectorProperty("mcfClassname", String.class.getName(), "com.ibm.ejs.jms.GenericJMSManagedQueueConnectionFactory"));
            properties = ((GenericJMSManagedQueueConnectionFactory)this.managedConnectionFactory).getDataSourceProperties();
            bl = false;
        }
        if (this.managedConnectionFactory instanceof GenericJMSManagedTopicConnectionFactory) {
            connectorProperties.add(new ConnectorProperty("mcfClassname", String.class.getName(), "com.ibm.ejs.jms.GenericJMSManagedTopicConnectionFactory"));
            properties = ((GenericJMSManagedTopicConnectionFactory)this.managedConnectionFactory).getDataSourceProperties();
            bl = false;
        }
        if (this.managedConnectionFactory instanceof GenericJMSManagedConnectionFactory) {
            connectorProperties.add(new ConnectorProperty("mcfClassname", String.class.getName(), "com.ibm.ejs.jms.GenericJMSManagedConnectionFactory"));
            properties = ((GenericJMSManagedConnectionFactory)this.managedConnectionFactory).getDataSourceProperties();
            bl = false;
        }
        if (this.credential != null) {
            connectorProperties.add(new ConnectorProperty("mcfUserName", String.class.getName(), this.credential.getUserName()));
            if (this.credential.getPassword() != null) {
                String string = null;
                try {
                    string = PasswordUtil.encode(String.valueOf(this.credential.getPassword()));
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.JMSManagedConnection.getMCFProperties", "373", this);
                    ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("Failed to encode MCF password");
                    resourceAdapterInternalException.setLinkedException(exception);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to encode MCF password", resourceAdapterInternalException);
                    }
                    throw resourceAdapterInternalException;
                }
                connectorProperties.add(new ConnectorProperty("mcfPassword", String.class.getName(), string));
            }
        }
        connectorProperties.add(new ConnectorProperty("mcfConnectorName", String.class.getName(), this.managedConnectionFactory.getConnectorName()));
        if (bl) {
            connectorProperties.add(new ConnectorProperty("mcfObjectType", Integer.class.getName(), String.valueOf(((WSJMSManagedConnectionFactory)this.managedConnectionFactory).getObjectType())));
        } else {
            connectorProperties.add(new ConnectorProperty("mcfProviderURL", String.class.getName(), ((GenericJMSManagedConnectionFactory)this.managedConnectionFactory).getProviderURL()));
            connectorProperties.add(new ConnectorProperty("mcfContextFactoryClassname", String.class.getName(), ((GenericJMSManagedConnectionFactory)this.managedConnectionFactory).getContextFactoryClassname()));
            connectorProperties.add(new ConnectorProperty("mcfJndiPath", String.class.getName(), ((GenericJMSManagedConnectionFactory)this.managedConnectionFactory).getJNDIPath()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMCFProperties", JMSResourceRefBuilderFactory.maskPasswords(properties));
        }
        return properties;
    }

    public final ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public final LocalTransaction getLocalTransaction() throws ResourceException {
        NotSupportedException notSupportedException = new NotSupportedException("Does not support LocalTransaction at connection level");
        if (tc.isEventEnabled()) {
            Tr.event(tc, "Does not support LocalTransaction at connection level", (Object)notSupportedException);
        }
        throw notSupportedException;
    }

    public final PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public final ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new JMSManagedConnectionMetaData();
    }

    public final Subject getSubject() {
        return this.subject;
    }

    public final void setSubject(Subject subject) {
        this.subject = subject;
    }

    public final XAResource getXAResource() throws ResourceException {
        NotSupportedException notSupportedException = new NotSupportedException("Does not support XA resource at connection level");
        if (tc.isEventEnabled()) {
            Tr.event(tc, "Does not support XA resource at connection level", (Object)notSupportedException);
        }
        throw notSupportedException;
    }

    public final void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding connection event listener", connectionEventListener);
        }
        this.connectionEventListeners.add(connectionEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateConnection(Object object) throws ResourceException {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "associateConnection", object);
            }
            try {
                if (object instanceof JMSConnectionHandle) {
                    JMSConnectionHandle jMSConnectionHandle = (JMSConnectionHandle)object;
                    JMSManagedConnection jMSManagedConnection = jMSConnectionHandle.getManagedConnection();
                    Set set = this.openConnectionHandles;
                    synchronized (set) {
                        if (jMSManagedConnection.openConnectionHandles.remove(jMSConnectionHandle)) {
                            this.openConnectionHandles.add(jMSConnectionHandle);
                        }
                    }
                    jMSConnectionHandle.setManagedConnection(this);
                    break block10;
                }
                ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("Can't associate non-JMSConnectionHandle");
                Tr.event(tc, "Can't associate non-JMSConnectionHandle", resourceAdapterInternalException);
                throw resourceAdapterInternalException;
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "associateConnection");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanup() throws ResourceException {
        HashSet hashSet;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup");
        }
        Object object = this.openConnectionHandles;
        synchronized (object) {
            Tr.debug(tc, "Creating a Iterator clone of the openConnectionHandles set");
            hashSet = (HashSet)this.connHandlesSet.clone();
            Tr.debug(tc, "Created an Iterator Clone of the openConnectionHandles set");
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            JMSConnectionHandle jMSConnectionHandle = (JMSConnectionHandle)object.next();
            jMSConnectionHandle.invalidate();
        }
        try {
            if (this.jmsException != null) {
                this.connectionExceptionListener = this.connection.getExceptionListener();
                if (this.connectionExceptionListener != null) {
                    this.connectionExceptionListener.onException(this.jmsException);
                }
            } else {
                this.connection.stop();
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedConnection.cleanup", "466", this);
            throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), tc, "Failed to stop connection on cleanup");
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "cleanup");
            }
        }
    }

    /*
     * Loose catch block
     */
    public final void destroy() throws ResourceException {
        block20: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "destroy");
            }
            this.connection.close();
            Object var3_1 = null;
            try {
                if (!this.sessionSharingScopes.isEmpty()) {
                    Properties properties = new Properties();
                    properties.setProperty("name", this._connectorName);
                    ConnectionFactoryBuilder connectionFactoryBuilder = ConnectionFactoryBuilderFactory.create();
                    Iterator iterator = this.sessionSharingScopes.iterator();
                    while (iterator.hasNext()) {
                        Integer n = (Integer)iterator.next();
                        connectionFactoryBuilder.freeConnectionFactory(properties, n, 0, 1);
                    }
                }
                break block20;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.JMSManagedConnection.destroy", "535", this);
                ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("Failed to free session factories");
                resourceAdapterInternalException.setLinkedException(exception);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to free session factories", resourceAdapterInternalException);
                }
                throw resourceAdapterInternalException;
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "destroy");
                }
            }
            {
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedConnection.destroy", "498", this);
                    throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), tc, "Failed to close connection");
                }
            }
            catch (Throwable throwable) {
                block21: {
                    Object var3_2 = null;
                    try {
                        if (this.sessionSharingScopes.isEmpty()) break block21;
                        Properties properties = new Properties();
                        properties.setProperty("name", this._connectorName);
                        ConnectionFactoryBuilder connectionFactoryBuilder = ConnectionFactoryBuilderFactory.create();
                        Iterator iterator = this.sessionSharingScopes.iterator();
                        while (iterator.hasNext()) {
                            Integer n = (Integer)iterator.next();
                            connectionFactoryBuilder.freeConnectionFactory(properties, n, 0, 1);
                        }
                    }
                    catch (Exception exception) {
                        try {}
                        catch (Throwable throwable2) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "destroy");
                            }
                            throw throwable2;
                        }
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.JMSManagedConnection.destroy", "535", this);
                        ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("Failed to free session factories");
                        resourceAdapterInternalException.setLinkedException(exception);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to free session factories", resourceAdapterInternalException);
                        }
                        throw resourceAdapterInternalException;
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "destroy");
                }
                throw throwable;
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JMSManagedConnection jMSManagedConnection = (JMSManagedConnection)object;
        if (!JMSCMUtils.objectsEqual(this.credential, jMSManagedConnection.credential)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.exceptionListener, jMSManagedConnection.exceptionListener)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.managedConnectionFactory, jMSManagedConnection.managedConnectionFactory)) {
            return false;
        }
        return JMSCMUtils.objectsEqual(this.connection, jMSManagedConnection.connection);
    }

    public int hashCode() {
        return this._hashCode;
    }

    private int _hashCode() {
        int n = JMSCMUtils.objectHashCode(this.credential);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.exceptionListener);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.managedConnectionFactory);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.connection);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        HashSet hashSet;
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(JMSCMUtils.objectToString(this));
        stringBuffer.append(string + "managed connection factory = " + JMSCMUtils.objectToString(this.managedConnectionFactory));
        stringBuffer.append(string + "physical connection = " + this.connection);
        stringBuffer.append(string + "credential = " + this.credential);
        stringBuffer.append(string + "open connection handles = [");
        Object object = this.openConnectionHandles;
        synchronized (object) {
            Tr.debug(tc, "Creating an Iterator clone of the openConnectionHandles set");
            hashSet = (HashSet)this.connHandlesSet.clone();
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            stringBuffer.append(JMSCMUtils.objectToString(object.next()));
            if (!object.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onException(JMSException jMSException) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onException", (Object)jMSException);
        }
        if (!this.alreadyProcessedException) {
            Object object = this.onExceptionSem;
            synchronized (object) {
                Tr.event(tc, "Locked onException semaphore");
                this.alreadyProcessedException = true;
                try {
                    if (this.jmsException == null) {
                        this.connectionErrorOccurred((Exception)((Object)jMSException));
                    }
                    if (this.exceptionListener != null) {
                        try {
                            this.exceptionListener.onException(jMSException);
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ejs.jms.JMSManagedConnection.onException", "631", this);
                            Tr.event(tc, "Ignoring exception thrown by application exception listener", throwable);
                        }
                    }
                    Thread.yield();
                }
                finally {
                    this.alreadyProcessedException = false;
                }
            }
        }
        Tr.event(tc, "We are already currently processing an exception");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void connectionErrorOccurred(Exception exception) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "connectionErrorOccurred", exception);
        }
        if (this.jmsException != null) {
            Tr.debug(tc, "Exception is already being processed. Ignoring the new exception");
        } else {
            if (exception instanceof JMSException) {
                this.jmsException = (JMSException)((Object)exception);
            }
            ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 5, exception);
            Object object = this.connectionEventListeners;
            synchronized (object) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating a copy of the connectionEventListeners set");
                }
                this.copyOfConnectionEventListeners = this.connectionEventListeners;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Copy of the connectionEventListeners set created");
                }
            }
            object = this.copyOfConnectionEventListeners.iterator();
            while (object.hasNext()) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)object.next();
                connectionEventListener.connectionErrorOccurred(connectionEvent);
            }
            this.jmsException = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "connectionErrorOccurred");
        }
    }

    public final void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Remove connection event listener", connectionEventListener);
        }
        this.connectionEventListeners.remove(connectionEventListener);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Connection createConnection(ConnectionFactory connectionFactory) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConnection", connectionFactory);
        }
        Connection connection = null;
        try {
            if (connectionFactory instanceof XAConnectionFactory) {
                this.xaCapable = true;
                XAConnectionFactory xAConnectionFactory = (XAConnectionFactory)connectionFactory;
                connection = xAConnectionFactory.createXAConnection();
            } else {
                this.xaCapable = false;
                ConnectionFactory connectionFactory2 = connectionFactory;
                connection = connectionFactory2.createConnection();
            }
        }
        catch (ClassCastException classCastException) {
            try {
                FFDCFilter.processException((Throwable)classCastException, "com.ibm.ejs.jms.JMSManagedConnection.createConnection", "779", this);
                throw JMSCMUtils.mapToResourceException(classCastException, tc, "Expected ConnectionFactory");
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedConnection.createConnection", "784", this);
                    if (jMSException.getLinkedException() == null) throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), tc, "createConnection failed");
                    FFDCFilter.processException((Throwable)jMSException.getLinkedException(), "com.ibm.ejs.jms.JMSManagedConnection.createConnection", "787", this);
                    throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), tc, "createConnection failed");
                }
            }
            catch (Throwable throwable) {
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "createConnection", connection);
                throw throwable;
            }
        }
        if (!tc.isEntryEnabled()) return connection;
        Tr.exit(tc, "createConnection", connection);
        return connection;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Connection createConnection(ConnectionFactory connectionFactory, String string, String string2) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConnection", new Object[]{connectionFactory, string, "password not traced"});
        }
        Connection connection = null;
        try {
            if (connectionFactory instanceof XAConnectionFactory) {
                this.xaCapable = true;
                XAConnectionFactory xAConnectionFactory = (XAConnectionFactory)connectionFactory;
                connection = xAConnectionFactory.createXAConnection(string, string2);
            } else {
                this.xaCapable = false;
                ConnectionFactory connectionFactory2 = connectionFactory;
                connection = connectionFactory2.createConnection(string, string2);
            }
        }
        catch (ClassCastException classCastException) {
            try {
                FFDCFilter.processException((Throwable)classCastException, "com.ibm.ejs.jms.JMSManagedConnection.createConnection", "843", this);
                throw JMSCMUtils.mapToResourceException(classCastException, tc, "Expected ConnectionFactory");
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedConnection.createConnection", "848", this);
                    throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), tc, "createConnection failed");
                }
            }
            catch (Throwable throwable) {
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "createConnection", connection);
                throw throwable;
            }
        }
        if (!tc.isEntryEnabled()) return connection;
        Tr.exit(tc, "createConnection", connection);
        return connection;
    }

    protected String getManagedSessionFactoryClassName() {
        return MANAGED_SESSION_FACTORY_CLASS_NAME;
    }

    final void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    final PasswordCredential getPasswordCredential() {
        return this.credential;
    }

    final Connection getPhysicalConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void handleClosed(JMSConnectionHandle jMSConnectionHandle) {
        HashSet hashSet;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleClosed", jMSConnectionHandle);
        }
        Set set = this.openConnectionHandles;
        synchronized (set) {
            this.openConnectionHandles.remove(jMSConnectionHandle);
        }
        set = new ConnectionEvent((ManagedConnection)this, 1);
        set.setConnectionHandle(jMSConnectionHandle);
        Object object = this.connectionEventListeners;
        synchronized (object) {
            Tr.debug(tc, "Creating a Iterator clone of the connectionEventListeners set");
            hashSet = (HashSet)this.connEventListenerSet.clone();
            Tr.debug(tc, "Created an Iterator Clone of the connectionEventListeners set");
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)object.next();
            connectionEventListener.connectionClosed((ConnectionEvent)set);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleClosed");
        }
    }

    final boolean getXACapable() {
        return this.xaCapable;
    }

    final JMSManagedConnectionFactory getManagedConnectionFactory() {
        return this.managedConnectionFactory;
    }

    public boolean getAllowsNonTransactedSessionsInTran() {
        return this.allowsNonTransactedSessionsInTran;
    }

    public Boolean isUnified() {
        return this.unifiedConnection;
    }

    private final class JMSManagedConnectionMetaData
    implements ManagedConnectionMetaData {
        private JMSManagedConnectionMetaData() {
        }

        public String getEISProductName() throws ResourceException {
            try {
                return JMSManagedConnection.this.connection.getMetaData().getJMSProviderName();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedConnection.getEISProductName", "848", this);
                throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), tc, "Failed to get JMS provider name");
            }
        }

        public String getEISProductVersion() throws ResourceException {
            try {
                return JMSManagedConnection.this.connection.getMetaData().getProviderVersion();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedConnection.getEISProductVersion", "870", this);
                throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), tc, "Failed to get JMS provider version");
            }
        }

        public int getMaxConnections() throws ResourceException {
            return 0;
        }

        public String getUserName() throws ResourceException {
            return JMSManagedConnection.this.credential.getUserName();
        }
    }

    private static class ConnectorNameLock {
        private ConnectorNameLock() {
        }
    }
}

