/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSConnectionFactoryHandle;
import com.ibm.ejs.jms.JMSConnectionRequestInfo;
import com.ibm.ejs.jms.JMSDefaultConnectionManager;
import com.ibm.ejs.jms.JMSManagedConnection;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.security.util.PasswordUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.jms.ConnectionFactory;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public abstract class JMSManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable,
FFDCSelfIntrospectable {
    private static final TraceComponent tc = Tr.register(JMSManagedConnectionFactory.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    protected transient ConnectionFactory connectionFactory = null;
    protected transient ConnectionFactory connectionFactory1pc = null;
    protected boolean serverRecoveryNoCredentials = false;
    private transient PrintWriter logWriter = null;
    private String userName = null;
    private transient String password = null;
    private String connectorName = null;
    Properties sessionPoolProperties = new Properties();
    private String mappingConfigAlias = null;
    private String authDataAlias = null;
    private int sessionSharingScope = 0;
    private boolean nondeferredreaper = false;
    private static final long serialVersionUID = 6163116077001529572L;
    private static ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("serverRecoveryNoCredentials", Boolean.TYPE), new ObjectStreamField("userName", String.class), new ObjectStreamField("connectorName", String.class), new ObjectStreamField("sessionPoolProperties", Properties.class), new ObjectStreamField("mappingConfigAlias", String.class), new ObjectStreamField("authDataAlias", String.class)};
    static /* synthetic */ Class class$javax$resource$spi$security$PasswordCredential;

    public JMSManagedConnectionFactory() {
        this.sessionPoolProperties.setProperty("maxConnections", String.valueOf(10));
    }

    public String[] introspectSelf() {
        String string = System.getProperty("line.separator") + "\t";
        String[] stringArray = new String[]{JMSCMUtils.objectToString(this), string + "tc = " + tc, string + "connectionFactory = " + this.connectionFactory, string + "serverRecoveryNoCredentials = " + this.serverRecoveryNoCredentials, string + "logWriter = " + this.logWriter, string + "userName = " + this.userName, string + "password not dumped", string + "connectorName = " + this.connectorName, string + "sessionPoolProperties = " + this.sessionPoolProperties, string + "mappingConfigAlias = " + this.mappingConfigAlias, string + "authDataAlias = " + this.authDataAlias, string + "serialVersionUID = " + 6163116077001529572L, string + "sessionSharingScope = " + this.sessionSharingScope};
        return stringArray;
    }

    public final void setMappingConfigAlias(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "MappingConfigAlias set", string);
        }
        this.mappingConfigAlias = string;
    }

    public final String getMappingConfigAlias() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "MappingConfigAlias get", this.mappingConfigAlias);
        }
        return this.mappingConfigAlias;
    }

    public final void setAuthDataAlias(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "AuthDataAlias set", string);
        }
        this.authDataAlias = string;
    }

    public final String getAuthDataAlias() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "AuthDataAlias get", this.authDataAlias);
        }
        return this.authDataAlias;
    }

    public final void setLogWriter(PrintWriter printWriter) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Log writer set", printWriter);
        }
        this.logWriter = printWriter;
    }

    public final void setPassword(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Password set", "password not traced");
        }
        this.password = string;
    }

    public final void setUserName(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "UserName set", string);
        }
        this.userName = string;
    }

    public final void setConnectorName(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ConnectorName set", string);
        }
        this.connectorName = string;
    }

    public final void setSessionSharingScope(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("UNSHAREABLE")) {
                this.sessionSharingScope = 1;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "session sharing scope set", string);
            }
        }
    }

    public final int getSessionSharingScope() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SessionSharingScope get", Integer.toString(this.sessionSharingScope));
        }
        return this.sessionSharingScope;
    }

    public final void setSessionPoolMaxConnections(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SessionPoolMaxConnections set", string);
        }
        this.sessionPoolProperties.setProperty("maxConnections", string);
    }

    public final String getSessionPoolMaxConnections() {
        String string = this.sessionPoolProperties.getProperty("maxConnections", String.valueOf(10));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SessionPoolMaxConnections get", string);
        }
        return string;
    }

    public final void setSessionPoolMinConnections(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SessionPoolMinConnections set", string);
        }
        this.sessionPoolProperties.setProperty("minConnections", string);
    }

    public final void setSessionPoolConnectionTimeout(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SessionPoolConnectionTimeout set", string);
        }
        this.sessionPoolProperties.setProperty("connectionTimeout", string);
    }

    public final void setSessionPoolReapTime(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SessionPoolReapTime set", string);
        }
        this.sessionPoolProperties.setProperty("reapTime", string);
    }

    public final void setSessionPoolAgedTimeout(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SessionPoolAgedTimeout set", string);
        }
        this.sessionPoolProperties.setProperty("agedTimeout", string);
    }

    public final void setSessionPoolUnusedTimeout(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SessionPoolUnusedTimeout set", string);
        }
        this.sessionPoolProperties.setProperty("unusedTimeout", string);
    }

    public final void setSessionPoolPurgePolicy(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SessionPoolPurgePolicy set", string);
        }
        this.sessionPoolProperties.setProperty("purgePolicy", string);
    }

    public final PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object createConnectionFactory() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConnectionFactory");
        }
        Object object = null;
        try {
            object = this.createConnectionFactory(new JMSDefaultConnectionManager());
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createConnectionFactory", object);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConnectionFactory", connectionManager);
        }
        JMSConnectionFactoryHandle jMSConnectionFactoryHandle = null;
        try {
            jMSConnectionFactoryHandle = this.createConnectionFactoryHandle(connectionManager);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createConnectionFactory", jMSConnectionFactoryHandle);
            }
        }
        return jMSConnectionFactoryHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        JMSManagedConnection jMSManagedConnection;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createManagedConnection", new Object[]{JMSCMUtils.subjectToString(subject), connectionRequestInfo});
            }
            jMSManagedConnection = null;
            try {
                JMSConnectionRequestInfo jMSConnectionRequestInfo = (JMSConnectionRequestInfo)connectionRequestInfo;
                boolean bl = jMSConnectionRequestInfo.getAllowsNonTransactedSessionsInTran();
                if (this.zosSubjectHasValidUtokenCredential(subject)) {
                    Boolean bl2 = jMSConnectionRequestInfo.getUnified();
                    jMSManagedConnection = bl2 != null && bl2 != false ? this.createUnifiedManagedConnection(null, bl) : this.createManagedConnection(null, bl);
                    jMSManagedConnection.setSubject(subject);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Utoken credential found on Subject: ", JMSCMUtils.subjectToString(subject));
                    }
                    break block7;
                }
                PasswordCredential passwordCredential = this.getPasswordCredential(subject, jMSConnectionRequestInfo);
                Boolean bl3 = jMSConnectionRequestInfo.getUnified();
                jMSManagedConnection = bl3 != null && bl3 != false ? this.createUnifiedManagedConnection(passwordCredential, bl) : this.createManagedConnection(passwordCredential, bl);
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createManagedConnection", jMSManagedConnection);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createManagedConnection", jMSManagedConnection);
        }
        return jMSManagedConnection;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JMSManagedConnectionFactory jMSManagedConnectionFactory = (JMSManagedConnectionFactory)object;
        if (!JMSCMUtils.objectsEqual(this.mappingConfigAlias, jMSManagedConnectionFactory.mappingConfigAlias)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.authDataAlias, jMSManagedConnectionFactory.authDataAlias)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.userName, jMSManagedConnectionFactory.userName)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.password, jMSManagedConnectionFactory.password)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.connectorName, jMSManagedConnectionFactory.connectorName)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.sessionPoolProperties, jMSManagedConnectionFactory.sessionPoolProperties)) {
            return false;
        }
        try {
            if (!JMSCMUtils.objectsEqual(this.getConnectionFactory(), jMSManagedConnectionFactory.getConnectionFactory())) {
                return false;
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSManagedConnectionFactory.equals", "313", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught ResourceException when comparing connection factories", (Object)resourceException);
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n;
        block2: {
            n = JMSCMUtils.objectHashCode(this.userName);
            n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.password);
            n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.connectorName);
            n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.mappingConfigAlias);
            n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.authDataAlias);
            try {
                n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.getConnectionFactory());
            }
            catch (ResourceException resourceException) {
                FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSManagedConnectionFactory.hashCode", "345", this);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Caught ResourceException when creating hash code", (Object)resourceException);
            }
        }
        return n;
    }

    public final ManagedConnection matchManagedConnections(Set set, final Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "matchManagedConnections", new Object[]{set, JMSCMUtils.subjectToString(subject), connectionRequestInfo});
        }
        PasswordCredential passwordCredential = null;
        JMSManagedConnection jMSManagedConnection = null;
        boolean bl = ((JMSConnectionRequestInfo)connectionRequestInfo).getAllowsNonTransactedSessionsInTran();
        Boolean bl2 = ((JMSConnectionRequestInfo)connectionRequestInfo).getUnified();
        boolean bl3 = this.zosSubjectHasValidUtokenCredential(subject);
        if (!bl3) {
            passwordCredential = this.getPasswordCredential(subject, connectionRequestInfo);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && jMSManagedConnection == null) {
            JMSManagedConnection jMSManagedConnection2;
            Object e2 = iterator.next();
            if (!(e2 instanceof JMSManagedConnection) || !bl2.equals((jMSManagedConnection2 = (JMSManagedConnection)e2).isUnified()) || bl != jMSManagedConnection2.getAllowsNonTransactedSessionsInTran()) continue;
            if (bl3) {
                if (System.getSecurityManager() != null) {
                    jMSManagedConnection = (JMSManagedConnection)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return JMSCMUtils.objectsEqual(subject, jMSManagedConnection2.getSubject()) ? jMSManagedConnection2 : null;
                        }
                    });
                    continue;
                }
                jMSManagedConnection = JMSCMUtils.objectsEqual(subject, jMSManagedConnection2.getSubject()) ? jMSManagedConnection2 : null;
                continue;
            }
            if (!JMSCMUtils.objectsEqual(passwordCredential, jMSManagedConnection2.getPasswordCredential())) continue;
            jMSManagedConnection = jMSManagedConnection2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "matchManagedConnections", jMSManagedConnection);
        }
        return jMSManagedConnection;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(JMSCMUtils.objectToString(this));
        stringBuffer.append(string + "physical connection factory = " + this.connectionFactory);
        if (this.connectionFactory1pc != null) {
            stringBuffer.append(string + "1pc physical connection factory = " + this.connectionFactory1pc);
        }
        stringBuffer.append(string + "default user name = " + this.userName);
        return stringBuffer.toString();
    }

    final String getConnectorName() {
        return this.connectorName;
    }

    final Properties getSessionPoolProperties() {
        return this.sessionPoolProperties;
    }

    protected abstract ConnectionFactory getConnectionFactory() throws ResourceException;

    protected abstract ConnectionFactory getConnectionFactory(boolean var1) throws ResourceException;

    private final PasswordCredential getPasswordCredential(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws SecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPasswordCredential", new Object[]{JMSCMUtils.subjectToString(subject), connectionRequestInfo});
        }
        PasswordCredential passwordCredential = null;
        try {
            if (subject != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using credentials from Subject");
                }
                passwordCredential = this.getPasswordCredential(subject);
            } else if (connectionRequestInfo instanceof JMSConnectionRequestInfo) {
                JMSConnectionRequestInfo jMSConnectionRequestInfo = (JMSConnectionRequestInfo)connectionRequestInfo;
                passwordCredential = jMSConnectionRequestInfo.getPasswordCredential();
                if (passwordCredential != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Using credentials passed on createXXXConnection");
                    }
                } else if (this.userName != null && this.password != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Using default credentials from ConnectionFactory");
                    }
                    String string = this.userName == null ? "" : this.userName;
                    char[] cArray = this.password == null ? new char[]{} : this.password.toCharArray();
                    passwordCredential = new PasswordCredential(string, cArray);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No default credentials on ConnectionFactory");
                }
            }
        }
        catch (SecurityException securityException) {
            FFDCFilter.processException((Throwable)securityException, "com.ibm.ejs.jms.JMSManagedConnectionFactory.getPasswordCredential", "546", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Caught SecurityException in getPasswordCredential", (Object)securityException);
            }
            throw securityException;
        }
        finally {
            if (tc.isDebugEnabled() && passwordCredential != null) {
                Tr.debug(tc, "Credential contains userName", passwordCredential.getUserName());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPasswordCredential", passwordCredential);
            }
        }
        return passwordCredential;
    }

    private final PasswordCredential getPasswordCredential(Subject subject) throws SecurityException {
        PasswordCredential passwordCredential;
        final Subject subject2 = subject;
        PasswordCredential passwordCredential2 = (PasswordCredential)com.ibm.ws.security.util.AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                Set set = subject2.getPrivateCredentials(class$javax$resource$spi$security$PasswordCredential == null ? (class$javax$resource$spi$security$PasswordCredential = JMSManagedConnectionFactory.class$("javax.resource.spi.security.PasswordCredential")) : class$javax$resource$spi$security$PasswordCredential);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    PasswordCredential passwordCredential;
                    Object t = iterator.next();
                    if (!(t instanceof PasswordCredential) || !(passwordCredential = (PasswordCredential)t).getManagedConnectionFactory().equals(JMSManagedConnectionFactory.this)) continue;
                    return passwordCredential;
                }
                return null;
            }
        });
        if (passwordCredential2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No PasswordCredential in Subject");
            }
            passwordCredential = null;
        } else {
            passwordCredential = new PasswordCredential(passwordCredential2.getUserName(), passwordCredential2.getPassword());
        }
        return passwordCredential;
    }

    protected boolean zosSubjectHasValidUtokenCredential(Subject subject) throws SecurityException {
        return false;
    }

    protected abstract void setupForRecovery();

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeObject");
        }
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("serverRecoveryNoCredentials", this.serverRecoveryNoCredentials);
        putField.put("userName", this.userName);
        putField.put("connectorName", this.connectorName);
        putField.put("sessionPoolProperties", this.sessionPoolProperties);
        putField.put("mappingConfigAlias", this.mappingConfigAlias);
        putField.put("authDataAlias", this.authDataAlias);
        objectOutputStream.writeFields();
        if (this.password == null) {
            objectOutputStream.writeBoolean(false);
        } else {
            String string = "";
            try {
                string = PasswordUtil.encode(this.password);
            }
            catch (Exception exception) {
                throw new IOException();
            }
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeUTF(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeObject");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readObject", objectInputStream);
        }
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.serverRecoveryNoCredentials = getField.get("serverRecoveryNoCredentials", false);
        this.userName = (String)getField.get("userName", null);
        this.connectorName = (String)getField.get("connectorName", null);
        this.sessionPoolProperties = (Properties)getField.get("sessionPoolProperties", null);
        this.mappingConfigAlias = (String)getField.get("mappingConfigAlias", null);
        this.authDataAlias = (String)getField.get("authDataAlias", null);
        if (objectInputStream.readBoolean()) {
            String string = objectInputStream.readUTF();
            try {
                this.password = PasswordUtil.decode(string);
            }
            catch (Exception exception) {
                throw new IOException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readObject");
        }
    }

    protected final boolean getServerRecoveryNoCredentials() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverRecoveryNoCredentials get", new Boolean(this.serverRecoveryNoCredentials));
        }
        return this.serverRecoveryNoCredentials;
    }

    protected JMSConnectionFactoryHandle createConnectionFactoryHandle(ConnectionManager connectionManager) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConnectionFactoryHandle", connectionManager);
        }
        JMSConnectionFactoryHandle jMSConnectionFactoryHandle = new JMSConnectionFactoryHandle(this, connectionManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConnectionFactoryHandle", jMSConnectionFactoryHandle);
        }
        return jMSConnectionFactoryHandle;
    }

    private JMSManagedConnection createUnifiedManagedConnection(PasswordCredential passwordCredential, boolean bl) throws ResourceException {
        JMSManagedConnection jMSManagedConnection = null;
        jMSManagedConnection = new JMSManagedConnection(this, passwordCredential, bl, Boolean.TRUE);
        return jMSManagedConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JMSManagedConnection createManagedConnection(PasswordCredential passwordCredential, boolean bl) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createManagedConnection", passwordCredential);
        }
        JMSManagedConnection jMSManagedConnection = null;
        try {
            jMSManagedConnection = this.createUnifiedManagedConnection(passwordCredential, bl);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createManagedConnection", jMSManagedConnection);
            }
        }
        return jMSManagedConnection;
    }

    public void setNondeferredreaper(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "set nondeferredreaper=" + string);
        }
        this.nondeferredreaper = Boolean.parseBoolean(string);
    }

    public boolean getNondeferredreaper() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "get nondeferredreaper=" + this.nondeferredreaper);
        }
        return this.nondeferredreaper;
    }
}

