/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSManagedConnection;
import com.ibm.ejs.jms.JMSManagedConnectionFactory;
import com.ibm.ejs.jms.JMSManagedQueueSessionFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.resource.ResourceException;
import javax.resource.spi.security.PasswordCredential;

public final class JMSManagedQueueConnection
extends JMSManagedConnection {
    private static final TraceComponent tc = Tr.register(JMSManagedQueueConnection.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private static final String MANAGED_SESSION_FACTORY_CLASS_NAME = JMSManagedQueueSessionFactory.class.getName();

    JMSManagedQueueConnection(JMSManagedConnectionFactory jMSManagedConnectionFactory, PasswordCredential passwordCredential, boolean bl) throws ResourceException {
        super(jMSManagedConnectionFactory, passwordCredential, bl, Boolean.FALSE);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSManagedQueueConnection", new Object[]{jMSManagedConnectionFactory, passwordCredential, new Boolean(bl)});
            Tr.exit(tc, "JMSManagedQueueConnection");
        }
    }

    public String[] introspectSelf() {
        String string = System.getProperty("line.separator") + "\t";
        String[] stringArray = super.introspectSelf();
        String[] stringArray2 = new String[stringArray.length + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[stringArray.length] = string + "MANAGED_SESSION_FACTORY_CLASS_NAME = " + MANAGED_SESSION_FACTORY_CLASS_NAME;
        return stringArray2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Connection createConnection(ConnectionFactory connectionFactory) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConnection", connectionFactory);
        }
        XAQueueConnection xAQueueConnection = null;
        try {
            if (connectionFactory instanceof XAQueueConnectionFactory) {
                this.xaCapable = true;
                XAQueueConnectionFactory xAQueueConnectionFactory = (XAQueueConnectionFactory)connectionFactory;
                xAQueueConnection = xAQueueConnectionFactory.createXAQueueConnection();
            } else {
                this.xaCapable = false;
                QueueConnectionFactory queueConnectionFactory = (QueueConnectionFactory)connectionFactory;
                xAQueueConnection = queueConnectionFactory.createQueueConnection();
            }
        }
        catch (ClassCastException classCastException) {
            try {
                FFDCFilter.processException((Throwable)classCastException, "com.ibm.ejs.jms.JMSManagedQueueConnection.createConnection", "111", this);
                throw JMSCMUtils.mapToResourceException(classCastException, tc, "Expected QueueConnectionFactory");
                catch (JMSException jMSException) {
                    jMSException.printStackTrace();
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedQueueConnection.createConnection", "116", this);
                    if (jMSException.getLinkedException() == null) throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), tc, "createQueueConnection failed");
                    FFDCFilter.processException((Throwable)jMSException.getLinkedException(), "com.ibm.ejs.jms.JMSManagedQueueConnection.createConnection", "119", this);
                    throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), tc, "createQueueConnection failed");
                }
            }
            catch (Throwable throwable) {
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "createConnection", xAQueueConnection);
                throw throwable;
            }
        }
        if (!tc.isEntryEnabled()) return xAQueueConnection;
        Tr.exit(tc, "createConnection", xAQueueConnection);
        return xAQueueConnection;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Connection createConnection(ConnectionFactory connectionFactory, String string, String string2) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConnection", new Object[]{connectionFactory, string, "password not traced"});
        }
        XAQueueConnection xAQueueConnection = null;
        try {
            if (connectionFactory instanceof XAQueueConnectionFactory) {
                this.xaCapable = true;
                XAQueueConnectionFactory xAQueueConnectionFactory = (XAQueueConnectionFactory)connectionFactory;
                xAQueueConnection = xAQueueConnectionFactory.createXAQueueConnection(string, string2);
            } else {
                this.xaCapable = false;
                QueueConnectionFactory queueConnectionFactory = (QueueConnectionFactory)connectionFactory;
                xAQueueConnection = queueConnectionFactory.createQueueConnection(string, string2);
            }
        }
        catch (ClassCastException classCastException) {
            try {
                FFDCFilter.processException((Throwable)classCastException, "com.ibm.ejs.jms.JMSManagedQueueConnection.createConnection", "166", this);
                throw JMSCMUtils.mapToResourceException(classCastException, tc, "Expected QueueConnectionFactory");
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedQueueConnection.createConnection", "171", this);
                    throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), tc, "createQueueConnection failed");
                }
            }
            catch (Throwable throwable) {
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "createConnection", xAQueueConnection);
                throw throwable;
            }
        }
        if (!tc.isEntryEnabled()) return xAQueueConnection;
        Tr.exit(tc, "createConnection", xAQueueConnection);
        return xAQueueConnection;
    }

    protected String getManagedSessionFactoryClassName() {
        return MANAGED_SESSION_FACTORY_CLASS_NAME;
    }
}

