/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSManagedQueueSessionFactory;
import com.ibm.ejs.jms.JMSManagedSession;
import com.ibm.ejs.jms.JMSQueueSessionHandle;
import com.ibm.ejs.jms.JMSSessionHandle;
import com.ibm.ejs.jms.JMSSessionRequestInfo;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;

final class JMSManagedQueueSession
extends JMSManagedSession {
    private static final TraceComponent tc = Tr.register(JMSManagedQueueSession.class, "Messaging", JMSCMUtils.MSG_BUNDLE);

    JMSManagedQueueSession(JMSManagedQueueSessionFactory jMSManagedQueueSessionFactory, JMSSessionRequestInfo jMSSessionRequestInfo) throws ResourceException {
        super(jMSManagedQueueSessionFactory, jMSSessionRequestInfo);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSManagedQueueSession", new Object[]{jMSManagedQueueSessionFactory, jMSSessionRequestInfo});
            Tr.exit(tc, "JMSManagedQueueSession");
        }
    }

    protected JMSSessionHandle createSessionHandle(ConnectionRequestInfo connectionRequestInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSessionHandle", connectionRequestInfo);
        }
        JMSQueueSessionHandle jMSQueueSessionHandle = new JMSQueueSessionHandle(connectionRequestInfo, this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSessionHandle", jMSQueueSessionHandle);
        }
        return jMSQueueSessionHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session createSession(Connection connection, boolean bl, int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSession", new Object[]{connection, new Boolean(bl), new Integer(n)});
        }
        QueueSession queueSession = null;
        try {
            queueSession = ((QueueConnection)connection).createQueueSession(bl, n);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSession", queueSession);
            }
        }
        return queueSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XASession createXASession(XAConnection xAConnection) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createXASession", xAConnection);
        }
        XAQueueSession xAQueueSession = null;
        try {
            xAQueueSession = ((XAQueueConnection)xAConnection).createXAQueueSession();
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createXASession", xAQueueSession);
            }
        }
        return xAQueueSession;
    }
}

