/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSListenerSessionRequestInfo;
import com.ibm.ejs.jms.JMSManagedSessionFactory;
import com.ibm.ejs.jms.JMSSessionHandle;
import com.ibm.ejs.jms.JMSSessionRequestInfo;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

class JMSManagedSession
implements ManagedConnection {
    static final int NON_TRANSACTED_SESSION = 0;
    static final int TRANSACTED_SESSION = 1;
    static final int XA_SESSION = 2;
    static final int RRS_GLOBAL_SESSION = 3;
    private static final TraceComponent tc = Tr.register(JMSManagedSession.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private static final TraceComponent lttc = Tr.register(JMSLocalTransaction.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private static final TraceComponent xatc = Tr.register(JMSXAResource.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private JMSManagedSessionFactory managedSessionFactory;
    private Session session;
    private JMSSessionRequestInfo sessionRequestInfo;
    private int sessionType;
    private int acknowledgeMode;
    private Set connectionEventListeners = Collections.synchronizedSet(new HashSet());
    private Set openSessionHandles = Collections.synchronizedSet(new HashSet());
    private PrintWriter logWriter = null;
    private boolean enlisted = false;
    private LocalTransaction localTransaction = null;
    private boolean localTranStarted = false;
    private XAResource xaResource = null;
    private boolean mqSession = false;

    JMSManagedSession(JMSManagedSessionFactory jMSManagedSessionFactory, JMSSessionRequestInfo jMSSessionRequestInfo) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSManagedSession", new Object[]{jMSManagedSessionFactory, jMSSessionRequestInfo});
        }
        this.managedSessionFactory = jMSManagedSessionFactory;
        this.sessionType = jMSManagedSessionFactory.getSessionTypeRequired(jMSSessionRequestInfo);
        this.sessionRequestInfo = jMSSessionRequestInfo;
        try {
            Connection connection = jMSManagedSessionFactory.getPhysicalConnection();
            switch (this.sessionType) {
                case 2: {
                    this.session = this.createXASession((XAConnection)connection);
                    break;
                }
                case 1: {
                    this.acknowledgeMode = jMSSessionRequestInfo.getAcknowledgeMode();
                    this.session = this.createSession(connection, true, this.acknowledgeMode);
                    break;
                }
                case 0: {
                    this.acknowledgeMode = jMSSessionRequestInfo.getAcknowledgeMode();
                    this.session = this.createSession(connection, false, this.acknowledgeMode);
                    break;
                }
                case 3: {
                    this.acknowledgeMode = jMSSessionRequestInfo.getAcknowledgeMode();
                    this.session = this.createSession(connection, true, this.acknowledgeMode);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid session type");
                }
            }
            try {
                Class<?> clazz = Class.forName("com.ibm.mq.jms.MQSession");
                if (clazz.isInstance(this.session)) {
                    this.mqSession = true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedSession.JMSManagedSession", "172", this);
            if (jMSException.getLinkedException() != null) {
                FFDCFilter.processException((Throwable)jMSException.getLinkedException(), "com.ibm.ejs.jms.JMSManagedSession.JMSManagedSession", "175", this);
            }
            throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), tc, "Failed to create session");
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "JMSManagedSession");
            }
        }
    }

    public final void setLogWriter(PrintWriter printWriter) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Log writer set", printWriter);
        }
        this.logWriter = printWriter;
    }

    public final Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnection", new Object[]{JMSCMUtils.subjectToString(subject), connectionRequestInfo});
        }
        JMSSessionHandle jMSSessionHandle = this.createSessionHandle(connectionRequestInfo);
        this.openSessionHandles.add(jMSSessionHandle);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnection", jMSSessionHandle);
        }
        return jMSSessionHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LocalTransaction getLocalTransaction() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocalTransaction");
        }
        try {
            if (this.sessionType == 2 && !(this.sessionRequestInfo instanceof JMSListenerSessionRequestInfo)) {
                ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("getLocalTransaction called on XA session");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "XA session does not support getLocalTransaction", resourceAdapterInternalException);
                }
                throw resourceAdapterInternalException;
            }
            if (this.localTransaction == null) {
                this.localTransaction = new JMSLocalTransaction();
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getLocalTransaction", this.localTransaction);
            }
        }
        return this.localTransaction;
    }

    public final PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public final ManagedConnectionMetaData getMetaData() throws ResourceException {
        return this.managedSessionFactory.getMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final XAResource getXAResource() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXAResource");
        }
        try {
            if (this.xaResource != null) return this.xaResource;
            switch (this.sessionType) {
                case 2: {
                    XASession xASession = (XASession)this.session;
                    this.xaResource = new JMSXAResource(xASession.getXAResource());
                    return this.xaResource;
                }
                case 0: {
                    this.xaResource = new JMSXAResource(null);
                    return this.xaResource;
                }
                default: {
                    ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("getXAResource called on non-XA managed sesssion");
                    if (!tc.isEventEnabled()) throw resourceAdapterInternalException;
                    Tr.event(tc, "Non-XA managed session does not support getXAResource", resourceAdapterInternalException);
                    throw resourceAdapterInternalException;
                }
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getXAResource", this.xaResource);
            }
        }
    }

    public final void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding connection event listener", connectionEventListener);
        }
        this.connectionEventListeners.add(connectionEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void associateConnection(Object object) throws ResourceException {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "associateConnection", object);
            }
            try {
                if (object instanceof JMSSessionHandle) {
                    JMSSessionHandle jMSSessionHandle = (JMSSessionHandle)object;
                    JMSManagedSession jMSManagedSession = jMSSessionHandle.getManagedSession();
                    if (jMSManagedSession != null) {
                        jMSManagedSession.openSessionHandles.remove(jMSSessionHandle);
                    }
                    jMSSessionHandle.activate(this);
                    this.openSessionHandles.add(jMSSessionHandle);
                    break block8;
                }
                ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("Can't associate non-JMSSessionHandle");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Can't associate non-JMSSessionHandle", resourceAdapterInternalException);
                }
                throw resourceAdapterInternalException;
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "associateConnection");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanup() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup");
        }
        Set set = this.openSessionHandles;
        synchronized (set) {
            Iterator iterator = this.openSessionHandles.iterator();
            while (iterator.hasNext()) {
                JMSSessionHandle jMSSessionHandle = (JMSSessionHandle)iterator.next();
                jMSSessionHandle.deactivate();
            }
            this.openSessionHandles.clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup");
        }
    }

    public final void destroy() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        try {
            this.session.close();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedSession.destroy", "471", this);
            throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), tc, "Failed to close session");
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "destroy");
            }
        }
    }

    public final void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Remove connection event listener", connectionEventListener);
        }
        this.connectionEventListeners.remove(connectionEventListener);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JMSManagedSession jMSManagedSession = (JMSManagedSession)object;
        if (this.sessionType != jMSManagedSession.sessionType) {
            return false;
        }
        if (this.acknowledgeMode != jMSManagedSession.acknowledgeMode) {
            return false;
        }
        return JMSCMUtils.objectsEqual(this.session, jMSManagedSession.session);
    }

    public int hashCode() {
        int n = this.sessionType;
        n = n * JMSCMUtils.HASH_CODE_PRIME + this.acknowledgeMode;
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.session);
        return n;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(JMSCMUtils.objectToString(this));
        stringBuffer.append(string + "physical session = " + JMSCMUtils.objectToString(this.session));
        stringBuffer.append(string + "session type = ");
        switch (this.sessionType) {
            case 0: {
                stringBuffer.append("NON_TRANSACTED_SESSION");
                break;
            }
            case 1: {
                stringBuffer.append("TRANSACTED_SESSION");
                break;
            }
            case 2: {
                stringBuffer.append("XA_SESSION");
                break;
            }
            case 3: {
                stringBuffer.append("RRS_GLOBAL_SESSION");
                break;
            }
            default: {
                throw new RuntimeException("Invalid session type");
            }
        }
        if (this.sessionType != 2 && this.sessionType != 3) {
            stringBuffer.append(string + "acknowledge mode = ");
            switch (this.acknowledgeMode) {
                case 2: {
                    stringBuffer.append("CLIENT_ACKNOWLEDGE");
                    break;
                }
                case 1: {
                    stringBuffer.append("AUTO_ACKNOWLEDGE");
                    break;
                }
                case 3: {
                    stringBuffer.append("DUPS_OK_ACKNOWLEDGE");
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid acknowledge mode");
                }
            }
        }
        stringBuffer.append(string + "enlisted = " + this.enlisted);
        stringBuffer.append(string + "open session handles = [");
        Iterator iterator = this.openSessionHandles.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(JMSCMUtils.objectToString(iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        stringBuffer.append(string + "managed session factory = " + JMSCMUtils.objectToString(this.managedSessionFactory));
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session createSession(Connection connection, boolean bl, int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSession", new Object[]{connection, new Boolean(bl), new Integer(n)});
        }
        Session session = null;
        try {
            session = connection.createSession(bl, n);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSession", session);
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XASession createXASession(XAConnection xAConnection) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createXASession", xAConnection);
        }
        XASession xASession = null;
        try {
            xASession = xAConnection.createXASession();
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createXASession", xASession);
            }
        }
        return xASession;
    }

    protected JMSSessionHandle createSessionHandle(ConnectionRequestInfo connectionRequestInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSessionHandle", connectionRequestInfo);
        }
        JMSSessionHandle jMSSessionHandle = new JMSSessionHandle(connectionRequestInfo, this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSessionHandle", jMSSessionHandle);
        }
        return jMSSessionHandle;
    }

    final Session getPhysicalSession() {
        return this.session;
    }

    final int getSessionType() {
        return this.sessionType;
    }

    final JMSSessionRequestInfo getSessionRequestInfo() {
        return this.sessionRequestInfo;
    }

    final int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void handleClosed(JMSSessionHandle jMSSessionHandle) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleClosed", jMSSessionHandle);
        }
        this.openSessionHandles.remove(jMSSessionHandle);
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 1);
        connectionEvent.setConnectionHandle((Object)jMSSessionHandle);
        Set set = this.connectionEventListeners;
        synchronized (set) {
            Iterator iterator = this.connectionEventListeners.iterator();
            while (iterator.hasNext()) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
                connectionEventListener.connectionClosed(connectionEvent);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleClosed");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void enlist() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "enlist");
        }
        try {
            if (this.enlisted) return;
            switch (this.sessionType) {
                case 2: {
                    this.interactionPending();
                    this.enlisted = true;
                    return;
                }
                case 1: {
                    this.localTransactionStarted();
                    this.enlisted = true;
                    return;
                }
                case 0: {
                    return;
                }
                case 3: {
                    this.interactionPending();
                    this.enlisted = true;
                    return;
                }
                default: {
                    throw new RuntimeException("Invalid session type");
                }
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSManagedSession.enlist", "752", this);
            throw JMSCMUtils.mapToJMSException(resourceException, tc, "Enlist failed");
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "enlist");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void localTransactionStarted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "localTransactionStarted");
        }
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 2);
        Set set = this.connectionEventListeners;
        synchronized (set) {
            Iterator iterator = this.connectionEventListeners.iterator();
            while (iterator.hasNext()) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
                connectionEventListener.localTransactionStarted(connectionEvent);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "localTransactionStarted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void localTransactionCommitted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "localTransactionCommitted");
        }
        if (this.enlisted) {
            ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 3);
            Set set = this.connectionEventListeners;
            synchronized (set) {
                Iterator iterator = this.connectionEventListeners.iterator();
                while (iterator.hasNext()) {
                    ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
                    connectionEventListener.localTransactionCommitted(connectionEvent);
                }
            }
            this.enlisted = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "localTransactionCommitted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void localTransactionRolledback() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "localTransactionRolledback");
        }
        if (this.enlisted) {
            ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 4);
            Set set = this.connectionEventListeners;
            synchronized (set) {
                Iterator iterator = this.connectionEventListeners.iterator();
                while (iterator.hasNext()) {
                    ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
                    connectionEventListener.localTransactionRolledback(connectionEvent);
                }
            }
            this.enlisted = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "localTransactionRolledback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void interactionPending() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "interactionPending");
        }
        try {
            ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 900);
            Set set = this.connectionEventListeners;
            synchronized (set) {
                Iterator iterator = this.connectionEventListeners.iterator();
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    if (!(e2 instanceof com.ibm.websphere.j2c.ConnectionEventListener)) continue;
                    com.ibm.websphere.j2c.ConnectionEventListener connectionEventListener = (com.ibm.websphere.j2c.ConnectionEventListener)e2;
                    connectionEventListener.interactionPending(connectionEvent);
                }
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSManagedSession.interactionPending", "909", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught ResourceException in interactionPending", (Object)resourceException);
            }
            throw resourceException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "interactionPending");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void connectionErrorOccurred(Exception exception) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "connectionErrorOccurred");
        }
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 5, exception);
        Set set = this.connectionEventListeners;
        synchronized (set) {
            Iterator iterator = this.connectionEventListeners.iterator();
            while (iterator.hasNext()) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
                connectionEventListener.connectionErrorOccurred(connectionEvent);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "connectionErrorOccurred");
        }
    }

    final boolean inContainerLocalTran() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "inContainerLocalTran");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "inContainerLocalTran", new Boolean(this.localTranStarted));
        }
        return this.localTranStarted;
    }

    public boolean isMQSession() {
        return this.mqSession;
    }

    private final class JMSXAResource
    implements XAResource {
        private final XAResource providerXAResource;

        JMSXAResource(XAResource xAResource) {
            if (xatc.isEntryEnabled()) {
                Tr.entry(xatc, "JMSXAResource", xAResource);
            }
            this.providerXAResource = xAResource;
            if (xatc.isEntryEnabled()) {
                Tr.exit(xatc, "JMSXAResource");
            }
        }

        public void start(Xid xid, int n) throws XAException {
            if (xatc.isEntryEnabled()) {
                Tr.entry(xatc, "start", new Object[]{xid, new Integer(n)});
            }
            try {
                this.providerXAResource.start(xid, n);
            }
            catch (XAException xAException) {
                FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.jms.JMSManagedSession.start", "1052", this);
                if (xatc.isEventEnabled()) {
                    Tr.event(xatc, "XAException in start", xAException);
                }
                throw xAException;
            }
            finally {
                if (xatc.isEntryEnabled()) {
                    Tr.exit(xatc, "start");
                }
            }
        }

        public boolean setTransactionTimeout(int n) throws XAException {
            if (xatc.isEntryEnabled()) {
                Tr.entry(xatc, "setTransactionTimeout", new Integer(n));
            }
            boolean bl = false;
            try {
                bl = this.providerXAResource.setTransactionTimeout(n);
            }
            catch (XAException xAException) {
                FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.jms.JMSManagedSession.setTransactionTimeout", "1090", this);
                if (xatc.isEventEnabled()) {
                    Tr.event(xatc, "XAException in setTransactionTimeout", xAException);
                }
                throw xAException;
            }
            finally {
                if (xatc.isEntryEnabled()) {
                    Tr.exit(xatc, "setTransactionTimeout", new Boolean(bl));
                }
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollback(Xid xid) throws XAException {
            block9: {
                if (xatc.isEntryEnabled()) {
                    Tr.entry(xatc, "rollback", xid);
                }
                try {
                    JMSManagedSession.this.enlisted = false;
                    this.providerXAResource.rollback(xid);
                }
                catch (XAException xAException) {
                    FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.jms.JMSManagedSession.rollback", "1129", this);
                    if (xatc.isEventEnabled()) {
                        Tr.event(xatc, "XAException in rollback", xAException);
                    }
                    if (xAException.errorCode >= 100 && xAException.errorCode <= 107) {
                        break block9;
                    }
                    throw xAException;
                }
                finally {
                    if (xatc.isEntryEnabled()) {
                        Tr.exit(xatc, "rollback");
                    }
                }
            }
        }

        public Xid[] recover(int n) throws XAException {
            if (xatc.isEntryEnabled()) {
                Tr.entry(xatc, "recover", new Integer(n));
            }
            Xid[] xidArray = null;
            try {
                xidArray = this.providerXAResource.recover(n);
            }
            catch (XAException xAException) {
                FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.jms.JMSManagedSession.recover", "1168", this);
                if (xatc.isEventEnabled()) {
                    Tr.event(xatc, "XAException in recover", xAException);
                }
                throw xAException;
            }
            finally {
                if (xatc.isEntryEnabled()) {
                    Tr.exit(xatc, "recover", xidArray);
                }
            }
            return xidArray;
        }

        public int prepare(Xid xid) throws XAException {
            if (xatc.isEntryEnabled()) {
                Tr.entry(xatc, "prepare", xid);
            }
            int n = 0;
            try {
                n = this.providerXAResource.prepare(xid);
            }
            catch (XAException xAException) {
                FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.jms.JMSManagedSession.prepare", "1209", this);
                if (xatc.isEventEnabled()) {
                    Tr.event(xatc, "XAException in prepare", xAException);
                }
                throw xAException;
            }
            finally {
                if (xatc.isEntryEnabled()) {
                    Tr.exit(xatc, "prepare", new Integer(n));
                }
            }
            if (n == 3) {
                JMSManagedSession.this.enlisted = false;
            }
            return n;
        }

        public boolean isSameRM(XAResource xAResource) throws XAException {
            if (xatc.isEntryEnabled()) {
                Tr.entry(xatc, "isSameRM", xAResource);
            }
            boolean bl = false;
            try {
                bl = this.providerXAResource.isSameRM(xAResource);
            }
            catch (XAException xAException) {
                FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.jms.JMSManagedSession.isSameRM", "1254", this);
                if (xatc.isEventEnabled()) {
                    Tr.event(xatc, "XAException in isSameRM", xAException);
                }
                throw xAException;
            }
            finally {
                if (xatc.isEntryEnabled()) {
                    Tr.exit(xatc, "isSameRM", new Boolean(bl));
                }
            }
            return bl;
        }

        public int getTransactionTimeout() throws XAException {
            if (xatc.isEntryEnabled()) {
                Tr.entry(xatc, "getTransactionTimeout");
            }
            int n = 0;
            try {
                n = this.providerXAResource.getTransactionTimeout();
            }
            catch (XAException xAException) {
                FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.jms.JMSManagedSession.getTransactionTimeout", "1292", this);
                if (xatc.isEventEnabled()) {
                    Tr.event(xatc, "XAException in getTransactionTimeout", xAException);
                }
                throw xAException;
            }
            finally {
                if (xatc.isEntryEnabled()) {
                    Tr.exit(xatc, "getTransactionTimeout", new Integer(n));
                }
            }
            return n;
        }

        public void forget(Xid xid) throws XAException {
            if (xatc.isEntryEnabled()) {
                Tr.entry(xatc, "forget", xid);
            }
            try {
                this.providerXAResource.forget(xid);
            }
            catch (XAException xAException) {
                FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.jms.JMSManagedSession.forget", "1330", this);
                if (xatc.isEventEnabled()) {
                    Tr.event(xatc, "XAException in forget", xAException);
                }
                throw xAException;
            }
            finally {
                if (xatc.isEntryEnabled()) {
                    Tr.exit(xatc, "forget");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void end(Xid xid, int n) throws XAException {
            block9: {
                if (xatc.isEntryEnabled()) {
                    Tr.entry(xatc, "end", new Object[]{xid, new Integer(n)});
                }
                try {
                    this.providerXAResource.end(xid, n);
                }
                catch (XAException xAException) {
                    if (n == 0x20000000 && xAException.errorCode >= 100 && xAException.errorCode <= 107) {
                        break block9;
                    }
                    FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.jms.JMSManagedSession.end", "1367", this);
                    if (xatc.isEventEnabled()) {
                        Tr.event(xatc, "XAException in end", xAException);
                    }
                    throw xAException;
                }
                finally {
                    if (xatc.isEntryEnabled()) {
                        Tr.exit(xatc, "end");
                    }
                }
            }
        }

        public void commit(Xid xid, boolean bl) throws XAException {
            if (xatc.isEntryEnabled()) {
                Tr.entry(xatc, "commit", new Object[]{xid, new Boolean(bl)});
            }
            try {
                JMSManagedSession.this.enlisted = false;
                this.providerXAResource.commit(xid, bl);
            }
            catch (XAException xAException) {
                FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.jms.JMSManagedSession.commit", "1406", this);
                if (xatc.isEventEnabled()) {
                    Tr.event(xatc, "XAException in commit", xAException);
                }
                throw xAException;
            }
            finally {
                if (xatc.isEntryEnabled()) {
                    Tr.exit(xatc, "commit");
                }
            }
        }
    }

    private final class JMSLocalTransaction
    implements LocalTransaction {
        private JMSLocalTransaction() {
        }

        public void begin() throws ResourceException {
            if (tc.isEntryEnabled()) {
                Tr.entry(lttc, "begin");
            }
            JMSManagedSession.this.localTranStarted = true;
            if (tc.isEntryEnabled()) {
                Tr.exit(lttc, "begin");
            }
        }

        public void commit() throws ResourceException {
            if (lttc.isEntryEnabled()) {
                Tr.entry(lttc, "commit");
            }
            JMSManagedSession.this.localTranStarted = false;
            try {
                if (JMSManagedSession.this.sessionType == 1) {
                    JMSManagedSession.this.enlisted = false;
                    JMSManagedSession.this.session.commit();
                }
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedSession.commit", "945", this);
                throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), lttc, "Failed to commit transaction");
            }
            finally {
                if (lttc.isEntryEnabled()) {
                    Tr.exit(lttc, "commit");
                }
            }
        }

        public void rollback() throws ResourceException {
            if (lttc.isEntryEnabled()) {
                Tr.entry(lttc, "rollback");
            }
            JMSManagedSession.this.localTranStarted = false;
            try {
                if (JMSManagedSession.this.sessionType == 1) {
                    JMSManagedSession.this.enlisted = false;
                    JMSManagedSession.this.session.rollback();
                }
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedSession.rollback", "983", this);
                throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), lttc, "Failed to rollback transaction");
            }
            finally {
                if (lttc.isEntryEnabled()) {
                    Tr.exit(lttc, "rollback");
                }
            }
        }
    }
}

