/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.j2c.ConnectionFactoryBuilder;
import com.ibm.ejs.j2c.ConnectionFactoryBuilderFactory;
import com.ibm.ejs.j2c.ConnectionFactoryRefBuilder;
import com.ibm.ejs.j2c.ConnectorProperties;
import com.ibm.ejs.j2c.ConnectorProperty;
import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSConnectionFactoryHandle;
import com.ibm.ejs.jms.JMSConnectionHandle;
import com.ibm.ejs.jms.JMSListenerSessionRequestInfo;
import com.ibm.ejs.jms.JMSManagedConnection;
import com.ibm.ejs.jms.JMSManagedConnectionFactory;
import com.ibm.ejs.jms.JMSManagedSession;
import com.ibm.ejs.jms.JMSResourceRefBuilderFactory;
import com.ibm.ejs.jms.JMSSessionRequestInfo;
import com.ibm.ejs.jms.WSJMSManagedConnectionFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.LocalTranConfigData;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ContainerComponentMetaData;
import com.ibm.ws.security.util.PasswordUtil;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.jms.Connection;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.eclipse.jst.j2ee.jca.TransactionSupportKind;

public class JMSManagedSessionFactory
implements ManagedConnectionFactory,
Serializable,
FFDCSelfIntrospectable {
    private static final TraceComponent tc = Tr.register(JMSManagedSessionFactory.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private transient JMSManagedConnection managedConnection;
    private transient PasswordCredential passwordCredential;
    private JMSManagedConnectionFactory managedConnectionFactory;
    private transient PrintWriter logWriter = null;
    static final String TRANSACTION_RESOURCE_REGISTRATION = "TransactionResourceRegistration";
    static final String DYNAMIC_REGISTRATION = "dynamic";
    static final String INACTIVE_CONNECTION_SUPPORT = "InactiveConnectionSupport";
    private static final long serialVersionUID = 714979373854309568L;
    static final String MCF_USER_NAME = "mcfUserName";
    static final String MCF_PASSWORD = "mcfPassword";
    static final String MCF_CONNECTOR_NAME = "mcfConnectorName";
    static final String MCF_CLASSNAME = "mcfClassname";
    static final String MCF_OBJECT_TYPE = "mcfObjectType";
    static final String MCF_PROVIDER_URL = "mcfProviderURL";
    static final String MCF_CONTEXT_FACTORY_CLASSNAME = "mcfContextFactoryClassname";
    static final String MCF_JNDI_PATH = "mcfJndiPath";
    private String mcfUserName = null;
    private String mcfPassword = null;
    private String mcfConnectorName = null;
    private String mcfClassname = null;
    private Properties mcfDsProperties = null;
    private Integer mcfObjectType = null;
    private String mcfProviderURL = null;
    private String mcfContextFactoryClassname = null;
    private String mcfJndiPath = null;
    private static final String OBJECTTYPE = "ObjectType";
    private static final String INTEGER_TYPE = "java.lang.Integer";
    private static final String STRING_TYPE = "java.lang.String";
    private static final String CREDENTIAL_INTERFACE = "javax.resource.spi.security.PasswordCredential";
    private String sslRepertoire = null;
    private static ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("managedConnectionFactory", JMSManagedConnectionFactory.class), new ObjectStreamField("rrsEnabled", Boolean.class)};
    private Boolean rrsEnabled = Boolean.FALSE;

    public String[] introspectSelf() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[14];
        stringArray[0] = string + "tc = " + tc;
        if (this.managedConnection == null) {
            stringArray[1] = string + "managedConnection = null";
        } else {
            stringBuffer.append(string + "managedConnection = ");
            stringBuffer.append(this.managedConnection.introspectSelf());
            stringArray[1] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        if (this.passwordCredential == null) {
            stringArray[2] = string + "passwordCredential = null";
        } else {
            stringBuffer.append(string + "passwordCredential = ");
            stringBuffer.append(string + string + "UserName = " + this.passwordCredential.getUserName());
            stringBuffer.append(string + string + "Password not dumped");
            stringArray[2] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        if (this.managedConnectionFactory == null) {
            stringArray[3] = string + "managedConnectionFactory = null";
        } else {
            stringBuffer.append(string + "managedConnectionFactory = ");
            stringBuffer.append(this.managedConnectionFactory.introspectSelf());
            stringArray[3] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        stringArray[4] = string + "logWriter = " + this.logWriter;
        stringArray[5] = string + "mcfUserName = " + this.mcfUserName;
        stringArray[6] = string + "mcfPassword not dumped";
        stringArray[7] = string + "mcfConnectorName = " + this.mcfConnectorName;
        stringArray[8] = string + "mcfClassname = " + this.mcfClassname;
        stringArray[9] = string + "mcfDsProperties = " + this.mcfDsProperties;
        stringArray[10] = string + "mcfObjectType = " + this.mcfObjectType;
        stringArray[11] = string + "mcfProviderURL = " + this.mcfProviderURL;
        stringArray[12] = string + "mcfContextFactoryClassname = " + this.mcfContextFactoryClassname;
        stringArray[13] = string + "mcfJndiPath = " + this.mcfJndiPath;
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTransactionResourceRegistration(String string) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTransactionResourceRegistration", string);
        }
        try {
            if (!DYNAMIC_REGISTRATION.equals(string)) {
                String string2 = "Transaction resource registration of " + string + " not supported";
                ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException(string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2, resourceAdapterInternalException);
                }
                throw resourceAdapterInternalException;
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setTransactionResourceRegistration");
            }
        }
    }

    public final String getTransactionResourceRegistration() {
        return DYNAMIC_REGISTRATION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setInactiveConnectionSupport(Boolean bl) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInactiveConnectionSupport", bl);
        }
        try {
            if (!bl.booleanValue()) {
                String string = "InactiveConnectionSupport of " + bl + " not supported";
                ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string, resourceAdapterInternalException);
                }
                throw resourceAdapterInternalException;
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setInactiveConnectionSupport");
            }
        }
    }

    public final Boolean getInactiveConnectionSupport() {
        return Boolean.TRUE;
    }

    public Boolean getRRSTransactional() {
        return this.rrsEnabled;
    }

    public final Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConnectionFactory", connectionManager);
        }
        JMSConnectionHandle jMSConnectionHandle = this.createConnectionHandle(connectionManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConnectionFactory", jMSConnectionHandle);
        }
        return jMSConnectionHandle;
    }

    public final Object createConnectionFactory() throws ResourceException {
        throw new NotSupportedException("Method not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createManagedConnection", new Object[]{JMSCMUtils.subjectToString(subject), connectionRequestInfo});
        }
        JMSManagedSession jMSManagedSession = null;
        try {
            if (connectionRequestInfo == null) {
                if (this.managedConnectionFactory == null) {
                    this.createMCF();
                }
                this.managedConnectionFactory.setupForRecovery();
            }
            jMSManagedSession = this.createManagedSession((JMSSessionRequestInfo)connectionRequestInfo);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createManagedConnection", jMSManagedSession);
            }
        }
        return jMSManagedSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "matchManagedConnections", new Object[]{set, JMSCMUtils.subjectToString(subject), connectionRequestInfo});
        }
        JMSManagedSession jMSManagedSession = null;
        try {
            JMSSessionRequestInfo jMSSessionRequestInfo = (JMSSessionRequestInfo)connectionRequestInfo;
            int n = this.getSessionTypeRequired(jMSSessionRequestInfo);
            int n2 = jMSSessionRequestInfo.getAcknowledgeMode();
            Iterator iterator = set.iterator();
            while (iterator.hasNext() && jMSManagedSession == null) {
                JMSManagedSession jMSManagedSession2;
                Object e2 = iterator.next();
                if (!(e2 instanceof JMSManagedSession) || (jMSManagedSession2 = (JMSManagedSession)e2).getSessionType() != n) continue;
                if (n == 2) {
                    jMSManagedSession = jMSManagedSession2;
                    continue;
                }
                if (jMSManagedSession2.getAcknowledgeMode() != n2) continue;
                jMSManagedSession = jMSManagedSession2;
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "matchManagedConnections", jMSManagedSession);
            }
        }
        return jMSManagedSession;
    }

    public final void setLogWriter(PrintWriter printWriter) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Log writer set", printWriter);
        }
        this.logWriter = printWriter;
    }

    public final PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public final void setDataSourceProperties(Properties properties) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDataSourceProperties", JMSResourceRefBuilderFactory.maskPasswords(properties));
        }
        if ((string = (String)properties.remove("RRSTransactional")) != null && string.equals("true")) {
            this.rrsEnabled = Boolean.TRUE;
        }
        this.mcfDsProperties = properties;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDataSourceProperties");
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JMSManagedSessionFactory jMSManagedSessionFactory = (JMSManagedSessionFactory)object;
        return JMSCMUtils.objectsEqual(this.managedConnection, jMSManagedSessionFactory.managedConnection);
    }

    public int hashCode() {
        int n = JMSCMUtils.objectHashCode(this.managedConnection);
        return n *= JMSCMUtils.HASH_CODE_PRIME;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(JMSCMUtils.objectToString(this));
        stringBuffer.append(string + "managed connection = " + JMSCMUtils.objectToString(this.managedConnection));
        return stringBuffer.toString();
    }

    protected JMSManagedSession createManagedSession(JMSSessionRequestInfo jMSSessionRequestInfo) throws ResourceException {
        return new JMSManagedSession(this, jMSSessionRequestInfo);
    }

    protected JMSConnectionHandle createConnectionHandle(ConnectionManager connectionManager) {
        return new JMSConnectionHandle(this, connectionManager);
    }

    final int getSessionTypeRequired(JMSSessionRequestInfo jMSSessionRequestInfo) throws ResourceException {
        int n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSessionTypeRequired", jMSSessionRequestInfo);
        }
        if (jMSSessionRequestInfo == null) {
            n = 2;
        } else {
            boolean bl;
            boolean bl2;
            boolean bl3 = false;
            boolean bl4 = bl2 = jMSSessionRequestInfo instanceof JMSListenerSessionRequestInfo;
            if (bl2) {
                JMSListenerSessionRequestInfo jMSListenerSessionRequestInfo = (JMSListenerSessionRequestInfo)jMSSessionRequestInfo;
                bl = jMSListenerSessionRequestInfo.getTransactional();
                bl3 = jMSListenerSessionRequestInfo.getLocalTransactionRequired();
            } else {
                bl = JMSCMUtils.inGlobalTransaction();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "transactional=" + bl + ",forceLocalTxn=" + bl3, jMSSessionRequestInfo);
            }
            if (bl) {
                n = !bl3 && this.rrsEnabled.booleanValue() ? 3 : (!bl3 && this.getManagedConnection().getXACapable() ? 2 : 1);
            } else {
                LocalTranConfigData localTranConfigData;
                boolean bl5 = false;
                ComponentMetaData componentMetaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
                if (componentMetaData instanceof ContainerComponentMetaData && (localTranConfigData = ((ContainerComponentMetaData)componentMetaData).getLocalTranConfigData()) != null) {
                    boolean bl6 = bl5 = localTranConfigData.getValueResolver() == 1;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Local Tran resolver is ContainerAtBoundary?", new Boolean(bl5));
                }
                n = bl5 && !bl2 || jMSSessionRequestInfo.getTransacted() ? 1 : 0;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSessionTypeRequired", new Integer(n));
        }
        return n;
    }

    final void setManagedConnection(JMSManagedConnection jMSManagedConnection) {
        this.managedConnection = jMSManagedConnection;
        this.passwordCredential = jMSManagedConnection.getPasswordCredential();
        this.managedConnectionFactory = jMSManagedConnection.getManagedConnectionFactory();
    }

    final Connection getPhysicalConnection() throws ResourceException {
        return this.getManagedConnection().getPhysicalConnection();
    }

    final ManagedConnectionMetaData getMetaData() throws ResourceException {
        return this.getManagedConnection().getMetaData();
    }

    protected final JMSManagedConnection getManagedConnection() throws ResourceException {
        if (this.managedConnection == null) {
            this.managedConnection = this.managedConnectionFactory.createManagedConnection(this.passwordCredential, false);
        }
        return this.managedConnection;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeObject");
        }
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("managedConnectionFactory", this.managedConnectionFactory);
        putField.put("rrsEnabled", this.rrsEnabled);
        objectOutputStream.writeFields();
        if (this.passwordCredential == null) {
            objectOutputStream.writeBoolean(false);
        } else {
            String string = "";
            try {
                string = PasswordUtil.encode(String.valueOf(this.passwordCredential.getPassword()));
            }
            catch (Exception exception) {
                throw new IOException();
            }
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeUTF(this.passwordCredential.getUserName());
            objectOutputStream.writeUTF(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeObject");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readObject", objectInputStream);
        }
        if ((getField = objectInputStream.readFields()).defaulted("managedConnectionFactory")) {
            throw new IOException("Serialized JMSManagedSessionFactory does not contain a value for managedConnectionFactory");
        }
        this.managedConnectionFactory = (JMSManagedConnectionFactory)getField.get("managedConnectionFactory", null);
        this.rrsEnabled = (Boolean)getField.get("rrsEnabled", new Boolean(false));
        if (objectInputStream.readBoolean()) {
            String string = objectInputStream.readUTF();
            String string2 = objectInputStream.readUTF();
            String string3 = "";
            try {
                string3 = PasswordUtil.decode(string2);
            }
            catch (Exception exception) {
                throw new IOException();
            }
            this.passwordCredential = new PasswordCredential(string, string3.toCharArray());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readObject");
        }
    }

    public ResourceAdapter getResourceAdapter() {
        return null;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) throws ResourceException {
    }

    public final void setMcfUserName(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMcfUserName", string);
        }
        this.mcfUserName = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMcfUserName");
        }
    }

    public final String getMcfUserName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMcfUserName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMcfUserName", this.mcfUserName);
        }
        return this.mcfUserName;
    }

    public final void setMcfPassword(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMcfPassword", string);
        }
        this.mcfPassword = "";
        try {
            this.mcfPassword = PasswordUtil.passwordDecode(string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.JMSManagedSessionFactory.setMcfPassword", "795", this);
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setMcfPassword");
            }
        }
    }

    public final String getMcfPassword() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMcfPassword");
        }
        String string = null;
        try {
            string = PasswordUtil.encode(String.valueOf(this.mcfPassword));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.JMSManagedSessionFactory.getMcfPassword", "826", this);
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMcfPassword", string);
            }
        }
        return string;
    }

    public final void setMcfConnectorName(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMcfConnectorName", string);
        }
        this.mcfConnectorName = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMcfConnectorName");
        }
    }

    public final String getMcfConnectorName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMcfConnectorName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMcfConnectorName", this.mcfConnectorName);
        }
        return this.mcfConnectorName;
    }

    public final Properties getDataSourceProperties() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDataSourceProperties");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDataSourceProperties", this.mcfDsProperties);
        }
        return this.mcfDsProperties;
    }

    public final void setMcfClassname(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMcfClassname", string);
        }
        this.mcfClassname = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMcfClassname");
        }
    }

    public final String getMcfClassname() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMcfClassname");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMcfClassname", this.mcfClassname);
        }
        return this.mcfClassname;
    }

    public final void setMcfObjectType(Integer n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMcfObjectType", n);
        }
        this.mcfObjectType = n;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMcfObjectType");
        }
    }

    public final Integer getMcfObjectType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMcfObjectType");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMcfObjectType", this.mcfObjectType);
        }
        return this.mcfObjectType;
    }

    public final void setMcfProviderURL(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMcfProviderURL", string);
        }
        this.mcfProviderURL = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMcfProviderURL");
        }
    }

    public final String getMcfProviderURL() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMcfProviderURL");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMcfProviderURL", this.mcfProviderURL);
        }
        return this.mcfProviderURL;
    }

    public final void setMcfContextFactoryClassname(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMcfContextFactoryClassname", string);
        }
        this.mcfContextFactoryClassname = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMcfContextFactoryClassname");
        }
    }

    public final String getMcfContextFactoryClassname() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMcfContextFactoryClassname");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMcfContextFactoryClassname", this.mcfContextFactoryClassname);
        }
        return this.mcfContextFactoryClassname;
    }

    public final void setMcfJndiPath(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMcfJndiPath", string);
        }
        this.mcfJndiPath = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMcfJndiPath");
        }
    }

    public final String getMcfJndiPath() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMcfJndiPath");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMcfJndiPath", this.mcfJndiPath);
        }
        return this.mcfJndiPath;
    }

    private void createMCF() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMCF");
        }
        try {
            Properties properties = new Properties();
            properties.setProperty("name", this.mcfConnectorName);
            properties.setProperty("managedConnectionFactoryClass", this.mcfClassname);
            properties.setProperty("transactionSupport", TransactionSupportKind.NO_TRANSACTION_LITERAL.getName());
            properties.setProperty("authMechanismPreference", ConnectionFactoryRefBuilder.AUTH_MECH_PREF_BASIC_PASSWORD.toString());
            properties.setProperty(ConnectionFactoryRefBuilder.SECURITY_BasicPassword, CREDENTIAL_INTERFACE);
            ConnectorProperties connectorProperties = new ConnectorProperties();
            connectorProperties.add(new ConnectorProperty("ConnectorName", STRING_TYPE, this.mcfConnectorName));
            if (this.mcfUserName != null) {
                connectorProperties.add(new ConnectorProperty("UserName", STRING_TYPE, this.mcfUserName));
            }
            if (this.mcfPassword != null) {
                connectorProperties.add(new ConnectorProperty("Password", STRING_TYPE, this.mcfPassword));
            }
            if (this.mcfClassname.equals("com.ibm.ejs.jms.WSJMSManagedQueueConnectionFactory") || this.mcfClassname.equals("com.ibm.ejs.jms.WSJMSManagedTopicConnectionFactory") || this.mcfClassname.equals("com.ibm.ejs.jms.WSJMSManagedConnectionFactory")) {
                connectorProperties.add(new ConnectorProperty(OBJECTTYPE, INTEGER_TYPE, String.valueOf(this.mcfObjectType)));
            } else {
                connectorProperties.add(new ConnectorProperty("ProviderURL", STRING_TYPE, this.mcfProviderURL));
                connectorProperties.add(new ConnectorProperty("ContextFactoryClassname", STRING_TYPE, this.mcfContextFactoryClassname));
                connectorProperties.add(new ConnectorProperty("JNDIPath", STRING_TYPE, this.mcfJndiPath));
            }
            ConnectionFactoryBuilder connectionFactoryBuilder = ConnectionFactoryBuilderFactory.create();
            this.sslRepertoire = (String)this.mcfDsProperties.remove("ssl.repertoire");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ssl repertoire is: " + this.sslRepertoire);
                Tr.debug(tc, "Datasource properties in transaction recovery process are: " + this.mcfDsProperties);
            }
            JMSConnectionFactoryHandle jMSConnectionFactoryHandle = (JMSConnectionFactoryHandle)connectionFactoryBuilder.getConnectionFactory(properties, this.mcfDsProperties, connectorProperties, 1, 0, 1);
            this.managedConnectionFactory = (JMSManagedConnectionFactory)jMSConnectionFactoryHandle.getManagedConnectionFactory();
            if (this.mcfUserName != null) {
                char[] cArray = this.mcfPassword == null ? new char[]{} : this.mcfPassword.toCharArray();
                this.passwordCredential = new PasswordCredential(this.mcfUserName, cArray);
            } else {
                this.passwordCredential = null;
            }
            if (this.managedConnectionFactory instanceof WSJMSManagedConnectionFactory) {
                ((WSJMSManagedConnectionFactory)this.managedConnectionFactory).setSSLRepertoire(this.sslRepertoire);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.JMSManagedSessionFactory.createMCF", "1147", this);
            ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("Failed to create JMSManagedConnectionFactory for recovery");
            resourceAdapterInternalException.setLinkedException(exception);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to create JMSManagedConnectionFactory for recovery", resourceAdapterInternalException);
            }
            throw resourceAdapterInternalException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "managedConnectionFactory", this.managedConnectionFactory);
                Tr.exit(tc, "createMCF");
            }
        }
    }
}

