/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSManagedConnection;
import com.ibm.ejs.jms.JMSManagedConnectionFactory;
import com.ibm.ejs.jms.JMSManagedTopicSessionFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.TopicConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.resource.ResourceException;
import javax.resource.spi.security.PasswordCredential;

public final class JMSManagedTopicConnection
extends JMSManagedConnection {
    private static final TraceComponent tc = Tr.register(JMSManagedTopicConnection.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private static final String MANAGED_SESSION_FACTORY_CLASS_NAME = JMSManagedTopicSessionFactory.class.getName();

    JMSManagedTopicConnection(JMSManagedConnectionFactory jMSManagedConnectionFactory, PasswordCredential passwordCredential, boolean bl) throws ResourceException {
        super(jMSManagedConnectionFactory, passwordCredential, bl, Boolean.FALSE);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSManagedTopicConnection", new Object[]{jMSManagedConnectionFactory, passwordCredential, new Boolean(bl)});
            Tr.exit(tc, "JMSManagedTopicConnection");
        }
    }

    public String[] introspectSelf() {
        String string = System.getProperty("line.separator") + "\t";
        String[] stringArray = super.introspectSelf();
        String[] stringArray2 = new String[stringArray.length + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[stringArray.length] = string + "MANAGED_SESSION_FACTORY_CLASS_NAME = " + MANAGED_SESSION_FACTORY_CLASS_NAME;
        return stringArray2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Connection createConnection(ConnectionFactory connectionFactory) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConnection", connectionFactory);
        }
        XATopicConnection xATopicConnection = null;
        try {
            if (connectionFactory instanceof XATopicConnectionFactory) {
                this.xaCapable = true;
                XATopicConnectionFactory xATopicConnectionFactory = (XATopicConnectionFactory)connectionFactory;
                xATopicConnection = xATopicConnectionFactory.createXATopicConnection();
            } else {
                this.xaCapable = false;
                TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)connectionFactory;
                xATopicConnection = topicConnectionFactory.createTopicConnection();
            }
        }
        catch (ClassCastException classCastException) {
            try {
                FFDCFilter.processException((Throwable)classCastException, "com.ibm.ejs.jms.JMSManagedTopicConnection.createConnection", "124", this);
                throw JMSCMUtils.mapToResourceException(classCastException, tc, "Expected TopicConnectionFactory");
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedTopicConnection.createConnection", "129", this);
                    if (jMSException.getLinkedException() == null) throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), tc, "JMSException in createConnection");
                    FFDCFilter.processException((Throwable)jMSException.getLinkedException(), "com.ibm.ejs.jms.JMSManagedTopicConnection.createConnection", "132", this);
                    throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), tc, "JMSException in createConnection");
                }
            }
            catch (Throwable throwable) {
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "createConnection", xATopicConnection);
                throw throwable;
            }
        }
        if (!tc.isEntryEnabled()) return xATopicConnection;
        Tr.exit(tc, "createConnection", xATopicConnection);
        return xATopicConnection;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Connection createConnection(ConnectionFactory connectionFactory, String string, String string2) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConnection", new Object[]{connectionFactory, string, "password not traced"});
        }
        XATopicConnection xATopicConnection = null;
        try {
            if (connectionFactory instanceof XATopicConnectionFactory) {
                this.xaCapable = true;
                XATopicConnectionFactory xATopicConnectionFactory = (XATopicConnectionFactory)connectionFactory;
                xATopicConnection = xATopicConnectionFactory.createXATopicConnection(string, string2);
            } else {
                this.xaCapable = false;
                TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)connectionFactory;
                xATopicConnection = topicConnectionFactory.createTopicConnection(string, string2);
            }
        }
        catch (ClassCastException classCastException) {
            try {
                FFDCFilter.processException((Throwable)classCastException, "com.ibm.ejs.jms.JMSManagedTopicConnection.createConnection", "190", this);
                throw JMSCMUtils.mapToResourceException(classCastException, tc, "Expected TopicConnectionFactory");
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedTopicConnection.createConnection", "195", this);
                    throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), tc, "createTopicConnection failed");
                }
            }
            catch (Throwable throwable) {
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "createConnection", xATopicConnection);
                throw throwable;
            }
        }
        if (!tc.isEntryEnabled()) return xATopicConnection;
        Tr.exit(tc, "createConnection", xATopicConnection);
        return xATopicConnection;
    }

    protected String getManagedSessionFactoryClassName() {
        return MANAGED_SESSION_FACTORY_CLASS_NAME;
    }
}

