/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSManagedSession;
import com.ibm.ejs.jms.JMSManagedTopicSessionFactory;
import com.ibm.ejs.jms.JMSSessionHandle;
import com.ibm.ejs.jms.JMSSessionRequestInfo;
import com.ibm.ejs.jms.JMSTopicSessionHandle;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;

final class JMSManagedTopicSession
extends JMSManagedSession {
    private static final TraceComponent tc = Tr.register(JMSManagedTopicSession.class, "Messaging", JMSCMUtils.MSG_BUNDLE);

    JMSManagedTopicSession(JMSManagedTopicSessionFactory jMSManagedTopicSessionFactory, JMSSessionRequestInfo jMSSessionRequestInfo) throws ResourceException {
        super(jMSManagedTopicSessionFactory, jMSSessionRequestInfo);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSManagedTopicSession", new Object[]{jMSManagedTopicSessionFactory, jMSSessionRequestInfo});
            Tr.exit(tc, "JMSManagedTopicSession");
        }
    }

    protected JMSSessionHandle createSessionHandle(ConnectionRequestInfo connectionRequestInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSessionHandle");
        }
        JMSTopicSessionHandle jMSTopicSessionHandle = new JMSTopicSessionHandle(connectionRequestInfo, this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSessionHandle", jMSTopicSessionHandle);
        }
        return jMSTopicSessionHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session createSession(Connection connection, boolean bl, int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSession", new Object[]{connection, new Boolean(bl), new Integer(n)});
        }
        TopicSession topicSession = null;
        try {
            topicSession = ((TopicConnection)connection).createTopicSession(bl, n);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSession", topicSession);
            }
        }
        return topicSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XASession createXASession(XAConnection xAConnection) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createXASession", xAConnection);
        }
        XATopicSession xATopicSession = null;
        try {
            xATopicSession = ((XATopicConnection)xAConnection).createXATopicSession();
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createXASession", xATopicSession);
            }
        }
        return xATopicSession;
    }
}

