/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSCloseable;
import com.ibm.ejs.jms.JMSRequestMetrics;
import com.ibm.ejs.jms.JMSSessionHandle;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;

class JMSMessageConsumerHandle
implements MessageConsumer,
JMSCloseable,
Serializable {
    private static final long serialVersionUID = 5338766940183645083L;
    private static final TraceComponent tc = Tr.register(JMSMessageConsumerHandle.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private JMSSessionHandle sessionHandle;
    protected String messageSelector = null;
    private boolean closed = false;
    private Destination destination;
    private MessageConsumer messageConsumer;
    private Boolean noLocal = null;

    JMSMessageConsumerHandle(JMSSessionHandle jMSSessionHandle, Destination destination) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSMessageConsumerHandle", new Object[]{jMSSessionHandle, destination});
        }
        try {
            this.sessionHandle = jMSSessionHandle;
            this.destination = destination;
            Session session = jMSSessionHandle.getOpenUnifiedSession();
            try {
                this.messageConsumer = session.createConsumer(destination);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            this.sessionHandle.addChild(this);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageConsumerHandle.JMSMessageConsumerHandle", "112", this);
            JMSCMUtils.trace(tc, "JMSMessageConsumerHandle", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "JMSMessageConsumerHandle");
            }
        }
    }

    JMSMessageConsumerHandle(JMSSessionHandle jMSSessionHandle, Destination destination, String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSMessageConsumerHandle", new Object[]{jMSSessionHandle, destination, string});
        }
        try {
            this.sessionHandle = jMSSessionHandle;
            this.destination = destination;
            this.messageSelector = string;
            Session session = jMSSessionHandle.getOpenUnifiedSession();
            try {
                this.messageConsumer = session.createConsumer(destination, string);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (InvalidSelectorException invalidSelectorException) {
                throw invalidSelectorException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            jMSSessionHandle.addChild(this);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageConsumerHandle.JMSMessageConsumerHandle", "124", this);
            JMSCMUtils.trace(tc, "JMSMessageConsumerHandle", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "JMSMessageConsumerHandle");
            }
        }
    }

    JMSMessageConsumerHandle(JMSSessionHandle jMSSessionHandle, Destination destination, String string, boolean bl) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSMessageConsumerHandle", new Object[]{jMSSessionHandle, destination, string, new Boolean(bl)});
        }
        try {
            this.sessionHandle = jMSSessionHandle;
            this.destination = destination;
            this.messageSelector = string;
            this.noLocal = new Boolean(bl);
            Session session = jMSSessionHandle.getOpenUnifiedSession();
            try {
                this.messageConsumer = session.createConsumer(destination, string, bl);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (InvalidSelectorException invalidSelectorException) {
                throw invalidSelectorException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            jMSSessionHandle.addChild(this);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageConsumerHandle.JMSMessageConsumerHandle", "247", this);
            JMSCMUtils.trace(tc, "JMSMessageConsumerHandle", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "JMSMessageConsumerHandle");
            }
        }
    }

    JMSMessageConsumerHandle(JMSSessionHandle jMSSessionHandle) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSMessageConsumerHandle", jMSSessionHandle);
        }
        this.sessionHandle = jMSSessionHandle;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JMSMessageConsumerHandle");
        }
    }

    JMSMessageConsumerHandle(JMSSessionHandle jMSSessionHandle, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSMessageConsumerHandle", new Object[]{jMSSessionHandle, string});
        }
        this.messageSelector = string;
        this.sessionHandle = jMSSessionHandle;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JMSMessageConsumerHandle");
        }
    }

    public final String getMessageSelector() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessageSelector");
        }
        String string = null;
        try {
            MessageConsumer messageConsumer = this.getOpenMessageConsumer();
            string = messageConsumer.getMessageSelector();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageConsumerHandle.getMessageSelector", "125", this);
            JMSCMUtils.trace(tc, "getMessageSelector", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMessageSelector", string);
            }
        }
        return string;
    }

    public final MessageListener getMessageListener() throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessageListener");
        }
        try {
            throw JMSCMUtils.methodNotPermittedException(tc, "getMessageListener");
        }
        catch (Throwable throwable) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMessageListener", null);
            }
            throw throwable;
        }
    }

    public final void setMessageListener(MessageListener messageListener) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMessageListener", messageListener);
        }
        try {
            throw JMSCMUtils.methodNotPermittedException(tc, "setMessageListener");
        }
        catch (Throwable throwable) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setMessageListener");
            }
            throw throwable;
        }
    }

    public final Message receive() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receive");
        }
        Message message = null;
        try {
            MessageConsumer messageConsumer = this.getOpenMessageConsumer();
            try {
                this.enlist();
                boolean bl = this.sessionHandle.isMQSession();
                boolean bl2 = JMSRequestMetrics.isRMEnabled(JMSRequestMetrics.JMS_COMPONENT_ID);
                Object object = null;
                if (bl && bl2) {
                    object = this.syncConsumeMessageBlock("receive ()");
                }
                boolean bl3 = true;
                try {
                    message = messageConsumer.receive();
                }
                catch (JMSException jMSException) {
                    bl3 = false;
                    throw jMSException;
                }
                finally {
                    if (bl && bl2) {
                        this.syncConsumeMessageUnblock(bl3, message, object);
                    }
                }
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            try {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageConsumerHandle.receive", "221", this);
                JMSCMUtils.trace(tc, "receive", jMSException);
                throw jMSException;
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "receive", message);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive", message);
        }
        return message;
    }

    public final Message receive(long l) throws IllegalStateException, JMSException {
        return this.receive(l, true);
    }

    protected final Message receiveWithoutEnlist(long l) throws IllegalStateException, JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "receiveWithoutEnlist", new Long(l));
        }
        Message message = this.receive(l, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "receiveWithoutEnlist", message);
        }
        return message;
    }

    private final Message receive(long l, boolean bl) throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receive", new Object[]{new Long(l), bl});
        }
        Message message = null;
        try {
            MessageConsumer messageConsumer = this.getOpenMessageConsumer();
            try {
                if (bl) {
                    this.enlist();
                }
                boolean bl2 = this.sessionHandle.isMQSession();
                boolean bl3 = JMSRequestMetrics.isRMEnabled(JMSRequestMetrics.JMS_COMPONENT_ID);
                Object object = null;
                if (bl2 && bl3) {
                    object = this.syncConsumeMessageBlock("receive (long)");
                }
                boolean bl4 = true;
                try {
                    message = messageConsumer.receive(l);
                }
                catch (JMSException jMSException) {
                    bl4 = false;
                    throw jMSException;
                }
                finally {
                    if (bl2 && bl3) {
                        this.syncConsumeMessageUnblock(bl4, message, object);
                    }
                }
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            try {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageConsumerHandle.receive", "264", this);
                JMSCMUtils.trace(tc, "receive", jMSException);
                throw jMSException;
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "receive", message);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive", message);
        }
        return message;
    }

    public final Message receiveNoWait() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receiveNoWait");
        }
        Message message = null;
        try {
            MessageConsumer messageConsumer = this.getOpenMessageConsumer();
            try {
                this.enlist();
                boolean bl = this.sessionHandle.isMQSession();
                boolean bl2 = JMSRequestMetrics.isRMEnabled(JMSRequestMetrics.JMS_COMPONENT_ID);
                Object object = null;
                if (bl && bl2) {
                    object = this.syncConsumeMessageBlock("receiveNoWait ()");
                }
                boolean bl3 = true;
                try {
                    message = messageConsumer.receiveNoWait();
                }
                catch (JMSException jMSException) {
                    bl3 = false;
                    throw jMSException;
                }
                finally {
                    if (bl && bl2) {
                        this.syncConsumeMessageUnblock(bl3, message, object);
                    }
                }
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            try {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageConsumerHandle.receiveNoWait", "304", this);
                JMSCMUtils.trace(tc, "receiveNoWait", jMSException);
                throw jMSException;
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "receiveNoWait", message);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receiveNoWait", message);
        }
        return message;
    }

    public void close() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close");
        }
        try {
            MessageConsumer messageConsumer = this.getMessageConsumer();
            if (messageConsumer != null) {
                messageConsumer.close();
            }
            this.sessionHandle.removeChild(this);
            this.closed = true;
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageConsumerHandle.close", "347", this);
            JMSCMUtils.trace(tc, "close", jMSException);
            this.markManagedObjectsAsStale(jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "close");
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JMSMessageConsumerHandle jMSMessageConsumerHandle = (JMSMessageConsumerHandle)object;
        if (!JMSCMUtils.objectsEqual(this.sessionHandle, jMSMessageConsumerHandle.sessionHandle)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.messageSelector, jMSMessageConsumerHandle.messageSelector)) {
            return false;
        }
        return this.closed == jMSMessageConsumerHandle.closed;
    }

    public int hashCode() {
        int n = this.closed ? -1 : 1;
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.sessionHandle);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.messageSelector);
        return n;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(JMSCMUtils.objectToString(this));
        stringBuffer.append(string + "session handle = " + JMSCMUtils.objectToString(this.sessionHandle));
        stringBuffer.append(string + "message selector = " + this.messageSelector);
        stringBuffer.append(string + "closed = " + this.closed);
        return stringBuffer.toString();
    }

    protected final void checkOpen() throws IllegalStateException {
        if (this.closed) {
            IllegalStateException illegalStateException = new IllegalStateException("Consumer closed");
            throw illegalStateException;
        }
    }

    protected final void enlist() throws JMSException {
        this.sessionHandle.getManagedSession().enlist();
    }

    protected MessageConsumer getMessageConsumer() {
        return this.messageConsumer;
    }

    protected MessageConsumer getOpenMessageConsumer() throws IllegalStateException, JMSException {
        this.checkOpen();
        if (this.messageConsumer == null) {
            Session session = this.sessionHandle.getOpenUnifiedSession();
            try {
                this.messageConsumer = this.messageSelector == null ? session.createConsumer(this.destination) : (this.noLocal == null ? session.createConsumer(this.destination, this.messageSelector) : session.createConsumer(this.destination, this.messageSelector, this.noLocal.booleanValue()));
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (InvalidSelectorException invalidSelectorException) {
                throw invalidSelectorException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        return this.messageConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
        try {
            if (this.messageConsumer != null) {
                this.messageConsumer.close();
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageConsumerHandle.reset", "736", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Failed to close MessageConsumer during reset", (Object)jMSException);
            }
            this.markManagedObjectsAsStale(jMSException);
        }
        finally {
            this.messageConsumer = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "reset");
            }
        }
    }

    final void markManagedObjectsAsStale(JMSException jMSException) {
        this.sessionHandle.markManagedObjectsAsStale(jMSException);
    }

    private Object syncConsumeMessageBlock(String string) throws JMSException {
        String[] stringArray = new String[]{this.getClass().getName(), string};
        return JMSRequestMetrics.syncConsumeMessageBlock(stringArray);
    }

    private void syncConsumeMessageUnblock(boolean bl, Message message, Object object) throws JMSException {
        Properties properties = new Properties();
        int n = JMSRequestMetrics.getTransactionTraceLevel(JMSRequestMetrics.JMS_COMPONENT_ID);
        if (n == 2) {
            properties = JMSRequestMetrics.getBasicOutboundTrace(message, this.sessionHandle.getMQQueueManagerName());
        } else if (n == 3) {
            properties = JMSRequestMetrics.getExtendedOutboundTrace(message, this.sessionHandle.getMQQueueManagerName(), null);
        }
        JMSRequestMetrics.syncConsumeMessageUnblock(object, bl ? 0 : 2, properties);
    }

    protected String getDestinationName() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDestinationName");
        }
        String string = null;
        if (this.destination instanceof Queue) {
            string = ((Queue)this.destination).getQueueName();
        } else if (this.destination instanceof Topic) {
            string = ((Topic)this.destination).getTopicName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDestinationName", string);
        }
        return string;
    }
}

