/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSCloseable;
import com.ibm.ejs.jms.JMSRequestMetrics;
import com.ibm.ejs.jms.JMSSessionHandle;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;

class JMSMessageProducerHandle
implements MessageProducer,
JMSCloseable,
Serializable {
    private static final long serialVersionUID = 7848397831579234901L;
    private static final TraceComponent tc = Tr.register(JMSMessageProducerHandle.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private JMSSessionHandle sessionHandle;
    private Boolean disableMessageID = null;
    private Boolean disableMessageTimestamp = null;
    private Integer deliveryMode = null;
    private Integer priority = null;
    private Long timeToLive = null;
    private boolean closed = false;
    private Destination destination;
    private MessageProducer messageProducer;

    JMSMessageProducerHandle(JMSSessionHandle jMSSessionHandle, Destination destination) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSMessageProducerHandle", new Object[]{jMSSessionHandle, destination});
        }
        try {
            this.sessionHandle = jMSSessionHandle;
            this.destination = destination;
            Session session = jMSSessionHandle.getOpenUnifiedSession();
            try {
                this.messageProducer = session.createProducer(destination);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            this.sessionHandle.addChild(this);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.JMSMessageProducerHandle", "139", this);
            JMSCMUtils.trace(tc, "JMSMessageProducerHandle", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "JMSMessageProducerHandle");
            }
        }
    }

    JMSMessageProducerHandle(JMSSessionHandle jMSSessionHandle) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSMessageProducerHandle", jMSSessionHandle);
        }
        this.sessionHandle = jMSSessionHandle;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JMSMessageProducerHandle");
        }
    }

    public void setDisableMessageID(boolean bl) throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDisableMessageID", new Boolean(bl));
        }
        try {
            MessageProducer messageProducer = this.getOpenMessageProducer();
            messageProducer.setDisableMessageID(bl);
            this.disableMessageID = new Boolean(bl);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.setDisableMessageID", "118", this);
            JMSCMUtils.trace(tc, "setDisableMessageID", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setDisableMessageID");
            }
        }
    }

    public boolean getDisableMessageID() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDisableMessageID");
        }
        boolean bl = false;
        try {
            MessageProducer messageProducer = this.getOpenMessageProducer();
            bl = messageProducer.getDisableMessageID();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.getDisableMessageID", "154", this);
            JMSCMUtils.trace(tc, "getDisableMessageID", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDisableMessageID", new Boolean(bl));
            }
        }
        return bl;
    }

    public void setDisableMessageTimestamp(boolean bl) throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDisableMessageTimestamp", new Boolean(bl));
        }
        try {
            MessageProducer messageProducer = this.getOpenMessageProducer();
            messageProducer.setDisableMessageTimestamp(bl);
            this.disableMessageTimestamp = new Boolean(bl);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.setDisableMessageTimestamp", "192", this);
            JMSCMUtils.trace(tc, "setDisableMessageTimestamp", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setDisableMessageTimestamp");
            }
        }
    }

    public boolean getDisableMessageTimestamp() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDisableMessageTimestamp");
        }
        boolean bl = false;
        try {
            MessageProducer messageProducer = this.getOpenMessageProducer();
            bl = messageProducer.getDisableMessageTimestamp();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.getDisableMessageTimestamp", "228", this);
            JMSCMUtils.trace(tc, "getDisableMessageTimestamp", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDisableMessageTimestamp", new Boolean(bl));
            }
        }
        return bl;
    }

    public void setDeliveryMode(int n) throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDeliveryMode", new Integer(n));
        }
        try {
            MessageProducer messageProducer = this.getOpenMessageProducer();
            messageProducer.setDeliveryMode(n);
            this.deliveryMode = new Integer(n);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.setDeliveryMode", "269", this);
            JMSCMUtils.trace(tc, "setDeliveryMode", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setDeliveryMode");
            }
        }
    }

    public int getDeliveryMode() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeliveryMode");
        }
        int n = 0;
        try {
            MessageProducer messageProducer = this.getOpenMessageProducer();
            n = messageProducer.getDeliveryMode();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.getDeliveryMode", "305", this);
            JMSCMUtils.trace(tc, "getDeliveryMode", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDeliveryMode", new Integer(n));
            }
        }
        return n;
    }

    public void setPriority(int n) throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPriority", new Integer(n));
        }
        try {
            MessageProducer messageProducer = this.getOpenMessageProducer();
            messageProducer.setPriority(n);
            this.priority = new Integer(n);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.setPriority", "344", this);
            JMSCMUtils.trace(tc, "setPriority", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setPriority");
            }
        }
    }

    public int getPriority() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPriority");
        }
        int n = 0;
        try {
            MessageProducer messageProducer = this.getOpenMessageProducer();
            n = messageProducer.getPriority();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.getPriority", "380", this);
            JMSCMUtils.trace(tc, "getPriority", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPriority", new Integer(n));
            }
        }
        return n;
    }

    public void setTimeToLive(long l) throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTimeToLive", new Long(l));
        }
        try {
            MessageProducer messageProducer = this.getOpenMessageProducer();
            messageProducer.setTimeToLive(l);
            this.timeToLive = new Long(l);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.setTimeToLive", "420", this);
            JMSCMUtils.trace(tc, "setTimeToLive", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setTimeToLive");
            }
        }
    }

    public long getTimeToLive() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimeToLive");
        }
        long l = 0L;
        try {
            MessageProducer messageProducer = this.getOpenMessageProducer();
            l = messageProducer.getTimeToLive();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.getTimeToLive", "457", this);
            JMSCMUtils.trace(tc, "getTimeToLive", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTimeToLive", new Long(l));
            }
        }
        return l;
    }

    public void close() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close");
        }
        try {
            MessageProducer messageProducer = this.getMessageProducer();
            if (messageProducer != null) {
                messageProducer.close();
            }
            this.sessionHandle.removeChild(this);
            this.closed = true;
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.close", "500", this);
            JMSCMUtils.trace(tc, "close", jMSException);
            this.markManagedObjectsAsStale(jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "close");
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JMSMessageProducerHandle jMSMessageProducerHandle = (JMSMessageProducerHandle)object;
        if (!JMSCMUtils.objectsEqual(this.sessionHandle, jMSMessageProducerHandle.sessionHandle)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.disableMessageID, jMSMessageProducerHandle.disableMessageID)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.disableMessageTimestamp, jMSMessageProducerHandle.disableMessageTimestamp)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.deliveryMode, jMSMessageProducerHandle.deliveryMode)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.priority, jMSMessageProducerHandle.priority)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.timeToLive, jMSMessageProducerHandle.timeToLive)) {
            return false;
        }
        return this.closed == jMSMessageProducerHandle.closed;
    }

    public int hashCode() {
        int n = this.closed ? -1 : 1;
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.sessionHandle);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.disableMessageID);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.disableMessageTimestamp);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.deliveryMode);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.priority);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.timeToLive);
        return n;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(JMSCMUtils.objectToString(this));
        stringBuffer.append(string + "session handle = " + JMSCMUtils.objectToString(this.sessionHandle));
        stringBuffer.append(string + "message ID disabled = " + this.disableMessageID);
        stringBuffer.append(string + "message timestamp disabled = " + this.disableMessageTimestamp);
        stringBuffer.append(string + "delivery mode = ");
        if (this.deliveryMode == null) {
            stringBuffer.append("null");
        } else {
            switch (this.deliveryMode) {
                case 2: {
                    stringBuffer.append("PERSISTENT");
                    break;
                }
                case 1: {
                    stringBuffer.append("NON_PERSISTENT");
                }
            }
        }
        stringBuffer.append(string + "priority = " + this.priority);
        stringBuffer.append(string + "time to live = " + this.timeToLive);
        stringBuffer.append(string + "closed = " + this.closed);
        return stringBuffer.toString();
    }

    protected void checkOpen() throws IllegalStateException {
        if (this.closed) {
            IllegalStateException illegalStateException = new IllegalStateException("Producer closed");
            throw illegalStateException;
        }
    }

    protected void initialiseMessageProducer() throws JMSException {
        try {
            MessageProducer messageProducer = this.getMessageProducer();
            if (messageProducer != null) {
                if (this.disableMessageID != null) {
                    messageProducer.setDisableMessageID(this.disableMessageID.booleanValue());
                }
                if (this.disableMessageTimestamp != null) {
                    messageProducer.setDisableMessageTimestamp(this.disableMessageTimestamp.booleanValue());
                }
                if (this.deliveryMode != null) {
                    messageProducer.setDeliveryMode(this.deliveryMode.intValue());
                }
                if (this.priority != null) {
                    messageProducer.setPriority(this.priority.intValue());
                }
                if (this.timeToLive != null) {
                    messageProducer.setTimeToLive(this.timeToLive.longValue());
                }
            }
        }
        catch (JMSException jMSException) {
            this.markManagedObjectsAsStale(jMSException);
            throw jMSException;
        }
    }

    protected void enlist() throws JMSException {
        this.sessionHandle.getManagedSession().enlist();
    }

    protected MessageProducer getMessageProducer() {
        return this.messageProducer;
    }

    protected MessageProducer getOpenMessageProducer() throws IllegalStateException, JMSException {
        this.checkOpen();
        if (this.messageProducer == null) {
            Session session = this.sessionHandle.getOpenUnifiedSession();
            try {
                this.messageProducer = session.createProducer(this.destination);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            this.initialiseMessageProducer();
        }
        return this.messageProducer;
    }

    final void markManagedObjectsAsStale(JMSException jMSException) {
        this.sessionHandle.markManagedObjectsAsStale(jMSException);
    }

    public Destination getDestination() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQueue");
        }
        Destination destination = null;
        try {
            MessageProducer messageProducer = this.getOpenMessageProducer();
            destination = messageProducer.getDestination();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.getDestination", "852", this);
            JMSCMUtils.trace(tc, "getDestination", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDestination", destination);
            }
        }
        return destination;
    }

    public void send(Destination destination, Message message, int n, int n2, long l) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send", new Object[]{destination, message, new Integer(n), new Integer(n2), new Long(l)});
        }
        try {
            MessageProducer messageProducer = this.getOpenMessageProducer();
            try {
                this.enlist();
                boolean bl = this.sessionHandle.isMQSession();
                boolean bl2 = JMSRequestMetrics.isRMEnabled(JMSRequestMetrics.JMS_COMPONENT_ID);
                Object object = null;
                if (bl && bl2) {
                    object = this.produceMessageBlock("send (Destination, Message, int, int, long)");
                }
                boolean bl3 = true;
                try {
                    messageProducer.send(destination, message, n, n2, l);
                }
                catch (JMSException jMSException) {
                    bl3 = false;
                    throw jMSException;
                }
                finally {
                    if (bl && bl2) {
                        this.produceMessageUnblock(bl3, message, object, "" + l);
                    }
                }
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (MessageFormatException messageFormatException) {
                throw messageFormatException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.send", "912", this);
            JMSCMUtils.trace(tc, "send", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "send");
            }
        }
    }

    public void send(Destination destination, Message message) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send", new Object[]{destination, message});
        }
        try {
            MessageProducer messageProducer = this.getOpenMessageProducer();
            try {
                this.enlist();
                boolean bl = this.sessionHandle.isMQSession();
                boolean bl2 = JMSRequestMetrics.isRMEnabled(JMSRequestMetrics.JMS_COMPONENT_ID);
                Object object = null;
                if (bl && bl2) {
                    object = this.produceMessageBlock("send (Destination, Message)");
                }
                boolean bl3 = true;
                try {
                    messageProducer.send(destination, message);
                }
                catch (JMSException jMSException) {
                    bl3 = false;
                    throw jMSException;
                }
                finally {
                    if (bl && bl2) {
                        this.produceMessageUnblock(bl3, message, object);
                    }
                }
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (MessageFormatException messageFormatException) {
                throw messageFormatException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProdcuerHandle.send", "965", this);
            JMSCMUtils.trace(tc, "send", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "send");
            }
        }
    }

    public void send(Message message, int n, int n2, long l) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send", new Object[]{message, new Integer(n), new Integer(n2), new Long(l)});
        }
        try {
            MessageProducer messageProducer = this.getOpenMessageProducer();
            try {
                this.enlist();
                boolean bl = this.sessionHandle.isMQSession();
                boolean bl2 = JMSRequestMetrics.isRMEnabled(JMSRequestMetrics.JMS_COMPONENT_ID);
                Object object = null;
                if (bl && bl2) {
                    object = this.produceMessageBlock("send (Message, int, int , long)");
                }
                boolean bl3 = true;
                try {
                    messageProducer.send(message, n, n2, l);
                }
                catch (JMSException jMSException) {
                    bl3 = false;
                    throw jMSException;
                }
                finally {
                    if (bl && bl2) {
                        this.produceMessageUnblock(bl3, message, object, "" + l);
                    }
                }
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (MessageFormatException messageFormatException) {
                throw messageFormatException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.send", "1023", this);
            JMSCMUtils.trace(tc, "send", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "send");
            }
        }
    }

    public void send(Message message) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send", message);
        }
        try {
            MessageProducer messageProducer = this.getOpenMessageProducer();
            try {
                this.enlist();
                boolean bl = this.sessionHandle.isMQSession();
                boolean bl2 = JMSRequestMetrics.isRMEnabled(JMSRequestMetrics.JMS_COMPONENT_ID);
                Object object = null;
                if (bl && bl2) {
                    object = this.produceMessageBlock("send (Message)");
                }
                boolean bl3 = true;
                try {
                    messageProducer.send(message);
                }
                catch (JMSException jMSException) {
                    bl3 = false;
                    throw jMSException;
                }
                finally {
                    if (bl && bl2) {
                        this.produceMessageUnblock(bl3, message, object);
                    }
                }
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (MessageFormatException messageFormatException) {
                throw messageFormatException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.send", "1075", this);
            JMSCMUtils.trace(tc, "send", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "send");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
        try {
            if (this.messageProducer != null) {
                this.messageProducer.close();
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.reset", "1104", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Failed to close MessageProducer during reset", (Object)jMSException);
            }
            this.markManagedObjectsAsStale(jMSException);
        }
        finally {
            this.messageProducer = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "reset");
            }
        }
    }

    private Object produceMessageBlock(String string) throws JMSException {
        String[] stringArray = new String[]{this.getClass().getName(), string};
        boolean bl = this.destination instanceof Topic;
        return JMSRequestMetrics.produceMessageBlock(stringArray);
    }

    private void produceMessageUnblock(boolean bl, Message message, Object object) throws JMSException {
        this.produceMessageUnblock(bl, message, object, "" + this.timeToLive);
    }

    private void produceMessageUnblock(boolean bl, Message message, Object object, String string) throws JMSException {
        Properties properties = new Properties();
        int n = JMSRequestMetrics.getTransactionTraceLevel(JMSRequestMetrics.JMS_COMPONENT_ID);
        if (n == 2) {
            properties = JMSRequestMetrics.getBasicOutboundTrace(message, this.sessionHandle.getMQQueueManagerName());
        } else if (n == 3) {
            properties = JMSRequestMetrics.getExtendedOutboundTrace(message, this.sessionHandle.getMQQueueManagerName(), string);
        }
        JMSRequestMetrics.produceMessageUnblock(object, bl ? 0 : 2, properties);
    }
}

