/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.mq.MQEnvironment;

public final class JMSProviderUtils {
    public static final String MSG_BUNDLE = "com.ibm.ejs.jms.messaging";
    private static TraceComponent tc = Tr.register(JMSProviderUtils.class, null, "com.ibm.ejs.jms.messaging");
    public static final String QNAME_PREFIX = "WQ_";
    private static final int QNAME_OFFSET = "WQ_".length();
    private static final int MAX_QUEUE_NAME = 48 - QNAME_OFFSET;
    public static final String DATAFLOW_QUEUE = "SYSTEM.BROKER.DEFAULT.STREAM";
    public static final String QM_CHANNEL = "WAS.JMS.SVRCONN";
    public static final String JMSSERVER_NAME = "jmsserver";
    private static boolean providerIsMQJD = false;

    public static String getRealQueueName(String string) {
        String string2 = null;
        if (string.length() <= MAX_QUEUE_NAME) {
            string2 = QNAME_PREFIX + string;
        } else {
            Tr.error(tc, "QUEUE_NAME_TOO_LONG_WMSG1152", new String[]{string, String.valueOf(MAX_QUEUE_NAME)});
        }
        return string2;
    }

    public static String getWebSphereQueueName(String string) throws StringIndexOutOfBoundsException {
        if (string.startsWith(QNAME_PREFIX)) {
            string = string.substring(QNAME_OFFSET).trim();
        }
        return string;
    }

    public static boolean isProviderMQJD() {
        return providerIsMQJD;
    }

    static void setProviderIsMQJD() {
        providerIsMQJD = true;
        MQEnvironment.properties.put("transport", "MQJD");
    }
}

