/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSCloseable;
import com.ibm.ejs.jms.JMSSessionHandle;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import java.util.Enumeration;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;

public final class JMSQueueBrowserHandle
implements QueueBrowser,
JMSCloseable,
Serializable {
    private static final long serialVersionUID = -894908880461193531L;
    private static final TraceComponent tc = Tr.register(JMSQueueBrowserHandle.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private final JMSSessionHandle sessionHandle;
    private final Queue queue;
    private final String messageSelector;
    private QueueBrowser queueBrowser;
    private boolean closed = false;

    JMSQueueBrowserHandle(JMSSessionHandle jMSSessionHandle, Queue queue) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSQueueBrowserHandle", new Object[]{jMSSessionHandle, queue});
        }
        try {
            this.sessionHandle = jMSSessionHandle;
            this.queue = queue;
            this.messageSelector = null;
            Session session = jMSSessionHandle.getOpenSession();
            try {
                this.queueBrowser = session.createBrowser(queue);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            this.sessionHandle.addChild(this);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueBrowserHandle.JMSQueueBrowserHandle", "89", this);
            JMSCMUtils.trace(tc, "JMSQueueBrowserHandle", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "JMSQueueBrowserHandle");
            }
        }
    }

    JMSQueueBrowserHandle(JMSSessionHandle jMSSessionHandle, Queue queue, String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSQueueBrowserHandle", new Object[]{jMSSessionHandle, queue, string});
        }
        try {
            this.sessionHandle = jMSSessionHandle;
            this.queue = queue;
            this.messageSelector = string;
            Session session = jMSSessionHandle.getOpenSession();
            try {
                this.queueBrowser = session.createBrowser(queue, string);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (InvalidSelectorException invalidSelectorException) {
                throw invalidSelectorException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            this.sessionHandle.addChild(this);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueBrowserHandle.JMSQueueBrowserHandle", "133", this);
            JMSCMUtils.trace(tc, "JMSQueueBrowserHandle", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "JMSQueueBrowserHandle");
            }
        }
    }

    public Queue getQueue() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQueue");
        }
        Queue queue = null;
        try {
            QueueBrowser queueBrowser = this.getOpenQueueBrowser();
            try {
                queue = queueBrowser.getQueue();
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueBrowserHandle.getQueue", "168", this);
            JMSCMUtils.trace(tc, "getQueue", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getQueue", queue);
            }
        }
        return queue;
    }

    public String getMessageSelector() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessageSelector");
        }
        String string = null;
        try {
            QueueBrowser queueBrowser = this.getOpenQueueBrowser();
            try {
                string = queueBrowser.getMessageSelector();
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueBrowserHandle.getMessageSelector", "208", this);
            JMSCMUtils.trace(tc, "getMessageSelector", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMessageSelector", string);
            }
        }
        return string;
    }

    public Enumeration getEnumeration() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEnumeration");
        }
        Enumeration enumeration = null;
        try {
            QueueBrowser queueBrowser = this.getOpenQueueBrowser();
            try {
                enumeration = queueBrowser.getEnumeration();
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueBrowserHandle.getEnumeration", "246", this);
            JMSCMUtils.trace(tc, "getEnumeration", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getEnumeration", enumeration);
            }
        }
        return enumeration;
    }

    public void close() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close");
        }
        try {
            if (this.queueBrowser != null) {
                this.queueBrowser.close();
            }
            this.sessionHandle.removeChild(this);
            this.closed = true;
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueBrowserHandle.close", "287", this);
            JMSCMUtils.trace(tc, "close", jMSException);
            this.markManagedObjectsAsStale(jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "close");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
        try {
            if (this.queueBrowser != null) {
                this.queueBrowser.close();
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueBrowserHandle.reset", "318", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Failed to close QueueBrowser during reset", (Object)jMSException);
            }
            this.markManagedObjectsAsStale(jMSException);
        }
        finally {
            this.queueBrowser = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "reset");
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JMSQueueBrowserHandle jMSQueueBrowserHandle = (JMSQueueBrowserHandle)object;
        if (!JMSCMUtils.objectsEqual(this.sessionHandle, jMSQueueBrowserHandle.sessionHandle)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.queue, jMSQueueBrowserHandle.queue)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.messageSelector, jMSQueueBrowserHandle.messageSelector)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.queueBrowser, jMSQueueBrowserHandle.queueBrowser)) {
            return false;
        }
        return this.closed == jMSQueueBrowserHandle.closed;
    }

    public int hashCode() {
        int n = this.closed ? -1 : 1;
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.sessionHandle);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.queue);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.messageSelector);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.queueBrowser);
        return n;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(JMSCMUtils.objectToString(this));
        stringBuffer.append(string + "session handle = " + JMSCMUtils.objectToString(this.sessionHandle));
        stringBuffer.append(string + "message selector = " + this.messageSelector);
        stringBuffer.append(string + "closed = " + this.closed);
        stringBuffer.append(string + "queue = " + this.queue);
        stringBuffer.append(string + "physical queue browser = " + this.queueBrowser);
        return stringBuffer.toString();
    }

    protected void checkOpen() throws IllegalStateException {
        if (this.closed) {
            IllegalStateException illegalStateException = new IllegalStateException("Browser closed");
            throw illegalStateException;
        }
    }

    private QueueBrowser getOpenQueueBrowser() throws IllegalStateException, JMSException {
        this.checkOpen();
        if (this.queueBrowser == null) {
            Session session = this.sessionHandle.getOpenSession();
            try {
                this.queueBrowser = this.messageSelector == null ? session.createBrowser(this.queue) : session.createBrowser(this.queue, this.messageSelector);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (InvalidSelectorException invalidSelectorException) {
                throw invalidSelectorException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        return this.queueBrowser;
    }

    private final void markManagedObjectsAsStale(JMSException jMSException) {
        this.sessionHandle.markManagedObjectsAsStale(jMSException);
    }
}

