/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSConnectionFactoryHandle;
import com.ibm.ejs.jms.JMSConnectionRequestInfo;
import com.ibm.ejs.jms.JMSQueueConnectionHandle;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public final class JMSQueueConnectionFactoryHandle
extends JMSConnectionFactoryHandle
implements QueueConnectionFactory {
    private static final long serialVersionUID = 5568154229263480456L;
    private static final TraceComponent tc = Tr.register(JMSQueueConnectionFactoryHandle.class, "Messaging", JMSCMUtils.MSG_BUNDLE);

    JMSQueueConnectionFactoryHandle(ManagedConnectionFactory managedConnectionFactory, ConnectionManager connectionManager) {
        super(managedConnectionFactory, connectionManager);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSQueueConnectionFactoryHandle", new Object[]{managedConnectionFactory, connectionManager});
            Tr.exit(tc, "JMSQueueConnectionFactoryHandle");
        }
    }

    public QueueConnection createQueueConnection() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createQueueConnection");
        }
        JMSQueueConnectionHandle jMSQueueConnectionHandle = null;
        try {
            boolean bl = !this.restrictedMethodsEnabled;
            JMSConnectionRequestInfo jMSConnectionRequestInfo = new JMSConnectionRequestInfo(bl);
            jMSQueueConnectionHandle = (JMSQueueConnectionHandle)this.cxManager.allocateConnection(this.factory, (ConnectionRequestInfo)jMSConnectionRequestInfo);
            jMSQueueConnectionHandle.setConnectionFactoryHandle(this);
        }
        catch (ResourceException resourceException) {
            try {
                FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSQueueConnectionFactoryHandle.createQueueConnection", "83", this);
                throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create queue connection");
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createQueueConnection", jMSQueueConnectionHandle);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createQueueConnection", jMSQueueConnectionHandle);
        }
        return jMSQueueConnectionHandle;
    }

    public QueueConnection createQueueConnection(String string, String string2) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createQueueConnection", new Object[]{string, "password not traced"});
        }
        JMSQueueConnectionHandle jMSQueueConnectionHandle = null;
        try {
            boolean bl = !this.restrictedMethodsEnabled;
            JMSConnectionRequestInfo jMSConnectionRequestInfo = new JMSConnectionRequestInfo(string, string2, bl);
            jMSQueueConnectionHandle = (JMSQueueConnectionHandle)this.cxManager.allocateConnection(this.factory, (ConnectionRequestInfo)jMSConnectionRequestInfo);
            jMSQueueConnectionHandle.setConnectionFactoryHandle(this);
        }
        catch (ResourceException resourceException) {
            try {
                FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSQueueConnectionFactoryHandle.createQueueConnection", "126", this);
                throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create queue connection");
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createQueueConnection", jMSQueueConnectionHandle);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createQueueConnection", jMSQueueConnectionHandle);
        }
        return jMSQueueConnectionHandle;
    }

    public QueueConnection createNonTransactableInTranQueueConnection() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNonTransactableInTranQueueConnection");
        }
        JMSQueueConnectionHandle jMSQueueConnectionHandle = null;
        try {
            boolean bl = !this.restrictedMethodsEnabled;
            JMSConnectionRequestInfo jMSConnectionRequestInfo = new JMSConnectionRequestInfo(bl);
            jMSConnectionRequestInfo.setAllowsNonTransactedSessionsInTran(true);
            jMSQueueConnectionHandle = (JMSQueueConnectionHandle)this.cxManager.allocateConnection(this.factory, (ConnectionRequestInfo)jMSConnectionRequestInfo);
            jMSQueueConnectionHandle.setConnectionFactoryHandle(this);
        }
        catch (ResourceException resourceException) {
            try {
                FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSQueueConnectionFactoryHandle.createNonTransactableInTranQueueConnection", "83", this);
                throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create queue connection");
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createNonTransactableInTranQueueConnection", jMSQueueConnectionHandle);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNonTransactableInTranQueueConnection", jMSQueueConnectionHandle);
        }
        return jMSQueueConnectionHandle;
    }

    public QueueConnection createNonTransactableInTranQueueConnection(String string, String string2) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNonTransactableInTranQueueConnection", new Object[]{string, "password not traced"});
        }
        JMSQueueConnectionHandle jMSQueueConnectionHandle = null;
        try {
            boolean bl = !this.restrictedMethodsEnabled;
            JMSConnectionRequestInfo jMSConnectionRequestInfo = new JMSConnectionRequestInfo(string, string2, bl);
            jMSConnectionRequestInfo.setAllowsNonTransactedSessionsInTran(true);
            jMSQueueConnectionHandle = (JMSQueueConnectionHandle)this.cxManager.allocateConnection(this.factory, (ConnectionRequestInfo)jMSConnectionRequestInfo);
            jMSQueueConnectionHandle.setConnectionFactoryHandle(this);
        }
        catch (ResourceException resourceException) {
            try {
                FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSQueueConnectionFactoryHandle.createNonTransactableInTranQueueConnection", "126", this);
                throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create queue connection");
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createNonTransactableInTranQueueConnection", jMSQueueConnectionHandle);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNonTransactableInTranQueueConnection", jMSQueueConnectionHandle);
        }
        return jMSQueueConnectionHandle;
    }
}

