/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSConnectionHandle;
import com.ibm.ejs.jms.JMSListenerSessionRequestInfo;
import com.ibm.ejs.jms.JMSManagedQueueSessionFactory;
import com.ibm.ejs.jms.JMSQueueSessionHandle;
import com.ibm.ejs.jms.JMSSessionRequestInfo;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Iterator;
import javax.jms.ConnectionConsumer;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public final class JMSQueueConnectionHandle
extends JMSConnectionHandle
implements QueueConnection {
    private static final long serialVersionUID = 4542457159524167453L;
    private static final TraceComponent tc = Tr.register(JMSQueueConnectionHandle.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private transient String lockCreateConnectionConsumer = new String("createConnectionConsumer");
    private transient String lockCreateListenerQueueSession = new String("createListenerQueueSession");
    private transient String lockCreateQueueSession = new String("createQueueSession");

    JMSQueueConnectionHandle(JMSManagedQueueSessionFactory jMSManagedQueueSessionFactory, ConnectionManager connectionManager) {
        super(jMSManagedQueueSessionFactory, connectionManager);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSQueueConnectionHandle", new Object[]{jMSManagedQueueSessionFactory, connectionManager});
        }
        this.methodSyncList.add(this.lockCreateConnectionConsumer);
        this.methodSyncList.add(this.lockCreateListenerQueueSession);
        this.methodSyncList.add(this.lockCreateQueueSession);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JMSQueueConnectionHandle");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionConsumer createConnectionConsumer(Queue queue, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createConnectionConsumer", new Object[]{queue, string, serverSessionPool, new Integer(n)});
        }
        ConnectionConsumer connectionConsumer = null;
        JMSException jMSException = null;
        try {
            String string2 = this.lockCreateConnectionConsumer;
            synchronized (string2) {
                this.checkRestrictedMethod("createConnectionConsumer");
                this.checkOpen();
                this.checkValid();
                QueueConnection queueConnection = (QueueConnection)this.connection;
                try {
                    connectionConsumer = queueConnection.createConnectionConsumer(queue, string, serverSessionPool, n);
                }
                catch (InvalidDestinationException invalidDestinationException) {
                    throw invalidDestinationException;
                }
                catch (InvalidSelectorException invalidSelectorException) {
                    throw invalidSelectorException;
                }
                catch (JMSException jMSException2) {
                    jMSException = jMSException2;
                    throw jMSException2;
                }
            }
        }
        catch (JMSException jMSException3) {
            try {
                FFDCFilter.processException((Throwable)jMSException3, "com.ibm.ejs.jms.JMSQueueConnectionHandle.createConnectionConsumer", "112", this);
                JMSCMUtils.trace(tc, "createConnectionConsumer", jMSException3);
                if (jMSException != null) {
                    this.markManagedConnectionAsStale(jMSException);
                }
                throw jMSException3;
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createConnectionConsumer", connectionConsumer);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConnectionConsumer", connectionConsumer);
        }
        return connectionConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QueueSession createQueueSession(boolean bl, int n) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createQueueSession", new Object[]{bl, new Integer(n)});
        }
        JMSQueueSessionHandle jMSQueueSessionHandle = null;
        try {
            String string = this.lockCreateQueueSession;
            synchronized (string) {
                this.checkOpen();
                this.checkValid();
                JMSSessionRequestInfo jMSSessionRequestInfo = new JMSSessionRequestInfo(bl, n);
                jMSQueueSessionHandle = (JMSQueueSessionHandle)this.sessionManager.allocateConnection((ManagedConnectionFactory)this.factory, (ConnectionRequestInfo)jMSSessionRequestInfo);
                jMSQueueSessionHandle.setQueueConnectionHandle(this);
            }
        }
        catch (JMSException jMSException) {
            try {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueConnectionHandle.createQueueSession", "159", this);
                JMSCMUtils.trace(tc, "createQueueSession", jMSException);
                throw jMSException;
                catch (ResourceException resourceException) {
                    FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSQueueConnectionHandle.createQueueSession", "165", this);
                    if (!(resourceException.getCause() instanceof JMSException)) throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create queue session");
                    this.markManagedConnectionAsStale((JMSException)resourceException.getCause());
                    throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create queue session");
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "createQueueSession", jMSQueueSessionHandle);
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return jMSQueueSessionHandle;
        if (!tc.isEntryEnabled()) return jMSQueueSessionHandle;
        Tr.exit(tc, "createQueueSession", jMSQueueSessionHandle);
        return jMSQueueSessionHandle;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(string + "temporary queues = [");
        Iterator iterator = this.getTemporaryQueues().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(JMSCMUtils.objectToString(iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public QueueSession createListenerQueueSession(int n, boolean bl) throws JMSException {
        return this.createListenerQueueSession(n, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QueueSession createListenerQueueSession(int n, boolean bl, boolean bl2) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createListenerQueueSession", new Object[]{new Integer(n), bl, bl2});
        }
        JMSQueueSessionHandle jMSQueueSessionHandle = null;
        try {
            String string = this.lockCreateListenerQueueSession;
            synchronized (string) {
                this.checkOpen();
                this.checkValid();
                JMSListenerSessionRequestInfo jMSListenerSessionRequestInfo = new JMSListenerSessionRequestInfo(n, bl, bl2);
                jMSQueueSessionHandle = (JMSQueueSessionHandle)this.sessionManager.allocateConnection((ManagedConnectionFactory)this.factory, (ConnectionRequestInfo)jMSListenerSessionRequestInfo);
                jMSQueueSessionHandle.setQueueConnectionHandle(this);
            }
        }
        catch (JMSException jMSException) {
            try {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueConnectionHandle.createListenerQueueSession", "284", this);
                JMSCMUtils.trace(tc, "createListenerQueueSession", jMSException);
                throw jMSException;
                catch (ResourceException resourceException) {
                    FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSQueueConnectionHandle.createListenerQueueSession", "290", this);
                    if (!(resourceException.getCause() instanceof JMSException)) throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create queue session");
                    this.markManagedConnectionAsStale((JMSException)resourceException.getCause());
                    throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create queue session");
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "createListenerQueueSession", jMSQueueSessionHandle);
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return jMSQueueSessionHandle;
        if (!tc.isEntryEnabled()) return jMSQueueSessionHandle;
        Tr.exit(tc, "createListenerQueueSession", jMSQueueSessionHandle);
        return jMSQueueSessionHandle;
    }
}

