/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSMessageConsumerHandle;
import com.ibm.ejs.jms.JMSQueueSessionHandle;
import com.ibm.ejs.jms.JMSSessionHandle;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;

final class JMSQueueReceiverHandle
extends JMSMessageConsumerHandle
implements QueueReceiver {
    private static final long serialVersionUID = 7475704319595799795L;
    private static final TraceComponent tc = Tr.register(JMSQueueReceiverHandle.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private JMSQueueSessionHandle queueSessionHandle;
    private Queue queue;
    private QueueReceiver queueReceiver;

    JMSQueueReceiverHandle(JMSQueueSessionHandle jMSQueueSessionHandle, Queue queue) throws JMSException {
        super(jMSQueueSessionHandle);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSQueueReceiverHandle", new Object[]{jMSQueueSessionHandle, queue});
        }
        try {
            this.queueSessionHandle = jMSQueueSessionHandle;
            this.queue = queue;
            QueueSession queueSession = jMSQueueSessionHandle.getOpenQueueSession();
            try {
                this.queueReceiver = queueSession.createReceiver(queue);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            this.queueSessionHandle.addChild(this);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueReceiverHandle.JMSQueueReceiverHandle", "81", this);
            JMSCMUtils.trace(tc, "JMSQueueReceiverHandle", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "JMSQueueReceiverHandle");
            }
        }
    }

    JMSQueueReceiverHandle(JMSQueueSessionHandle jMSQueueSessionHandle, Queue queue, String string) throws JMSException {
        super((JMSSessionHandle)jMSQueueSessionHandle, string);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSQueueReceiverHandle", new Object[]{jMSQueueSessionHandle, queue, string});
        }
        try {
            this.queueSessionHandle = jMSQueueSessionHandle;
            this.queue = queue;
            QueueSession queueSession = jMSQueueSessionHandle.getOpenQueueSession();
            try {
                this.queueReceiver = queueSession.createReceiver(queue, string);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (InvalidSelectorException invalidSelectorException) {
                throw invalidSelectorException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            jMSQueueSessionHandle.addChild(this);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueReceiverHandle.JMSQueueReceiverHandle", "124", this);
            JMSCMUtils.trace(tc, "JMSQueueReceiverHandle", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "JMSQueueReceiverHandle");
            }
        }
    }

    public Queue getQueue() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQueue");
        }
        Queue queue = null;
        try {
            QueueReceiver queueReceiver = this.getOpenQueueReceiver();
            queue = queueReceiver.getQueue();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueReceiverHandle.getQueue", "160", this);
            JMSCMUtils.trace(tc, "getQueue", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getQueue", queue);
            }
        }
        return queue;
    }

    protected MessageConsumer getMessageConsumer() {
        return this.queueReceiver;
    }

    protected MessageConsumer getOpenMessageConsumer() throws IllegalStateException, JMSException {
        return this.getOpenQueueReceiver();
    }

    private QueueReceiver getOpenQueueReceiver() throws IllegalStateException, JMSException {
        this.checkOpen();
        if (this.queueReceiver == null) {
            QueueSession queueSession = this.queueSessionHandle.getOpenQueueSession();
            try {
                this.queueReceiver = this.messageSelector == null ? queueSession.createReceiver(this.queue) : queueSession.createReceiver(this.queue, this.messageSelector);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (InvalidSelectorException invalidSelectorException) {
                throw invalidSelectorException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        return this.queueReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
        try {
            if (this.queueReceiver != null) {
                this.queueReceiver.close();
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueReceiverHandle.reset", "240", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Failed to close QueueReceiver during reset", (Object)jMSException);
            }
            this.markManagedObjectsAsStale(jMSException);
        }
        finally {
            this.queueReceiver = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "reset");
            }
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        JMSQueueReceiverHandle jMSQueueReceiverHandle = (JMSQueueReceiverHandle)object;
        if (!JMSCMUtils.objectsEqual(this.queueSessionHandle, jMSQueueReceiverHandle.queueSessionHandle)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.queue, jMSQueueReceiverHandle.queue)) {
            return false;
        }
        return JMSCMUtils.objectsEqual(this.queueReceiver, jMSQueueReceiverHandle.queueReceiver);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.queueSessionHandle);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.queue);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.queueReceiver);
        return n;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(string + "queue = " + this.queue);
        stringBuffer.append(string + "physical queue receiver = " + this.queueReceiver);
        return stringBuffer.toString();
    }

    protected String getDestinationName() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDestinationName");
        }
        String string = this.queue.getQueueName();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDestinationName", string);
        }
        return string;
    }
}

