/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSMessageProducerHandle;
import com.ibm.ejs.jms.JMSQueueSessionHandle;
import com.ibm.ejs.jms.JMSRequestMetrics;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Properties;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.QueueSession;

final class JMSQueueSenderHandle
extends JMSMessageProducerHandle
implements QueueSender {
    private static final long serialVersionUID = -6309227391802570580L;
    private static final TraceComponent tc = Tr.register(JMSQueueSenderHandle.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private JMSQueueSessionHandle queueSessionHandle;
    private Queue queue;
    private QueueSender queueSender;

    JMSQueueSenderHandle(JMSQueueSessionHandle jMSQueueSessionHandle, Queue queue) throws JMSException {
        super(jMSQueueSessionHandle);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSQueueSenderHandle", new Object[]{jMSQueueSessionHandle, queue});
        }
        try {
            this.queueSessionHandle = jMSQueueSessionHandle;
            this.queue = queue;
            QueueSession queueSession = jMSQueueSessionHandle.getOpenQueueSession();
            try {
                this.queueSender = queueSession.createSender(queue);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            this.queueSessionHandle.addChild(this);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueSenderHandle.JMSQueueSenderHandle", "83", this);
            JMSCMUtils.trace(tc, "JMSQueueSenderHandle", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "JMSQueueSenderHandle");
            }
        }
    }

    public Queue getQueue() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQueue");
        }
        Queue queue = null;
        try {
            QueueSender queueSender = this.getOpenQueueSender();
            queue = queueSender.getQueue();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueSenderHandle.getQueue", "119", this);
            JMSCMUtils.trace(tc, "getQueue", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getQueue", queue);
            }
        }
        return queue;
    }

    public void send(Message message) throws IllegalStateException, MessageFormatException, InvalidDestinationException, JMSException, UnsupportedOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send", message);
        }
        try {
            QueueSender queueSender = this.getOpenQueueSender();
            try {
                this.enlist();
                boolean bl = this.queueSessionHandle.isMQSession();
                boolean bl2 = JMSRequestMetrics.isRMEnabled(JMSRequestMetrics.JMS_COMPONENT_ID);
                Object object = null;
                if (bl && bl2) {
                    object = this.produceMessageBlock("send (Message)");
                }
                boolean bl3 = true;
                try {
                    queueSender.send(message);
                }
                catch (JMSException jMSException) {
                    bl3 = false;
                    throw jMSException;
                }
                finally {
                    if (bl && bl2) {
                        this.produceMessageUnblock(bl3, message, object, queueSender);
                    }
                }
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (MessageFormatException messageFormatException) {
                throw messageFormatException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueSenderHandle.send", "164", this);
            JMSCMUtils.trace(tc, "send", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "send");
            }
        }
    }

    public void send(Message message, int n, int n2, long l) throws IllegalStateException, MessageFormatException, InvalidDestinationException, JMSException, UnsupportedOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send", new Object[]{message, new Integer(n), new Integer(n2), new Long(l)});
        }
        try {
            QueueSender queueSender = this.getOpenQueueSender();
            try {
                this.enlist();
                boolean bl = this.queueSessionHandle.isMQSession();
                boolean bl2 = JMSRequestMetrics.isRMEnabled(JMSRequestMetrics.JMS_COMPONENT_ID);
                Object object = null;
                if (bl && bl2) {
                    object = this.produceMessageBlock("send (Message, int, int, long)");
                }
                boolean bl3 = true;
                try {
                    queueSender.send(message, n, n2, l);
                }
                catch (JMSException jMSException) {
                    bl3 = false;
                    throw jMSException;
                }
                finally {
                    if (bl && bl2) {
                        this.produceMessageUnblock(bl3, message, object, "" + l);
                    }
                }
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (MessageFormatException messageFormatException) {
                throw messageFormatException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueSenderHandle.send", "211", this);
            JMSCMUtils.trace(tc, "send", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "send");
            }
        }
    }

    public void send(Queue queue, Message message) throws IllegalStateException, MessageFormatException, InvalidDestinationException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send", new Object[]{queue, message});
        }
        try {
            QueueSender queueSender = this.getOpenQueueSender();
            try {
                this.enlist();
                boolean bl = this.queueSessionHandle.isMQSession();
                boolean bl2 = JMSRequestMetrics.isRMEnabled(JMSRequestMetrics.JMS_COMPONENT_ID);
                Object object = null;
                if (bl && bl2) {
                    object = this.produceMessageBlock("send (Queue, Message)");
                }
                boolean bl3 = true;
                try {
                    queueSender.send(queue, message);
                }
                catch (JMSException jMSException) {
                    bl3 = false;
                    throw jMSException;
                }
                finally {
                    if (bl && bl2) {
                        this.produceMessageUnblock(bl3, message, object, queueSender);
                    }
                }
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (MessageFormatException messageFormatException) {
                throw messageFormatException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueSenderHandle.send", "253", this);
            JMSCMUtils.trace(tc, "send", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "send");
            }
        }
    }

    public void send(Queue queue, Message message, int n, int n2, long l) throws IllegalStateException, MessageFormatException, InvalidDestinationException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send", new Object[]{queue, message, new Integer(n), new Integer(n2), new Long(l)});
        }
        try {
            QueueSender queueSender = this.getOpenQueueSender();
            try {
                this.enlist();
                boolean bl = this.queueSessionHandle.isMQSession();
                boolean bl2 = JMSRequestMetrics.isRMEnabled(JMSRequestMetrics.JMS_COMPONENT_ID);
                Object object = null;
                if (bl && bl2) {
                    object = this.produceMessageBlock("send (Queue, Message, int, int, long)");
                }
                boolean bl3 = true;
                try {
                    queueSender.send(queue, message, n, n2, l);
                }
                catch (JMSException jMSException) {
                    bl3 = false;
                    throw jMSException;
                }
                finally {
                    if (bl && bl2) {
                        this.produceMessageUnblock(bl3, message, object, "" + l);
                    }
                }
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (MessageFormatException messageFormatException) {
                throw messageFormatException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueSenderHandle.send", "298", this);
            JMSCMUtils.trace(tc, "send", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "send");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
        try {
            if (this.queueSender != null) {
                this.queueSender.close();
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueSenderHandle.reset", "324", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Failed to close QueueSender during reset", (Object)jMSException);
            }
            this.markManagedObjectsAsStale(jMSException);
        }
        finally {
            this.queueSender = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "reset");
            }
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        JMSQueueSenderHandle jMSQueueSenderHandle = (JMSQueueSenderHandle)object;
        if (!JMSCMUtils.objectsEqual(this.queueSessionHandle, jMSQueueSenderHandle.queueSessionHandle)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.queue, jMSQueueSenderHandle.queue)) {
            return false;
        }
        return JMSCMUtils.objectsEqual(this.queueSender, jMSQueueSenderHandle.queueSender);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.queueSessionHandle);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.queue);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.queueSender);
        return n;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(string + "queue = " + this.queue);
        stringBuffer.append(string + "physical queue sender = " + this.queueSender);
        return stringBuffer.toString();
    }

    protected final MessageProducer getMessageProducer() {
        return this.queueSender;
    }

    protected MessageProducer getOpenMessageProducer() throws IllegalStateException, JMSException {
        return this.getOpenQueueSender();
    }

    private QueueSender getOpenQueueSender() throws IllegalStateException, JMSException {
        this.checkOpen();
        if (this.queueSender == null) {
            QueueSession queueSession = this.queueSessionHandle.getOpenQueueSession();
            try {
                this.queueSender = queueSession.createSender(this.queue);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            this.initialiseMessageProducer();
        }
        return this.queueSender;
    }

    private Object produceMessageBlock(String string) throws JMSException {
        String[] stringArray = new String[]{this.getClass().getName(), string};
        return JMSRequestMetrics.produceMessageBlock(stringArray);
    }

    private void produceMessageUnblock(boolean bl, Message message, Object object, QueueSender queueSender) throws JMSException {
        this.produceMessageUnblock(bl, message, object, "" + queueSender.getTimeToLive());
    }

    private void produceMessageUnblock(boolean bl, Message message, Object object, String string) throws JMSException {
        Properties properties = new Properties();
        int n = JMSRequestMetrics.getTransactionTraceLevel(JMSRequestMetrics.JMS_COMPONENT_ID);
        if (n == 2) {
            properties = JMSRequestMetrics.getBasicOutboundTrace(message, this.queueSessionHandle.getMQQueueManagerName());
        } else if (n == 3) {
            properties = JMSRequestMetrics.getExtendedOutboundTrace(message, this.queueSessionHandle.getMQQueueManagerName(), string);
        }
        JMSRequestMetrics.produceMessageUnblock(object, bl ? 0 : 2, properties);
    }
}

