/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSManagedQueueSession;
import com.ibm.ejs.jms.JMSQueueBrowserHandle;
import com.ibm.ejs.jms.JMSQueueConnectionHandle;
import com.ibm.ejs.jms.JMSQueueReceiverHandle;
import com.ibm.ejs.jms.JMSQueueSenderHandle;
import com.ibm.ejs.jms.JMSSessionHandle;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.XAQueueSession;
import javax.resource.spi.ConnectionRequestInfo;

public final class JMSQueueSessionHandle
extends JMSSessionHandle
implements QueueSession {
    private static final long serialVersionUID = -4651133841463563155L;
    private static final TraceComponent tc = Tr.register(JMSQueueSessionHandle.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private JMSQueueConnectionHandle queueConnectionHandle;

    JMSQueueSessionHandle(ConnectionRequestInfo connectionRequestInfo, JMSManagedQueueSession jMSManagedQueueSession) {
        super(connectionRequestInfo, jMSManagedQueueSession);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSQueueSessionHandle", new Object[]{connectionRequestInfo, jMSManagedQueueSession});
            Tr.exit(tc, "JMSQueueSessionHandle");
        }
    }

    public Queue createQueue(String string) throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.event(tc, "createQueue", string);
        }
        Queue queue = null;
        try {
            QueueSession queueSession = this.getOpenQueueSession();
            queue = queueSession.createQueue(string);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueSessionHandle.createQueue", "97", this);
            JMSCMUtils.trace(tc, "createQueue", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createQueue", queue);
            }
        }
        return queue;
    }

    public QueueReceiver createReceiver(Queue queue) throws IllegalStateException, InvalidDestinationException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.event(tc, "createReceiver", queue);
        }
        JMSQueueReceiverHandle jMSQueueReceiverHandle = null;
        try {
            jMSQueueReceiverHandle = new JMSQueueReceiverHandle(this, queue);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueSessionHandle.createReceiver", "138", this);
            JMSCMUtils.trace(tc, "createReceiver", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createReceiver", jMSQueueReceiverHandle);
            }
        }
        return jMSQueueReceiverHandle;
    }

    public QueueReceiver createReceiver(Queue queue, String string) throws IllegalStateException, InvalidDestinationException, InvalidSelectorException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.event(tc, "createReceiver", new Object[]{queue, string});
        }
        JMSQueueReceiverHandle jMSQueueReceiverHandle = null;
        try {
            jMSQueueReceiverHandle = new JMSQueueReceiverHandle(this, queue, string);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueSessionHandle.createReceiver", "183", this);
            JMSCMUtils.trace(tc, "createReceiver", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createReceiver", jMSQueueReceiverHandle);
            }
        }
        return jMSQueueReceiverHandle;
    }

    public QueueSender createSender(Queue queue) throws IllegalStateException, InvalidDestinationException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSender", queue);
        }
        JMSQueueSenderHandle jMSQueueSenderHandle = null;
        try {
            jMSQueueSenderHandle = new JMSQueueSenderHandle(this, queue);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueSessionHandle.createSender", "223", this);
            JMSCMUtils.trace(tc, "createSender", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSender", jMSQueueSenderHandle);
            }
        }
        return jMSQueueSenderHandle;
    }

    public QueueBrowser createBrowser(Queue queue) throws IllegalStateException, InvalidDestinationException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createBrowser", queue);
        }
        JMSQueueBrowserHandle jMSQueueBrowserHandle = null;
        try {
            jMSQueueBrowserHandle = new JMSQueueBrowserHandle(this, queue);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueSessionHandle.createBrowser", "263", this);
            JMSCMUtils.trace(tc, "createBrowser", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createBrowser", jMSQueueBrowserHandle);
            }
        }
        return jMSQueueBrowserHandle;
    }

    public QueueBrowser createBrowser(Queue queue, String string) throws IllegalStateException, InvalidDestinationException, InvalidSelectorException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createBrowser", new Object[]{queue, string});
        }
        JMSQueueBrowserHandle jMSQueueBrowserHandle = null;
        try {
            jMSQueueBrowserHandle = new JMSQueueBrowserHandle(this, queue, string);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueSessionHandle.createBrowser", "307", this);
            JMSCMUtils.trace(tc, "createBrowser", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createBrowser", jMSQueueBrowserHandle);
            }
        }
        return jMSQueueBrowserHandle;
    }

    public TemporaryQueue createTemporaryQueue() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTemporaryQueue");
        }
        TemporaryQueue temporaryQueue = null;
        try {
            QueueSession queueSession = this.getOpenQueueSession();
            try {
                temporaryQueue = queueSession.createTemporaryQueue();
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            this.queueConnectionHandle.addTemporaryQueue(temporaryQueue);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueSessionHandle.createTemporaryQueue", "346", this);
            JMSCMUtils.trace(tc, "createTemporaryQueue", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTemporaryQueue", temporaryQueue);
            }
        }
        return temporaryQueue;
    }

    public Session getSession() throws JMSException {
        return this.getOpenQueueSession();
    }

    protected QueueSession getOpenQueueSession() throws IllegalStateException, JMSException {
        Session session = this.getOpenSession();
        QueueSession queueSession = session instanceof XAQueueSession ? ((XAQueueSession)session).getQueueSession() : (QueueSession)session;
        return queueSession;
    }

    void setQueueConnectionHandle(JMSQueueConnectionHandle jMSQueueConnectionHandle) {
        super.setConnectionHandle(jMSQueueConnectionHandle);
        this.queueConnectionHandle = jMSQueueConnectionHandle;
    }
}

