/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSClientInit;
import com.ibm.ejs.jms.JMSRegistrar;
import com.ibm.ejs.jms.JMSRegistrationFactory;
import com.ibm.ejs.jms.mq.pcf.WMQQueueDefinerActivator;
import com.ibm.ejs.jms.registration.FileDetails;
import com.ibm.ejs.jms.registration.JVMUtils;
import com.ibm.ejs.jms.registration.MA88Install;
import com.ibm.ejs.jms.registration.Version;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.ws.runtime.service.impl.BundleContextMap;
import com.ibm.ws.security.policy.DynamicPolicyFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class JMSRegistration
extends WsComponentImpl
implements JMSRegistrar {
    private static final String WMQ_JMS_CLIENT_DETAILS = "WMQ_JMS_CLIENT_DETAILS";
    private static final String WMQ_JMS_BUNDLE_NAME = "com.ibm.ws.runtime.mqjms";
    private static final TraceComponent tc = Tr.register(JMSRegistration.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private static final String WMQ_JAVA_VAR = "${MQ_INSTALL_ROOT}";
    private static final String WMQ_JAVA_VERSION_VAR = "${MQ_INSTALL_VERSION}";
    private static final String ALL_FILES = "/-";
    public static final String FILE_URL = "file:/";
    private static final String MQ_CLEAR_MQ_FROM_OSGI_CACHE_ON_SHUTDOWN_VAR = "${MQ_CLEAR_MQ_FROM_OSGI_CACHE_ON_SHUTDOWN}";
    private boolean _ma88RegistrationSucceeded;
    private Exception _failureException;
    private Version _minimumVersion;
    private Version _currentVersion;
    private static JMSRegistration _instance;
    private static String _failureKey;
    private static Object[] _failureInserts;

    public void initialize(Object object) {
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        _instance = this;
        JMSRegistrationFactory.setJMSRegistrationInstance(_instance);
        MA88Install mA88Install = this.getMQInstallRoot();
        if (mA88Install.isValid()) {
            if (this.checkVersion(mA88Install)) {
                if (this.shouldInstallBundle()) {
                    this._ma88RegistrationSucceeded = this.installBundle(mA88Install, true);
                    if (!this._ma88RegistrationSucceeded) {
                        Tr.error(tc, "JMS_REGISTRATION_OSGI_FAILURE_WMSG1603", this._failureException);
                    }
                } else {
                    object2 = this.getOSGiInstall();
                    this._ma88RegistrationSucceeded = true;
                    if (!((MA88Install)object2).isValid()) {
                        Tr.error(tc, "JMS_REGISTRATION_MQ_JAVA_NOT_FOUND_WMSG1605", new Object[]{mA88Install});
                        this._ma88RegistrationSucceeded = false;
                    } else if (this.hasInstallRootChanged(mA88Install)) {
                        this._ma88RegistrationSucceeded = false;
                        _failureKey = "JMS_FAKE_RESOURCE_INSTALL_CHANGE_WMSG2002";
                        Tr.error(tc, "MQ_INSTALL_ROOT_UPDATED_PLEASE_RESTART_WMSG1612", new Object[]{object2, mA88Install});
                    } else if (this.hasInstallContentChanged(mA88Install)) {
                        this._ma88RegistrationSucceeded = false;
                        _failureKey = "JMS_FAKE_RESOURCE_CLIENT_UPDATE2003";
                        Tr.error(tc, "MQ_INSTALL_ROOT_CONTENT_CHANGED_WMSG1614");
                    } else if (this.hasVersionChanged(mA88Install)) {
                        Tr.warning(tc, "MQ_INSTALL_ROOT_VERSION_HAS_CHANGED_WMSG1613", new Object[]{mA88Install, this.getOSGiInstallVersion(), mA88Install.getVersion()});
                    }
                }
            } else {
                Tr.error(tc, "JMS_REGISTRATION_UNSUPPORTED_VERSION_WMSG1604", new Object[]{mA88Install, mA88Install.getVersion(), this.getMinimumVersion(mA88Install.getVersion())});
                _failureKey = "JMS_FAKE_RESOURCE_VERSION_WMSG2000";
                _failureInserts = new Object[4];
                object2 = AdminServiceFactory.getAdminService();
                JMSRegistration._failureInserts[0] = object2.getProcessName();
                JMSRegistration._failureInserts[1] = object2.getNodeName();
                JMSRegistration._failureInserts[2] = mA88Install.getVersion();
                JMSRegistration._failureInserts[3] = this.getMinimumVersion(mA88Install.getVersion());
            }
        } else {
            Tr.error(tc, "JMS_REGISTRATION_MQ_JAVA_NOT_FOUND_WMSG1605", new Object[]{mA88Install});
        }
        if (this._ma88RegistrationSucceeded) {
            mA88Install = this.getOSGiInstall();
            JVMUtils.updateJavaLibraryPath(mA88Install.getNativePath());
            if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                System.setProperty("com.ibm.ws390.messaging.ma88.enabled", "true");
            }
            if ((object2 = DynamicPolicyFactory.getInstance()) != null) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
                hashMap.put("type", "spi");
                String[] stringArray = new String[]{mA88Install.getInstallRoot() + ALL_FILES};
                hashMap.put("classpath", stringArray);
                object2.setupPolicy(hashMap);
            }
        }
        if (mA88Install != null) {
            this._currentVersion = mA88Install.getVersion();
        }
        if (!this._ma88RegistrationSucceeded && _failureKey == null) {
            _failureKey = "JMS_FAKE_RESOURCE_BOUND_WMSG2001";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    private boolean hasVersionChanged(MA88Install mA88Install) {
        Version version;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasVersionChanged", new Object[]{mA88Install, this});
        }
        if (!(version = this.getOSGiInstallVersion()).equals(mA88Install.getVersion())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The old clients version is " + version + " the new clients version is " + mA88Install.getVersion());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "shouldReinstall", Boolean.TRUE);
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasVersionChanged", Boolean.FALSE);
        }
        return false;
    }

    private MA88Install getOSGiInstall() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentInstallRoot", this);
        }
        Bundle bundle = Platform.getBundle((String)WMQ_JMS_BUNDLE_NAME);
        MA88Install mA88Install = null;
        if (bundle != null) {
            String string = bundle.getLocation();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "OSGi bundle location is " + string);
            }
            mA88Install = new MA88Install(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentInstallRoot", mA88Install);
        }
        return mA88Install;
    }

    private Version getOSGiInstallVersion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOSGiInstallVersion", this);
        }
        Bundle bundle = Platform.getBundle((String)WMQ_JMS_BUNDLE_NAME);
        Version version = null;
        if (bundle != null) {
            String string = (String)bundle.getHeaders().get("Bundle-Version");
            version = new Version(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOSGiInstallVersion", version);
        }
        return version;
    }

    private MA88Install getMQInstallRoot() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMA88Install", this);
        }
        String string = null;
        try {
            string = this.expandVariable(WMQ_JAVA_VAR);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.messaging.JMSRegistration.initialize", "73", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception expanding ${MQ_INSTALL_ROOT}: " + throwable);
            }
            Tr.error(tc, "VARMAP_EXCEPTION_WMSG1600", throwable);
        }
        MA88Install mA88Install = new MA88Install(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMA88Install", mA88Install);
        }
        return mA88Install;
    }

    private boolean isUninstallOnShutdownRequested() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUninstallOnShutdownRequested", this);
        }
        Boolean bl = Boolean.FALSE;
        try {
            String string = this.expandVariable(MQ_CLEAR_MQ_FROM_OSGI_CACHE_ON_SHUTDOWN_VAR);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Expanded ${MQ_CLEAR_MQ_FROM_OSGI_CACHE_ON_SHUTDOWN}: " + string);
            }
            bl = Boolean.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Variable ${MQ_CLEAR_MQ_FROM_OSGI_CACHE_ON_SHUTDOWN} appears to be unset: " + illegalArgumentException);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.messaging.JMSRegistration.isUninstallOnShutdownRequested", "731", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception expanding ${MQ_CLEAR_MQ_FROM_OSGI_CACHE_ON_SHUTDOWN}: " + throwable);
            }
            Tr.error(tc, "VARMAP_EXCEPTION_WMSG1600", throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUninstallOnShutdownRequested", bl);
        }
        return bl;
    }

    private boolean shouldInstallBundle() {
        Bundle bundle;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "shouldInstallBundle", this);
        }
        if ((bundle = Platform.getBundle((String)WMQ_JMS_BUNDLE_NAME)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The OSGi bundle cannot be found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "shouldInstallBundle", Boolean.TRUE);
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "shouldInstallBundle", Boolean.FALSE);
        }
        return false;
    }

    private boolean hasInstallContentChanged(MA88Install mA88Install) {
        FileDetails fileDetails;
        int n;
        Object object;
        File[] fileArray;
        Bundle bundle;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "shouldReinstall", new Object[]{mA88Install, this});
        }
        if ((bundle = Platform.getBundle((String)WMQ_JMS_BUNDLE_NAME)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The OSGi bundle cannot be found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "shouldReinstall", Boolean.TRUE);
            }
            return true;
        }
        Dictionary dictionary = bundle.getHeaders();
        String string = (String)dictionary.get(WMQ_JMS_CLIENT_DETAILS);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        while (stringTokenizer.hasMoreTokens()) {
            fileArray = stringTokenizer.nextToken();
            if (fileArray.length() <= 0) continue;
            object = new FileDetails((String)fileArray);
            if (((FileDetails)object).isJar()) {
                hashMap.put(((FileDetails)object).getPath(), object);
                continue;
            }
            hashMap2.put(((FileDetails)object).getPath(), object);
        }
        fileArray = mA88Install.getJars();
        object = mA88Install.getNativeLibraries();
        if (hashMap.size() != fileArray.length || hashMap2.size() != ((Object)object).length) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "old jar count = " + hashMap.size() + ", new jar count = " + fileArray.length + ", old dll count = " + hashMap2.size() + ", new dll count = " + ((Object)object).length);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "shouldReinstall", Boolean.TRUE);
            }
            return true;
        }
        for (n = 0; n < fileArray.length; ++n) {
            fileDetails = (FileDetails)hashMap.remove(fileArray[n].getAbsolutePath());
            if (fileDetails != null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to find " + fileArray[n].getAbsolutePath());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "shouldReinstall", Boolean.TRUE);
            }
            return true;
        }
        if (hashMap.size() != 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to locate old jars: " + hashMap);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "shouldReinstall", Boolean.TRUE);
            }
            return true;
        }
        for (n = 0; n < ((Object)object).length; ++n) {
            fileDetails = (FileDetails)hashMap2.remove(((File)object[n]).getAbsolutePath());
            if (fileDetails != null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to find " + fileArray[n].getAbsolutePath());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "shouldReinstall", Boolean.TRUE);
            }
            return true;
        }
        if (hashMap2.size() != 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to locate old DLLs: " + hashMap2);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "shouldReinstall", Boolean.TRUE);
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "shouldReinstall", Boolean.FALSE);
        }
        return false;
    }

    private boolean checkVersion(MA88Install mA88Install) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkVersion", new Object[]{mA88Install, this});
        }
        boolean bl = false;
        Version version = this.getMinimumVersion(mA88Install.getVersion());
        if (version != null) {
            boolean bl2 = bl = version.compareTo(mA88Install.getVersion()) < 1;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkVersion", new Boolean(bl));
        }
        return bl;
    }

    private Version getMinimumVersion(Version version) {
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getMinimumVersion", new Object[]{this, version});
            }
            if (this._minimumVersion == null) {
                try {
                    String string;
                    Properties properties;
                    block14: {
                        properties = new Properties();
                        properties.load(this.getClass().getResourceAsStream("client.version.properties"));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "minimum level map: " + properties);
                        }
                        string = null;
                        try {
                            string = this.expandVariable(WMQ_JAVA_VERSION_VAR);
                        }
                        catch (Throwable throwable) {
                            if (!tc.isDebugEnabled()) break block14;
                            Tr.debug(tc, "Exception expanding ${MQ_INSTALL_ROOT}: " + throwable);
                        }
                    }
                    String string2 = "minimumSupportedLevel";
                    int n = version.getMajorVersion();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Major Version of referenced install: " + n);
                    }
                    if (Integer.toString(n).equals(string)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "major version matches minimum configured versions");
                        }
                        String string3 = string2 + "_" + string;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "minimum supported level key being searched for: " + string3);
                        }
                        if (properties.containsKey(string3)) {
                            string2 = string3;
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "supported level key: " + string2);
                    }
                    this._minimumVersion = new Version(properties.getProperty(string2));
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ejs.jms.JMSRegistration.getMinimumVersion", "500", this);
                    if (!tc.isDebugEnabled()) break block15;
                    Tr.debug(tc, "unable to get minimum supported version due to exception", iOException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMinimumVersion", this._minimumVersion);
        }
        return this._minimumVersion;
    }

    public void start() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        if (this._ma88RegistrationSucceeded) {
            try {
                JMSClientInit.setRunningInWebSphere();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                Tr.audit(tc, "MESSAGING_NOT_INSTALLED_WMSG1601");
            }
        }
        if (this._ma88RegistrationSucceeded) {
            WMQQueueDefinerActivator wMQQueueDefinerActivator = new WMQQueueDefinerActivator();
            wMQQueueDefinerActivator.activateMBean();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    private boolean installBundle(MA88Install mA88Install, boolean bl) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installBundle", new Object[]{mA88Install, bl ? Boolean.TRUE : Boolean.FALSE});
        }
        boolean bl2 = true;
        BundleContext bundleContext = BundleContextMap.instance().get(this.getClass().getClassLoader());
        File[] fileArray = mA88Install.getJars();
        File[] fileArray2 = mA88Install.getNativeLibraries();
        Version version = mA88Install.getVersion();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer(1024);
        stringBuffer2.append("Manifest-Version: 1.0\n");
        stringBuffer2.append("Bundle-ManifestVersion");
        stringBuffer2.append(": 2\n");
        stringBuffer2.append("Bundle-Name");
        stringBuffer2.append(": WebSphere MQ Java Client\n");
        stringBuffer2.append("Bundle-SymbolicName");
        stringBuffer2.append(": com.ibm.ws.runtime.mqjms; ");
        stringBuffer2.append("singleton");
        stringBuffer2.append(":=true\n");
        stringBuffer2.append("Bundle-Version");
        stringBuffer2.append(": ");
        stringBuffer2.append(version);
        stringBuffer2.append('\n');
        stringBuffer2.append("Bundle-Vendor");
        stringBuffer2.append(": IBM\n");
        stringBuffer2.append("Bundle-Localization");
        stringBuffer2.append(": plugin\n");
        stringBuffer2.append("Eclipse-AutoStart: true\n");
        stringBuffer2.append("Import-Package");
        stringBuffer2.append(": com.ibm.websphere.ras, com.ibm.ras");
        if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
            stringBuffer2.append(", com.ibm.ws390.tx.rrs");
        }
        stringBuffer2.append("\n");
        stringBuffer2.append("Export-Package");
        stringBuffer2.append(": com.ibm.mq, com.ibm.mq.jms, com.ibm.mq.jms.admin, com.ibm.jms, com.ibm.mq.jms.services, com.ibm.mqservices, com.ibm.mq.connector, com.ibm.mq.jmqi, com.ibm.mq.jmqi.local, com.ibm.mq.jmqi.remote, com.ibm.mq.jmqi.remote.internal, com.ibm.msg.client.jms, com.ibm.msg.client.jms.internal, com.ibm.msg.client.commonservices, com.ibm.msg.client.commonservices.j2se, com.ibm.msg.client.wmq, com.ibm.msg.client.wmq.common, com.ibm.msg.client.wmq.factories, com.ibm.msg.client.wmq.factories.admin, com.ibm.msg.client.wmq.v6\n");
        stringBuffer2.append("Bundle-ClassPath");
        stringBuffer2.append(": ");
        for (int i = 0; i < fileArray.length; ++i) {
            stringBuffer2.append("external:");
            stringBuffer2.append(fileArray[i].getAbsolutePath());
            if (i < fileArray.length - 1) {
                stringBuffer2.append(",");
            }
            stringBuffer.append(FileDetails.toString(fileArray[i], true));
            stringBuffer.append(',');
        }
        stringBuffer2.append("\n");
        if (fileArray2.length != 0) {
            String string = bundleContext.getProperty("org.osgi.framework.os.name");
            object = bundleContext.getProperty("org.osgi.framework.processor");
            stringBuffer2.append("Bundle-NativeCode");
            stringBuffer2.append(": ");
            for (int i = 0; i < fileArray2.length; ++i) {
                stringBuffer2.append("external:");
                stringBuffer2.append(fileArray2[i].getAbsolutePath());
                stringBuffer2.append(";");
                stringBuffer.append(FileDetails.toString(fileArray2[i], false));
                stringBuffer.append(',');
            }
            stringBuffer2.append("osname");
            stringBuffer2.append('=');
            stringBuffer2.append(string);
            stringBuffer2.append("; ");
            stringBuffer2.append("processor");
            stringBuffer2.append('=');
            stringBuffer2.append((String)object);
            stringBuffer2.append("\n");
        }
        stringBuffer2.append(WMQ_JMS_CLIENT_DETAILS);
        stringBuffer2.append(": ");
        stringBuffer2.append(stringBuffer);
        stringBuffer2.append("\n");
        byte[] byArray = null;
        try {
            byArray = stringBuffer2.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, "com.ibm.ejs.jms.JMSRegistration.installBundle", "834", this);
            bl2 = false;
            this._failureException = unsupportedEncodingException;
        }
        if (bl2) {
            try {
                object = new ByteArrayOutputStream();
                ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)object);
                ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.write(byArray, 0, byArray.length);
                zipOutputStream.closeEntry();
                zipOutputStream.flush();
                zipOutputStream.close();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
                Bundle bundle = bundleContext.installBundle(mA88Install.getInstallRoot().toURI().toString(), (InputStream)byteArrayInputStream);
                if (bl) {
                    bundle.start();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.JMSRegistration.installBundle", "310", this);
                bl2 = false;
                this._failureException = exception;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "installBundle", bl2 ? Boolean.TRUE : Boolean.FALSE);
        }
        return bl2;
    }

    private boolean uninstallBundle() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uninstallBundle", this);
        }
        boolean bl = true;
        Bundle bundle = Platform.getBundle((String)WMQ_JMS_BUNDLE_NAME);
        if (bundle != null) {
            try {
                bundle.stop();
                bundle.uninstall();
            }
            catch (BundleException bundleException) {
                FFDCFilter.processException((Throwable)bundleException, "com.ibm.ejs.jms.JMSRegistration.uninstallBundle", "331", this);
                bl = false;
                this._failureException = bundleException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uninstallBundle", new Boolean(bl));
        }
        return bl;
    }

    public static final boolean isRegistered() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRegistered");
        }
        boolean bl = false;
        if (_instance != null) {
            bl = _instance.isMA88Registered();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRegistered", new Boolean(bl));
        }
        return bl;
    }

    public static final String getFailureMessageKey() {
        return _failureKey;
    }

    public static final Object[] getFailureInserts() {
        return _failureInserts;
    }

    private final boolean isMA88Registered() {
        return this._ma88RegistrationSucceeded;
    }

    public boolean checkCompatibleVersion(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCompatibleVersion", string);
        }
        Version version = new Version(string);
        if (this._currentVersion != null && this._currentVersion.compareTo(version) >= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCompatibleVersion", new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCompatibleVersion", new Boolean(false));
        }
        return false;
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy", this);
        }
        VariableMapFactory.getVariableMap().refresh();
        MA88Install mA88Install = this.getMQInstallRoot();
        boolean bl = this.isUninstallOnShutdownRequested();
        if (bl || this.hasInstallRootChanged(mA88Install) || this.hasInstallContentChanged(mA88Install) || this.hasVersionChanged(mA88Install)) {
            if (!this.uninstallBundle()) {
                Tr.error(tc, "JMS_REGISTRATION_OSGI_FAILURE_WMSG1603", this._failureException);
            } else if (!mA88Install.isValid()) {
                Tr.error(tc, "JMS_REGISTRATION_MQ_JAVA_NOT_FOUND_WMSG1605", new Object[]{mA88Install});
            } else if (!this.checkVersion(mA88Install)) {
                Tr.error(tc, "JMS_REGISTRATION_UNSUPPORTED_VERSION_WMSG1604", new Object[]{mA88Install, mA88Install.getVersion(), this.getMinimumVersion(mA88Install.getVersion())});
            } else if (!bl && !this.installBundle(mA88Install, false)) {
                Tr.error(tc, "JMS_REGISTRATION_OSGI_FAILURE_WMSG1603", this._failureException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    private boolean hasInstallRootChanged(MA88Install mA88Install) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasInstallRootChanged", new Object[]{mA88Install, this});
        }
        MA88Install mA88Install2 = this.getOSGiInstall();
        boolean bl = false;
        if (mA88Install2 == null) {
            bl = true;
        } else if (!mA88Install2.getInstallRoot().equals(mA88Install.getInstallRoot())) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasInstallRootChanged", new Boolean(bl));
        }
        return bl;
    }

    static {
        _failureInserts = new Object[0];
    }
}

