/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.reqmetrics.PmiReqMetrics;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.TextMessage;
import javax.jms.Topic;

public class JMSRequestMetrics {
    protected static final TraceComponent tc = Tr.register(JMSRequestMetrics.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    public static int ARM_CORRELATOR_INDEX = 0;
    public static int RM_CORRELATOR_INDEX = 1;
    public static int NUM_CORRELATORS = 2;
    public static final int STATUS_GOOD = 0;
    public static final int STATUS_FAILED = 2;
    public static final int TRAN_DETAIL_LEVEL_NONE = 0;
    public static final int TRAN_DETAIL_LEVEL_BASIC = 2;
    public static final int TRAN_DETAIL_LEVEL_EXTENDED = 3;
    protected static final int REQSCOPE_INBOUND = 1;
    protected static final int REQSCOPE_OUTBOUND = 2;
    private static final String JMS_COMPONENT_NAME = "JMS";
    public static int JMS_COMPONENT_ID = 9;
    public static int JMS_COMPONENT_MDB_ID = 8;

    public static boolean isActiveOnThread() {
        boolean bl = null != PmiReqMetrics.getCorrelatorsInString(null);
        return bl;
    }

    public static boolean isRMEnabled(int n) {
        return PmiReqMetrics.isEnabled() && PmiReqMetrics.isComponentEnabled(n) && JMSRequestMetrics.getTransactionTraceLevel(n) != 0;
    }

    public static boolean isRMEnabledForMDB() {
        return PmiReqMetrics.isEnabled();
    }

    public static int getTransactionTraceLevel(int n) {
        int n2 = PmiReqMetrics.getTranDetailLevel(n);
        return n2;
    }

    public static Object produceMessageBlock(String[] stringArray) {
        Object object = null;
        if (JMSRequestMetrics.isActiveOnThread()) {
            object = PmiReqMetrics.reqStart(JMS_COMPONENT_ID, 2, stringArray);
        }
        return object;
    }

    public static void produceMessageUnblock(Object object, int n, Properties properties) {
        if (JMSRequestMetrics.isActiveOnThread()) {
            PmiReqMetrics.reqStop(object, JMS_COMPONENT_ID, 2, n, properties);
        }
    }

    public static Object preMDBConsumeMessage(Message message, String[] stringArray) {
        Object object = null;
        if (PmiReqMetrics.isEnabled()) {
            String string = null;
            String string2 = null;
            try {
                string2 = message.getStringProperty("JMS_IBM_RMCorrelator");
                string = message.getStringProperty("JMS_IBM_ArmCorrelator");
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException(jMSException, "com.ibm.ejs.jms.JMSRequestMetrics.preMDBConsumeMessage", "104");
                Tr.event(tc, "Exception {0} getting destination name from the destination", (Object)jMSException);
            }
            String[] stringArray2 = new String[NUM_CORRELATORS];
            stringArray2[JMSRequestMetrics.RM_CORRELATOR_INDEX] = string2;
            stringArray2[JMSRequestMetrics.ARM_CORRELATOR_INDEX] = string;
            PmiReqMetrics.setInboundCorrelators(JMS_COMPONENT_MDB_ID, stringArray2);
            if (PmiReqMetrics.isComponentEnabled(JMS_COMPONENT_MDB_ID, 1)) {
                object = PmiReqMetrics.reqStart(JMS_COMPONENT_MDB_ID, 1, stringArray);
            }
        }
        return object;
    }

    public static void postMDBConsumeMessage(Object object, int n, Properties properties) {
        if (PmiReqMetrics.isEnabled()) {
            PmiReqMetrics.reqStop(object, JMS_COMPONENT_MDB_ID, 1, n, properties);
        }
    }

    public static Object syncConsumeMessageBlock(String[] stringArray) {
        Object object = null;
        if (JMSRequestMetrics.isActiveOnThread()) {
            object = PmiReqMetrics.reqStart(JMS_COMPONENT_ID, 2, stringArray);
        }
        return object;
    }

    public static void syncConsumeMessageUnblock(Object object, int n, Properties properties) {
        if (JMSRequestMetrics.isActiveOnThread()) {
            PmiReqMetrics.reqStop(object, JMS_COMPONENT_ID, 2, n, properties);
        }
    }

    public static Properties getBasicOutboundTrace(Message message, String string) throws JMSException {
        Properties properties = new Properties();
        properties.put("QueueManagerName", string);
        properties.put("DestinationName", (Object)null);
        properties.put("MessageClass", message.getClass().getName());
        properties.put("MessageText", message instanceof TextMessage ? ((TextMessage)message).getText() : null);
        properties.put("MessageTimeStamp", "" + message.getJMSTimestamp());
        properties.put("RedeliveryStatus", message.getJMSRedelivered() ? "Redelivered" : "Not redelivered");
        return properties;
    }

    public static Properties getExtendedOutboundTrace(Message message, String string, String string2) throws JMSException {
        Properties properties = JMSRequestMetrics.getBasicOutboundTrace(message, string);
        Destination destination = null;
        destination = message.getJMSReplyTo();
        String string3 = null;
        if (destination instanceof Queue) {
            string3 = ((Queue)destination).getQueueName();
        } else if (destination instanceof Topic) {
            string3 = ((Topic)destination).getTopicName();
        }
        properties.put("MessageTTL", "" + string2);
        properties.put("MessageExpiration", "" + message.getJMSExpiration());
        properties.put("MessageID", "" + message.getJMSMessageID());
        properties.put("ReplyToDestination", string3);
        properties.put("DeliveryMode", "" + message.getJMSDeliveryMode());
        properties.put("MessagePriority", "" + message.getJMSPriority());
        properties.put("MessageType", message.getJMSType());
        return properties;
    }

    public static String[] getCorrelators() {
        return PmiReqMetrics.getCorrelatorsInString(null);
    }

    public static Properties getRegistrationIndentifier() {
        Properties properties = new Properties();
        properties.put("identity", "send/receive");
        return properties;
    }

    public static Properties getMDBRegistrationIndentifier() {
        Properties properties = new Properties();
        properties.put("identity", "MDB");
        return properties;
    }

    public static String[] getOutboundContextNames() {
        String[] stringArray = new String[]{"className", "methodName"};
        return stringArray;
    }

    public static String[] getInboundContextNames() {
        String[] stringArray = new String[]{"destinationName", "messageSelector", "provider"};
        return stringArray;
    }
}

