/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSCloseable;
import com.ibm.ejs.jms.JMSConnectionHandle;
import com.ibm.ejs.jms.JMSManagedConnection;
import com.ibm.ejs.jms.JMSManagedSession;
import com.ibm.ejs.jms.JMSMessageConsumerHandle;
import com.ibm.ejs.jms.JMSMessageProducerHandle;
import com.ibm.ejs.jms.JMSQueueBrowserHandle;
import com.ibm.ejs.jms.JMSRequestMetrics;
import com.ibm.ejs.jms.JMSSessionHandleInterface;
import com.ibm.ejs.jms.JMSTopicSubscriberHandle;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQSession;
import com.ibm.websphere.j2c.ConnectionManager;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionRolledBackException;
import javax.jms.XASession;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;

public class JMSSessionHandle
implements Session,
JMSSessionHandleInterface,
Serializable {
    private static final long serialVersionUID = -3207257027785212201L;
    private static final TraceComponent tc = Tr.register(JMSSessionHandle.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private JMSManagedSession managedSession;
    private JMSConnectionHandle connectionHandle;
    private ConnectionRequestInfo sessionRequestInfo;
    private List openChildren = new ArrayList();
    private int state;
    private static final int INACTIVE = 0;
    private static final int ACTIVE = 1;
    private static final int CLOSED = 2;
    private boolean restrictedMethodsEnabled = false;
    JMSManagedConnection mc = null;

    JMSSessionHandle(ConnectionRequestInfo connectionRequestInfo, JMSManagedSession jMSManagedSession) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSSessionHandle", new Object[]{connectionRequestInfo, jMSManagedSession});
        }
        this.sessionRequestInfo = connectionRequestInfo;
        this.activate(jMSManagedSession);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JMSSessionHandle");
        }
    }

    public BytesMessage createBytesMessage() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createBytesMessage");
        }
        BytesMessage bytesMessage = null;
        try {
            Session session = this.getOpenUnifiedSession();
            try {
                bytesMessage = session.createBytesMessage();
                this.addCorrelators((Message)bytesMessage);
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createBytesMessage", "136", this);
            JMSCMUtils.trace(tc, "createBytesMessage", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createBytesMessage", bytesMessage);
            }
        }
        return bytesMessage;
    }

    public MapMessage createMapMessage() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMapMessage");
        }
        MapMessage mapMessage = null;
        try {
            Session session = this.getOpenUnifiedSession();
            try {
                mapMessage = session.createMapMessage();
                this.addCorrelators((Message)mapMessage);
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createMapMessage", "176", this);
            JMSCMUtils.trace(tc, "createMapMessage", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createMapMessage", mapMessage);
            }
        }
        return mapMessage;
    }

    public Message createMessage() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMessage");
        }
        Message message = null;
        try {
            Session session = this.getOpenUnifiedSession();
            try {
                message = session.createMessage();
                this.addCorrelators(message);
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createMessage", "216", this);
            JMSCMUtils.trace(tc, "createMessage", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createMessage", message);
            }
        }
        return message;
    }

    public ObjectMessage createObjectMessage() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createObjectMessage");
        }
        ObjectMessage objectMessage = null;
        try {
            Session session = this.getOpenUnifiedSession();
            try {
                objectMessage = session.createObjectMessage();
                this.addCorrelators((Message)objectMessage);
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createObjectMessage", "256", this);
            JMSCMUtils.trace(tc, "createObjectMessage", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createObjectMessage", objectMessage);
            }
        }
        return objectMessage;
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createObjectMessage", serializable);
        }
        ObjectMessage objectMessage = null;
        try {
            Session session = this.getOpenUnifiedSession();
            try {
                objectMessage = session.createObjectMessage(serializable);
                this.addCorrelators((Message)objectMessage);
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createObjectMessage", "297", this);
            JMSCMUtils.trace(tc, "createObjectMessage", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createObjectMessage", objectMessage);
            }
        }
        return objectMessage;
    }

    public StreamMessage createStreamMessage() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStreamMessage");
        }
        StreamMessage streamMessage = null;
        try {
            Session session = this.getOpenUnifiedSession();
            try {
                streamMessage = session.createStreamMessage();
                this.addCorrelators((Message)streamMessage);
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createStreamMessage", "337", this);
            JMSCMUtils.trace(tc, "createStreamMessage", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStreamMessage", streamMessage);
            }
        }
        return streamMessage;
    }

    public TextMessage createTextMessage() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTextMessage");
        }
        TextMessage textMessage = null;
        try {
            Session session = this.getOpenUnifiedSession();
            try {
                textMessage = session.createTextMessage();
                this.addCorrelators((Message)textMessage);
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createTextMessage", "377", this);
            JMSCMUtils.trace(tc, "createTextMessage", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTextMessage", textMessage);
            }
        }
        return textMessage;
    }

    public TextMessage createTextMessage(String string) throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTextMessage", string);
        }
        TextMessage textMessage = null;
        try {
            Session session = this.getOpenUnifiedSession();
            try {
                textMessage = session.createTextMessage(string);
                this.addCorrelators((Message)textMessage);
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createTextMessage", "418", this);
            JMSCMUtils.trace(tc, "createTextMessage", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTextMessage", textMessage);
            }
        }
        return textMessage;
    }

    public boolean getTransacted() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransacted");
        }
        boolean bl = false;
        try {
            Session session = this.getOpenUnifiedSession();
            try {
                bl = session.getTransacted();
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.getTransacted", "462", this);
            JMSCMUtils.trace(tc, "getTransacted", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTransacted", new Boolean(bl));
            }
        }
        return bl;
    }

    public void commit() throws IllegalStateException, JMSException {
        this.commit(false);
    }

    void commitInAnyContext() throws IllegalStateException, JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "commitInAnyContext");
        }
        this.commit(true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "commitInAnyContext");
        }
    }

    private void commit(boolean bl) throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit", new Boolean(bl));
        }
        try {
            if (!bl) {
                this.checkNotInGlobalTransaction();
            }
            Session session = this.getOpenUnifiedSession();
            if (this.managedSession.inContainerLocalTran()) {
                throw new IllegalStateException("Method not permitted in ContainerAtBoundary local transaction");
            }
            try {
                session.commit();
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                throw transactionRolledBackException;
            }
            catch (IllegalStateException illegalStateException) {
                throw illegalStateException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            this.managedSession.localTransactionCommitted();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.commit", "505", this);
            JMSCMUtils.trace(tc, "commit", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commit");
            }
        }
    }

    public void rollback() throws IllegalStateException, JMSException {
        this.rollback(false);
    }

    void rollbackInAnyContext() throws IllegalStateException, JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "rollbackInAnyContext");
        }
        this.rollback(true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "rollbackInAnyContext");
        }
    }

    private void rollback(boolean bl) throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback", new Boolean(bl));
        }
        try {
            if (!bl) {
                this.checkNotInGlobalTransaction();
            }
            Session session = this.getOpenUnifiedSession();
            if (this.managedSession.inContainerLocalTran()) {
                throw new IllegalStateException("Method not permitted in ContainerAtBoundary local transaction");
            }
            try {
                session.rollback();
            }
            catch (IllegalStateException illegalStateException) {
                throw illegalStateException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            this.managedSession.localTransactionRolledback();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.rollback", "546", this);
            JMSCMUtils.trace(tc, "rollback", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "rollback");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close");
        }
        try {
            switch (this.state) {
                case 2: {
                    return;
                }
                case 0: {
                    this.closeChildren();
                    if (this.connectionHandle != null) {
                        this.connectionHandle.removeSessionHandle(this);
                        ConnectionManager connectionManager = (ConnectionManager)this.connectionHandle.getSessionManager();
                        connectionManager.inactiveConnectionClosed(this);
                    }
                    this.state = 2;
                    return;
                }
                case 1: {
                    this.closeChildren();
                    if (this.connectionHandle != null) {
                        this.connectionHandle.removeSessionHandle(this);
                    }
                    if (this.managedSession != null) {
                        this.managedSession.handleClosed(this);
                    }
                    this.managedSession = null;
                    this.state = 2;
                    return;
                }
                default: {
                    throw new RuntimeException("Invalid state");
                }
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.close", "593", this);
            JMSCMUtils.trace(tc, "close", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "close");
            }
        }
    }

    public void recover() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recover");
        }
        try {
            Session session = this.getOpenUnifiedSession();
            try {
                session.recover();
            }
            catch (IllegalStateException illegalStateException) {
                throw illegalStateException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.recover", "630", this);
            JMSCMUtils.trace(tc, "recover", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recover");
            }
        }
    }

    public MessageListener getMessageListener() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessageListener");
        }
        MessageListener messageListener = null;
        try {
            this.checkRestrictedMethod("getMessageListener");
            Session session = this.getSession();
            try {
                messageListener = session.getMessageListener();
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            try {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.getMessageListener", "671", this);
                JMSCMUtils.trace(tc, "getMessageListener", jMSException);
                throw jMSException;
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMessageListener", messageListener);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessageListener", messageListener);
        }
        return messageListener;
    }

    public void setMessageListener(MessageListener messageListener) throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMessageListener", messageListener);
        }
        try {
            this.checkRestrictedMethod("setMessageListener");
            Session session = this.getSession();
            try {
                session.setMessageListener(messageListener);
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.setMessageListener", "713", this);
            JMSCMUtils.trace(tc, "setMessageListener", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setMessageListener");
            }
        }
    }

    public void run() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "run");
        }
        try {
            this.checkRestrictedMethod("run");
            this.getSession().run();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.run", "746", this);
            JMSCMUtils.trace(tc, "run", jMSException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run");
        }
    }

    public void enlist() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "enlist");
        }
        try {
            this.managedSession.enlist();
        }
        catch (JMSException jMSException) {
            this.markManagedObjectsAsStale(jMSException);
            throw jMSException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "enlist");
        }
    }

    public boolean isPreASFRunEnlist() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isPreASFRunEnlist");
        }
        boolean bl = false;
        try {
            Class<?> clazz = Class.forName("com.ibm.mq.jms.MQSession");
            if (clazz.isInstance(this.getOpenUnifiedSession())) {
                bl = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isPreASFRunEnlist", new Boolean(bl));
        }
        return bl;
    }

    public Session getSession() throws IllegalStateException, JMSException {
        return this.getOpenUnifiedSession();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JMSSessionHandle jMSSessionHandle = (JMSSessionHandle)object;
        if (!JMSCMUtils.objectsEqual(this.managedSession, jMSSessionHandle.managedSession)) {
            return false;
        }
        if (this.state != jMSSessionHandle.state) {
            return false;
        }
        return this.restrictedMethodsEnabled == jMSSessionHandle.restrictedMethodsEnabled;
    }

    public int hashCode() {
        int n = this.state;
        n = n * JMSCMUtils.HASH_CODE_PRIME + (this.restrictedMethodsEnabled ? -1 : 1);
        return n;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(JMSCMUtils.objectToString(this));
        stringBuffer.append(string + "managed session = " + JMSCMUtils.objectToString(this.managedSession));
        stringBuffer.append(string + "state = " + this.getStateAsString());
        stringBuffer.append(string + "restricted methods enabled = " + this.restrictedMethodsEnabled);
        stringBuffer.append(string + "open children = [");
        Iterator iterator = this.openChildren.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(JMSCMUtils.objectToString(iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    final void addChild(JMSCloseable jMSCloseable) {
        this.openChildren.add(jMSCloseable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeChild(JMSCloseable jMSCloseable) {
        List list = this.openChildren;
        synchronized (list) {
            for (int i = 0; i < this.openChildren.size(); ++i) {
                JMSCloseable jMSCloseable2 = (JMSCloseable)this.openChildren.get(i);
                if (jMSCloseable != jMSCloseable2) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found sessionhandle to remove, compared: " + jMSCloseable + " with this: " + jMSCloseable2);
                }
                this.openChildren.remove(i);
                break;
            }
        }
    }

    void closeChildren() throws JMSException {
        ArrayList arrayList = new ArrayList(this.openChildren);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            JMSCloseable jMSCloseable = (JMSCloseable)iterator.next();
            try {
                jMSCloseable.close();
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
    }

    protected Session getOpenSession() throws IllegalStateException, JMSException {
        switch (this.state) {
            case 2: {
                throw new IllegalStateException("Session closed");
            }
            case 1: {
                break;
            }
            case 0: {
                try {
                    ConnectionManager connectionManager = (ConnectionManager)this.connectionHandle.getSessionManager();
                    connectionManager.associateConnection(this.connectionHandle.getManagedSessionFactory(), null, this.sessionRequestInfo, this);
                    break;
                }
                catch (ResourceException resourceException) {
                    FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSSessionHandle.getOpenSession", "982", this);
                    if (resourceException.getCause() instanceof JMSException) {
                        this.markManagedObjectsAsStale((JMSException)resourceException.getCause());
                    }
                    throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to re-associate session handle");
                }
            }
        }
        return this.managedSession.getPhysicalSession();
    }

    protected Session getOpenUnifiedSession() throws IllegalStateException, JMSException {
        Session session = this.getOpenSession();
        Session session2 = session instanceof XASession ? ((XASession)session).getSession() : session;
        return session2;
    }

    protected void checkNotInGlobalTransaction() throws IllegalStateException, JMSException {
        if (JMSCMUtils.inGlobalTransaction()) {
            throw new IllegalStateException("Method not permitted in global transaction");
        }
    }

    protected void checkRestrictedMethod(String string) throws JMSException {
        if (!this.restrictedMethodsEnabled) {
            throw JMSCMUtils.methodNotPermittedException(tc, string);
        }
    }

    private String getStateAsString() {
        String string;
        switch (this.state) {
            case 1: {
                string = "ACTIVE";
                break;
            }
            case 0: {
                string = "INACTIVE";
                break;
            }
            case 2: {
                string = "CLOSED";
                break;
            }
            default: {
                throw new RuntimeException("Invalid state");
            }
        }
        return string;
    }

    final JMSManagedSession getManagedSession() {
        return this.managedSession;
    }

    void activate(JMSManagedSession jMSManagedSession) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "activate", jMSManagedSession);
        }
        this.state = 1;
        this.managedSession = jMSManagedSession;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "activate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deactivate() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deactivate");
        }
        this.state = 0;
        Serializable serializable = this;
        synchronized (serializable) {
            this.managedSession = null;
        }
        serializable = new ArrayList(this.openChildren);
        Iterator iterator = serializable.iterator();
        while (iterator.hasNext()) {
            JMSCloseable jMSCloseable = (JMSCloseable)iterator.next();
            jMSCloseable.reset();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deactivate");
        }
    }

    final void setConnectionHandle(JMSConnectionHandle jMSConnectionHandle) {
        this.connectionHandle = jMSConnectionHandle;
        this.restrictedMethodsEnabled = jMSConnectionHandle.getRestrictedMethodsEnabled();
        jMSConnectionHandle.addSessionHandle(this);
        this.mc = jMSConnectionHandle.getManagedConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void markManagedObjectsAsStale(JMSException jMSException) {
        JMSSessionHandle jMSSessionHandle = this;
        synchronized (jMSSessionHandle) {
            if (this.managedSession != null) {
                this.managedSession.connectionErrorOccurred((Exception)((Object)jMSException));
            }
        }
        if (this.connectionHandle != null) {
            this.connectionHandle.markManagedConnectionAsStale(jMSException);
        }
    }

    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createBrowser", new Object[]{queue, string});
        }
        JMSQueueBrowserHandle jMSQueueBrowserHandle = null;
        try {
            jMSQueueBrowserHandle = new JMSQueueBrowserHandle(this, queue, string);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createBrowser", "1389", this);
            JMSCMUtils.trace(tc, "createBrowser", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createBrowser", jMSQueueBrowserHandle);
            }
        }
        return jMSQueueBrowserHandle;
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createBrowser", queue);
        }
        JMSQueueBrowserHandle jMSQueueBrowserHandle = null;
        try {
            jMSQueueBrowserHandle = new JMSQueueBrowserHandle(this, queue);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createBrowser", "1426", this);
            JMSCMUtils.trace(tc, "createBrowser", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createBrowser", jMSQueueBrowserHandle);
            }
        }
        return jMSQueueBrowserHandle;
    }

    public MessageConsumer createConsumer(Destination destination, String string, boolean bl) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSubscriber", new Object[]{destination, string, new Boolean(bl)});
        }
        JMSMessageConsumerHandle jMSMessageConsumerHandle = null;
        try {
            jMSMessageConsumerHandle = new JMSMessageConsumerHandle(this, destination, string, bl);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createConsumer", "1475", this);
            JMSCMUtils.trace(tc, "createConsumer", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createConsumer", jMSMessageConsumerHandle);
            }
        }
        return jMSMessageConsumerHandle;
    }

    public MessageConsumer createConsumer(Destination destination, String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.event(tc, "createConsumer", new Object[]{destination, string});
        }
        JMSMessageConsumerHandle jMSMessageConsumerHandle = null;
        try {
            jMSMessageConsumerHandle = new JMSMessageConsumerHandle(this, destination, string);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createConsumer", "1518", this);
            JMSCMUtils.trace(tc, "createConsumer", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createConsumer", jMSMessageConsumerHandle);
            }
        }
        return jMSMessageConsumerHandle;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.event(tc, "createConsumer", destination);
        }
        JMSMessageConsumerHandle jMSMessageConsumerHandle = null;
        try {
            jMSMessageConsumerHandle = new JMSMessageConsumerHandle(this, destination);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createConsumer", "1558", this);
            JMSCMUtils.trace(tc, "createConsumer", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createReceiver", jMSMessageConsumerHandle);
            }
        }
        return jMSMessageConsumerHandle;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDurableSubscriber", new Object[]{topic, string, string2, new Boolean(bl)});
        }
        JMSTopicSubscriberHandle jMSTopicSubscriberHandle = null;
        try {
            jMSTopicSubscriberHandle = new JMSTopicSubscriberHandle(this, topic, string, string2, bl);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createDurableSubscriber", "1613", this);
            JMSCMUtils.trace(tc, "createDurableSubscriber", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createDurableSubscriber", jMSTopicSubscriberHandle);
            }
        }
        return jMSTopicSubscriberHandle;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDurableSubscriber", new Object[]{topic, string});
        }
        JMSTopicSubscriberHandle jMSTopicSubscriberHandle = null;
        try {
            jMSTopicSubscriberHandle = new JMSTopicSubscriberHandle(this, topic, string);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createDurableSubscriber", "1653", this);
            JMSCMUtils.trace(tc, "createDurableSubscriber", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createDurableSubscriber", jMSTopicSubscriberHandle);
            }
        }
        return jMSTopicSubscriberHandle;
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createProducer", destination);
        }
        JMSMessageProducerHandle jMSMessageProducerHandle = null;
        try {
            jMSMessageProducerHandle = new JMSMessageProducerHandle(this, destination);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createProducer", "1691", this);
            JMSCMUtils.trace(tc, "createProducer", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createProducer", jMSMessageProducerHandle);
            }
        }
        return jMSMessageProducerHandle;
    }

    public Queue createQueue(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.event(tc, "createQueue", string);
        }
        Queue queue = null;
        try {
            Session session = this.getOpenUnifiedSession();
            queue = session.createQueue(string);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createQueue", "1732", this);
            JMSCMUtils.trace(tc, "createQueue", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createQueue", queue);
            }
        }
        return queue;
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTemporaryQueue");
        }
        TemporaryQueue temporaryQueue = null;
        try {
            Session session = this.getOpenUnifiedSession();
            try {
                temporaryQueue = session.createTemporaryQueue();
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            this.connectionHandle.addTemporaryQueue(temporaryQueue);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createTemporaryQueue", "1776", this);
            JMSCMUtils.trace(tc, "createTemporaryQueue", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTemporaryQueue", temporaryQueue);
            }
        }
        return temporaryQueue;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTemporaryTopic");
        }
        TemporaryTopic temporaryTopic = null;
        try {
            Session session = this.getOpenUnifiedSession();
            try {
                temporaryTopic = session.createTemporaryTopic();
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            this.connectionHandle.addTemporaryTopic(temporaryTopic);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createTemporaryTopic", "1822", this);
            JMSCMUtils.trace(tc, "createTemporaryTopic", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTemporaryTopic", temporaryTopic);
            }
        }
        return temporaryTopic;
    }

    public Topic createTopic(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTopic", string);
        }
        Topic topic = null;
        try {
            Session session = this.getOpenUnifiedSession();
            topic = session.createTopic(string);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createTopic", "1862", this);
            JMSCMUtils.trace(tc, "createTopic", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTopic", topic);
            }
        }
        return topic;
    }

    public int getAcknowledgeMode() throws JMSException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAcknowledgeMode");
        }
        try {
            Session session = this.getOpenUnifiedSession();
            try {
                n = session.getAcknowledgeMode();
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.getAcknowledgeMode", "1898", this);
            JMSCMUtils.trace(tc, "getAcknowledgeMode", jMSException);
            throw jMSException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAcknowledgeMode", new Integer(n));
        }
        return n;
    }

    public void unsubscribe(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsubscribe", string);
        }
        try {
            Session session = this.getOpenUnifiedSession();
            try {
                session.unsubscribe(string);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.unsubscribe", "1948", this);
            JMSCMUtils.trace(tc, "unsubscribe", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "unsubscribe");
            }
        }
    }

    private void addCorrelators(Message message) throws JMSException {
        String[] stringArray;
        if (this.managedSession.isMQSession() && (stringArray = JMSRequestMetrics.getCorrelators()) != null) {
            if (stringArray[JMSRequestMetrics.ARM_CORRELATOR_INDEX] != null) {
                message.setStringProperty("JMS_IBM_ArmCorrelator", stringArray[JMSRequestMetrics.ARM_CORRELATOR_INDEX]);
            }
            if (stringArray[JMSRequestMetrics.RM_CORRELATOR_INDEX] != null) {
                message.setStringProperty("JMS_IBM_RMCorrelator", stringArray[JMSRequestMetrics.RM_CORRELATOR_INDEX]);
            }
        }
    }

    public boolean isMQSession() {
        return this.managedSession.isMQSession();
    }

    public String getMQQueueManagerName() throws JMSException {
        String string = null;
        if (this.isMQSession()) {
            ConnectionFactory connectionFactory = this.connectionHandle.getManagedConnection().getManagedConnectionFactory().connectionFactory;
            if (connectionFactory instanceof MQConnectionFactory) {
                string = ((MQConnectionFactory)connectionFactory).getQueueManager();
            } else {
                throw new JMSException("When trying to obtain the QM Name for request request metrics we expected the connection factory to be a " + MQConnectionFactory.class.getName() + " but it is a " + connectionFactory.getClass().getName());
            }
        }
        return string;
    }

    public final Message consume(byte[] byArray) throws JMSException {
        Message message;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "consume()");
        }
        this.checkRestrictedMethod("consume");
        try {
            MQSession mQSession = (MQSession)this.getSession();
            message = mQSession.consume(byArray);
        }
        catch (JMSException jMSException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "consume(): Exception thrown", (Object)jMSException);
                Tr.debug(tc, "calling exception listener");
            }
            this.mc.onException(jMSException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Exception on consume()");
            }
            throw jMSException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "consume(), msg", message);
        }
        return message;
    }
}

