/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import javax.resource.spi.ConnectionRequestInfo;

class JMSSessionRequestInfo
implements ConnectionRequestInfo {
    private static final TraceComponent tc = Tr.register(JMSSessionRequestInfo.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private boolean transacted;
    private int acknowledgeMode;

    JMSSessionRequestInfo(boolean bl, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSSessionRequestInfo", new Object[]{new Boolean(bl), new Integer(n)});
        }
        this.transacted = bl;
        this.setAcknowledgeMode(n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JMSSessionRequestInfo");
        }
    }

    final boolean getTransacted() {
        return this.transacted;
    }

    final int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    private final void setAcknowledgeMode(int n) {
        if (n == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Mapping acknowledge mode of 0 to AUTO_ACKNOWLEDGE");
            }
            this.acknowledgeMode = 1;
        } else if (n == 2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Mapping acknowledge mode of CLIENT_ACKNOWLEDGE to AUTO_ACKNOWLEDGE");
            }
            this.acknowledgeMode = 1;
        } else if (n == -1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "CLIENT_ACKNOWLEDGE set as Session will be used by non-ASF mode listener that wants to enable rollbacks");
            }
            this.acknowledgeMode = 2;
        } else if (n == -2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "CLIENT_ACKNOWLEDGE set as Session will be used by a ZOS CMT MDB");
            }
            this.acknowledgeMode = 2;
        } else {
            this.acknowledgeMode = n;
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JMSSessionRequestInfo jMSSessionRequestInfo = (JMSSessionRequestInfo)object;
        if (this.transacted != jMSSessionRequestInfo.transacted) {
            return false;
        }
        return this.acknowledgeMode == jMSSessionRequestInfo.acknowledgeMode;
    }

    public int hashCode() {
        int n = this.acknowledgeMode;
        n = n * JMSCMUtils.HASH_CODE_PRIME + (this.transacted ? -1 : 1);
        return n;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(JMSCMUtils.objectToString(this));
        stringBuffer.append(string + "transacted = " + this.transacted);
        stringBuffer.append(string + "acknowledge mode = ");
        switch (this.acknowledgeMode) {
            case 2: {
                stringBuffer.append("CLIENT_ACKNOWLEDGE");
                break;
            }
            case 1: {
                stringBuffer.append("AUTO_ACKNOWLEDGE");
                break;
            }
            case 3: {
                stringBuffer.append("DUPS_OK_ACKNOWLEDGE");
                break;
            }
            case -1: {
                stringBuffer.append("CLIENT_ACKNOWLEDGE for non-ASF listeners");
                break;
            }
            case -2: {
                stringBuffer.append("CLIENT_ACKNOWLEDGE for CMT Local Trans listeners on z/OS");
            }
        }
        return stringBuffer.toString();
    }
}

