/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSConnectionFactoryHandle;
import com.ibm.ejs.jms.JMSConnectionRequestInfo;
import com.ibm.ejs.jms.JMSTopicConnectionHandle;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public final class JMSTopicConnectionFactoryHandle
extends JMSConnectionFactoryHandle
implements TopicConnectionFactory {
    private static final long serialVersionUID = 5716026705364222501L;
    private static final TraceComponent tc = Tr.register(JMSTopicConnectionFactoryHandle.class, "Messaging", JMSCMUtils.MSG_BUNDLE);

    JMSTopicConnectionFactoryHandle(ManagedConnectionFactory managedConnectionFactory, ConnectionManager connectionManager) {
        super(managedConnectionFactory, connectionManager);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSTopicConnectionFactoryHandle", new Object[]{managedConnectionFactory, connectionManager});
            Tr.exit(tc, "JMSTopicConnectionFactoryHandle");
        }
    }

    public TopicConnection createTopicConnection() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTopicConnection");
        }
        JMSTopicConnectionHandle jMSTopicConnectionHandle = null;
        try {
            boolean bl = !this.restrictedMethodsEnabled;
            JMSConnectionRequestInfo jMSConnectionRequestInfo = new JMSConnectionRequestInfo(bl);
            jMSTopicConnectionHandle = (JMSTopicConnectionHandle)this.cxManager.allocateConnection(this.factory, (ConnectionRequestInfo)jMSConnectionRequestInfo);
            jMSTopicConnectionHandle.setConnectionFactoryHandle(this);
        }
        catch (ResourceException resourceException) {
            try {
                FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSTopicConnectionFactoryHandle.createTopicConnection", "83", this);
                throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create topic connection");
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createTopicConnection", jMSTopicConnectionHandle);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTopicConnection", jMSTopicConnectionHandle);
        }
        return jMSTopicConnectionHandle;
    }

    public TopicConnection createTopicConnection(String string, String string2) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTopicConnection", new Object[]{string, "password not traced"});
        }
        JMSTopicConnectionHandle jMSTopicConnectionHandle = null;
        try {
            boolean bl = !this.restrictedMethodsEnabled;
            JMSConnectionRequestInfo jMSConnectionRequestInfo = new JMSConnectionRequestInfo(string, string2, bl);
            jMSTopicConnectionHandle = (JMSTopicConnectionHandle)this.cxManager.allocateConnection(this.factory, (ConnectionRequestInfo)jMSConnectionRequestInfo);
            jMSTopicConnectionHandle.setConnectionFactoryHandle(this);
        }
        catch (ResourceException resourceException) {
            try {
                FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSTopicConnectionFactoryHandle.createTopicConnection", "126", this);
                throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create topic connection");
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createTopicConnection", jMSTopicConnectionHandle);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTopicConnection", jMSTopicConnectionHandle);
        }
        return jMSTopicConnectionHandle;
    }

    public TopicConnection createNonTransactableInTranTopicConnection() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNonTransactableInTranTopicConnection");
        }
        JMSTopicConnectionHandle jMSTopicConnectionHandle = null;
        try {
            boolean bl = !this.restrictedMethodsEnabled;
            JMSConnectionRequestInfo jMSConnectionRequestInfo = new JMSConnectionRequestInfo(bl);
            jMSConnectionRequestInfo.setAllowsNonTransactedSessionsInTran(true);
            jMSTopicConnectionHandle = (JMSTopicConnectionHandle)this.cxManager.allocateConnection(this.factory, (ConnectionRequestInfo)jMSConnectionRequestInfo);
            jMSTopicConnectionHandle.setConnectionFactoryHandle(this);
        }
        catch (ResourceException resourceException) {
            try {
                FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSTopicConnectionFactoryHandle.createNonTransactableInTranTopicConnection", "83", this);
                throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create topic connection");
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createNonTransactableInTranTopicConnection", jMSTopicConnectionHandle);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNonTransactableInTranTopicConnection", jMSTopicConnectionHandle);
        }
        return jMSTopicConnectionHandle;
    }

    public TopicConnection createNonTransactableInTranTopicConnection(String string, String string2) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNonTransactableInTranTopicConnection", new Object[]{string, "password not traced"});
        }
        JMSTopicConnectionHandle jMSTopicConnectionHandle = null;
        try {
            boolean bl = !this.restrictedMethodsEnabled;
            JMSConnectionRequestInfo jMSConnectionRequestInfo = new JMSConnectionRequestInfo(string, string2, bl);
            jMSConnectionRequestInfo.setAllowsNonTransactedSessionsInTran(true);
            jMSTopicConnectionHandle = (JMSTopicConnectionHandle)this.cxManager.allocateConnection(this.factory, (ConnectionRequestInfo)jMSConnectionRequestInfo);
            jMSTopicConnectionHandle.setConnectionFactoryHandle(this);
        }
        catch (ResourceException resourceException) {
            try {
                FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSTopicConnectionFactoryHandle.createNonTransactableInTranTopicConnection", "126", this);
                throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create topic connection");
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createNonTransactableInTranTopicConnection", jMSTopicConnectionHandle);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNonTransactableInTranTopicConnection", jMSTopicConnectionHandle);
        }
        return jMSTopicConnectionHandle;
    }
}

