/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSConnectionHandle;
import com.ibm.ejs.jms.JMSListenerSessionRequestInfo;
import com.ibm.ejs.jms.JMSManagedTopicSessionFactory;
import com.ibm.ejs.jms.JMSSessionRequestInfo;
import com.ibm.ejs.jms.JMSTopicSessionHandle;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Iterator;
import javax.jms.ConnectionConsumer;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public final class JMSTopicConnectionHandle
extends JMSConnectionHandle
implements TopicConnection {
    private static final long serialVersionUID = -193692574218302218L;
    private static final TraceComponent tc = Tr.register(JMSTopicConnectionHandle.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private transient String lockCreateConnectionConsumer = new String("createConnectionConsumer");
    private transient String lockCreateListenerTopicSession = new String("createListenerTopicSession");
    private transient String lockCreateDurableConnectionConsumer = new String("createDurableConnectionConsumer");
    private transient String lockCreateTopicSession = new String("createTopicSession");

    JMSTopicConnectionHandle(JMSManagedTopicSessionFactory jMSManagedTopicSessionFactory, ConnectionManager connectionManager) {
        super(jMSManagedTopicSessionFactory, connectionManager);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSTopicConnectionHandle", new Object[]{jMSManagedTopicSessionFactory, connectionManager});
        }
        this.methodSyncList.add(this.lockCreateConnectionConsumer);
        this.methodSyncList.add(this.lockCreateListenerTopicSession);
        this.methodSyncList.add(this.lockCreateDurableConnectionConsumer);
        this.methodSyncList.add(this.lockCreateTopicSession);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JMSTopicConnectionHandle");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionConsumer createConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createConnectionConsumer", new Object[]{topic, string, serverSessionPool, new Integer(n)});
        }
        ConnectionConsumer connectionConsumer = null;
        JMSException jMSException = null;
        try {
            String string2 = this.lockCreateConnectionConsumer;
            synchronized (string2) {
                this.checkRestrictedMethod("createConnectionConsumer");
                this.checkOpen();
                this.checkValid();
                TopicConnection topicConnection = (TopicConnection)this.connection;
                try {
                    connectionConsumer = topicConnection.createConnectionConsumer(topic, string, serverSessionPool, n);
                }
                catch (InvalidDestinationException invalidDestinationException) {
                    throw invalidDestinationException;
                }
                catch (InvalidSelectorException invalidSelectorException) {
                    throw invalidSelectorException;
                }
                catch (JMSException jMSException2) {
                    jMSException = jMSException2;
                    throw jMSException2;
                }
            }
        }
        catch (JMSException jMSException3) {
            try {
                FFDCFilter.processException((Throwable)jMSException3, "com.ibm.ejs.jms.JMSTopicConnectionHandle.createConnectionConsumer", "113", this);
                JMSCMUtils.trace(tc, "createConnectionConsumer", jMSException3);
                if (jMSException != null) {
                    this.markManagedConnectionAsStale(jMSException);
                }
                throw jMSException3;
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "createConnectionConsumer", connectionConsumer);
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createConnectionConsumer", connectionConsumer);
        }
        return connectionConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createDurableConnectionConsumer", new Object[]{topic, string, string2, serverSessionPool, new Integer(n)});
        }
        ConnectionConsumer connectionConsumer = null;
        JMSException jMSException = null;
        try {
            String string3 = this.lockCreateDurableConnectionConsumer;
            synchronized (string3) {
                this.checkRestrictedMethod("createDurableConnectionConsumer");
                this.checkOpen();
                this.checkValid();
                TopicConnection topicConnection = (TopicConnection)this.connection;
                try {
                    connectionConsumer = topicConnection.createDurableConnectionConsumer(topic, string, string2, serverSessionPool, n);
                }
                catch (InvalidDestinationException invalidDestinationException) {
                    throw invalidDestinationException;
                }
                catch (InvalidSelectorException invalidSelectorException) {
                    throw invalidSelectorException;
                }
                catch (JMSException jMSException2) {
                    jMSException = jMSException2;
                    throw jMSException2;
                }
            }
        }
        catch (JMSException jMSException3) {
            try {
                FFDCFilter.processException((Throwable)jMSException3, "com.ibm.ejs.jms.JMSTopicConnectionHandle.createDurableConnectionConsumer", "168", this);
                JMSCMUtils.trace(tc, "createDurableConnectionConsumer", jMSException3);
                if (jMSException != null) {
                    this.markManagedConnectionAsStale(jMSException);
                }
                throw jMSException3;
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "createDurableConnectionConsumer", connectionConsumer);
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createDurableConnectionConsumer", connectionConsumer);
        }
        return connectionConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TopicSession createTopicSession(boolean bl, int n) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createTopicSession", new Object[]{bl, new Integer(n)});
        }
        JMSTopicSessionHandle jMSTopicSessionHandle = null;
        try {
            String string = this.lockCreateListenerTopicSession;
            synchronized (string) {
                this.checkOpen();
                this.checkValid();
                JMSSessionRequestInfo jMSSessionRequestInfo = new JMSSessionRequestInfo(bl, n);
                jMSTopicSessionHandle = (JMSTopicSessionHandle)this.sessionManager.allocateConnection((ManagedConnectionFactory)this.factory, (ConnectionRequestInfo)jMSSessionRequestInfo);
                jMSTopicSessionHandle.setTopicConnectionHandle(this);
            }
        }
        catch (JMSException jMSException) {
            try {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueConnectionHandle.createTopicSession", "159", this);
                JMSCMUtils.trace(tc, "createTopicSession", jMSException);
                throw jMSException;
                catch (ResourceException resourceException) {
                    FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSTopicConnectionHandle.createTopicSession", "215", this);
                    if (!(resourceException.getCause() instanceof JMSException)) throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create topic session");
                    this.markManagedConnectionAsStale((JMSException)resourceException.getCause());
                    throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create topic session");
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "createTopicSession", jMSTopicSessionHandle);
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return jMSTopicSessionHandle;
        if (!tc.isEntryEnabled()) return jMSTopicSessionHandle;
        Tr.exit(tc, "createTopicSession", jMSTopicSessionHandle);
        return jMSTopicSessionHandle;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(string + "temporary topics = [");
        Iterator iterator = this.getTemporaryTopics().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(JMSCMUtils.objectToString(iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public TopicSession createListenerTopicSession(int n, boolean bl) throws JMSException {
        return this.createListenerTopicSession(n, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TopicSession createListenerTopicSession(int n, boolean bl, boolean bl2) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createListenerTopicSession", new Object[]{new Integer(n), bl, bl2});
        }
        JMSTopicSessionHandle jMSTopicSessionHandle = null;
        try {
            String string = this.lockCreateListenerTopicSession;
            synchronized (string) {
                this.checkOpen();
                this.checkValid();
                JMSListenerSessionRequestInfo jMSListenerSessionRequestInfo = new JMSListenerSessionRequestInfo(n, bl, bl2);
                jMSTopicSessionHandle = (JMSTopicSessionHandle)this.sessionManager.allocateConnection((ManagedConnectionFactory)this.factory, (ConnectionRequestInfo)jMSListenerSessionRequestInfo);
                jMSTopicSessionHandle.setTopicConnectionHandle(this);
            }
        }
        catch (JMSException jMSException) {
            try {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicConnectionHandle.createListenerTopicSession", "334", this);
                JMSCMUtils.trace(tc, "createListenerTopicSession", jMSException);
                throw jMSException;
                catch (ResourceException resourceException) {
                    FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSTopicConnectionHandle.createListenerTopicSession", "340", this);
                    if (!(resourceException.getCause() instanceof JMSException)) throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create topic session");
                    this.markManagedConnectionAsStale((JMSException)resourceException.getCause());
                    throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create topic session");
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "createListenerTopicSession", jMSTopicSessionHandle);
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return jMSTopicSessionHandle;
        if (!tc.isEntryEnabled()) return jMSTopicSessionHandle;
        Tr.exit(tc, "createListenerTopicSession", jMSTopicSessionHandle);
        return jMSTopicSessionHandle;
    }
}

