/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSMessageProducerHandle;
import com.ibm.ejs.jms.JMSRequestMetrics;
import com.ibm.ejs.jms.JMSTopicSessionHandle;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Properties;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageProducer;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;

final class JMSTopicPublisherHandle
extends JMSMessageProducerHandle
implements TopicPublisher {
    private static final long serialVersionUID = 9064090649775685972L;
    private static final TraceComponent tc = Tr.register(JMSTopicPublisherHandle.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private JMSTopicSessionHandle topicSessionHandle;
    private Topic topic;
    private TopicPublisher topicPublisher;

    JMSTopicPublisherHandle(JMSTopicSessionHandle jMSTopicSessionHandle, Topic topic) throws JMSException {
        super(jMSTopicSessionHandle);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSTopicPublisherHandle", new Object[]{jMSTopicSessionHandle, topic});
        }
        try {
            this.topicSessionHandle = jMSTopicSessionHandle;
            this.topic = topic;
            TopicSession topicSession = jMSTopicSessionHandle.getOpenTopicSession();
            try {
                this.topicPublisher = topicSession.createPublisher(topic);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            this.topicSessionHandle.addChild(this);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicPublisherHandle.JMSTopicPublisherHandle", "83", this);
            JMSCMUtils.trace(tc, "JMSTopicPublisherHandle", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "JMSTopicPublisherHandle");
            }
        }
    }

    public Topic getTopic() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTopic");
        }
        Topic topic = null;
        try {
            TopicPublisher topicPublisher = this.getOpenTopicPublisher();
            topic = topicPublisher.getTopic();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicPublisherHandle.getTopic", "119", this);
            JMSCMUtils.trace(tc, "getTopic", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTopic", topic);
            }
        }
        return topic;
    }

    public void publish(Message message) throws IllegalStateException, MessageFormatException, InvalidDestinationException, JMSException, UnsupportedOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "publish", message);
        }
        try {
            TopicPublisher topicPublisher = this.getOpenTopicPublisher();
            try {
                this.enlist();
                boolean bl = this.topicSessionHandle.isMQSession();
                boolean bl2 = JMSRequestMetrics.isRMEnabled(JMSRequestMetrics.JMS_COMPONENT_ID);
                Object object = null;
                if (bl && bl2) {
                    object = this.produceMessageBlock("publish (Message)");
                }
                boolean bl3 = true;
                try {
                    topicPublisher.publish(message);
                }
                catch (JMSException jMSException) {
                    bl3 = false;
                    throw jMSException;
                }
                finally {
                    if (bl && bl2) {
                        this.produceMessageUnblock(bl3, message, object, topicPublisher);
                    }
                }
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (MessageFormatException messageFormatException) {
                throw messageFormatException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicPublisherHandle.publish", "163", this);
            JMSCMUtils.trace(tc, "publish", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "publish");
            }
        }
    }

    public void publish(Message message, int n, int n2, long l) throws IllegalStateException, MessageFormatException, InvalidDestinationException, JMSException, UnsupportedOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "publish", new Object[]{message, new Integer(n), new Integer(n2), new Long(l)});
        }
        try {
            TopicPublisher topicPublisher = this.getOpenTopicPublisher();
            try {
                this.enlist();
                boolean bl = this.topicSessionHandle.isMQSession();
                boolean bl2 = JMSRequestMetrics.isRMEnabled(JMSRequestMetrics.JMS_COMPONENT_ID);
                Object object = null;
                if (bl && bl2) {
                    object = this.produceMessageBlock("publish (Message, int, int, long)");
                }
                boolean bl3 = true;
                try {
                    topicPublisher.publish(message, n, n2, l);
                }
                catch (JMSException jMSException) {
                    bl3 = false;
                    throw jMSException;
                }
                finally {
                    if (bl && bl2) {
                        this.produceMessageUnblock(bl3, message, object, "" + l);
                    }
                }
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (MessageFormatException messageFormatException) {
                throw messageFormatException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicPublisherHandle.publish", "210", this);
            JMSCMUtils.trace(tc, "publish", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "publish");
            }
        }
    }

    public void publish(Topic topic, Message message) throws IllegalStateException, JMSException, MessageFormatException, InvalidDestinationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "publish", new Object[]{topic, message});
        }
        try {
            TopicPublisher topicPublisher = this.getOpenTopicPublisher();
            try {
                this.enlist();
                boolean bl = this.topicSessionHandle.isMQSession();
                boolean bl2 = JMSRequestMetrics.isRMEnabled(JMSRequestMetrics.JMS_COMPONENT_ID);
                Object object = null;
                if (bl && bl2) {
                    object = this.produceMessageBlock("publish (Topic, Message)");
                }
                boolean bl3 = true;
                try {
                    topicPublisher.publish(topic, message);
                }
                catch (JMSException jMSException) {
                    bl3 = false;
                    throw jMSException;
                }
                finally {
                    if (bl && bl2) {
                        this.produceMessageUnblock(bl3, message, object, topicPublisher);
                    }
                }
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (MessageFormatException messageFormatException) {
                throw messageFormatException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicPublisherHandle.publish", "252", this);
            JMSCMUtils.trace(tc, "publish", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "publish");
            }
        }
    }

    public void publish(Topic topic, Message message, int n, int n2, long l) throws IllegalStateException, MessageFormatException, InvalidDestinationException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "publish", new Object[]{topic, message, new Integer(n), new Integer(n2), new Long(l)});
        }
        try {
            TopicPublisher topicPublisher = this.getOpenTopicPublisher();
            try {
                this.enlist();
                boolean bl = this.topicSessionHandle.isMQSession();
                boolean bl2 = JMSRequestMetrics.isRMEnabled(JMSRequestMetrics.JMS_COMPONENT_ID);
                Object object = null;
                if (bl && bl2) {
                    object = this.produceMessageBlock("publish (Topic, Message, int, int, long)");
                }
                boolean bl3 = true;
                try {
                    topicPublisher.publish(topic, message, n, n2, l);
                }
                catch (JMSException jMSException) {
                    bl3 = false;
                    throw jMSException;
                }
                finally {
                    if (bl && bl2) {
                        this.produceMessageUnblock(bl3, message, object, "" + l);
                    }
                }
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (MessageFormatException messageFormatException) {
                throw messageFormatException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicPublisherHandle.publish", "297", this);
            JMSCMUtils.trace(tc, "publish", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "publish");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
        try {
            if (this.topicPublisher != null) {
                this.topicPublisher.close();
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicPublisherHandle.reset", "323", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Failed to close TopicPublisher during reset", (Object)jMSException);
            }
            this.markManagedObjectsAsStale(jMSException);
        }
        finally {
            this.topicPublisher = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "reset");
            }
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        JMSTopicPublisherHandle jMSTopicPublisherHandle = (JMSTopicPublisherHandle)object;
        if (!JMSCMUtils.objectsEqual(this.topicSessionHandle, jMSTopicPublisherHandle.topicSessionHandle)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.topic, jMSTopicPublisherHandle.topic)) {
            return false;
        }
        return JMSCMUtils.objectsEqual(this.topicPublisher, jMSTopicPublisherHandle.topicPublisher);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.topicSessionHandle);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.topic);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.topicPublisher);
        return n;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(string + "topic = " + this.topic);
        stringBuffer.append(string + "physical topic publisher = " + this.topicPublisher);
        return stringBuffer.toString();
    }

    protected final MessageProducer getMessageProducer() {
        return this.topicPublisher;
    }

    protected MessageProducer getOpenMessageProducer() throws IllegalStateException, JMSException {
        return this.getOpenTopicPublisher();
    }

    private TopicPublisher getOpenTopicPublisher() throws IllegalStateException, JMSException {
        this.checkOpen();
        if (this.topicPublisher == null) {
            TopicSession topicSession = this.topicSessionHandle.getOpenTopicSession();
            try {
                this.topicPublisher = topicSession.createPublisher(this.topic);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            this.initialiseMessageProducer();
        }
        return this.topicPublisher;
    }

    private Object produceMessageBlock(String string) throws JMSException {
        String[] stringArray = new String[]{this.getClass().getName(), string};
        return JMSRequestMetrics.produceMessageBlock(stringArray);
    }

    private void produceMessageUnblock(boolean bl, Message message, Object object, TopicPublisher topicPublisher) throws JMSException {
        this.produceMessageUnblock(bl, message, object, "" + topicPublisher.getTimeToLive());
    }

    private void produceMessageUnblock(boolean bl, Message message, Object object, String string) throws JMSException {
        Properties properties = new Properties();
        int n = JMSRequestMetrics.getTransactionTraceLevel(JMSRequestMetrics.JMS_COMPONENT_ID);
        if (n == 2) {
            properties = JMSRequestMetrics.getBasicOutboundTrace(message, this.topicSessionHandle.getMQQueueManagerName());
        } else if (n == 3) {
            properties = JMSRequestMetrics.getExtendedOutboundTrace(message, this.topicSessionHandle.getMQQueueManagerName(), string);
        }
        JMSRequestMetrics.produceMessageUnblock(object, bl ? 0 : 2, properties);
    }
}

