/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSManagedTopicSession;
import com.ibm.ejs.jms.JMSSessionHandle;
import com.ibm.ejs.jms.JMSTopicConnectionHandle;
import com.ibm.ejs.jms.JMSTopicPublisherHandle;
import com.ibm.ejs.jms.JMSTopicSubscriberHandle;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.XATopicSession;
import javax.resource.spi.ConnectionRequestInfo;

public final class JMSTopicSessionHandle
extends JMSSessionHandle
implements TopicSession {
    private static final long serialVersionUID = -8043451092084188621L;
    private static final TraceComponent tc = Tr.register(JMSTopicSessionHandle.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private JMSTopicConnectionHandle topicConnectionHandle;

    JMSTopicSessionHandle(ConnectionRequestInfo connectionRequestInfo, JMSManagedTopicSession jMSManagedTopicSession) {
        super(connectionRequestInfo, jMSManagedTopicSession);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSTopicSessionHandle", new Object[]{connectionRequestInfo, jMSManagedTopicSession});
            Tr.exit(tc, "JMSTopicSessionHandle");
        }
    }

    public void unsubscribe(String string) throws IllegalStateException, InvalidDestinationException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsubscribe", string);
        }
        try {
            TopicSession topicSession = this.getOpenTopicSession();
            try {
                topicSession.unsubscribe(string);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicSessionHandle.unsubscribe", "96", this);
            JMSCMUtils.trace(tc, "unsubscribe", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "unsubscribe");
            }
        }
    }

    public TemporaryTopic createTemporaryTopic() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTemporaryTopic");
        }
        TemporaryTopic temporaryTopic = null;
        try {
            TopicSession topicSession = this.getOpenTopicSession();
            try {
                temporaryTopic = topicSession.createTemporaryTopic();
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            this.topicConnectionHandle.addTemporaryTopic(temporaryTopic);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicSessionHandle.createTemporaryTopic", "134", this);
            JMSCMUtils.trace(tc, "createTemporaryTopic", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTemporaryTopic", temporaryTopic);
            }
        }
        return temporaryTopic;
    }

    public TopicPublisher createPublisher(Topic topic) throws IllegalStateException, InvalidDestinationException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPublisher", topic);
        }
        JMSTopicPublisherHandle jMSTopicPublisherHandle = null;
        try {
            jMSTopicPublisherHandle = new JMSTopicPublisherHandle(this, topic);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicSessionHandle.createPublisher", "176", this);
            JMSCMUtils.trace(tc, "createPublisher", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createPublisher", jMSTopicPublisherHandle);
            }
        }
        return jMSTopicPublisherHandle;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl) throws IllegalStateException, InvalidDestinationException, InvalidSelectorException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDurableSubscriber", new Object[]{topic, string, string2, new Boolean(bl)});
        }
        JMSTopicSubscriberHandle jMSTopicSubscriberHandle = null;
        try {
            jMSTopicSubscriberHandle = new JMSTopicSubscriberHandle(this, topic, string, string2, bl);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicSessionHandle.createDurableSubscriber", "224", this);
            JMSCMUtils.trace(tc, "createDurableSubscriber", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createDurableSubscriber", jMSTopicSubscriberHandle);
            }
        }
        return jMSTopicSubscriberHandle;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws IllegalStateException, InvalidDestinationException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDurableSubscriber", new Object[]{topic, string});
        }
        JMSTopicSubscriberHandle jMSTopicSubscriberHandle = null;
        try {
            jMSTopicSubscriberHandle = new JMSTopicSubscriberHandle((JMSSessionHandle)this, topic, string);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicSessionHandle.createDurableSubscriber", "265", this);
            JMSCMUtils.trace(tc, "createDurableSubscriber", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createDurableSubscriber", jMSTopicSubscriberHandle);
            }
        }
        return jMSTopicSubscriberHandle;
    }

    public TopicSubscriber createSubscriber(Topic topic, String string, boolean bl) throws IllegalStateException, InvalidDestinationException, InvalidSelectorException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSubscriber", new Object[]{topic, string, new Boolean(bl)});
        }
        JMSTopicSubscriberHandle jMSTopicSubscriberHandle = null;
        try {
            jMSTopicSubscriberHandle = new JMSTopicSubscriberHandle(this, topic, string, bl);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicSessionHandle.createSubscriber", "312", this);
            JMSCMUtils.trace(tc, "createSubscriber", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSubscriber", jMSTopicSubscriberHandle);
            }
        }
        return jMSTopicSubscriberHandle;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws IllegalStateException, InvalidDestinationException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSubscriber", topic);
        }
        JMSTopicSubscriberHandle jMSTopicSubscriberHandle = null;
        try {
            jMSTopicSubscriberHandle = new JMSTopicSubscriberHandle(this, topic);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicSessionHandle.createSubscriber", "352", this);
            JMSCMUtils.trace(tc, "createSubscriber", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSubscriber", jMSTopicSubscriberHandle);
            }
        }
        return jMSTopicSubscriberHandle;
    }

    public Topic createTopic(String string) throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTopic", string);
        }
        Topic topic = null;
        try {
            TopicSession topicSession = this.getOpenTopicSession();
            topic = topicSession.createTopic(string);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicSessionHandle.createTopic", "390", this);
            JMSCMUtils.trace(tc, "createTopic", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTopic", topic);
            }
        }
        return topic;
    }

    public Session getSession() throws JMSException {
        return this.getOpenTopicSession();
    }

    protected TopicSession getOpenTopicSession() throws JMSException {
        Session session = this.getOpenSession();
        TopicSession topicSession = session instanceof XATopicSession ? ((XATopicSession)session).getTopicSession() : (TopicSession)session;
        return topicSession;
    }

    void setTopicConnectionHandle(JMSTopicConnectionHandle jMSTopicConnectionHandle) {
        super.setConnectionHandle(jMSTopicConnectionHandle);
        this.topicConnectionHandle = jMSTopicConnectionHandle;
    }
}

