/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSMessageConsumerHandle;
import com.ibm.ejs.jms.JMSSessionHandle;
import com.ibm.ejs.jms.JMSTopicSessionHandle;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

final class JMSTopicSubscriberHandle
extends JMSMessageConsumerHandle
implements TopicSubscriber {
    private static final long serialVersionUID = 1066734876278582004L;
    private static final TraceComponent tc = Tr.register(JMSTopicSubscriberHandle.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private final JMSSessionHandle sessionHandle;
    private final Topic topic;
    private String durableSubscriptionName = null;
    private Boolean noLocal = null;
    private TopicSubscriber topicSubscriber;

    JMSTopicSubscriberHandle(JMSTopicSessionHandle jMSTopicSessionHandle, Topic topic) throws JMSException {
        super(jMSTopicSessionHandle);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSTopicSubscriberHandle", new Object[]{jMSTopicSessionHandle, topic});
        }
        try {
            this.sessionHandle = jMSTopicSessionHandle;
            this.topic = topic;
            TopicSession topicSession = jMSTopicSessionHandle.getOpenTopicSession();
            try {
                this.topicSubscriber = topicSession.createSubscriber(topic);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            jMSTopicSessionHandle.addChild(this);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicSubscriberHandle.JMSTopicSubscriberHandle", "91", this);
            JMSCMUtils.trace(tc, "JMSTopicSubscriberHandle", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "JMSTopicSubscriberHandle");
            }
        }
    }

    JMSTopicSubscriberHandle(JMSTopicSessionHandle jMSTopicSessionHandle, Topic topic, String string, boolean bl) throws JMSException {
        super((JMSSessionHandle)jMSTopicSessionHandle, string);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSTopicSubscriberHandle", new Object[]{jMSTopicSessionHandle, topic, string, new Boolean(bl)});
        }
        try {
            this.sessionHandle = jMSTopicSessionHandle;
            this.topic = topic;
            this.noLocal = new Boolean(bl);
            TopicSession topicSession = jMSTopicSessionHandle.getOpenTopicSession();
            try {
                this.topicSubscriber = topicSession.createSubscriber(topic, string, bl);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (InvalidSelectorException invalidSelectorException) {
                throw invalidSelectorException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            jMSTopicSessionHandle.addChild(this);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicSubscriberHandle.JMSTopicSubscriberHandle", "138", this);
            JMSCMUtils.trace(tc, "JMSTopicSubscriberHandle", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "JMSTopicSubscriberHandle");
            }
        }
    }

    JMSTopicSubscriberHandle(JMSSessionHandle jMSSessionHandle, Topic topic, String string) throws JMSException {
        super(jMSSessionHandle);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSTopicSubscriberHandle", new Object[]{jMSSessionHandle, topic, string});
        }
        try {
            this.sessionHandle = jMSSessionHandle;
            this.topic = topic;
            this.durableSubscriptionName = string;
            Session session = jMSSessionHandle.getOpenSession();
            try {
                this.topicSubscriber = session.createDurableSubscriber(topic, string);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            jMSSessionHandle.addChild(this);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicSubscriberHandle.JMSTopicSubscriberHandle", "183", this);
            JMSCMUtils.trace(tc, "JMSTopicSubscriberHandle", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "JMSTopicSubscriberHandle");
            }
        }
    }

    JMSTopicSubscriberHandle(JMSSessionHandle jMSSessionHandle, Topic topic, String string, String string2, boolean bl) throws JMSException {
        super(jMSSessionHandle, string2);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSTopicSubscriberHandle", new Object[]{jMSSessionHandle, topic, string, string2, new Boolean(bl)});
        }
        try {
            this.sessionHandle = jMSSessionHandle;
            this.topic = topic;
            this.durableSubscriptionName = string;
            this.noLocal = new Boolean(bl);
            Session session = jMSSessionHandle.getOpenSession();
            try {
                this.topicSubscriber = session.createDurableSubscriber(topic, string, string2, bl);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (InvalidSelectorException invalidSelectorException) {
                throw invalidSelectorException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            jMSSessionHandle.addChild(this);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicSubscriberHandle.JMSTopicSubscriberHandle", "235", this);
            JMSCMUtils.trace(tc, "JMSTopicSubscriberHandle", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "JMSTopicSubscriberHandle");
            }
        }
    }

    public Topic getTopic() throws java.lang.IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTopic");
        }
        Topic topic = null;
        try {
            TopicSubscriber topicSubscriber = this.getOpenTopicSubscriber();
            topic = topicSubscriber.getTopic();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicSubscriberHandle.getTopic", "271", this);
            JMSCMUtils.trace(tc, "getTopic", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTopic", topic);
            }
        }
        return topic;
    }

    public boolean getNoLocal() throws java.lang.IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNoLocal");
        }
        boolean bl = false;
        try {
            TopicSubscriber topicSubscriber = this.getOpenTopicSubscriber();
            bl = topicSubscriber.getNoLocal();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicSubscriberHandle.getNoLocal", "311", this);
            JMSCMUtils.trace(tc, "getNoLocal", jMSException);
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNoLocal", new Boolean(bl));
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
        try {
            if (this.topicSubscriber != null) {
                this.topicSubscriber.close();
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicSubscriberHandle.reset", "339", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Failed to close TopicSubscriber during reset", (Object)jMSException);
            }
            this.markManagedObjectsAsStale(jMSException);
        }
        finally {
            this.topicSubscriber = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "reset");
            }
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        JMSTopicSubscriberHandle jMSTopicSubscriberHandle = (JMSTopicSubscriberHandle)object;
        if (!JMSCMUtils.objectsEqual(this.sessionHandle, jMSTopicSubscriberHandle.sessionHandle)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.topic, jMSTopicSubscriberHandle.topic)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.topicSubscriber, jMSTopicSubscriberHandle.topicSubscriber)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.durableSubscriptionName, jMSTopicSubscriberHandle.durableSubscriptionName)) {
            return false;
        }
        return JMSCMUtils.objectsEqual(this.noLocal, jMSTopicSubscriberHandle.noLocal);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.sessionHandle);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.topic);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.topicSubscriber);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.durableSubscriptionName);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.noLocal);
        return n;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(string + "topic = " + this.topic);
        stringBuffer.append(string + "physical topic subscriber = " + this.topicSubscriber);
        if (this.durableSubscriptionName != null) {
            stringBuffer.append(string + "durable subscription name = " + this.durableSubscriptionName);
        }
        if (this.noLocal != null) {
            stringBuffer.append(string + "no local = " + this.noLocal);
        }
        return stringBuffer.toString();
    }

    protected final MessageConsumer getMessageConsumer() {
        return this.topicSubscriber;
    }

    protected MessageConsumer getOpenMessageConsumer() throws java.lang.IllegalStateException, JMSException {
        return this.getOpenTopicSubscriber();
    }

    private TopicSubscriber getOpenTopicSubscriber() throws java.lang.IllegalStateException, JMSException {
        this.checkOpen();
        if (this.topicSubscriber == null) {
            Session session = this.sessionHandle.getOpenSession();
            if (this.durableSubscriptionName == null) {
                throw new IllegalStateException("Non-durable subscriber invalidated on transaction boundary");
            }
            try {
                this.topicSubscriber = this.noLocal == null ? session.createDurableSubscriber(this.topic, this.durableSubscriptionName) : session.createDurableSubscriber(this.topic, this.durableSubscriptionName, this.messageSelector, this.noLocal.booleanValue());
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        return this.topicSubscriber;
    }

    protected String getDestinationName() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDestinationName");
        }
        String string = this.topic.getTopicName();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDestinationName", string);
        }
        return string;
    }
}

